/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class Extensions {
    private static LogProvider ourLogger = new SimpleLogProvider();
    public static final ExtensionPointName<AreaListener> AREA_LISTENER_EXTENSION_POINT = new ExtensionPointName("com.intellij.arealistener");
    private static final Map<AreaInstance, ExtensionsAreaImpl> ourAreaInstance2area = new HashMap<AreaInstance, ExtensionsAreaImpl>();
    private static final MultiMap<String, AreaInstance> ourAreaClass2instances = new MultiMap();
    private static final Map<AreaInstance, String> ourAreaInstance2class = new HashMap<AreaInstance, String>();
    private static final Map<String, AreaClassConfiguration> ourAreaClass2Configuration = new HashMap<String, AreaClassConfiguration>();

    private static ExtensionsAreaImpl createRootArea() {
        ExtensionsAreaImpl rootArea = new ExtensionsAreaImpl(null, null, null, ourLogger);
        rootArea.registerExtensionPoint(AREA_LISTENER_EXTENSION_POINT.getName(), AreaListener.class.getName());
        ourAreaInstance2area.put(null, rootArea);
        return rootArea;
    }

    private Extensions() {
    }

    public static ExtensionsArea getRootArea() {
        return Extensions.getArea(null);
    }

    @NotNull
    public static ExtensionsArea getArea(@Nullable AreaInstance areaInstance) {
        ExtensionsAreaImpl area = ourAreaInstance2area.get(areaInstance);
        if (area == null) {
            throw new IllegalArgumentException("No area instantiated for: " + areaInstance);
        }
        ExtensionsAreaImpl extensionsAreaImpl = area;
        if (extensionsAreaImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getArea must not return null");
        }
        return extensionsAreaImpl;
    }

    public static void cleanRootArea(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.cleanRootArea must not be null");
        }
        final ExtensionsAreaImpl oldRootArea = (ExtensionsAreaImpl)Extensions.getRootArea();
        final ExtensionsAreaImpl newArea = Extensions.createRootArea();
        oldRootArea.notifyAreaReplaced();
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAreaInstance2area.put(null, oldRootArea);
                newArea.notifyAreaReplaced();
            }
        });
    }

    public static Object[] getExtensions(@NonNls String extensionPointName) {
        return Extensions.getExtensions(extensionPointName, null);
    }

    public static <T> T[] getExtensions(ExtensionPointName<T> extensionPointName) {
        return Extensions.getExtensions(extensionPointName.getName(), null);
    }

    public static <T> T[] getExtensions(ExtensionPointName<T> extensionPointName, AreaInstance areaInstance) {
        return Extensions.getExtensions(extensionPointName.getName(), areaInstance);
    }

    public static <T> T[] getExtensions(String extensionPointName, AreaInstance areaInstance) {
        ExtensionsArea area = Extensions.getArea(areaInstance);
        ExtensionPoint extensionPoint = area.getExtensionPoint(extensionPointName);
        return extensionPoint.getExtensions();
    }

    public static void instantiateArea(@NonNls @NotNull String areaClass, AreaInstance areaInstance, AreaInstance parentAreaInstance) {
        AreaListener[] listeners;
        if (areaClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.instantiateArea must not be null");
        }
        if (!ourAreaClass2Configuration.containsKey(areaClass)) {
            throw new IllegalArgumentException("Area class is not registered: " + areaClass);
        }
        if (ourAreaInstance2area.containsKey(areaInstance)) {
            throw new IllegalArgumentException("Area already instantiated for: " + areaInstance);
        }
        ExtensionsArea parentArea = Extensions.getArea(parentAreaInstance);
        AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
        if (!Extensions.equals(parentArea.getAreaClass(), configuration.getParentClassName())) {
            throw new IllegalArgumentException("Wrong parent area. Expected class: " + configuration.getParentClassName() + " actual class: " + parentArea.getAreaClass());
        }
        ExtensionsAreaImpl area = new ExtensionsAreaImpl(areaClass, areaInstance, (PicoContainer)parentArea.getPicoContainer(), ourLogger);
        ourAreaInstance2area.put(areaInstance, area);
        ourAreaClass2instances.putValue((Object)areaClass, (Object)areaInstance);
        ourAreaInstance2class.put(areaInstance, areaClass);
        for (AreaListener listener : listeners = Extensions.getAreaListeners()) {
            listener.areaCreated(areaClass, areaInstance);
        }
    }

    private static AreaListener[] getAreaListeners() {
        return Extensions.getRootArea().getExtensionPoint(AREA_LISTENER_EXTENSION_POINT).getExtensions();
    }

    public static void registerAreaClass(@NonNls String areaClass, @NonNls String parentAreaClass) {
        if (ourAreaClass2Configuration.containsKey(areaClass)) {
            AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
            if (!Extensions.equals(configuration.getParentClassName(), parentAreaClass)) {
                throw new RuntimeException("Area class already registered: " + areaClass, ourAreaClass2Configuration.get(areaClass).getCreationPoint());
            }
            return;
        }
        AreaClassConfiguration configuration = new AreaClassConfiguration(areaClass, parentAreaClass);
        ourAreaClass2Configuration.put(areaClass, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeArea(@NotNull AreaInstance areaInstance) {
        if (areaInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.disposeArea must not be null");
        }
        assert (ourAreaInstance2area.containsKey(areaInstance));
        AreaListener[] listeners = Extensions.getAreaListeners();
        String areaClass = ourAreaInstance2class.get(areaInstance);
        if (areaClass == null) {
            throw new IllegalArgumentException("Area class is null (area never instantiated?). Instance: " + areaInstance);
        }
        try {
            for (AreaListener listener : listeners) {
                listener.areaDisposing(areaClass, areaInstance);
            }
        }
        finally {
            ourAreaInstance2area.remove(areaInstance);
            ourAreaClass2instances.removeValue((Object)ourAreaInstance2class.remove(areaInstance), (Object)areaInstance);
            ourAreaInstance2class.remove(areaInstance);
        }
    }

    public static AreaInstance[] getAllAreas(String areaClass) {
        Collection instances = ourAreaClass2instances.get((Object)areaClass);
        return instances.toArray(new AreaInstance[instances.size()]);
    }

    private static boolean equals(Object object1, Object object2) {
        return object1 == object2 || object1 != null && object2 != null && object1.equals(object2);
    }

    public static void setLogProvider(LogProvider logProvider) {
        ourLogger = logProvider;
    }

    static {
        Extensions.createRootArea();
    }

    public static class SimpleLogProvider
    implements LogProvider {
        @Override
        public void error(String message) {
            new Throwable(message).printStackTrace();
        }

        @Override
        public void error(String message, Throwable t) {
            System.err.println(message);
            t.printStackTrace();
        }

        @Override
        public void error(Throwable t) {
            t.printStackTrace();
        }

        @Override
        public void warn(String message) {
            System.err.println(message);
        }

        @Override
        public void warn(String message, Throwable t) {
            System.err.println(message);
            t.printStackTrace();
        }

        @Override
        public void warn(Throwable t) {
            t.printStackTrace();
        }
    }

    private static class AreaClassConfiguration {
        private final String myClassName;
        private final String myParentClassName;
        private final Throwable myCreationPoint = new Throwable();

        AreaClassConfiguration(String className, String parentClassName) {
            this.myClassName = className;
            this.myParentClassName = parentClassName;
        }

        public Throwable getCreationPoint() {
            return this.myCreationPoint;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public String getParentClassName() {
            return this.myParentClassName;
        }
    }
}

