#!/bin/sh
echo 'name: text
version: 0.11.1.5
id: text-0.11.1.5-24dbc1ca0a1252804bf8bef893d5cf9c

license: BSD3
copyright: 2009-2011 Bryan O'\''Sullivan, 2008-2009 Tom Harper
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
            Tom Harper <rtomharper@googlemail.com>
            Duncan Coutts <duncan@haskell.org>
stability:
homepage: https://bitbucket.org/bos/text
package-url:
description: .
             An efficient packed, immutable Unicode text type (both strict and
             lazy), with a powerful loop fusion optimization framework.
             .
             The '\''Text'\'' type represents Unicode character strings, in a time and
             space-efficient manner. This package provides text processing
             capabilities that are optimized for performance critical use, both
             in terms of large data quantities and high speed.
             .
             The '\''Text'\'' type provides character-encoding, type-safe case
             conversion via whole-string case conversion functions. It also
             provides a range of functions for converting '\''Text'\'' values to and from
             '\''ByteStrings'\'', using several standard encodings.
             .
             Efficient locale-sensitive support for text IO is also supported.
             .
             These modules are intended to be imported qualified, to avoid name
             clashes with Prelude functions, e.g.
             .
             > import qualified Data.Text as T
             .
             To use an extended and very rich family of functions for working
             with Unicode text (including normalization, regular expressions,
             non-standard encodings, text breaking, and locales), see
             the @text-icu@ package:
             <http://hackage.haskell.org/package/text-icu>
category: Data, Text
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-text
exposed: True
exposed-modules: Data.Text Data.Text.Array Data.Text.Encoding
                 Data.Text.Encoding.Error Data.Text.Foreign Data.Text.IO
                 Data.Text.Internal Data.Text.Lazy Data.Text.Lazy.Builder
                 Data.Text.Lazy.Builder.Int Data.Text.Lazy.Builder.RealFloat
                 Data.Text.Lazy.Encoding Data.Text.Lazy.IO Data.Text.Lazy.Internal
                 Data.Text.Lazy.Read Data.Text.Read
hidden-modules: Data.Text.Encoding.Fusion
                Data.Text.Encoding.Fusion.Common Data.Text.Encoding.Utf16
                Data.Text.Encoding.Utf32 Data.Text.Encoding.Utf8 Data.Text.Fusion
                Data.Text.Fusion.CaseMapping Data.Text.Fusion.Common
                Data.Text.Fusion.Internal Data.Text.Fusion.Size
                Data.Text.IO.Internal Data.Text.Lazy.Builder.Functions
                Data.Text.Lazy.Builder.RealFloat.Functions
                Data.Text.Lazy.Encoding.Fusion Data.Text.Lazy.Fusion
                Data.Text.Lazy.Search Data.Text.Search Data.Text.Unsafe
                Data.Text.Unsafe.Base Data.Text.UnsafeChar Data.Text.UnsafeShift
                Data.Text.Util
import-dirs: /usr/local/lib/ghc/text-0.11.1.5
library-dirs: /usr/local/lib/ghc/text-0.11.1.5
hs-libraries: HStext-0.11.1.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-143060371bda4ff52c270d1067551fe8
         base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         deepseq-1.1.0.2-0465f803f7d27d264907e7e03e72a71f
         ghc-prim-0.2.0.0-d9df11f804556f362beb0ea4e67261ba
         integer-gmp-0.2.0.3-298c59ba68b7aaa7e76ae5b1fe5e876e
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-text-0.11.1.5/html/text.haddock
haddock-html: /usr/local/share/doc/hs-text-0.11.1.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
