#!/bin/sh
echo 'name: semigroupoids
version: 1.2.6
id: semigroupoids-1.2.6-fd1697a5fdbbddeb47427c4dca0be1cf

license: BSD3
copyright: Copyright (C) 2011 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
package-url:
description: Provides a wide array of semigroupoids and operations for working with semigroupds.
             .
             A Semigroupoid is a Category without the requirement of identity arrows for every object in the category.
             .
             When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
             not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
             in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
             .
             Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
             .
             .
             Ideally the following relationships would hold:
             .
             > Traversable <---- Foldable <--- Functor ------> Alt ---------> Plus           Semigroupoid
             >      |               |            |                              |                  |
             >      v               v            v                              v                  v
             > Traversable1 <--- Foldable1     Apply --------> Applicative -> Alternative      Category
             >                                   |               |              |                  |
             >                                   v               v              v                  v
             >                                 Bind ---------> Monad -------> MonadPlus          Arrow
             >
             .
             Apply, Bind, and Extract give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
             .
             This lets us remove many of the restrictions from various monad transformers
             as in many cases the binding operation or @\<*\>@ operation does not require them.
             .
             Finally, to work with these weaker structures it is beneficial to have containers
             that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
             and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
pkgpath: devel/hs-semigroupoids
exposed: True
exposed-modules: Data.Functor.Alt Data.Functor.Apply
                 Data.Functor.Bind Data.Functor.Bind.Trans Data.Functor.Plus
                 Data.Semigroup.Foldable Data.Semigroup.Traversable
                 Data.Semigroupoid Data.Semigroupoid.Dual Data.Semigroupoid.Static
                 Data.Traversable.Instances
hidden-modules:
import-dirs: /usr/local/lib/ghc/semigroupoids-1.2.6
library-dirs: /usr/local/lib/ghc/semigroupoids-1.2.6
hs-libraries: HSsemigroupoids-1.2.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         comonad-1.1.1.1-f476e360a9b2b159a1a1857fd6affcc0
         containers-0.4.0.0-b4885363abca642443ccd842502a3b7e
         contravariant-0.1.2-63dbce92591eeda9d33710d2fa60b756
         semigroups-0.8.3.2-035cd31ef7e519671bae332a3a0d7689
         transformers-0.2.2.0-4bbbfde1fb5c4eb17cdb1963dda698f3
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-semigroupoids-1.2.6/html/semigroupoids.haddock
haddock-html: /usr/local/share/doc/hs-semigroupoids-1.2.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
