// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOOLITEM_H
#define _GTKMM_TOOLITEM_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

// This is for including the config header before any code (such as
// the #ifndef GTKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <gtkmm/bin.h>
#include <gtkmm/activatable.h>
#include <gtkmm/sizegroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkToolItem GtkToolItem;
typedef struct _GtkToolItemClass GtkToolItemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ToolItem_Class; } // namespace Gtk
namespace Gtk
{

/**
 * @ingroup Widgets
 */

class ToolItem
 : public Bin,
   public Activatable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ToolItem CppObjectType;
  typedef ToolItem_Class CppClassType;
  typedef GtkToolItem BaseObjectType;
  typedef GtkToolItemClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ToolItem();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ToolItem_Class;
  static CppClassType toolitem_class_;

  // noncopyable
  ToolItem(const ToolItem&);
  ToolItem& operator=(const ToolItem&);

protected:
  explicit ToolItem(const Glib::ConstructParams& construct_params);
  explicit ToolItem(GtkToolItem* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkToolItem*       gobj()       { return reinterpret_cast<GtkToolItem*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkToolItem* gobj() const { return reinterpret_cast<GtkToolItem*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_create_menu_proxy().
  virtual bool on_create_menu_proxy();
  /// This is a default handler for the signal signal_toolbar_reconfigured().
  virtual void on_toolbar_reconfigured();


private:

  
public:
  ToolItem();

  
  /** Sets whether @a tool_item is to be allocated the same size as other
   * homogeneous items. The effect is that all homogeneous items will have
   * the same width as the widest of the items.
   * 
   * @newin{2,4}
   * @param homogeneous Whether @a tool_item is the same size as other homogeneous items.
   */
  void set_homogeneous(bool homogeneous =  true);
  
  /** Returns whether @a tool_item is the same size as other homogeneous
   * items. See set_homogeneous().
   * 
   * @newin{2,4}
   * @return <tt>true</tt> if the item is the same size as other homogeneous
   * items.
   */
  bool get_homogeneous() const;

  
  /** Sets whether @a tool_item is allocated extra space when there
   * is more room on the toolbar then needed for the items. The
   * effect is that the item gets bigger when the toolbar gets bigger
   * and smaller when the toolbar gets smaller.
   * 
   * @newin{2,4}
   * @param expand Whether @a tool_item is allocated extra space.
   */
  void set_expand(bool expand =  true);
  
  /** Returns whether @a tool_item is allocated extra space.
   * See set_expand().
   * 
   * @newin{2,4}
   * @return <tt>true</tt> if @a tool_item is allocated extra space.
   */
  bool get_expand() const;

   //deprecated.

  
  /** Sets the text to be displayed as tooltip on the item.
   * See Gtk::Widget::set_tooltip_text().
   * 
   * @newin{2,12}
   * @param text Text to be used as tooltip for @a tool_item.
   */
  void set_tooltip_text(const Glib::ustring& text);
  
  /** Sets the markup text to be displayed as tooltip on the item.
   * See Gtk::Widget::set_tooltip_markup().
   * 
   * @newin{2,12}
   * @param markup Markup text to be used as tooltip for @a tool_item.
   */
  void set_tooltip_markup(const Glib::ustring& markup);

  
  /** Sets whether @a tool_item has a drag window. When <tt>true</tt> the
   * toolitem can be used as a drag source through Gtk::DragSource::set().
   * When @a tool_item has a drag window it will intercept all events,
   * even those that would otherwise be sent to a child of @a tool_item.
   * 
   * @newin{2,4}
   * @param use_drag_window Whether @a tool_item has a drag window.
   */
  void set_use_drag_window(bool use_drag_window =  true);
  
  /** Returns whether @a tool_item has a drag window. See
   * set_use_drag_window().
   * 
   * @newin{2,4}
   * @return <tt>true</tt> if @a tool_item uses a drag window.
   */
  bool get_use_drag_window() const;

  
  /** Sets whether @a tool_item is visible when the toolbar is docked horizontally.
   * 
   * @newin{2,4}
   * @param visible_horizontal Whether @a tool_item is visible when in horizontal mode.
   */
  void set_visible_horizontal(bool visible_horizontal =  true);
  
  /** Returns whether the @a tool_item is visible on toolbars that are
   * docked horizontally.
   * 
   * @newin{2,4}
   * @return <tt>true</tt> if @a tool_item is visible on toolbars that are
   * docked horizontally.
   */
  bool get_visible_horizontal() const;

  
  /** Sets whether @a tool_item is visible when the toolbar is docked
   * vertically. Some tool items, such as text entries, are too wide to be
   * useful on a vertically docked toolbar. If @a visible_vertical is <tt>false</tt>
   *  @a tool_item will not appear on toolbars that are docked vertically.
   * 
   * @newin{2,4}
   * @param visible_vertical Whether @a tool_item is visible when the toolbar
   * is in vertical mode.
   */
  void set_visible_vertical(bool visible_vertical =  true);
  
  /** Returns whether @a tool_item is visible when the toolbar is docked vertically.
   * See set_visible_vertical().
   * 
   * @newin{2,4}
   * @return Whether @a tool_item is visible when the toolbar is docked vertically.
   */
  bool get_visible_vertical() const;

  
  /** Returns whether @a tool_item is considered important. See
   * set_is_important()
   * 
   * @newin{2,4}
   * @return <tt>true</tt> if @a tool_item is considered important.
   */
  bool get_is_important() const;
  
  /** Sets whether @a tool_item should be considered important. The Gtk::ToolButton
   * class uses this property to determine whether to show or hide its label
   * when the toolbar style is Gtk::TOOLBAR_BOTH_HORIZ. The result is that
   * only tool buttons with the "is_important" property set have labels, an
   * effect known as "priority text"
   * 
   * @newin{2,4}
   * @param is_important Whether the tool item should be considered important.
   */
  void set_is_important(bool is_important =  true);

  
  /** Returns the ellipsize mode used for @a tool_item. Custom subclasses of
   * Gtk::ToolItem should call this function to find out how text should
   * be ellipsized.
   * 
   * @newin{2,20}
   * @return A Pango::EllipsizeMode indicating how text in @a tool_item
   * should be ellipsized.
   */
  Pango::EllipsizeMode get_ellipsize_mode() const;
  
  /** Returns the icon size used for @a tool_item. Custom subclasses of
   * Gtk::ToolItem should call this function to find out what size icons
   * they should use.
   * 
   * @newin{2,4}
   * @return A Gtk::IconSize indicating the icon size
   * used for @a tool_item.
   */
  IconSize get_icon_size() const;
  
  /** Returns the orientation used for @a tool_item. Custom subclasses of
   * Gtk::ToolItem should call this function to find out what size icons
   * they should use.
   * 
   * @newin{2,4}
   * @return A Gtk::Orientation indicating the orientation
   * used for @a tool_item.
   */
  Orientation get_orientation() const;
  
  /** Returns the toolbar style used for @a tool_item. Custom subclasses of
   * Gtk::ToolItem should call this function in the handler of the
   * GtkToolItem::toolbar_reconfigured signal to find out in what style
   * the toolbar is displayed and change themselves accordingly 
   * 
   * Possibilities are:
   * -  GTK_TOOLBAR_BOTH, meaning the tool item should show
   * both an icon and a label, stacked vertically 
   * -  GTK_TOOLBAR_ICONS, meaning the toolbar shows
   * only icons 
   * -  GTK_TOOLBAR_TEXT, meaning the tool item should only
   * show text
   * -  GTK_TOOLBAR_BOTH_HORIZ, meaning the tool item should show
   * both an icon and a label, arranged horizontally (however, note the 
   * Gtk::ToolButton::property_has()_text_horizontally property that makes tool buttons not
   * show labels when the toolbar style is GTK_TOOLBAR_BOTH_HORIZ.
   * 
   * @newin{2,4}
   * @return A Gtk::ToolbarStyle indicating the toolbar style used
   * for @a tool_item.
   */
  ToolbarStyle get_toolbar_style() const;
  
  /** Returns the relief style of @a tool_item. See gtk_button_set_relief_style().
   * Custom subclasses of Gtk::ToolItem should call this function in the handler
   * of the Gtk::ToolItem::toolbar_reconfigured signal to find out the
   * relief style of buttons.
   * 
   * @newin{2,4}
   * @return A Gtk::ReliefStyle indicating the relief style used
   * for @a tool_item.
   */
  ReliefStyle get_relief_style() const;

  
  /** Returns the text alignment used for @a tool_item. Custom subclasses of
   * Gtk::ToolItem should call this function to find out how text should
   * be aligned.
   * 
   * @newin{2,20}
   * @return A #gfloat indicating the horizontal text alignment
   * used for @a tool_item.
   */
  float get_text_alignment() const;
  
  /** Returns the text orientation used for @a tool_item. Custom subclasses of
   * Gtk::ToolItem should call this function to find out how text should
   * be orientated.
   * 
   * @newin{2,20}
   * @return A Gtk::Orientation indicating the text orientation
   * used for @a tool_item.
   */
  Orientation get_text_orientation() const;
  
  /** Returns the size group used for labels in @a tool_item.
   * Custom subclasses of Gtk::ToolItem should call this function
   * and use the size group for labels.
   * 
   * @newin{2,20}
   * @return A Gtk::SizeGroup.
   */
  Glib::RefPtr<SizeGroup> get_text_size_group();
  
  /** Returns the size group used for labels in @a tool_item.
   * Custom subclasses of Gtk::ToolItem should call this function
   * and use the size group for labels.
   * 
   * @newin{2,20}
   * @return A Gtk::SizeGroup.
   */
  Glib::RefPtr<const SizeGroup> get_text_size_group() const;

  
  /** Returns the Gtk::MenuItem that was last set by
   * set_proxy_menu_item(), ie. the Gtk::MenuItem
   * that is going to appear in the overflow menu.
   * 
   * @newin{2,4}
   * @return The Gtk::MenuItem that is going to appear in the
   * overflow menu for @a tool_item.
   */
  Widget* retrieve_proxy_menu_item();
  
  /** Returns the Gtk::MenuItem that was last set by
   * set_proxy_menu_item(), ie. the Gtk::MenuItem
   * that is going to appear in the overflow menu.
   * 
   * @newin{2,4}
   * @return The Gtk::MenuItem that is going to appear in the
   * overflow menu for @a tool_item.
   */
  const Widget* retrieve_proxy_menu_item() const;
  
  /** If @a menu_item_id matches the string passed to
   * set_proxy_menu_item() return the corresponding Gtk::MenuItem.
   * 
   * Custom subclasses of Gtk::ToolItem should use this function to
   * update their menu item when the Gtk::ToolItem changes. That the
   *  @a menu_item_id<!-- -->s must match ensures that a Gtk::ToolItem
   * will not inadvertently change a menu item that they did not create.
   * 
   * @newin{2,4}
   * @param menu_item_id A string used to identify the menu item.
   * @return The Gtk::MenuItem passed to
   * set_proxy_menu_item(), if the @a menu_item_id<!-- -->s
   * match.
   */
  Widget* get_proxy_menu_item(const Glib::ustring& menu_item_id);
  
  /** If @a menu_item_id matches the string passed to
   * set_proxy_menu_item() return the corresponding Gtk::MenuItem.
   * 
   * Custom subclasses of Gtk::ToolItem should use this function to
   * update their menu item when the Gtk::ToolItem changes. That the
   *  @a menu_item_id<!-- -->s must match ensures that a Gtk::ToolItem
   * will not inadvertently change a menu item that they did not create.
   * 
   * @newin{2,4}
   * @param menu_item_id A string used to identify the menu item.
   * @return The Gtk::MenuItem passed to
   * set_proxy_menu_item(), if the @a menu_item_id<!-- -->s
   * match.
   */
  const Widget* get_proxy_menu_item(const Glib::ustring& menu_item_id) const;
  
  /** Sets the Gtk::MenuItem used in the toolbar overflow menu. The
   *  @a menu_item_id is used to identify the caller of this function and
   * should also be used with get_proxy_menu_item().
   * 
   * @newin{2,4}
   * @param menu_item_id A string used to identify @a menu_item.
   * @param menu_item A Gtk::MenuItem to be used in the overflow menu.
   */
  void set_proxy_menu_item(const Glib::ustring& menu_item_id, Widget& menu_item);

  
  /** Calling this function signals to the toolbar that the
   * overflow menu item for @a tool_item has changed. If the
   * overflow menu is visible when this function it called,
   * the menu will be rebuilt.
   * 
   * The function must be called when the tool item changes what it
   * will do in response to the Gtk::ToolItem::signal_create_menu_proxy() signal.
   * 
   * @newin{2,6}
   */
  void rebuild_menu();

  
  /** Emits the signal Gtk::ToolItem::toolbar_reconfigured on @a tool_item.
   * Gtk::Toolbar and other Gtk::ToolShell implementations use this function
   * to notify children, when some aspect of their configuration changes.
   * 
   * @newin{2,14}
   */
  void toolbar_reconfigured();

  //TODO: This suggests calling set_proxy_menu_item() with NULL. but the function asserts against that.
  
/**
   * @par Slot Prototype:
   * <tt>bool on_my_%create_menu_proxy()</tt>
   *
   * This signal is emitted when the toolbar needs information from @a tool_item
   * about whether the item should appear in the toolbar overflow menu. In
   * response the tool item should either
   * - call Gtk::ToolItem::set_proxy_menu_item() with a <tt>0</tt>
   * pointer and return <tt>true</tt> to indicate that the item should not appear
   * in the overflow menu
   * -  call Gtk::ToolItem::set_proxy_menu_item() with a new menu
   * item and return <tt>true</tt>, or 
   * -  return <tt>false</tt> to indicate that the signal was not
   * handled by the item. This means that
   * the item will not appear in the overflow menu unless a later handler
   * installs a menu item.
   * 
   * The toolbar may cache the result of this signal. When the tool item changes
   * how it will respond to this signal it must call Gtk::ToolItem::rebuild_menu()
   * to invalidate the cache and ensure that the toolbar rebuilds its overflow
   * menu.
   * @return <tt>true</tt> if the signal was handled, <tt>false</tt> if not.
   */

  Glib::SignalProxy0< bool > signal_create_menu_proxy();


/**
   * @par Slot Prototype:
   * <tt>void on_my_%toolbar_reconfigured()</tt>
   *
   * This signal is emitted when some property of the toolbar that the
   * item is a child of changes. For custom subclasses of Gtk::ToolItem,
   * the default handler of this signal use the functions
   * - Gtk::ToolShell::get_orientation()
   * - Gtk::ToolShell::get_style()
   * - Gtk::ToolShell::get_icon_size()
   * - Gtk::ToolShell::get_relief_style()
   * to find out what the toolbar should look like and change
   * themselves accordingly.
   */

  Glib::SignalProxy0< void > signal_toolbar_reconfigured();


  //_WRAP_SIGNAL(bool set_tooltip(Tooltips* tooltips, const Glib::ustring& tip_text, const Glib::ustring& tip_private), set_tooltip, deprecated) //TODO: Implement deprecated for _WRAP_SIGNAL() to avoid hand-coding this:
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a horizontal orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_visible_horizontal() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a horizontal orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_visible_horizontal() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a vertical orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_visible_vertical() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a vertical orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_visible_vertical() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is considered important. When TRUE, toolbar buttons show text in GTK_TOOLBAR_BOTH_HORIZ mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_is_important() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is considered important. When TRUE, toolbar buttons show text in GTK_TOOLBAR_BOTH_HORIZ mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_important() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ToolItem
   */
  Gtk::ToolItem* wrap(GtkToolItem* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_TOOLITEM_H */

