/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MenuSelectionManager {
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    private static final MenuSelectionManager manager = new MenuSelectionManager();
    private Vector selectedPath;

    private /* synthetic */ void finit$() {
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectedPath = new Vector();
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(this.changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(MenuSelectionManager.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(MenuSelectionManager.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(MenuSelectionManager.class$("javax.swing.event.ChangeListener"));
    }

    public void clearSelectedPath() {
        for (int i = this.selectedPath.size() - 1; i >= 0; --i) {
            ((MenuElement)this.selectedPath.get(i)).menuSelectionChanged(false);
        }
        this.selectedPath.clear();
        this.fireStateChanged();
    }

    public Component componentForPoint(Component component, Point point) {
        Point point2 = point;
        if (component.isShowing()) {
            SwingUtilities.convertPointToScreen(point2, component);
        }
        Component component2 = null;
        for (int i = 0; i < this.selectedPath.size(); ++i) {
            Component component3 = (Component)this.selectedPath.get(i);
            Dimension dimension = component3.getSize();
            Point point3 = component3.getLocationOnScreen();
            if (point3.x > point2.x || point2.x >= point3.x + dimension.width || point3.y > point2.y || point2.y >= point3.y + dimension.height) continue;
            Point point4 = point2;
            if (component3.isShowing()) {
                SwingUtilities.convertPointFromScreen(point4, component3);
            }
            component2 = SwingUtilities.getDeepestComponentAt(component3, point4.x, point4.y);
            break;
        }
        return component2;
    }

    public static MenuSelectionManager defaultManager() {
        return manager;
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] menuElementArray = new MenuElement[this.selectedPath.size()];
        for (int i = 0; i < menuElementArray.length; ++i) {
            menuElementArray[i] = (MenuElement)this.selectedPath.get(i);
        }
        return menuElementArray;
    }

    public boolean isComponentPartOfCurrentMenu(Component component) {
        boolean bl = false;
        block0: for (int i = 0; i < this.selectedPath.size(); ++i) {
            MenuElement menuElement = (MenuElement)this.selectedPath.get(i);
            if (SwingUtilities.isDescendingFrom(component, menuElement.getComponent())) {
                bl = true;
                break;
            }
            MenuElement[] menuElementArray = menuElement.getSubElements();
            for (int j = 0; j < menuElementArray.length; ++j) {
                MenuElement menuElement2 = menuElementArray[j];
                if (menuElement2 == null || !SwingUtilities.isDescendingFrom(component, menuElement2.getComponent())) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        MenuElement[] menuElementArray;
        MenuElement[] menuElementArray2 = (MenuElement[])this.selectedPath.toArray(new MenuElement[this.selectedPath.size()]);
        if (menuElementArray2.length == 0) {
            return;
        }
        for (int i = menuElementArray2.length - 1; i >= 0; --i) {
            MenuElement menuElement = menuElementArray2[i];
            MenuElement[] menuElementArray3 = menuElement.getSubElements();
            menuElementArray = null;
            for (int j = 0; j < menuElementArray3.length; ++j) {
                MenuElement menuElement2 = menuElementArray3[j];
                if (menuElement2 == null || !menuElement2.getComponent().isShowing() || !menuElement2.getComponent().isEnabled()) continue;
                if (menuElementArray == null) {
                    menuElementArray = new MenuElement[i + 2];
                    System.arraycopy(menuElementArray2, 0, menuElementArray, 0, i + 1);
                }
                menuElementArray[i + 1] = menuElement2;
                menuElement2.processKeyEvent(keyEvent, menuElementArray, this);
                if (keyEvent.isConsumed()) break;
            }
            if (keyEvent.isConsumed()) break;
        }
        if (!keyEvent.isConsumed()) {
            menuElementArray = new MenuElement[]{menuElementArray2[0]};
            menuElementArray[0].processKeyEvent(keyEvent, menuElementArray, this);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        Component component2 = mouseEvent.getID() == 506 || mouseEvent.getID() == 502 ? this.componentForPoint(component, mouseEvent.getPoint()) : component;
        if (component2 != null && component2 instanceof MenuElement) {
            MenuElement[] menuElementArray = this.getPath(component2);
            ((MenuElement)((Object)component2)).processMouseEvent(mouseEvent, menuElementArray, manager);
        } else if (mouseEvent.getID() == 502) {
            this.clearSelectedPath();
        }
    }

    public void setSelectedPath(MenuElement[] menuElementArray) {
        int n;
        if (menuElementArray == null) {
            this.clearSelectedPath();
            return;
        }
        int n2 = menuElementArray.length;
        int n3 = this.selectedPath.size();
        int n4 = 0;
        for (n = 0; n < n2 && n < n3 && (MenuElement)this.selectedPath.get(n) == menuElementArray[n]; ++n) {
            ++n4;
        }
        for (n = n3 - 1; n >= n4; --n) {
            MenuElement menuElement = (MenuElement)this.selectedPath.get(n);
            this.selectedPath.remove(n);
            menuElement.menuSelectionChanged(false);
        }
        for (n = n4; n < n2; ++n) {
            if (menuElementArray[n] == null) continue;
            this.selectedPath.add(menuElementArray[n]);
            menuElementArray[n].menuSelectionChanged(true);
        }
        this.fireStateChanged();
    }

    private MenuElement[] getPath(Component component) {
        ArrayList arrayList = new ArrayList();
        if (component instanceof JMenu) {
            arrayList.add(((JMenu)component).getPopupMenu());
        }
        while (component instanceof MenuElement) {
            arrayList.add(0, (MenuElement)((Object)component));
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component.getParent();
        }
        Object[] objectArray = new MenuElement[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public MenuSelectionManager() {
        this.finit$();
    }
}

