module Examples.Simple.Pairs where

import Prelude ()
import Feldspar
import Feldspar.Vector
import Feldspar.Compiler

-- | Haskell pairs are compiled to separate variables.
pairs1 :: Data Int32 -> Data Float -> (Data Int32, Data Float)
pairs1 x y = (x,y)

-- | Feldspar pairs are compiled to structs.
pairs2 :: Data Int32 -> Data Float -> Data (Int32,Float)
pairs2 x y = pair x y

-- | Selector functions: getFst, getSnd.
pairs3 :: Data (Int32,Float) -> (Data Int32, Data Float)
pairs3 p = (getFst p, getSnd p)

-- | Zipping two vectors into a vector of pairs.
pairs4 :: Data [Float] -> Data [Int32] -> Data [(Float,Int32)]
pairs4 xs ys = freezeVector $ zipWith pair (unfreezeVector' 256 xs) (unfreezeVector' 256 ys)

