/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.CompositeReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jdt.internal.ui.text.java.JavaReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingReconcileStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaCompositeReconcilingStrategy
extends CompositeReconcilingStrategy {
    private ITextEditor fEditor;
    private JavaReconcilingStrategy fJavaStrategy;

    public JavaCompositeReconcilingStrategy(ITextEditor editor, String documentPartitioning) {
        this.fEditor = editor;
        this.fJavaStrategy = new JavaReconcilingStrategy(editor);
        this.setReconcilingStrategies(new IReconcilingStrategy[]{this.fJavaStrategy, new JavaSpellingReconcileStrategy(editor)});
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel m;
        IDocumentProvider p = this.fEditor.getDocumentProvider();
        if (p == null) {
            p = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        }
        if ((m = p.getAnnotationModel((Object)this.fEditor.getEditorInput())) instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)m;
        }
        return null;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(dirtyRegion, subRegion);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(partition);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(partition);
        }
    }

    public void notifyListeners(boolean notify) {
        this.fJavaStrategy.notifyListeners(notify);
    }

    public void initialReconcile() {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.initialReconcile();
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.initialReconcile();
        }
    }

    public void aboutToBeReconciled() {
        this.fJavaStrategy.aboutToBeReconciled();
    }
}

