/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitDescriptorChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ExtractTempRefactoring
extends ScriptableRefactoring {
    private static final String ID_EXTRACT_TEMP = "org.eclipse.jdt.ui.extract.temp";
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private CompilationUnit fCompilationUnitNode;
    private ICompilationUnit fCu;
    private boolean fDeclareFinal;
    private String[] fExcludedVariableNames;
    private boolean fReplaceAllOccurrences;
    private IExpressionFragment fSelectedExpression;
    private String fTempTypeName;
    private int fSelectionLength;
    private int fSelectionStart;
    private String fTempName;
    private TextEdit fImportEdit;
    private TextChange fChange;

    private static boolean allArraysEqual(Object[][] arrays, int position) {
        Object element = arrays[0][position];
        int i = 0;
        while (i < arrays.length) {
            Object[] array = arrays[i];
            if (!element.equals(array[position])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (ExtractTempRefactoring.isMethodParameter(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isThrowableInCatchBlock(node)) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        if (ExtractTempRefactoring.isLeftValue(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
            return false;
        }
        if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater((Expression)node)) {
            return false;
        }
        return !(parent instanceof SwitchCase);
    }

    private static Object[] getArrayPrefix(Object[] array, int prefixLength) {
        Assert.isTrue((prefixLength <= array.length ? 1 : 0) != 0);
        Assert.isTrue((prefixLength >= 0 ? 1 : 0) != 0);
        Object[] prefix = new Object[prefixLength];
        int i = 0;
        while (i < prefix.length) {
            prefix[i] = array[i];
            ++i;
        }
        return prefix;
    }

    private static List getForInitializedVariables(VariableDeclarationExpression variableDeclarations) {
        ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
        for (VariableDeclarationFragment fragment : variableDeclarations.fragments()) {
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null) continue;
            forInitializerVariables.add(binding);
        }
        return forInitializerVariables;
    }

    private static Object[] getLongestArrayPrefix(Object[][] arrays) {
        int length = -1;
        if (arrays.length == 0) {
            return new Object[0];
        }
        int minArrayLength = arrays[0].length;
        int i = 1;
        while (i < arrays.length) {
            minArrayLength = Math.min(minArrayLength, arrays[i].length);
            ++i;
        }
        i = 0;
        while (i < minArrayLength) {
            if (!ExtractTempRefactoring.allArraysEqual(arrays, i)) break;
            ++length;
            ++i;
        }
        if (length == -1) {
            return new Object[0];
        }
        return ExtractTempRefactoring.getArrayPrefix(arrays[0], length + 1);
    }

    private static ASTNode[] getParents(ASTNode node) {
        ASTNode current = node;
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>();
        do {
            parents.add(current.getParent());
        } while ((current = current.getParent()).getParent() != null);
        Collections.reverse(parents);
        return parents.toArray(new ASTNode[parents.size()]);
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return ExtractTempRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private static boolean isLeftValue(ASTNode node) {
        Assignment assignment;
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getLeftHandSide() == node) {
            return true;
        }
        if (parent instanceof PostfixExpression) {
            return true;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression.Operator op = ((PrefixExpression)parent).getOperator();
            if (op.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return op.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        Expression current = expression;
        ASTNode parent = current.getParent();
        while (parent != null && !(parent instanceof BodyDeclaration)) {
            List initializers;
            ForStatement forStmt;
            if (parent instanceof ForStatement && ((forStmt = (ForStatement)parent).initializers().contains(current) || forStmt.updaters().contains(current) || forStmt.getExpression() == current) && (initializers = forStmt.initializers()).size() == 1 && initializers.get(0) instanceof VariableDeclarationExpression) {
                List forInitializerVariables = ExtractTempRefactoring.getForInitializedVariables((VariableDeclarationExpression)initializers.get(0));
                ForStatementChecker checker = new ForStatementChecker(forInitializerVariables);
                expression.accept((ASTVisitor)checker);
                if (checker.isReferringToForVariable()) {
                    return true;
                }
            }
            current = parent;
            parent = current.getParent();
        }
        return false;
    }

    private static boolean isThrowableInCatchBlock(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forStmt = (ForStatement)parent;
            return forStmt.initializers().contains(expression) || forStmt.updaters().contains(expression);
        }
        return false;
    }

    private static String removeTrailingSemicolons(String s) {
        String arg = s.trim();
        if (!arg.endsWith(";")) {
            return arg;
        }
        return ExtractTempRefactoring.removeTrailingSemicolons(arg.substring(0, arg.length() - 1));
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            if (ExtractTempRefactoring.canReplace(allMatches[i])) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    public ExtractTempRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
    }

    private void addReplaceExpressionWithTemp(TextChange change) throws JavaModelException {
        TextEdit[] edits = this.createReplaceExpressionWithTempEdits();
        int i = 0;
        while (i < edits.length) {
            TextChangeCompatibility.addTextEdit(change, RefactoringCoreMessages.ExtractTempRefactoring_replace, edits[i]);
            ++i;
        }
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (selectedExpression != null) {
            ASTNode parent = selectedExpression.getParent();
            if (selectedExpression instanceof NullLiteral) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
            }
            if (selectedExpression instanceof ArrayInitializer) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
            }
            if (selectedExpression instanceof Assignment) {
                if (parent instanceof Expression && !(parent instanceof ParenthesizedExpression)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
                }
                return null;
            }
            if (selectedExpression instanceof SimpleName) {
                if (((SimpleName)selectedExpression).isDeclaration()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
                }
                if (parent instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || parent instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
                }
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        ITextFileBuffer buffer = null;
        ICompilationUnit original = this.fCu.getPrimary();
        try {
            buffer = RefactoringFileBuffers.acquire(original);
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 3);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkMatchingFragments());
            if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fTempName)) {
                result.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, this.fTempName));
            }
            TextChange change = this.doCreateChange(buffer, pm);
            change.setKeepPreviewEdits(true);
            this.checkNewSource(change, result);
            this.fChange = change;
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            RefactoringFileBuffers.release(original);
            pm.done();
        }
    }

    private TextChange doCreateChange(ITextFileBuffer buffer, IProgressMonitor pm) throws CoreException, JavaModelException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description_short, this.fTempName);
        String expression = ASTNodes.asString((ASTNode)this.fSelectedExpression.getAssociatedExpression());
        String header = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description, new String[]{this.fTempName, expression});
        JavaRefactoringDescriptorComment comment = new JavaRefactoringDescriptorComment(this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_name_pattern, this.fTempName));
        BodyDeclaration decl = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression.getAssociatedExpression(), BodyDeclaration.class);
        if (decl instanceof MethodDeclaration) {
            IMethodBinding method = ((MethodDeclaration)decl).resolveBinding();
            String label = method != null ? BindingLabelProvider.getBindingLabel((IBinding)method, JavaElementLabels.ALL_FULLY_QUALIFIED) : "{...}";
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_destination_pattern, label));
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_expression_pattern, expression));
        if (this.fReplaceAllOccurrences) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_replace_occurrences);
        }
        if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_declare_final);
        }
        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_EXTRACT_TEMP, project, description, comment.asString(), arguments, 0);
        arguments.put("input", descriptor.elementToHandle((IJavaElement)this.fCu));
        arguments.put("name", this.fTempName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllOccurrences).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        CompilationUnitDescriptorChange result = new CompilationUnitDescriptorChange(descriptor, RefactoringCoreMessages.ExtractTempRefactoring_extract_temp, this.fCu);
        try {
            String lineDelimiter = buffer.getDocument().getLineDelimiter(buffer.getDocument().getLineOfOffset(this.fSelectionStart));
            TextEdit tempDeclarationEdit = this.createTempDeclarationEdit(lineDelimiter);
            TextChangeCompatibility.addTextEdit((TextChange)result, RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable, tempDeclarationEdit);
        }
        catch (CoreException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        pm.worked(1);
        if (this.fImportEdit != null) {
            TextChangeCompatibility.addTextEdit((TextChange)result, RefactoringCoreMessages.ExtractTempRefactoring_update_imports, this.fImportEdit.copy());
        }
        pm.worked(1);
        this.addReplaceExpressionWithTemp((TextChange)result);
        pm.worked(1);
        return result;
    }

    private void checkNewSource(TextChange change, RefactoringStatus result) throws CoreException {
        String newCuSource = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit newCUNode = new RefactoringASTParser(3).parse(newCuSource, this.fCu, true, true, null);
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCompilationUnitNode);
        int i = 0;
        while (i < newProblems.length) {
            IProblem problem = newProblems[i];
            if (problem.isError()) {
                result.addEntry(new RefactoringStatusEntry(problem.isError() ? 3 : 2, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, new SourceRange(problem))));
            }
            ++i;
        }
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit rootNode, IProgressMonitor pm) throws JavaModelException {
        this.fCompilationUnitNode = rootNode;
        return this.checkSelection(pm);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 6);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            CompilationUnit rootNode = RefactoringASTParser.parseWithASTProvider(this.fCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            result.merge(this.checkActivationBasics(rootNode, (IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (!result.hasFatalError() && this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkMatchingFragments() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IASTFragment[] matchingFragments = this.getMatchingFragments();
        int i = 0;
        while (i < matchingFragments.length) {
            ASTNode node = matchingFragments[i].getAssociatedNode();
            if (ExtractTempRefactoring.isLeftValue(node) && !ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
                String msg = RefactoringCoreMessages.ExtractTempRefactoring_assigned_to;
                result.addWarning(msg, JavaStatusContext.create(this.fCu, node));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask("", 8);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.ExtractTempRefactoring_select_expression;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.isUsedInExplicitConstructorCall()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_explicit_constructor);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.getEnclosingBodyNode() == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_expr_in_method_or_initializer);
                return refactoringStatus;
            }
            pm.worked(1);
            ASTNode associatedNode = selectedExpression.getAssociatedNode();
            if (associatedNode instanceof Name && associatedNode.getParent() instanceof ClassInstanceCreation && associatedNode.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkExpressionFragmentIsRValue());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_for_initializer_updater);
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isReferringToLocalVariableFromFor(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_refers_to_for_variable);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkTempName(String newName) {
        RefactoringStatus status = Checks.checkTempName(newName);
        if (Arrays.asList(this.getExcludedVariableNames()).contains(newName)) {
            status.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, newName));
        }
        return status;
    }

    private TextEdit createAndInsertTempDeclaration(String delimiter) throws CoreException {
        String declarationText = this.createTempDeclarationSource(this.getInitializerSource(), false, delimiter);
        return this.getTempDeclarationInsertion(declarationText);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.done();
        return this.fChange;
    }

    private TextEdit[] createReplaceExpressionWithTempEdits() throws JavaModelException {
        IASTFragment[] fragmentsToReplace = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        TextEdit[] result = new TextEdit[fragmentsToReplace.length];
        int i = 0;
        while (i < fragmentsToReplace.length) {
            IASTFragment fragment = fragmentsToReplace[i];
            int offset = fragment.getStartPosition();
            int length = fragment.getLength();
            result[i] = new ReplaceEdit(offset, length, this.fTempName);
            ++i;
        }
        return result;
    }

    private TextEdit createTempDeclarationEdit(String delimiter) throws CoreException {
        if (this.shouldReplaceSelectedExpressionWithTempDeclaration()) {
            return this.replaceSelectedExpressionWithTempDeclaration(delimiter);
        }
        return this.createAndInsertTempDeclaration(delimiter);
    }

    private String createTempDeclarationSource(String initializerSource, boolean addTrailingLineDelimiter, String delimiter) throws CoreException {
        String modifier = this.fDeclareFinal ? "final " : "";
        String dummyInitializer = "0";
        String semicolon = ";";
        String dummyDeclaration = String.valueOf(modifier) + this.getTempTypeName() + " " + this.fTempName + " = " + dummyInitializer + semicolon;
        int[] position = new int[]{dummyDeclaration.length() - dummyInitializer.length() - semicolon.length()};
        String formattedDeclaration = CodeFormatterUtil.format(2, dummyDeclaration, 0, position, delimiter, this.fCu.getJavaProject());
        StringBuffer formattedDummyDeclaration = new StringBuffer(formattedDeclaration);
        String tail = addTrailingLineDelimiter ? delimiter : "";
        return formattedDummyDeclaration.replace(position[0], position[0] + dummyInitializer.length(), initializerSource).append(tail).toString();
    }

    public boolean declareFinal() {
        return this.fDeclareFinal;
    }

    private ASTNode[] findDeepestCommonSuperNodePathForReplacedNodes() throws JavaModelException {
        ASTNode[] matchNodes = this.getMatchNodes();
        Object[][] matchingNodesParents = new ASTNode[matchNodes.length][];
        int i = 0;
        while (i < matchNodes.length) {
            matchingNodesParents[i] = ExtractTempRefactoring.getParents(matchNodes[i]);
            ++i;
        }
        List<Object> l = Arrays.asList(ExtractTempRefactoring.getLongestArrayPrefix(matchingNodesParents));
        return l.toArray(new ASTNode[l.size()]);
    }

    private Block getEnclosingBodyNode() throws JavaModelException {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        do {
            switch (node.getNodeType()) {
                case 31: {
                    return ((MethodDeclaration)node).getBody();
                }
                case 28: {
                    return ((Initializer)node).getBody();
                }
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IBinding[] bindings = new ScopeAnalyzer(this.fCompilationUnitNode).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 2);
                this.fExcludedVariableNames = new String[bindings.length];
                int i = 0;
                while (i < bindings.length) {
                    this.fExcludedVariableNames[i] = bindings[i].getName();
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    private IExpressionFragment getFirstReplacedExpression() throws JavaModelException {
        if (!this.fReplaceAllOccurrences) {
            return this.getSelectedExpression();
        }
        IASTFragment[] nodesToReplace = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        if (nodesToReplace.length == 0) {
            return this.getSelectedExpression();
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IASTFragment)o1).getStartPosition() - ((IASTFragment)o2).getStartPosition();
            }
        };
        Arrays.sort(nodesToReplace, comparator);
        return (IExpressionFragment)nodesToReplace[0];
    }

    private String getInitializerSource() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        return ExtractTempRefactoring.removeTrailingSemicolons(this.fCu.getBuffer().getText(fragment.getStartPosition(), fragment.getLength()));
    }

    private TextEdit insertAt(ASTNode target, ASTRewrite rewrite, Statement declaration) throws JavaModelException {
        ASTNode parent = target.getParent();
        while (!(parent instanceof Block)) {
            StructuralPropertyDescriptor locationInParent = target.getLocationInParent();
            if (locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY) {
                Block replacement = rewrite.getAST().newBlock();
                ListRewrite replacementRewrite = rewrite.getListRewrite((ASTNode)replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst((ASTNode)declaration, null);
                replacementRewrite.insertLast(rewrite.createMoveTarget(target), null);
                rewrite.replace(target, (ASTNode)replacement, null);
                return rewrite.rewriteAST();
            }
            target = parent;
            parent = parent.getParent();
        }
        ListRewrite listRewrite = rewrite.getListRewrite(parent, Block.STATEMENTS_PROPERTY);
        listRewrite.insertBefore((ASTNode)declaration, target, null);
        return rewrite.rewriteAST();
    }

    private IASTFragment[] getMatchingFragments() throws JavaModelException {
        if (this.fReplaceAllOccurrences) {
            IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)this.getEnclosingBodyNode()).getSubFragmentsMatching(this.getSelectedExpression());
            return allMatches;
        }
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private ASTNode[] getMatchNodes() throws JavaModelException {
        IASTFragment[] matches = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTNode[] result = new ASTNode[matches.length];
        int i = 0;
        while (i < matches.length) {
            result[i] = matches[i].getAssociatedNode();
            ++i;
        }
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractTempRefactoring_name;
    }

    private TextEdit getTempDeclarationInsertion(String declarationText) throws JavaModelException {
        ASTRewrite rewrite = ASTRewrite.create((AST)this.fCompilationUnitNode.getAST());
        Statement declaration = (Statement)rewrite.createStringPlaceholder(declarationText, 21);
        if (!this.fReplaceAllOccurrences || ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments()).length <= 1) {
            return this.insertAt(this.getSelectedExpression().getAssociatedNode(), rewrite, declaration);
        }
        ASTNode[] firstReplaceNodeParents = ExtractTempRefactoring.getParents(this.getFirstReplacedExpression().getAssociatedNode());
        ASTNode[] commonPath = this.findDeepestCommonSuperNodePathForReplacedNodes();
        Assert.isTrue((commonPath.length <= firstReplaceNodeParents.length ? 1 : 0) != 0);
        ASTNode deepestCommonParent = firstReplaceNodeParents[commonPath.length - 1];
        if (deepestCommonParent instanceof Block) {
            return this.insertAt(firstReplaceNodeParents[commonPath.length], rewrite, declaration);
        }
        return this.insertAt(deepestCommonParent, rewrite, declaration);
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null) {
            if (selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
                ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
                Expression expression = exprStatement.getExpression();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
            } else if (selectedFragment.getAssociatedNode() instanceof Assignment) {
                Assignment assignment = (Assignment)selectedFragment.getAssociatedNode();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)assignment);
            }
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private String getTempTypeName() throws CoreException {
        if (this.fTempTypeName == null) {
            String tempTypeName;
            Expression expression = this.getSelectedExpression().getAssociatedExpression();
            if (expression instanceof ClassInstanceCreation) {
                ClassInstanceCreation creation = (ClassInstanceCreation)expression;
                tempTypeName = creation.getExpression() instanceof ClassInstanceCreation ? String.valueOf(this.getClassInstanceName((ClassInstanceCreation)creation.getExpression())) + this.getClassInstanceName(creation) : this.getClassInstanceName(creation);
            } else if (expression instanceof CastExpression) {
                CastExpression cast = (CastExpression)expression;
                tempTypeName = ASTNodes.asString((ASTNode)cast.getType());
            } else {
                ITypeBinding typeBinding = expression.resolveTypeBinding();
                if (typeBinding.isPrimitive()) {
                    tempTypeName = typeBinding.getName();
                } else {
                    typeBinding = Bindings.normalizeForDeclarationUse(typeBinding, expression.getAST());
                    ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fCu, true);
                    tempTypeName = importRewrite.addImport(typeBinding);
                    this.fImportEdit = importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor());
                }
            }
            this.fTempTypeName = tempTypeName;
        }
        return this.fTempTypeName;
    }

    private String getClassInstanceName(ClassInstanceCreation creation) {
        return ASTNodes.asString((ASTNode)creation.getType());
    }

    public String guessTempName() {
        String[] proposals = this.guessTempNames();
        if (proposals.length == 0) {
            return this.fTempName;
        }
        return proposals[0];
    }

    public String[] guessTempNames() {
        LinkedHashSet proposals = new LinkedHashSet();
        try {
            Expression expression;
            String[] excludedVariableNames = this.getExcludedVariableNames();
            ASTNode associatedNode = this.getSelectedExpression().getAssociatedNode();
            if (associatedNode instanceof MethodInvocation) {
                proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)associatedNode, excludedVariableNames));
            } else if (associatedNode instanceof CastExpression && (expression = ((CastExpression)associatedNode).getExpression()) instanceof MethodInvocation) {
                proposals.addAll(this.guessTempNamesFromMethodInvocation((MethodInvocation)expression, excludedVariableNames));
            }
            if (associatedNode instanceof Expression) {
                proposals.addAll(this.guessTempNamesFromExpression((Expression)associatedNode, excludedVariableNames));
            }
        }
        catch (JavaModelException javaModelException) {}
        return proposals.toArray(new String[proposals.size()]);
    }

    private List guessTempNamesFromExpression(Expression selectedExpression, String[] excluded) {
        ITypeBinding expressionBinding = selectedExpression.resolveTypeBinding();
        String typeName = ExtractTempRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        int typeParamStart = typeName.indexOf("<");
        if (typeParamStart != -1) {
            typeName = typeName.substring(0, typeParamStart);
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fCu.getJavaProject(), typeName, expressionBinding.getDimensions(), excluded);
        return Arrays.asList(proposals);
    }

    private List guessTempNamesFromMethodInvocation(MethodInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName = selectedMethodInvocation.getName().getIdentifier();
        int i = 0;
        while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
            String prefix = KNOWN_METHOD_NAME_PREFIXES[i];
            if (methodName.startsWith(prefix)) {
                if (methodName.length() == prefix.length()) {
                    return Collections.EMPTY_LIST;
                }
                char firstAfterPrefix = methodName.charAt(prefix.length());
                if (Character.isUpperCase(firstAfterPrefix)) {
                    String proposal;
                    methodName = proposal = String.valueOf(Character.toLowerCase(firstAfterPrefix)) + methodName.substring(prefix.length() + 1);
                    break;
                }
            }
            ++i;
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fCu.getJavaProject(), methodName, 0, excludedVariableNames);
        return Arrays.asList(proposals);
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedInExplicitConstructorCall() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (ASTNodes.getParent((ASTNode)selectedExpression, ConstructorInvocation.class) != null) {
            return true;
        }
        return ASTNodes.getParent((ASTNode)selectedExpression, SuperConstructorInvocation.class) != null;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    private TextEdit replaceSelectedExpressionWithTempDeclaration(String delimiter) throws CoreException {
        String nodeSource = this.fCu.getBuffer().getText(this.getSelectedExpression().getStartPosition(), this.getSelectedExpression().getLength());
        String text = this.createTempDeclarationSource(nodeSource, false, delimiter);
        ASTNode parent = this.getSelectedExpression().getAssociatedNode().getParent();
        Assert.isTrue((boolean)(parent instanceof ExpressionStatement));
        return new ReplaceEdit(parent.getStartPosition(), parent.getLength(), text);
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setTempName(String newName) {
        this.fTempName = newName;
    }

    private boolean shouldReplaceSelectedExpressionWithTempDeclaration() throws JavaModelException {
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        return selectedFragment.getAssociatedNode().getParent() instanceof ExpressionStatement && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(selectedFragment.getAssociatedNode()));
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String declareFinal;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaElement element;
            int length;
            int offset;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String selection = extended.getAttribute("selection");
            if (selection != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, ID_EXTRACT_TEMP);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (ICompilationUnit)element;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fTempName = name;
            String replace = extended.getAttribute(ATTRIBUTE_REPLACE);
            if (replace == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
            }
            this.fReplaceAllOccurrences = Boolean.valueOf(replace);
            declareFinal = extended.getAttribute(ATTRIBUTE_FINAL);
            if (declareFinal == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDeclareFinal = Boolean.valueOf(declareFinal);
        return new RefactoringStatus();
    }

    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection forInitializerVariables) {
            Assert.isNotNull((Object)forInitializerVariables);
            this.fForInitializerVariables = forInitializerVariables;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && this.fForInitializerVariables.contains(binding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }
}

