/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.StringManager;

public final class EngineConfig
implements LifecycleListener {
    private int debug = 0;
    private Engine engine = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int engineDebug;
            this.engine = (Engine)((Object)event.getLifecycle());
            if (this.engine instanceof StandardEngine && (engineDebug = ((StandardEngine)this.engine).getDebug()) > this.debug) {
                this.debug = engineDebug;
            }
        }
        catch (ClassCastException e) {
            this.log(sm.getString("engineConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.engine != null) {
            logger = this.engine.getLogger();
        }
        if (logger != null) {
            logger.log("EngineConfig: " + message);
        } else {
            System.out.println("EngineConfig: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.engine != null) {
            logger = this.engine.getLogger();
        }
        if (logger != null) {
            logger.log("EngineConfig: " + message, throwable);
        } else {
            System.out.println("EngineConfig: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(sm.getString("engineConfig.start"));
        }
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(sm.getString("engineConfig.stop"));
        }
    }
}

