/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.history;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.ui.PageSaveablePart;
import org.eclipse.team.ui.SaveablePartDialog;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.HistoryPageSource;
import org.eclipse.team.ui.history.IHistoryCompareAdapter;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.part.Page;

public class HistoryPageSaveablePart
extends PageSaveablePart {
    private IHistoryPage historyPage;
    private DialogHistoryPageSite site;
    private final Object object;
    private final IHistoryPageSource pageSource;

    public static boolean showHistoryInDialog(Shell shell, Object object) {
        IHistoryPageSource pageSource = HistoryPageSource.getHistoryPageSource(object);
        if (pageSource != null && pageSource.canShowHistoryFor(object)) {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(HistoryPageSaveablePart.isFile(object));
            cc.setRightEditable(false);
            HistoryPageSaveablePart input = new HistoryPageSaveablePart(shell, cc, pageSource, object);
            try {
                SaveablePartDialog cd = new SaveablePartDialog(shell, input);
                cd.setBlockOnOpen(true);
                cd.open();
            }
            finally {
                input.dispose();
            }
            return true;
        }
        return false;
    }

    private static boolean isFile(Object object) {
        IResource resource = Utils.getResource(object);
        return resource != null && resource.getType() == 1;
    }

    public HistoryPageSaveablePart(Shell shell, CompareConfiguration configuration, IHistoryPageSource pageSource, Object object) {
        super(shell, configuration);
        this.pageSource = pageSource;
        this.object = object;
    }

    public String getTitle() {
        return this.historyPage.getName();
    }

    public Image getTitleImage() {
        return null;
    }

    public void contentChanged(IContentChangeNotifier source) {
    }

    protected Control createPage(Composite parent, ToolBarManager toolBarManager) {
        this.site = new DialogHistoryPageSite(this.getShell());
        this.historyPage = (IHistoryPage)this.pageSource.createPage(this.object);
        this.historyPage.setSite(this.site);
        this.site.setToolBarManager((IToolBarManager)toolBarManager);
        ((Page)this.historyPage).createControl(parent);
        this.historyPage.setInput(this.object);
        String description = this.historyPage.getDescription();
        if (description == null) {
            description = "";
        }
        this.setPageDescription(description);
        return ((Page)this.historyPage).getControl();
    }

    protected final ISelectionProvider getSelectionProvider() {
        return this.site.getSelectionProvider();
    }

    protected ICompareInput getCompareInput(ISelection selection) {
        ICompareInput compareInput = super.getCompareInput(selection);
        if (compareInput != null) {
            return compareInput;
        }
        IHistoryCompareAdapter compareAdapter = (IHistoryCompareAdapter)Utils.getAdapter(this.historyPage, IHistoryCompareAdapter.class);
        if (compareAdapter != null) {
            return compareAdapter.getCompareInput(selection);
        }
        return null;
    }

    protected void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) throws InvocationTargetException {
        IHistoryCompareAdapter compareAdapter = (IHistoryCompareAdapter)Utils.getAdapter(this.historyPage, IHistoryCompareAdapter.class);
        if (compareAdapter != null) {
            compareAdapter.prepareInput(input, configuration, monitor);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.historyPage != null) {
            ((HistoryPage)this.historyPage).dispose();
        }
    }
}

