/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Jens Lukowski/Innoopract - initial renaming/restructuring
 *     
 *******************************************************************************/
/* The following code was generated by JFlex 1.2.2 on 04/10/01 22:53 */

/*nlsXXX*/
package org.eclipse.wst.sse.core.css.internal.parser;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.wst.sse.core.css.internal.parser.regions.CSSTextRegionFactory;
import org.eclipse.wst.sse.core.css.parser.CSSRegionContexts;
import org.eclipse.wst.sse.core.css.parser.CSSTextToken;
import org.eclipse.wst.sse.core.text.ITextRegion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.informatik.tu-muenchen.de/~kleing/jflex/">JFlex</a> 1.2.2
 */
public class CSSTokenizer implements CSSRegionContexts {

  /** this character denotes the end of file */
  final public static int YYEOF = -1;

  /** lexical states */
  final public static int ST_SELECTOR_ATTRIBUTE_NAME = 11;
  final public static int ST_IMPORT_DELIMITER = 5;
  final public static int ST_DECLARATION_PRE_VALUE = 17;
  final public static int ST_SELECTOR = 0;
  final public static int ST_CHARSET_DELIMITER = 2;
  final public static int ST_DECLARATION_VALUE = 18;
  final public static int ST_PAGE_PSEUDO_PAGE = 8;
  final public static int ST_IMPORT_URI = 3;
  final public static int ST_SELECTOR_ATTRIBUTE_END = 14;
  final public static int ST_SELECTOR_ATTRIBUTE_OPERATOR = 12;
  final public static int ST_DECLARATION = 15;
  final public static int ST_PAGE_DELIMITER = 9;
  final public static int ST_SELECTOR_ATTRIBUTE_VALUE = 13;
  final public static int ST_MEDIA_MEDIUM = 6;
  final public static int ST_CHARSET_NAME = 1;
  final public static int ST_IMPORT_MEDIUM = 4;
  final public static int ST_DECLARATION_SEPARATOR = 16;
  final public static int ST_FONT_FACE_DELIMITER = 9;
  final public static int ST_MEDIA_DELIMITER = 7;
  final public static int ST_SELECTOR_MODIFIER = 10;
  final public static int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\0\1\11\1\17\1\0\1\4\1\20\22\0\1\6\1\31\1\10"+
    "\1\22\1\16\1\72\1\16\1\5\1\26\1\12\1\35\1\14\1\55"+
    "\1\13\1\15\1\34\12\1\1\62\1\50\1\30\1\67\1\32\1\21"+
    "\1\36\1\43\1\27\1\40\1\57\1\46\1\64\1\61\1\41\1\51"+
    "\2\2\1\25\1\52\1\65\1\54\1\53\1\2\1\24\1\44\1\47"+
    "\1\23\5\2\1\66\1\3\1\71\1\16\1\2\1\16\1\42\1\7"+
    "\1\37\1\56\1\45\1\63\1\61\1\41\1\51\2\2\1\25\1\52"+
    "\1\65\1\54\1\53\1\2\1\24\1\44\1\47\1\23\5\2\1\60"+
    "\1\70\1\33\1\70\1\0\uff80\2";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    59,   118,   177,   236,   295,   354,   413,   472,   531, 
      590,   649,   708,   767,   826,   885,   944,  1003,  1062,  1121, 
     1180,  1239,  1298,  1357,  1416,  1475,  1534,  1121,  1593,  1121, 
     1652,  1711,  1121,  1770,  1829,  1888,  1121,  1947,  2006,  2065, 
     2124,  2183,  2242,  1121,  2301,  2360,  2419,  1121,  1121,  2478, 
     2537,  2596,  1121,  2655,  2714,  1121,  1121,  2773,  2832,  2891, 
     1121,  2950,  1121,  3009,  3068,  3127,  3186,  3245,  3304,  3363, 
     3422,  1121,  1121,  3481,  3540,  3599,  3658,  3717,  1121,  3776, 
     3835,  3894,  3953,  4012,  4071,  1593,  1121,  4130,  1239,  4189, 
     4248,  1416,  4307,  1475,  4366,  4425,  4484,  4543,  4602,  4661, 
     4720,  4779,  4838,  4897,  1770,  4956,  1121,  1829,  5015,  5074, 
     1947,  5133,  1121,  2006,  5192,  5251,  2183,  5310,  5369,  2360, 
     5428,  5487,  2537,  5546,  5605,  1121,  2714,  2832,  5664,  5723, 
     3068,  5782,  3127,  5841,  1121,  3186,  5900,  5959,  3363,  6018, 
     6077,  6136,  6195,  3894,  1121,  3599,  1121,  6254,  3658,  6313, 
     1121,  3717,  6372,  6431,  6490,  6549,  3953,  6608,  6667,  6726, 
     4071,  6785,  1121,  4130,  6844,  1121,  6903,  6962,  7021,  7080, 
     7139,  7198,  7257,  7316,  7375,  7434,  7493,  7552,  1770,  7611, 
     7670,  1829,  7729,  7788,  1947,  7847,  7906,  2006,  7965,  8024, 
     8083,  8142,  8201,  8260,  8319,  8378,  3127,  8437,  8496,  3186, 
     8555,  8614,  8673,  8732,  8791,  3658,  8850,  8909,  3717,  8968, 
     9027,  9086,  9145,  9204,  9263,  9322,  9381,  1121,  1121,  9440, 
     9499,  9558,  9617,  9676,  9735,  9794,  9853,  9912,  9971, 10030, 
    10089, 10148, 10207, 10266, 10325, 10384, 10443, 10502, 10561, 10620, 
    10679, 10738, 10797, 10856, 10915, 10974, 11033, 11092, 11151, 11210, 
    11269, 11328, 11387, 11446, 11505,  1121, 11564, 11623,  1121, 11682, 
    11741, 11800, 11859, 11918, 11977, 12036, 12095, 12154, 12213,  1121, 
    12272, 12331, 12390, 12449, 12508, 12567, 12626, 12685, 12744, 12803, 
    12862, 12921, 12980, 13039, 13098, 13157, 13216, 11092, 13275, 13334, 
     1121, 13393, 13452, 13511, 13570, 13629, 13688,  1121, 13747, 13806, 
    13865, 13924, 13983, 14042, 14101, 14160, 14219, 12036, 14278, 14337, 
    14396, 14455, 14514, 14573, 14632, 14691, 14750, 14809, 14868, 14927, 
    14986, 15045, 15104, 15163, 15222, 15281, 15340, 13157, 15399, 15458, 
    15517, 15576, 15635, 15694, 15753,  1121, 15812, 15871, 15930, 15989, 
    16048, 16107, 16166, 16225, 16284, 16343, 16402, 16461, 16520, 16579, 
    16638, 16697, 16756, 16815, 16874, 16933, 16992, 17051, 17110, 17169, 
    17228, 17287, 17346, 17405, 17464, 17523, 17582, 17641, 17700, 17759, 
    17818, 17877, 17936, 17995, 18054,  1121, 18113, 18172, 18231, 18290, 
    18349, 18408, 18467, 18526, 18585, 12154, 18644, 12213, 18703, 18762, 
    18821, 18880, 18939, 18998, 19057, 19116, 19175, 19234, 13275, 19293, 
    13334, 19352, 19411, 19470, 19529, 19588, 19647, 19706, 19765, 19824, 
    19883, 19942,  1121, 20001, 20060, 20119, 20178,  1121, 20237, 20296, 
    20355,  1121, 20414, 20473, 20532, 20591, 20650, 20709, 20768, 20827, 
    20886, 20945
  };

  /** 
   * The packed transition table of the DFA
   */
  final private static String yy_packed = 
    "\2\24\1\25\1\26\1\27\1\24\1\27\1\25\1\24"+
    "\1\27\1\24\1\30\1\24\1\31\1\24\2\27\1\24"+
    "\1\32\3\25\1\24\1\25\1\33\2\24\1\34\1\35"+
    "\1\36\1\37\11\25\1\24\4\25\1\24\2\25\1\24"+
    "\1\25\1\40\3\25\1\41\10\24\1\27\1\42\1\27"+
    "\1\24\1\43\1\27\1\24\1\44\3\24\2\27\7\24"+
    "\1\33\2\24\1\34\1\35\1\24\1\37\40\24\1\27"+
    "\1\24\1\27\2\24\1\27\1\24\1\44\3\24\2\27"+
    "\7\24\1\33\2\24\1\34\1\35\1\24\1\37\11\24"+
    "\1\45\26\24\1\27\1\46\1\27\1\24\1\47\1\27"+
    "\1\24\1\44\3\24\2\27\2\24\1\50\4\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\11\24\1\45\24\24"+
    "\1\51\1\52\1\27\1\24\1\27\1\51\1\24\1\27"+
    "\1\24\1\53\3\24\2\27\2\24\3\51\1\24\1\51"+
    "\1\33\2\24\1\34\1\35\1\24\1\37\11\51\1\45"+
    "\4\51\1\24\2\51\1\24\1\51\1\24\3\51\11\24"+
    "\1\27\1\24\1\27\2\24\1\27\1\24\1\44\3\24"+
    "\2\27\7\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\11\24\1\45\4\24\1\54\17\24\1\55\1\56\1\27"+
    "\1\24\1\27\1\55\1\24\1\27\1\24\1\57\3\24"+
    "\2\27\2\24\3\55\1\24\1\55\1\33\2\24\1\34"+
    "\1\35\1\24\1\37\11\55\1\24\4\55\1\24\2\55"+
    "\1\24\1\55\1\24\3\55\11\24\1\27\1\24\1\27"+
    "\2\24\1\27\1\24\1\44\3\24\2\27\7\24\1\33"+
    "\2\24\1\34\1\35\1\24\1\37\16\24\1\60\2\24"+
    "\1\61\14\24\1\62\1\63\1\27\1\24\1\27\1\62"+
    "\1\24\1\27\1\24\1\64\3\24\2\27\2\24\3\62"+
    "\1\24\1\62\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\11\62\1\24\4\62\1\24\2\62\1\65\1\62\1\66"+
    "\3\62\11\24\1\27\1\24\1\27\2\24\1\27\1\24"+
    "\1\44\3\24\2\27\7\24\1\33\2\24\1\34\1\35"+
    "\1\24\1\37\21\24\1\65\16\24\1\67\1\24\1\67"+
    "\2\24\1\67\1\24\1\44\1\70\1\31\1\24\2\67"+
    "\1\24\1\32\5\24\1\33\1\24\1\70\1\34\1\35"+
    "\1\36\1\37\16\24\1\71\2\24\1\65\1\24\1\40"+
    "\3\24\1\41\6\24\1\72\1\73\1\27\1\24\1\27"+
    "\1\72\1\24\1\27\1\24\1\74\3\24\2\27\2\24"+
    "\3\72\1\24\1\72\1\33\2\24\1\34\1\35\1\24"+
    "\1\37\11\72\1\24\4\72\1\24\2\72\1\24\1\72"+
    "\1\24\3\72\11\24\1\27\1\24\1\27\2\24\1\27"+
    "\1\24\1\44\3\24\2\27\7\24\1\33\2\24\1\34"+
    "\1\35\1\24\1\37\30\24\1\75\1\76\1\77\3\24"+
    "\1\100\1\101\1\27\1\102\1\27\1\100\1\103\1\27"+
    "\1\24\1\104\3\24\2\27\2\24\3\100\1\24\1\100"+
    "\1\33\2\24\1\34\1\35\1\24\1\37\11\100\1\24"+
    "\4\100\1\24\2\100\1\24\1\100\1\24\3\100\11\24"+
    "\1\27\1\24\1\27\2\24\1\27\1\24\1\44\3\24"+
    "\2\27\7\24\1\33\2\24\1\34\1\35\1\24\1\37"+
    "\32\24\1\77\3\24\1\105\1\106\1\27\1\24\1\27"+
    "\1\105\1\24\1\27\1\24\1\107\3\24\2\27\2\24"+
    "\3\105\1\24\1\105\1\33\2\24\1\34\1\35\1\24"+
    "\1\37\11\105\1\110\4\105\1\24\2\105\1\24\1\105"+
    "\1\24\3\105\11\24\1\27\1\24\1\27\2\24\1\27"+
    "\1\24\1\44\3\24\2\27\7\24\1\33\2\24\1\34"+
    "\1\35\1\24\1\37\11\24\1\110\11\24\1\111\11\24"+
    "\1\112\1\113\1\114\1\27\1\115\1\27\1\113\1\116"+
    "\1\27\1\117\1\120\1\121\1\122\1\24\2\27\1\24"+
    "\1\123\1\124\2\113\1\24\1\113\1\33\1\125\1\24"+
    "\1\34\1\126\1\24\1\37\11\113\1\110\4\113\1\127"+
    "\2\113\1\24\1\113\1\24\3\113\6\24\1\112\1\113"+
    "\1\114\1\130\1\115\1\130\1\113\1\116\1\130\1\117"+
    "\1\120\1\121\1\122\1\24\2\130\1\24\1\123\1\124"+
    "\2\113\1\24\1\113\1\33\1\125\1\24\1\34\1\126"+
    "\1\24\1\37\11\113\1\110\4\113\1\127\2\113\1\24"+
    "\1\113\1\24\3\113\5\24\74\0\2\25\1\131\3\0"+
    "\1\25\3\0\1\25\7\0\3\25\1\0\1\25\7\0"+
    "\11\25\1\0\4\25\1\0\2\25\1\0\1\25\1\0"+
    "\3\25\6\0\1\132\2\25\1\0\2\25\1\132\1\25"+
    "\1\0\5\25\2\0\16\25\1\132\2\25\1\132\2\25"+
    "\1\132\10\25\1\132\4\25\1\132\7\25\4\0\1\27"+
    "\1\0\1\27\2\0\1\27\5\0\2\27\53\0\2\25"+
    "\1\131\3\0\1\25\3\0\1\133\7\0\3\25\1\0"+
    "\1\25\7\0\11\25\1\0\4\25\1\0\2\25\1\0"+
    "\1\25\1\0\3\25\6\0\2\134\1\135\3\0\1\134"+
    "\3\0\1\134\7\0\3\134\1\0\1\134\7\0\11\134"+
    "\1\0\4\134\1\0\2\134\1\0\1\134\1\0\3\134"+
    "\6\0\2\136\1\137\3\0\1\136\3\0\1\136\7\0"+
    "\3\136\1\0\1\136\7\0\11\136\1\0\4\136\1\0"+
    "\2\136\1\0\1\136\1\0\3\136\36\0\1\140\76\0"+
    "\1\141\74\0\2\142\10\0\1\143\1\144\1\145\7\0"+
    "\2\146\10\0\1\147\1\150\3\0\1\147\3\0\1\147"+
    "\7\0\3\147\1\0\1\147\7\0\11\147\1\0\4\147"+
    "\1\0\2\147\1\0\1\147\1\0\3\147\6\0\2\151"+
    "\1\152\1\0\1\153\11\151\2\0\52\151\1\0\2\154"+
    "\1\155\1\0\3\154\1\153\6\154\2\0\52\154\13\0"+
    "\1\156\60\0\2\157\1\160\1\0\1\161\11\157\2\0"+
    "\52\157\1\0\2\162\1\163\1\0\3\162\1\161\6\162"+
    "\2\0\52\162\24\0\1\164\47\0\2\51\1\165\3\0"+
    "\1\51\3\0\1\51\7\0\3\51\1\0\1\51\7\0"+
    "\11\51\1\0\4\51\1\0\2\51\1\0\1\51\1\0"+
    "\3\51\6\0\1\166\2\51\1\0\2\51\1\166\1\51"+
    "\1\0\5\51\2\0\16\51\1\166\2\51\1\166\2\51"+
    "\1\166\10\51\1\166\4\51\1\166\7\51\1\0\2\51"+
    "\1\165\3\0\1\51\3\0\1\167\7\0\3\51\1\0"+
    "\1\51\7\0\11\51\1\0\4\51\1\0\2\51\1\0"+
    "\1\51\1\0\3\51\6\0\2\55\1\170\3\0\1\55"+
    "\3\0\1\55\7\0\3\55\1\0\1\55\7\0\11\55"+
    "\1\0\4\55\1\0\2\55\1\0\1\55\1\0\3\55"+
    "\6\0\1\171\2\55\1\0\2\55\1\171\1\55\1\0"+
    "\5\55\2\0\16\55\1\171\2\55\1\171\2\55\1\171"+
    "\10\55\1\171\4\55\1\171\7\55\1\0\2\55\1\170"+
    "\3\0\1\55\3\0\1\172\7\0\3\55\1\0\1\55"+
    "\7\0\11\55\1\0\4\55\1\0\2\55\1\0\1\55"+
    "\1\0\3\55\6\0\2\62\1\173\3\0\1\62\3\0"+
    "\1\62\7\0\3\62\1\0\1\62\7\0\11\62\1\0"+
    "\4\62\1\0\2\62\1\0\1\62\1\0\3\62\6\0"+
    "\1\174\2\62\1\0\2\62\1\174\1\62\1\0\5\62"+
    "\2\0\16\62\1\174\2\62\1\174\2\62\1\174\10\62"+
    "\1\174\4\62\1\174\7\62\1\0\2\62\1\173\3\0"+
    "\1\62\3\0\1\175\7\0\3\62\1\0\1\62\7\0"+
    "\11\62\1\0\4\62\1\0\2\62\1\0\1\62\1\0"+
    "\3\62\7\0\1\62\1\173\3\0\1\62\3\0\1\62"+
    "\7\0\3\62\1\0\1\62\7\0\11\62\1\0\4\62"+
    "\1\0\2\62\1\0\1\62\1\0\3\62\5\0\4\176"+
    "\1\177\1\176\1\177\2\176\1\177\2\176\1\0\2\176"+
    "\2\177\11\176\1\0\25\176\1\0\12\176\1\0\2\72"+
    "\1\200\3\0\1\72\3\0\1\72\7\0\3\72\1\0"+
    "\1\72\7\0\11\72\1\0\4\72\1\0\2\72\1\0"+
    "\1\72\1\0\3\72\6\0\1\201\2\72\1\0\2\72"+
    "\1\201\1\72\1\0\5\72\2\0\16\72\1\201\2\72"+
    "\1\201\2\72\1\201\10\72\1\201\4\72\1\201\7\72"+
    "\1\0\2\72\1\200\3\0\1\72\3\0\1\202\7\0"+
    "\3\72\1\0\1\72\7\0\11\72\1\0\4\72\1\0"+
    "\2\72\1\0\1\72\1\0\3\72\74\0\1\75\4\0"+
    "\2\100\1\203\3\0\1\100\3\0\1\100\7\0\3\100"+
    "\1\0\1\100\7\0\11\100\1\0\4\100\1\0\2\100"+
    "\1\0\1\100\1\0\3\100\6\0\1\204\2\100\1\0"+
    "\2\100\1\204\1\100\1\0\5\100\2\0\16\100\1\204"+
    "\2\100\1\204\2\100\1\204\10\100\1\204\4\100\1\204"+
    "\7\100\1\0\2\205\1\206\1\0\1\207\11\205\2\0"+
    "\52\205\1\0\2\210\1\211\1\0\3\210\1\207\6\210"+
    "\2\0\52\210\1\0\2\100\1\203\3\0\1\100\3\0"+
    "\1\212\7\0\3\100\1\0\1\100\7\0\11\100\1\0"+
    "\4\100\1\0\2\100\1\0\1\100\1\0\3\100\6\0"+
    "\2\105\1\213\3\0\1\105\3\0\1\105\7\0\3\105"+
    "\1\0\1\105\7\0\11\105\1\0\4\105\1\0\2\105"+
    "\1\0\1\105\1\0\3\105\6\0\1\214\2\105\1\0"+
    "\2\105\1\214\1\105\1\0\5\105\2\0\16\105\1\214"+
    "\2\105\1\214\2\105\1\214\10\105\1\214\4\105\1\214"+
    "\7\105\1\0\2\105\1\213\3\0\1\105\3\0\1\215"+
    "\7\0\3\105\1\0\1\105\7\0\11\105\1\0\4\105"+
    "\1\0\2\105\1\0\1\105\1\0\3\105\6\0\1\112"+
    "\1\216\1\217\3\0\1\216\3\0\1\216\1\0\1\220"+
    "\5\0\3\216\1\0\1\216\7\0\11\216\1\0\4\216"+
    "\1\0\2\216\1\0\1\216\1\0\3\216\4\0\1\221"+
    "\1\0\2\113\1\222\3\0\1\113\3\0\1\113\7\0"+
    "\3\113\1\223\1\113\7\0\11\113\1\0\4\113\1\0"+
    "\2\113\1\0\1\113\1\0\3\113\6\0\1\224\2\113"+
    "\1\0\2\113\1\224\1\113\1\0\5\113\2\0\16\113"+
    "\1\224\2\113\1\224\2\113\1\224\10\113\1\224\4\113"+
    "\1\224\7\113\1\0\2\225\1\226\1\0\1\227\11\225"+
    "\2\0\52\225\1\0\2\230\1\231\1\0\3\230\1\227"+
    "\6\230\2\0\52\230\1\0\1\232\1\113\1\222\3\0"+
    "\1\113\3\0\1\233\1\0\1\220\5\0\3\113\1\223"+
    "\1\113\7\0\11\113\1\0\4\113\1\0\2\113\1\0"+
    "\1\113\1\0\3\113\6\0\1\112\13\0\1\220\56\0"+
    "\1\234\72\0\2\235\1\236\3\0\1\235\3\0\1\235"+
    "\7\0\3\235\1\0\1\235\7\0\11\235\1\0\4\235"+
    "\1\0\2\235\1\0\1\235\1\0\3\235\6\0\2\113"+
    "\1\222\3\0\1\113\3\0\1\113\1\237\6\0\1\113"+
    "\1\240\1\113\1\223\1\113\7\0\11\113\1\0\4\113"+
    "\1\0\2\113\1\0\1\113\1\0\3\113\11\0\1\241"+
    "\1\0\1\241\2\0\1\241\5\0\2\241\30\0\1\242"+
    "\21\0\4\243\1\244\1\243\1\244\2\243\1\244\5\243"+
    "\2\244\12\243\1\0\14\243\1\0\22\243\1\0\1\245"+
    "\1\25\1\131\1\25\1\0\1\25\1\245\1\0\1\25"+
    "\1\0\1\25\3\0\2\25\2\0\3\25\1\0\1\25"+
    "\7\0\1\245\2\25\1\245\2\25\1\245\2\25\1\0"+
    "\4\25\1\0\1\245\1\25\1\0\1\25\1\0\1\245"+
    "\2\25\6\0\2\25\1\131\3\0\1\25\3\0\1\25"+
    "\7\0\3\25\1\0\1\25\2\0\1\246\4\0\11\25"+
    "\1\0\4\25\1\0\2\25\1\0\1\25\1\0\3\25"+
    "\6\0\1\247\2\134\1\0\2\134\1\247\1\134\1\0"+
    "\5\134\2\0\16\134\1\247\2\134\1\247\2\134\1\247"+
    "\10\134\1\247\4\134\1\247\7\134\1\0\1\250\2\136"+
    "\1\0\2\136\1\250\1\136\1\0\5\136\2\0\16\136"+
    "\1\250\2\136\1\250\2\136\1\250\10\136\1\250\4\136"+
    "\1\250\7\136\13\0\1\251\57\0\35\141\1\252\35\141"+
    "\41\0\1\253\103\0\1\254\65\0\2\255\66\0\2\256"+
    "\103\0\1\257\17\0\2\147\1\150\3\0\1\147\3\0"+
    "\1\147\7\0\3\147\1\260\1\147\7\0\11\147\1\0"+
    "\4\147\1\0\2\147\1\0\1\147\1\0\3\147\6\0"+
    "\1\261\2\147\1\0\2\147\1\261\1\147\1\0\5\147"+
    "\2\0\16\147\1\261\2\147\1\261\2\147\1\261\10\147"+
    "\1\261\4\147\1\261\7\147\1\0\1\262\1\151\1\152"+
    "\1\151\1\263\1\151\1\262\10\151\1\264\16\151\1\262"+
    "\2\151\1\262\2\151\1\262\10\151\1\262\4\151\1\262"+
    "\7\151\1\0\1\265\1\154\1\155\3\154\1\265\1\266"+
    "\7\154\1\267\16\154\1\265\2\154\1\265\2\154\1\265"+
    "\10\154\1\265\4\154\1\265\7\154\32\0\1\246\41\0"+
    "\1\270\1\157\1\160\1\157\1\271\1\157\1\270\10\157"+
    "\1\272\16\157\1\270\2\157\1\270\2\157\1\270\10\157"+
    "\1\270\4\157\1\270\7\157\1\0\1\273\1\162\1\163"+
    "\3\162\1\273\1\274\7\162\1\275\16\162\1\273\2\162"+
    "\1\273\2\162\1\273\10\162\1\273\4\162\1\273\7\162"+
    "\25\0\1\276\46\0\1\277\1\51\1\165\1\51\1\0"+
    "\1\51\1\277\1\0\1\51\1\0\1\51\3\0\2\51"+
    "\2\0\3\51\1\0\1\51\7\0\1\277\2\51\1\277"+
    "\2\51\1\277\2\51\1\0\4\51\1\0\1\277\1\51"+
    "\1\0\1\51\1\0\1\277\2\51\6\0\2\51\1\165"+
    "\3\0\1\51\3\0\1\51\7\0\3\51\1\0\1\51"+
    "\2\0\1\246\4\0\11\51\1\0\4\51\1\0\2\51"+
    "\1\0\1\51\1\0\3\51\6\0\1\300\1\55\1\170"+
    "\1\55\1\0\1\55\1\300\1\0\1\55\1\0\1\55"+
    "\3\0\2\55\2\0\3\55\1\0\1\55\7\0\1\300"+
    "\2\55\1\300\2\55\1\300\2\55\1\0\4\55\1\0"+
    "\1\300\1\55\1\0\1\55\1\0\1\300\2\55\6\0"+
    "\2\55\1\170\3\0\1\55\3\0\1\55\7\0\3\55"+
    "\1\0\1\55\2\0\1\246\4\0\11\55\1\0\4\55"+
    "\1\0\2\55\1\0\1\55\1\0\3\55\6\0\1\301"+
    "\1\62\1\173\1\62\1\0\1\62\1\301\1\0\1\62"+
    "\1\0\1\62\3\0\2\62\2\0\3\62\1\0\1\62"+
    "\7\0\1\301\2\62\1\301\2\62\1\301\2\62\1\0"+
    "\4\62\1\0\1\301\1\62\1\0\1\62\1\0\1\301"+
    "\2\62\6\0\2\62\1\173\3\0\1\62\3\0\1\62"+
    "\7\0\3\62\1\0\1\62\2\0\1\246\4\0\11\62"+
    "\1\0\4\62\1\0\2\62\1\0\1\62\1\0\3\62"+
    "\6\0\1\302\1\72\1\200\1\72\1\0\1\72\1\302"+
    "\1\0\1\72\1\0\1\72\3\0\2\72\2\0\3\72"+
    "\1\0\1\72\7\0\1\302\2\72\1\302\2\72\1\302"+
    "\2\72\1\0\4\72\1\0\1\302\1\72\1\0\1\72"+
    "\1\0\1\302\2\72\6\0\2\72\1\200\3\0\1\72"+
    "\3\0\1\72\7\0\3\72\1\0\1\72\2\0\1\246"+
    "\4\0\11\72\1\0\4\72\1\0\2\72\1\0\1\72"+
    "\1\0\3\72\6\0\1\303\1\100\1\203\1\100\1\0"+
    "\1\100\1\303\1\0\1\100\1\0\1\100\3\0\2\100"+
    "\2\0\3\100\1\0\1\100\7\0\1\303\2\100\1\303"+
    "\2\100\1\303\2\100\1\0\4\100\1\0\1\303\1\100"+
    "\1\0\1\100\1\0\1\303\2\100\6\0\1\304\1\205"+
    "\1\206\1\205\1\305\1\205\1\304\10\205\1\306\16\205"+
    "\1\304\2\205\1\304\2\205\1\304\10\205\1\304\4\205"+
    "\1\304\7\205\1\0\1\307\1\210\1\211\3\210\1\307"+
    "\1\310\7\210\1\311\16\210\1\307\2\210\1\307\2\210"+
    "\1\307\10\210\1\307\4\210\1\307\7\210\1\0\2\100"+
    "\1\203\3\0\1\100\3\0\1\100\7\0\3\100\1\0"+
    "\1\100\2\0\1\246\4\0\11\100\1\0\4\100\1\0"+
    "\2\100\1\0\1\100\1\0\3\100\6\0\1\312\1\105"+
    "\1\213\1\105\1\0\1\105\1\312\1\0\1\105\1\0"+
    "\1\105\3\0\2\105\2\0\3\105\1\0\1\105\7\0"+
    "\1\312\2\105\1\312\2\105\1\312\2\105\1\0\4\105"+
    "\1\0\1\312\1\105\1\0\1\105\1\0\1\312\2\105"+
    "\6\0\2\105\1\213\3\0\1\105\3\0\1\105\7\0"+
    "\3\105\1\0\1\105\2\0\1\246\4\0\11\105\1\0"+
    "\4\105\1\0\2\105\1\0\1\105\1\0\3\105\6\0"+
    "\2\216\1\217\3\0\1\216\3\0\1\216\7\0\3\216"+
    "\1\0\1\216\7\0\11\216\1\0\4\216\1\0\2\216"+
    "\1\0\1\216\1\0\3\216\6\0\1\313\2\216\1\0"+
    "\2\216\1\313\1\216\1\0\5\216\2\0\16\216\1\313"+
    "\2\216\1\313\2\216\1\313\10\216\1\313\4\216\1\313"+
    "\7\216\1\0\1\314\1\113\1\222\1\113\1\0\1\113"+
    "\1\314\1\0\1\113\1\0\1\113\3\0\2\113\2\0"+
    "\3\113\1\223\1\113\7\0\1\314\2\113\1\314\2\113"+
    "\1\314\2\113\1\0\4\113\1\0\1\314\1\113\1\0"+
    "\1\113\1\0\1\314\2\113\6\0\1\315\1\225\1\226"+
    "\1\225\1\316\1\225\1\315\10\225\1\317\16\225\1\315"+
    "\2\225\1\315\2\225\1\315\10\225\1\315\4\225\1\315"+
    "\7\225\1\0\1\320\1\230\1\231\3\230\1\320\1\321"+
    "\7\230\1\322\16\230\1\320\2\230\1\320\2\230\1\320"+
    "\10\230\1\320\4\230\1\320\7\230\1\0\1\232\1\113"+
    "\1\222\3\0\1\113\3\0\1\113\1\0\1\220\5\0"+
    "\3\113\1\223\1\113\7\0\11\113\1\0\4\113\1\0"+
    "\2\113\1\0\1\113\1\0\3\113\4\0\1\221\1\0"+
    "\2\113\1\222\3\0\1\113\3\0\1\113\7\0\3\113"+
    "\1\223\1\113\2\0\1\246\4\0\11\113\1\0\4\113"+
    "\1\0\2\113\1\0\1\113\1\0\3\113\6\0\1\234"+
    "\1\216\1\217\3\0\1\216\3\0\1\216\7\0\3\216"+
    "\1\0\1\216\7\0\11\216\1\0\4\216\1\0\2\216"+
    "\1\0\1\216\1\0\3\216\4\0\1\221\1\0\1\323"+
    "\2\235\1\0\2\235\1\323\1\235\1\0\5\235\2\0"+
    "\16\235\1\323\2\235\1\323\2\235\1\323\10\235\1\323"+
    "\4\235\1\323\7\235\1\0\1\324\5\0\1\324\11\0"+
    "\1\324\5\0\1\324\7\0\2\324\1\0\2\324\1\0"+
    "\2\324\7\0\2\324\3\0\2\324\7\0\2\113\1\222"+
    "\3\0\1\113\3\0\1\113\7\0\2\113\1\325\1\223"+
    "\1\113\7\0\11\113\1\0\4\113\1\0\2\113\1\0"+
    "\1\113\1\0\3\113\57\0\1\326\21\0\1\327\1\25"+
    "\1\131\1\25\1\0\1\25\1\327\1\0\1\25\1\0"+
    "\1\25\3\0\2\25\2\0\3\25\1\0\1\25\7\0"+
    "\1\327\2\25\1\327\2\25\1\327\2\25\1\0\4\25"+
    "\1\0\1\327\1\25\1\0\1\25\1\0\1\327\2\25"+
    "\6\0\1\330\1\134\1\135\1\134\1\0\1\134\1\330"+
    "\1\0\1\134\1\0\1\134\3\0\2\134\2\0\3\134"+
    "\1\0\1\134\7\0\1\330\2\134\1\330\2\134\1\330"+
    "\2\134\1\0\4\134\1\0\1\330\1\134\1\0\1\134"+
    "\1\0\1\330\2\134\6\0\1\331\1\136\1\137\1\136"+
    "\1\0\1\136\1\331\1\0\1\136\1\0\1\136\3\0"+
    "\2\136\2\0\3\136\1\0\1\136\7\0\1\331\2\136"+
    "\1\331\2\136\1\331\2\136\1\0\4\136\1\0\1\331"+
    "\1\136\1\0\1\136\1\0\1\331\2\136\20\0\1\332"+
    "\57\0\34\141\1\333\1\252\35\141\42\0\2\334\102\0"+
    "\1\335\75\0\2\336\74\0\1\337\76\0\1\340\7\0"+
    "\1\341\1\342\1\260\1\0\1\260\1\341\1\0\1\260"+
    "\1\0\1\341\3\0\2\260\2\0\3\341\1\0\1\341"+
    "\7\0\11\341\1\0\4\341\1\0\2\341\1\0\1\341"+
    "\1\0\3\341\6\0\1\343\1\147\1\150\1\147\1\0"+
    "\1\147\1\343\1\0\1\147\1\0\1\147\3\0\2\147"+
    "\2\0\3\147\1\260\1\147\7\0\1\343\2\147\1\343"+
    "\2\147\1\343\2\147\1\0\4\147\1\0\1\343\1\147"+
    "\1\0\1\147\1\0\1\343\2\147\6\0\1\344\1\151"+
    "\1\152\1\151\1\153\1\151\1\344\27\151\1\344\2\151"+
    "\1\344\2\151\1\344\10\151\1\344\4\151\1\344\7\151"+
    "\1\0\2\151\1\152\1\0\1\153\12\151\1\0\52\151"+
    "\1\0\1\345\1\154\1\155\3\154\1\345\1\153\26\154"+
    "\1\345\2\154\1\345\2\154\1\345\10\154\1\345\4\154"+
    "\1\345\7\154\1\0\2\154\1\155\1\0\3\154\1\153"+
    "\7\154\1\0\52\154\1\0\1\346\1\157\1\160\1\157"+
    "\1\161\1\157\1\346\27\157\1\346\2\157\1\346\2\157"+
    "\1\346\10\157\1\346\4\157\1\346\7\157\1\0\2\157"+
    "\1\160\1\0\1\161\12\157\1\0\52\157\1\0\1\347"+
    "\1\162\1\163\3\162\1\347\1\161\26\162\1\347\2\162"+
    "\1\347\2\162\1\347\10\162\1\347\4\162\1\347\7\162"+
    "\1\0\2\162\1\163\1\0\3\162\1\161\7\162\1\0"+
    "\52\162\26\0\1\350\45\0\1\351\1\51\1\165\1\51"+
    "\1\0\1\51\1\351\1\0\1\51\1\0\1\51\3\0"+
    "\2\51\2\0\3\51\1\0\1\51\7\0\1\351\2\51"+
    "\1\351\2\51\1\351\2\51\1\0\4\51\1\0\1\351"+
    "\1\51\1\0\1\51\1\0\1\351\2\51\6\0\1\352"+
    "\1\55\1\170\1\55\1\0\1\55\1\352\1\0\1\55"+
    "\1\0\1\55\3\0\2\55\2\0\3\55\1\0\1\55"+
    "\7\0\1\352\2\55\1\352\2\55\1\352\2\55\1\0"+
    "\4\55\1\0\1\352\1\55\1\0\1\55\1\0\1\352"+
    "\2\55\6\0\1\353\1\62\1\173\1\62\1\0\1\62"+
    "\1\353\1\0\1\62\1\0\1\62\3\0\2\62\2\0"+
    "\3\62\1\0\1\62\7\0\1\353\2\62\1\353\2\62"+
    "\1\353\2\62\1\0\4\62\1\0\1\353\1\62\1\0"+
    "\1\62\1\0\1\353\2\62\6\0\1\354\1\72\1\200"+
    "\1\72\1\0\1\72\1\354\1\0\1\72\1\0\1\72"+
    "\3\0\2\72\2\0\3\72\1\0\1\72\7\0\1\354"+
    "\2\72\1\354\2\72\1\354\2\72\1\0\4\72\1\0"+
    "\1\354\1\72\1\0\1\72\1\0\1\354\2\72\6\0"+
    "\1\355\1\100\1\203\1\100\1\0\1\100\1\355\1\0"+
    "\1\100\1\0\1\100\3\0\2\100\2\0\3\100\1\0"+
    "\1\100\7\0\1\355\2\100\1\355\2\100\1\355\2\100"+
    "\1\0\4\100\1\0\1\355\1\100\1\0\1\100\1\0"+
    "\1\355\2\100\6\0\1\356\1\205\1\206\1\205\1\207"+
    "\1\205\1\356\27\205\1\356\2\205\1\356\2\205\1\356"+
    "\10\205\1\356\4\205\1\356\7\205\1\0\2\205\1\206"+
    "\1\0\1\207\12\205\1\0\52\205\1\0\1\357\1\210"+
    "\1\211\3\210\1\357\1\207\26\210\1\357\2\210\1\357"+
    "\2\210\1\357\10\210\1\357\4\210\1\357\7\210\1\0"+
    "\2\210\1\211\1\0\3\210\1\207\7\210\1\0\52\210"+
    "\1\0\1\360\1\105\1\213\1\105\1\0\1\105\1\360"+
    "\1\0\1\105\1\0\1\105\3\0\2\105\2\0\3\105"+
    "\1\0\1\105\7\0\1\360\2\105\1\360\2\105\1\360"+
    "\2\105\1\0\4\105\1\0\1\360\1\105\1\0\1\105"+
    "\1\0\1\360\2\105\6\0\1\361\1\216\1\217\1\216"+
    "\1\0\1\216\1\361\1\0\1\216\1\0\1\216\3\0"+
    "\2\216\2\0\3\216\1\0\1\216\7\0\1\361\2\216"+
    "\1\361\2\216\1\361\2\216\1\0\4\216\1\0\1\361"+
    "\1\216\1\0\1\216\1\0\1\361\2\216\6\0\1\362"+
    "\1\113\1\222\1\113\1\0\1\113\1\362\1\0\1\113"+
    "\1\0\1\113\3\0\2\113\2\0\3\113\1\223\1\113"+
    "\7\0\1\362\2\113\1\362\2\113\1\362\2\113\1\0"+
    "\4\113\1\0\1\362\1\113\1\0\1\113\1\0\1\362"+
    "\2\113\6\0\1\363\1\225\1\226\1\225\1\227\1\225"+
    "\1\363\27\225\1\363\2\225\1\363\2\225\1\363\10\225"+
    "\1\363\4\225\1\363\7\225\1\0\2\225\1\226\1\0"+
    "\1\227\12\225\1\0\52\225\1\0\1\364\1\230\1\231"+
    "\3\230\1\364\1\227\26\230\1\364\2\230\1\364\2\230"+
    "\1\364\10\230\1\364\4\230\1\364\7\230\1\0\2\230"+
    "\1\231\1\0\3\230\1\227\7\230\1\0\52\230\1\0"+
    "\1\365\1\235\1\236\1\235\1\0\1\235\1\365\1\0"+
    "\1\235\1\0\1\235\3\0\2\235\2\0\3\235\1\0"+
    "\1\235\7\0\1\365\2\235\1\365\2\235\1\365\2\235"+
    "\1\0\4\235\1\0\1\365\1\235\1\0\1\235\1\0"+
    "\1\365\2\235\6\0\1\366\5\0\1\366\3\0\1\367"+
    "\5\0\1\366\5\0\1\366\7\0\2\366\1\0\2\366"+
    "\1\0\2\366\7\0\2\366\3\0\2\366\7\0\2\113"+
    "\1\222\3\0\1\113\3\0\1\113\7\0\3\113\1\370"+
    "\1\113\7\0\11\113\1\0\4\113\1\0\2\113\1\0"+
    "\1\113\1\0\3\113\60\0\1\371\20\0\1\372\1\25"+
    "\1\131\1\25\1\0\1\25\1\372\1\0\1\25\1\0"+
    "\1\25\3\0\2\25\2\0\3\25\1\0\1\25\7\0"+
    "\1\372\2\25\1\372\2\25\1\372\2\25\1\0\4\25"+
    "\1\0\1\372\1\25\1\0\1\25\1\0\1\372\2\25"+
    "\6\0\1\373\1\134\1\135\1\134\1\0\1\134\1\373"+
    "\1\0\1\134\1\0\1\134\3\0\2\134\2\0\3\134"+
    "\1\0\1\134\7\0\1\373\2\134\1\373\2\134\1\373"+
    "\2\134\1\0\4\134\1\0\1\373\1\134\1\0\1\134"+
    "\1\0\1\373\2\134\6\0\1\374\1\136\1\137\1\136"+
    "\1\0\1\136\1\374\1\0\1\136\1\0\1\136\3\0"+
    "\2\136\2\0\3\136\1\0\1\136\7\0\1\374\2\136"+
    "\1\374\2\136\1\374\2\136\1\0\4\136\1\0\1\374"+
    "\1\136\1\0\1\136\1\0\1\374\2\136\31\0\1\375"+
    "\122\0\1\376\67\0\1\377\66\0\2\u0100\73\0\1\u0101"+
    "\24\0\2\341\1\342\1\u0102\1\0\1\u0102\1\341\1\0"+
    "\1\u0102\1\u0103\1\341\3\0\2\u0102\2\0\3\341\1\0"+
    "\1\341\7\0\11\341\1\0\4\341\1\0\2\341\1\0"+
    "\1\341\1\0\3\341\6\0\1\u0104\2\341\1\0\2\341"+
    "\1\u0104\1\341\1\0\5\341\2\0\16\341\1\u0104\2\341"+
    "\1\u0104\2\341\1\u0104\10\341\1\u0104\4\341\1\u0104\7\341"+
    "\1\0\1\u0105\1\147\1\150\1\147\1\0\1\147\1\u0105"+
    "\1\0\1\147\1\0\1\147\3\0\2\147\2\0\3\147"+
    "\1\260\1\147\7\0\1\u0105\2\147\1\u0105\2\147\1\u0105"+
    "\2\147\1\0\4\147\1\0\1\u0105\1\147\1\0\1\147"+
    "\1\0\1\u0105\2\147\6\0\1\u0106\1\151\1\152\1\151"+
    "\1\153\1\151\1\u0106\27\151\1\u0106\2\151\1\u0106\2\151"+
    "\1\u0106\10\151\1\u0106\4\151\1\u0106\7\151\1\0\1\u0107"+
    "\1\154\1\155\3\154\1\u0107\1\153\26\154\1\u0107\2\154"+
    "\1\u0107\2\154\1\u0107\10\154\1\u0107\4\154\1\u0107\7\154"+
    "\1\0\1\u0108\1\157\1\160\1\157\1\161\1\157\1\u0108"+
    "\27\157\1\u0108\2\157\1\u0108\2\157\1\u0108\10\157\1\u0108"+
    "\4\157\1\u0108\7\157\1\0\1\u0109\1\162\1\163\3\162"+
    "\1\u0109\1\161\26\162\1\u0109\2\162\1\u0109\2\162\1\u0109"+
    "\10\162\1\u0109\4\162\1\u0109\7\162\1\0\2\u010a\1\u010b"+
    "\1\350\1\u010c\1\350\1\u010a\1\u010d\1\350\1\u010e\4\u010a"+
    "\2\350\5\u010a\1\0\44\u010a\1\0\1\u010f\1\51\1\165"+
    "\1\51\1\0\1\51\1\u010f\1\0\1\51\1\0\1\51"+
    "\3\0\2\51\2\0\3\51\1\0\1\51\7\0\1\u010f"+
    "\2\51\1\u010f\2\51\1\u010f\2\51\1\0\4\51\1\0"+
    "\1\u010f\1\51\1\0\1\51\1\0\1\u010f\2\51\6\0"+
    "\1\u0110\1\55\1\170\1\55\1\0\1\55\1\u0110\1\0"+
    "\1\55\1\0\1\55\3\0\2\55\2\0\3\55\1\0"+
    "\1\55\7\0\1\u0110\2\55\1\u0110\2\55\1\u0110\2\55"+
    "\1\0\4\55\1\0\1\u0110\1\55\1\0\1\55\1\0"+
    "\1\u0110\2\55\6\0\1\u0111\1\62\1\173\1\62\1\0"+
    "\1\62\1\u0111\1\0\1\62\1\0\1\62\3\0\2\62"+
    "\2\0\3\62\1\0\1\62\7\0\1\u0111\2\62\1\u0111"+
    "\2\62\1\u0111\2\62\1\0\4\62\1\0\1\u0111\1\62"+
    "\1\0\1\62\1\0\1\u0111\2\62\6\0\1\u0112\1\72"+
    "\1\200\1\72\1\0\1\72\1\u0112\1\0\1\72\1\0"+
    "\1\72\3\0\2\72\2\0\3\72\1\0\1\72\7\0"+
    "\1\u0112\2\72\1\u0112\2\72\1\u0112\2\72\1\0\4\72"+
    "\1\0\1\u0112\1\72\1\0\1\72\1\0\1\u0112\2\72"+
    "\6\0\1\u0113\1\100\1\203\1\100\1\0\1\100\1\u0113"+
    "\1\0\1\100\1\0\1\100\3\0\2\100\2\0\3\100"+
    "\1\0\1\100\7\0\1\u0113\2\100\1\u0113\2\100\1\u0113"+
    "\2\100\1\0\4\100\1\0\1\u0113\1\100\1\0\1\100"+
    "\1\0\1\u0113\2\100\6\0\1\u0114\1\205\1\206\1\205"+
    "\1\207\1\205\1\u0114\27\205\1\u0114\2\205\1\u0114\2\205"+
    "\1\u0114\10\205\1\u0114\4\205\1\u0114\7\205\1\0\1\u0115"+
    "\1\210\1\211\3\210\1\u0115\1\207\26\210\1\u0115\2\210"+
    "\1\u0115\2\210\1\u0115\10\210\1\u0115\4\210\1\u0115\7\210"+
    "\1\0\1\u0116\1\105\1\213\1\105\1\0\1\105\1\u0116"+
    "\1\0\1\105\1\0\1\105\3\0\2\105\2\0\3\105"+
    "\1\0\1\105\7\0\1\u0116\2\105\1\u0116\2\105\1\u0116"+
    "\2\105\1\0\4\105\1\0\1\u0116\1\105\1\0\1\105"+
    "\1\0\1\u0116\2\105\6\0\1\u0117\1\216\1\217\1\216"+
    "\1\0\1\216\1\u0117\1\0\1\216\1\0\1\216\3\0"+
    "\2\216\2\0\3\216\1\0\1\216\7\0\1\u0117\2\216"+
    "\1\u0117\2\216\1\u0117\2\216\1\0\4\216\1\0\1\u0117"+
    "\1\216\1\0\1\216\1\0\1\u0117\2\216\6\0\1\u0118"+
    "\1\113\1\222\1\113\1\0\1\113\1\u0118\1\0\1\113"+
    "\1\0\1\113\3\0\2\113\2\0\3\113\1\223\1\113"+
    "\7\0\1\u0118\2\113\1\u0118\2\113\1\u0118\2\113\1\0"+
    "\4\113\1\0\1\u0118\1\113\1\0\1\113\1\0\1\u0118"+
    "\2\113\6\0\1\u0119\1\225\1\226\1\225\1\227\1\225"+
    "\1\u0119\27\225\1\u0119\2\225\1\u0119\2\225\1\u0119\10\225"+
    "\1\u0119\4\225\1\u0119\7\225\1\0\1\u011a\1\230\1\231"+
    "\3\230\1\u011a\1\227\26\230\1\u011a\2\230\1\u011a\2\230"+
    "\1\u011a\10\230\1\u011a\4\230\1\u011a\7\230\1\0\1\u011b"+
    "\1\235\1\236\1\235\1\0\1\235\1\u011b\1\0\1\235"+
    "\1\0\1\235\3\0\2\235\2\0\3\235\1\0\1\235"+
    "\7\0\1\u011b\2\235\1\u011b\2\235\1\u011b\2\235\1\0"+
    "\4\235\1\0\1\u011b\1\235\1\0\1\235\1\0\1\u011b"+
    "\2\235\6\0\1\u011c\5\0\1\u011c\3\0\1\367\5\0"+
    "\1\u011c\5\0\1\u011c\7\0\2\u011c\1\0\2\u011c\1\0"+
    "\2\u011c\7\0\2\u011c\3\0\2\u011c\7\0\1\u011d\5\0"+
    "\1\u011d\11\0\1\u011d\5\0\1\u011d\7\0\2\u011d\1\0"+
    "\2\u011d\1\0\2\u011d\7\0\2\u011d\3\0\2\u011d\7\0"+
    "\2\u011e\1\u011f\1\u0120\1\u0121\1\u0120\1\u011e\1\u0122\1\u0120"+
    "\1\u0123\4\u011e\2\u0120\5\u011e\1\0\44\u011e\54\0\1\u0124"+
    "\17\0\1\u0125\1\25\1\131\1\25\1\0\1\25\1\u0125"+
    "\1\0\1\25\1\0\1\25\3\0\2\25\2\0\3\25"+
    "\1\0\1\25\7\0\1\u0125\2\25\1\u0125\2\25\1\u0125"+
    "\2\25\1\0\4\25\1\0\1\u0125\1\25\1\0\1\25"+
    "\1\0\1\u0125\2\25\6\0\1\u0126\1\134\1\135\1\134"+
    "\1\0\1\134\1\u0126\1\0\1\134\1\0\1\134\3\0"+
    "\2\134\2\0\3\134\1\0\1\134\7\0\1\u0126\2\134"+
    "\1\u0126\2\134\1\u0126\2\134\1\0\4\134\1\0\1\u0126"+
    "\1\134\1\0\1\134\1\0\1\u0126\2\134\6\0\1\u0127"+
    "\1\136\1\137\1\136\1\0\1\136\1\u0127\1\0\1\136"+
    "\1\0\1\136\3\0\2\136\2\0\3\136\1\0\1\136"+
    "\7\0\1\u0127\2\136\1\u0127\2\136\1\u0127\2\136\1\0"+
    "\4\136\1\0\1\u0127\1\136\1\0\1\136\1\0\1\u0127"+
    "\2\136\51\0\1\u0128\52\0\1\u0129\110\0\2\u012a\42\0"+
    "\1\u012b\63\0\1\u0102\1\0\1\u0102\2\0\1\u0102\1\u0103"+
    "\4\0\2\u0102\53\0\1\u012c\1\341\1\342\1\341\1\0"+
    "\1\341\1\u012c\1\0\1\341\1\u0103\1\341\3\0\2\341"+
    "\2\0\3\341\1\0\1\341\7\0\1\u012c\2\341\1\u012c"+
    "\2\341\1\u012c\2\341\1\0\4\341\1\0\1\u012c\1\341"+
    "\1\0\1\341\1\0\1\u012c\2\341\6\0\1\u012d\1\147"+
    "\1\150\1\147\1\0\1\147\1\u012d\1\0\1\147\1\0"+
    "\1\147\3\0\2\147\2\0\3\147\1\260\1\147\7\0"+
    "\1\u012d\2\147\1\u012d\2\147\1\u012d\2\147\1\0\4\147"+
    "\1\0\1\u012d\1\147\1\0\1\147\1\0\1\u012d\2\147"+
    "\6\0\1\u012e\1\151\1\152\1\151\1\153\1\151\1\u012e"+
    "\27\151\1\u012e\2\151\1\u012e\2\151\1\u012e\10\151\1\u012e"+
    "\4\151\1\u012e\7\151\1\0\1\u012f\1\154\1\155\3\154"+
    "\1\u012f\1\153\26\154\1\u012f\2\154\1\u012f\2\154\1\u012f"+
    "\10\154\1\u012f\4\154\1\u012f\7\154\1\0\1\u0130\1\157"+
    "\1\160\1\157\1\161\1\157\1\u0130\27\157\1\u0130\2\157"+
    "\1\u0130\2\157\1\u0130\10\157\1\u0130\4\157\1\u0130\7\157"+
    "\1\0\1\u0131\1\162\1\163\3\162\1\u0131\1\161\26\162"+
    "\1\u0131\2\162\1\u0131\2\162\1\u0131\10\162\1\u0131\4\162"+
    "\1\u0131\7\162\1\0\2\u010a\1\u010b\1\u0132\1\0\2\u010a"+
    "\1\0\1\u0132\1\u010e\4\u010a\2\u0132\5\u010a\1\0\44\u010a"+
    "\1\0\1\u0133\1\u010a\1\u010b\1\u0132\2\u010a\1\u0133\1\u010a"+
    "\1\u0132\1\u0134\4\u010a\2\u0132\16\u010a\1\u0133\2\u010a\1\u0133"+
    "\2\u010a\1\u0133\10\u010a\1\u0133\4\u010a\1\u0133\7\u010a\1\0"+
    "\2\u010c\1\u0135\1\0\1\u0132\11\u010c\2\0\52\u010c\1\0"+
    "\2\u010d\1\u0136\1\0\3\u010d\1\u0132\6\u010d\2\0\52\u010d"+
    "\1\0\1\u0137\1\51\1\165\1\51\1\0\1\51\1\u0137"+
    "\1\0\1\51\1\0\1\51\3\0\2\51\2\0\3\51"+
    "\1\0\1\51\7\0\1\u0137\2\51\1\u0137\2\51\1\u0137"+
    "\2\51\1\0\4\51\1\0\1\u0137\1\51\1\0\1\51"+
    "\1\0\1\u0137\2\51\6\0\1\u0138\1\55\1\170\1\55"+
    "\1\0\1\55\1\u0138\1\0\1\55\1\0\1\55\3\0"+
    "\2\55\2\0\3\55\1\0\1\55\7\0\1\u0138\2\55"+
    "\1\u0138\2\55\1\u0138\2\55\1\0\4\55\1\0\1\u0138"+
    "\1\55\1\0\1\55\1\0\1\u0138\2\55\6\0\1\u0139"+
    "\1\62\1\173\1\62\1\0\1\62\1\u0139\1\0\1\62"+
    "\1\0\1\62\3\0\2\62\2\0\3\62\1\0\1\62"+
    "\7\0\1\u0139\2\62\1\u0139\2\62\1\u0139\2\62\1\0"+
    "\4\62\1\0\1\u0139\1\62\1\0\1\62\1\0\1\u0139"+
    "\2\62\6\0\1\u013a\1\72\1\200\1\72\1\0\1\72"+
    "\1\u013a\1\0\1\72\1\0\1\72\3\0\2\72\2\0"+
    "\3\72\1\0\1\72\7\0\1\u013a\2\72\1\u013a\2\72"+
    "\1\u013a\2\72\1\0\4\72\1\0\1\u013a\1\72\1\0"+
    "\1\72\1\0\1\u013a\2\72\6\0\1\u013b\1\100\1\203"+
    "\1\100\1\0\1\100\1\u013b\1\0\1\100\1\0\1\100"+
    "\3\0\2\100\2\0\3\100\1\0\1\100\7\0\1\u013b"+
    "\2\100\1\u013b\2\100\1\u013b\2\100\1\0\4\100\1\0"+
    "\1\u013b\1\100\1\0\1\100\1\0\1\u013b\2\100\6\0"+
    "\1\u013c\1\205\1\206\1\205\1\207\1\205\1\u013c\27\205"+
    "\1\u013c\2\205\1\u013c\2\205\1\u013c\10\205\1\u013c\4\205"+
    "\1\u013c\7\205\1\0\1\u013d\1\210\1\211\3\210\1\u013d"+
    "\1\207\26\210\1\u013d\2\210\1\u013d\2\210\1\u013d\10\210"+
    "\1\u013d\4\210\1\u013d\7\210\1\0\1\u013e\1\105\1\213"+
    "\1\105\1\0\1\105\1\u013e\1\0\1\105\1\0\1\105"+
    "\3\0\2\105\2\0\3\105\1\0\1\105\7\0\1\u013e"+
    "\2\105\1\u013e\2\105\1\u013e\2\105\1\0\4\105\1\0"+
    "\1\u013e\1\105\1\0\1\105\1\0\1\u013e\2\105\6\0"+
    "\1\u013f\1\216\1\217\1\216\1\0\1\216\1\u013f\1\0"+
    "\1\216\1\0\1\216\3\0\2\216\2\0\3\216\1\0"+
    "\1\216\7\0\1\u013f\2\216\1\u013f\2\216\1\u013f\2\216"+
    "\1\0\4\216\1\0\1\u013f\1\216\1\0\1\216\1\0"+
    "\1\u013f\2\216\6\0\1\u0140\1\113\1\222\1\113\1\0"+
    "\1\113\1\u0140\1\0\1\113\1\0\1\113\3\0\2\113"+
    "\2\0\3\113\1\223\1\113\7\0\1\u0140\2\113\1\u0140"+
    "\2\113\1\u0140\2\113\1\0\4\113\1\0\1\u0140\1\113"+
    "\1\0\1\113\1\0\1\u0140\2\113\6\0\1\u0141\1\225"+
    "\1\226\1\225\1\227\1\225\1\u0141\27\225\1\u0141\2\225"+
    "\1\u0141\2\225\1\u0141\10\225\1\u0141\4\225\1\u0141\7\225"+
    "\1\0\1\u0142\1\230\1\231\3\230\1\u0142\1\227\26\230"+
    "\1\u0142\2\230\1\u0142\2\230\1\u0142\10\230\1\u0142\4\230"+
    "\1\u0142\7\230\1\0\1\u0143\1\235\1\236\1\235\1\0"+
    "\1\235\1\u0143\1\0\1\235\1\0\1\235\3\0\2\235"+
    "\2\0\3\235\1\0\1\235\7\0\1\u0143\2\235\1\u0143"+
    "\2\235\1\u0143\2\235\1\0\4\235\1\0\1\u0143\1\235"+
    "\1\0\1\235\1\0\1\u0143\2\235\6\0\1\u0144\5\0"+
    "\1\u0144\3\0\1\367\5\0\1\u0144\5\0\1\u0144\7\0"+
    "\2\u0144\1\0\2\u0144\1\0\2\u0144\7\0\2\u0144\3\0"+
    "\2\u0144\7\0\1\u0145\5\0\1\u0145\11\0\1\u0145\5\0"+
    "\1\u0145\7\0\2\u0145\1\0\2\u0145\1\0\2\u0145\7\0"+
    "\2\u0145\3\0\2\u0145\7\0\2\u011e\1\u011f\1\u0146\1\0"+
    "\2\u011e\1\0\1\u0146\1\u0123\4\u011e\2\u0146\5\u011e\1\0"+
    "\44\u011e\1\0\1\u0147\1\u011e\1\u011f\1\u0146\2\u011e\1\u0147"+
    "\1\u011e\1\u0146\1\u0148\4\u011e\2\u0146\16\u011e\1\u0147\2\u011e"+
    "\1\u0147\2\u011e\1\u0147\10\u011e\1\u0147\4\u011e\1\u0147\7\u011e"+
    "\1\0\2\u0121\1\u0149\1\0\1\u0146\11\u0121\2\0\52\u0121"+
    "\1\0\2\u0122\1\u014a\1\0\3\u0122\1\u0146\6\u0122\2\0"+
    "\52\u0122\24\0\1\u014b\47\0\1\u014c\1\25\1\131\1\25"+
    "\1\0\1\25\1\u014c\1\0\1\25\1\0\1\25\3\0"+
    "\2\25\2\0\3\25\1\0\1\25\7\0\1\u014c\2\25"+
    "\1\u014c\2\25\1\u014c\2\25\1\0\4\25\1\0\1\u014c"+
    "\1\25\1\0\1\25\1\0\1\u014c\2\25\6\0\1\u014d"+
    "\1\134\1\135\1\134\1\0\1\134\1\u014d\1\0\1\134"+
    "\1\0\1\134\3\0\2\134\2\0\3\134\1\0\1\134"+
    "\7\0\1\u014d\2\134\1\u014d\2\134\1\u014d\2\134\1\0"+
    "\4\134\1\0\1\u014d\1\134\1\0\1\134\1\0\1\u014d"+
    "\2\134\6\0\1\u014e\1\136\1\137\1\136\1\0\1\136"+
    "\1\u014e\1\0\1\136\1\0\1\136\3\0\2\136\2\0"+
    "\3\136\1\0\1\136\7\0\1\u014e\2\136\1\u014e\2\136"+
    "\1\u014e\2\136\1\0\4\136\1\0\1\u014e\1\136\1\0"+
    "\1\136\1\0\1\u014e\2\136\52\0\2\u014f\73\0\1\u0150"+
    "\106\0\2\u0151\7\0\1\u0152\1\341\1\342\1\341\1\0"+
    "\1\341\1\u0152\1\0\1\341\1\u0103\1\341\3\0\2\341"+
    "\2\0\3\341\1\0\1\341\7\0\1\u0152\2\341\1\u0152"+
    "\2\341\1\u0152\2\341\1\0\4\341\1\0\1\u0152\1\341"+
    "\1\0\1\341\1\0\1\u0152\2\341\6\0\1\u0153\1\147"+
    "\1\150\1\147\1\0\1\147\1\u0153\1\0\1\147\1\0"+
    "\1\147\3\0\2\147\2\0\3\147\1\260\1\147\7\0"+
    "\1\u0153\2\147\1\u0153\2\147\1\u0153\2\147\1\0\4\147"+
    "\1\0\1\u0153\1\147\1\0\1\147\1\0\1\u0153\2\147"+
    "\6\0\1\u0154\1\151\1\152\1\151\1\153\1\151\1\u0154"+
    "\27\151\1\u0154\2\151\1\u0154\2\151\1\u0154\10\151\1\u0154"+
    "\4\151\1\u0154\7\151\1\0\1\u0155\1\154\1\155\3\154"+
    "\1\u0155\1\153\26\154\1\u0155\2\154\1\u0155\2\154\1\u0155"+
    "\10\154\1\u0155\4\154\1\u0155\7\154\1\0\1\u0156\1\157"+
    "\1\160\1\157\1\161\1\157\1\u0156\27\157\1\u0156\2\157"+
    "\1\u0156\2\157\1\u0156\10\157\1\u0156\4\157\1\u0156\7\157"+
    "\1\0\1\u0157\1\162\1\163\3\162\1\u0157\1\161\26\162"+
    "\1\u0157\2\162\1\u0157\2\162\1\u0157\10\162\1\u0157\4\162"+
    "\1\u0157\7\162\4\0\1\u0132\1\0\1\u0132\2\0\1\u0132"+
    "\1\u010e\4\0\2\u0132\53\0\1\u0158\1\u010a\1\u010b\1\u010a"+
    "\1\0\1\u010a\1\u0158\1\0\1\u010a\1\u010e\13\u010a\1\0"+
    "\10\u010a\1\u0158\2\u010a\1\u0158\2\u010a\1\u0158\10\u010a\1\u0158"+
    "\4\u010a\1\u0158\7\u010a\1\0\1\u0159\1\u010c\1\u0135\1\u010c"+
    "\1\u015a\1\u010c\1\u0159\10\u010c\1\u015b\16\u010c\1\u0159\2\u010c"+
    "\1\u0159\2\u010c\1\u0159\10\u010c\1\u0159\4\u010c\1\u0159\7\u010c"+
    "\1\0\1\u015c\1\u010d\1\u0136\3\u010d\1\u015c\1\u015d\7\u010d"+
    "\1\u015e\16\u010d\1\u015c\2\u010d\1\u015c\2\u010d\1\u015c\10\u010d"+
    "\1\u015c\4\u010d\1\u015c\7\u010d\1\0\1\u015f\1\51\1\165"+
    "\1\51\1\0\1\51\1\u015f\1\0\1\51\1\0\1\51"+
    "\3\0\2\51\2\0\3\51\1\0\1\51\7\0\1\u015f"+
    "\2\51\1\u015f\2\51\1\u015f\2\51\1\0\4\51\1\0"+
    "\1\u015f\1\51\1\0\1\51\1\0\1\u015f\2\51\6\0"+
    "\1\u0160\1\55\1\170\1\55\1\0\1\55\1\u0160\1\0"+
    "\1\55\1\0\1\55\3\0\2\55\2\0\3\55\1\0"+
    "\1\55\7\0\1\u0160\2\55\1\u0160\2\55\1\u0160\2\55"+
    "\1\0\4\55\1\0\1\u0160\1\55\1\0\1\55\1\0"+
    "\1\u0160\2\55\6\0\1\u0161\1\62\1\173\1\62\1\0"+
    "\1\62\1\u0161\1\0\1\62\1\0\1\62\3\0\2\62"+
    "\2\0\3\62\1\0\1\62\7\0\1\u0161\2\62\1\u0161"+
    "\2\62\1\u0161\2\62\1\0\4\62\1\0\1\u0161\1\62"+
    "\1\0\1\62\1\0\1\u0161\2\62\6\0\1\u0162\1\72"+
    "\1\200\1\72\1\0\1\72\1\u0162\1\0\1\72\1\0"+
    "\1\72\3\0\2\72\2\0\3\72\1\0\1\72\7\0"+
    "\1\u0162\2\72\1\u0162\2\72\1\u0162\2\72\1\0\4\72"+
    "\1\0\1\u0162\1\72\1\0\1\72\1\0\1\u0162\2\72"+
    "\6\0\1\u0163\1\100\1\203\1\100\1\0\1\100\1\u0163"+
    "\1\0\1\100\1\0\1\100\3\0\2\100\2\0\3\100"+
    "\1\0\1\100\7\0\1\u0163\2\100\1\u0163\2\100\1\u0163"+
    "\2\100\1\0\4\100\1\0\1\u0163\1\100\1\0\1\100"+
    "\1\0\1\u0163\2\100\6\0\1\u0164\1\205\1\206\1\205"+
    "\1\207\1\205\1\u0164\27\205\1\u0164\2\205\1\u0164\2\205"+
    "\1\u0164\10\205\1\u0164\4\205\1\u0164\7\205\1\0\1\u0165"+
    "\1\210\1\211\3\210\1\u0165\1\207\26\210\1\u0165\2\210"+
    "\1\u0165\2\210\1\u0165\10\210\1\u0165\4\210\1\u0165\7\210"+
    "\1\0\1\u0166\1\105\1\213\1\105\1\0\1\105\1\u0166"+
    "\1\0\1\105\1\0\1\105\3\0\2\105\2\0\3\105"+
    "\1\0\1\105\7\0\1\u0166\2\105\1\u0166\2\105\1\u0166"+
    "\2\105\1\0\4\105\1\0\1\u0166\1\105\1\0\1\105"+
    "\1\0\1\u0166\2\105\6\0\1\u0167\1\216\1\217\1\216"+
    "\1\0\1\216\1\u0167\1\0\1\216\1\0\1\216\3\0"+
    "\2\216\2\0\3\216\1\0\1\216\7\0\1\u0167\2\216"+
    "\1\u0167\2\216\1\u0167\2\216\1\0\4\216\1\0\1\u0167"+
    "\1\216\1\0\1\216\1\0\1\u0167\2\216\6\0\1\u0168"+
    "\1\113\1\222\1\113\1\0\1\113\1\u0168\1\0\1\113"+
    "\1\0\1\113\3\0\2\113\2\0\3\113\1\223\1\113"+
    "\7\0\1\u0168\2\113\1\u0168\2\113\1\u0168\2\113\1\0"+
    "\4\113\1\0\1\u0168\1\113\1\0\1\113\1\0\1\u0168"+
    "\2\113\6\0\1\u0169\1\225\1\226\1\225\1\227\1\225"+
    "\1\u0169\27\225\1\u0169\2\225\1\u0169\2\225\1\u0169\10\225"+
    "\1\u0169\4\225\1\u0169\7\225\1\0\1\u016a\1\230\1\231"+
    "\3\230\1\u016a\1\227\26\230\1\u016a\2\230\1\u016a\2\230"+
    "\1\u016a\10\230\1\u016a\4\230\1\u016a\7\230\1\0\1\u016b"+
    "\1\235\1\236\1\235\1\0\1\235\1\u016b\1\0\1\235"+
    "\1\0\1\235\3\0\2\235\2\0\3\235\1\0\1\235"+
    "\7\0\1\u016b\2\235\1\u016b\2\235\1\u016b\2\235\1\0"+
    "\4\235\1\0\1\u016b\1\235\1\0\1\235\1\0\1\u016b"+
    "\2\235\6\0\1\u016c\5\0\1\u016c\3\0\1\367\5\0"+
    "\1\u016c\5\0\1\u016c\7\0\2\u016c\1\0\2\u016c\1\0"+
    "\2\u016c\7\0\2\u016c\3\0\2\u016c\7\0\1\u016d\5\0"+
    "\1\u016d\11\0\1\u016d\5\0\1\u016d\7\0\2\u016d\1\0"+
    "\2\u016d\1\0\2\u016d\7\0\2\u016d\3\0\2\u016d\12\0"+
    "\1\u0146\1\0\1\u0146\2\0\1\u0146\1\u0123\4\0\2\u0146"+
    "\53\0\1\u016e\1\u011e\1\u011f\1\u011e\1\0\1\u011e\1\u016e"+
    "\1\0\1\u011e\1\u0123\13\u011e\1\0\10\u011e\1\u016e\2\u011e"+
    "\1\u016e\2\u011e\1\u016e\10\u011e\1\u016e\4\u011e\1\u016e\7\u011e"+
    "\1\0\1\u016f\1\u0121\1\u0149\1\u0121\1\u0170\1\u0121\1\u016f"+
    "\10\u0121\1\u0171\16\u0121\1\u016f\2\u0121\1\u016f\2\u0121\1\u016f"+
    "\10\u0121\1\u016f\4\u0121\1\u016f\7\u0121\1\0\1\u0172\1\u0122"+
    "\1\u014a\3\u0122\1\u0172\1\u0173\7\u0122\1\u0174\16\u0122\1\u0172"+
    "\2\u0122\1\u0172\2\u0122\1\u0172\10\u0122\1\u0172\4\u0122\1\u0172"+
    "\7\u0122\47\0\1\u0175\24\0\2\25\1\131\1\25\1\0"+
    "\2\25\1\0\1\25\1\0\1\25\3\0\2\25\2\0"+
    "\3\25\1\0\1\25\7\0\11\25\1\0\4\25\1\0"+
    "\2\25\1\0\1\25\1\0\3\25\6\0\1\u0176\1\134"+
    "\1\135\1\134\1\0\1\134\1\u0176\1\0\1\134\1\0"+
    "\1\134\3\0\2\134\2\0\3\134\1\0\1\134\7\0"+
    "\1\u0176\2\134\1\u0176\2\134\1\u0176\2\134\1\0\4\134"+
    "\1\0\1\u0176\1\134\1\0\1\134\1\0\1\u0176\2\134"+
    "\6\0\1\u0177\1\136\1\137\1\136\1\0\1\136\1\u0177"+
    "\1\0\1\136\1\0\1\136\3\0\2\136\2\0\3\136"+
    "\1\0\1\136\7\0\1\u0177\2\136\1\u0177\2\136\1\u0177"+
    "\2\136\1\0\4\136\1\0\1\u0177\1\136\1\0\1\136"+
    "\1\0\1\u0177\2\136\54\0\1\u0178\65\0\2\u0179\30\0"+
    "\1\u017a\1\341\1\342\1\341\1\0\1\341\1\u017a\1\0"+
    "\1\341\1\u0103\1\341\3\0\2\341\2\0\3\341\1\0"+
    "\1\341\7\0\1\u017a\2\341\1\u017a\2\341\1\u017a\2\341"+
    "\1\0\4\341\1\0\1\u017a\1\341\1\0\1\341\1\0"+
    "\1\u017a\2\341\6\0\1\u017b\1\147\1\150\1\147\1\0"+
    "\1\147\1\u017b\1\0\1\147\1\0\1\147\3\0\2\147"+
    "\2\0\3\147\1\260\1\147\7\0\1\u017b\2\147\1\u017b"+
    "\2\147\1\u017b\2\147\1\0\4\147\1\0\1\u017b\1\147"+
    "\1\0\1\147\1\0\1\u017b\2\147\6\0\1\u017c\1\151"+
    "\1\152\1\151\1\153\1\151\1\u017c\27\151\1\u017c\2\151"+
    "\1\u017c\2\151\1\u017c\10\151\1\u017c\4\151\1\u017c\7\151"+
    "\1\0\1\u017d\1\154\1\155\3\154\1\u017d\1\153\26\154"+
    "\1\u017d\2\154\1\u017d\2\154\1\u017d\10\154\1\u017d\4\154"+
    "\1\u017d\7\154\1\0\1\u017e\1\157\1\160\1\157\1\161"+
    "\1\157\1\u017e\27\157\1\u017e\2\157\1\u017e\2\157\1\u017e"+
    "\10\157\1\u017e\4\157\1\u017e\7\157\1\0\1\u017f\1\162"+
    "\1\163\3\162\1\u017f\1\161\26\162\1\u017f\2\162\1\u017f"+
    "\2\162\1\u017f\10\162\1\u017f\4\162\1\u017f\7\162\1\0"+
    "\1\u0180\1\u010a\1\u010b\1\u010a\1\0\1\u010a\1\u0180\1\0"+
    "\1\u010a\1\u010e\13\u010a\1\0\10\u010a\1\u0180\2\u010a\1\u0180"+
    "\2\u010a\1\u0180\10\u010a\1\u0180\4\u010a\1\u0180\7\u010a\1\0"+
    "\1\u0181\1\u010c\1\u0135\1\u010c\1\u0132\1\u010c\1\u0181\27\u010c"+
    "\1\u0181\2\u010c\1\u0181\2\u010c\1\u0181\10\u010c\1\u0181\4\u010c"+
    "\1\u0181\7\u010c\1\0\2\u010c\1\u0135\2\u0132\1\u015a\2\u010c"+
    "\1\u015a\1\u0182\4\u010c\2\u0132\52\u010c\1\0\2\u010c\1\u0135"+
    "\1\0\1\u0132\12\u010c\1\0\52\u010c\1\0\1\u0183\1\u010d"+
    "\1\u0136\3\u010d\1\u0183\1\u0132\26\u010d\1\u0183\2\u010d\1\u0183"+
    "\2\u010d\1\u0183\10\u010d\1\u0183\4\u010d\1\u0183\7\u010d\1\0"+
    "\2\u010d\1\u0136\1\u0132\1\u010d\1\u015d\1\u010d\1\u0132\1\u015d"+
    "\1\u0184\4\u010d\2\u0132\52\u010d\1\0\2\u010d\1\u0136\1\0"+
    "\3\u010d\1\u0132\7\u010d\1\0\52\u010d\1\0\2\51\1\165"+
    "\1\51\1\0\2\51\1\0\1\51\1\0\1\51\3\0"+
    "\2\51\2\0\3\51\1\0\1\51\7\0\11\51\1\0"+
    "\4\51\1\0\2\51\1\0\1\51\1\0\3\51\6\0"+
    "\2\55\1\170\1\55\1\0\2\55\1\0\1\55\1\0"+
    "\1\55\3\0\2\55\2\0\3\55\1\0\1\55\7\0"+
    "\11\55\1\0\4\55\1\0\2\55\1\0\1\55\1\0"+
    "\3\55\6\0\2\62\1\173\1\62\1\0\2\62\1\0"+
    "\1\62\1\0\1\62\3\0\2\62\2\0\3\62\1\0"+
    "\1\62\7\0\11\62\1\0\4\62\1\0\2\62\1\0"+
    "\1\62\1\0\3\62\6\0\2\72\1\200\1\72\1\0"+
    "\2\72\1\0\1\72\1\0\1\72\3\0\2\72\2\0"+
    "\3\72\1\0\1\72\7\0\11\72\1\0\4\72\1\0"+
    "\2\72\1\0\1\72\1\0\3\72\6\0\2\100\1\203"+
    "\1\100\1\0\2\100\1\0\1\100\1\0\1\100\3\0"+
    "\2\100\2\0\3\100\1\0\1\100\7\0\11\100\1\0"+
    "\4\100\1\0\2\100\1\0\1\100\1\0\3\100\6\0"+
    "\1\u0185\1\205\1\206\1\205\1\207\1\205\1\u0185\27\205"+
    "\1\u0185\2\205\1\u0185\2\205\1\u0185\10\205\1\u0185\4\205"+
    "\1\u0185\7\205\1\0\1\u0186\1\210\1\211\3\210\1\u0186"+
    "\1\207\26\210\1\u0186\2\210\1\u0186\2\210\1\u0186\10\210"+
    "\1\u0186\4\210\1\u0186\7\210\1\0\2\105\1\213\1\105"+
    "\1\0\2\105\1\0\1\105\1\0\1\105\3\0\2\105"+
    "\2\0\3\105\1\0\1\105\7\0\11\105\1\0\4\105"+
    "\1\0\2\105\1\0\1\105\1\0\3\105\6\0\1\u0187"+
    "\1\216\1\217\1\216\1\0\1\216\1\u0187\1\0\1\216"+
    "\1\0\1\216\3\0\2\216\2\0\3\216\1\0\1\216"+
    "\7\0\1\u0187\2\216\1\u0187\2\216\1\u0187\2\216\1\0"+
    "\4\216\1\0\1\u0187\1\216\1\0\1\216\1\0\1\u0187"+
    "\2\216\6\0\2\113\1\222\1\113\1\0\2\113\1\0"+
    "\1\113\1\0\1\113\3\0\2\113\2\0\3\113\1\223"+
    "\1\113\7\0\11\113\1\0\4\113\1\0\2\113\1\0"+
    "\1\113\1\0\3\113\6\0\1\u0188\1\225\1\226\1\225"+
    "\1\227\1\225\1\u0188\27\225\1\u0188\2\225\1\u0188\2\225"+
    "\1\u0188\10\225\1\u0188\4\225\1\u0188\7\225\1\0\1\u0189"+
    "\1\230\1\231\3\230\1\u0189\1\227\26\230\1\u0189\2\230"+
    "\1\u0189\2\230\1\u0189\10\230\1\u0189\4\230\1\u0189\7\230"+
    "\1\0\1\u018a\1\235\1\236\1\235\1\0\1\235\1\u018a"+
    "\1\0\1\235\1\0\1\235\3\0\2\235\2\0\3\235"+
    "\1\0\1\235\7\0\1\u018a\2\235\1\u018a\2\235\1\u018a"+
    "\2\235\1\0\4\235\1\0\1\u018a\1\235\1\0\1\235"+
    "\1\0\1\u018a\2\235\6\0\1\u018b\5\0\1\u018b\3\0"+
    "\1\367\5\0\1\u018b\5\0\1\u018b\7\0\2\u018b\1\0"+
    "\2\u018b\1\0\2\u018b\7\0\2\u018b\3\0\2\u018b\7\0"+
    "\1\u018c\5\0\1\u018c\11\0\1\u018c\5\0\1\u018c\7\0"+
    "\2\u018c\1\0\2\u018c\1\0\2\u018c\7\0\2\u018c\3\0"+
    "\2\u018c\7\0\1\u018d\1\u011e\1\u011f\1\u011e\1\0\1\u011e"+
    "\1\u018d\1\0\1\u011e\1\u0123\13\u011e\1\0\10\u011e\1\u018d"+
    "\2\u011e\1\u018d\2\u011e\1\u018d\10\u011e\1\u018d\4\u011e\1\u018d"+
    "\7\u011e\1\0\1\u018e\1\u0121\1\u0149\1\u0121\1\u0146\1\u0121"+
    "\1\u018e\27\u0121\1\u018e\2\u0121\1\u018e\2\u0121\1\u018e\10\u0121"+
    "\1\u018e\4\u0121\1\u018e\7\u0121\1\0\2\u0121\1\u0149\2\u0146"+
    "\1\u0170\2\u0121\1\u0170\1\u018f\4\u0121\2\u0146\52\u0121\1\0"+
    "\2\u0121\1\u0149\1\0\1\u0146\12\u0121\1\0\52\u0121\1\0"+
    "\1\u0190\1\u0122\1\u014a\3\u0122\1\u0190\1\u0146\26\u0122\1\u0190"+
    "\2\u0122\1\u0190\2\u0122\1\u0190\10\u0122\1\u0190\4\u0122\1\u0190"+
    "\7\u0122\1\0\2\u0122\1\u014a\1\u0146\1\u0122\1\u0173\1\u0122"+
    "\1\u0146\1\u0173\1\u0191\4\u0122\2\u0146\52\u0122\1\0\2\u0122"+
    "\1\u014a\1\0\3\u0122\1\u0146\7\u0122\1\0\52\u0122\42\0"+
    "\2\u0192\30\0\2\134\1\135\1\134\1\0\2\134\1\0"+
    "\1\134\1\0\1\134\3\0\2\134\2\0\3\134\1\0"+
    "\1\134\7\0\11\134\1\0\4\134\1\0\2\134\1\0"+
    "\1\134\1\0\3\134\6\0\2\136\1\137\1\136\1\0"+
    "\2\136\1\0\1\136\1\0\1\136\3\0\2\136\2\0"+
    "\3\136\1\0\1\136\7\0\11\136\1\0\4\136\1\0"+
    "\2\136\1\0\1\136\1\0\3\136\44\0\2\u0193\33\0"+
    "\1\u0194\1\341\1\342\1\341\1\0\1\341\1\u0194\1\0"+
    "\1\341\1\u0103\1\341\3\0\2\341\2\0\3\341\1\0"+
    "\1\341\7\0\1\u0194\2\341\1\u0194\2\341\1\u0194\2\341"+
    "\1\0\4\341\1\0\1\u0194\1\341\1\0\1\341\1\0"+
    "\1\u0194\2\341\6\0\2\147\1\150\1\147\1\0\2\147"+
    "\1\0\1\147\1\0\1\147\3\0\2\147\2\0\3\147"+
    "\1\260\1\147\7\0\11\147\1\0\4\147\1\0\2\147"+
    "\1\0\1\147\1\0\3\147\6\0\2\151\1\152\1\151"+
    "\1\153\65\151\1\0\2\154\1\155\4\154\1\153\62\154"+
    "\1\0\2\157\1\160\1\157\1\161\65\157\1\0\2\162"+
    "\1\163\4\162\1\161\62\162\1\0\1\u0195\1\u010a\1\u010b"+
    "\1\u010a\1\0\1\u010a\1\u0195\1\0\1\u010a\1\u010e\13\u010a"+
    "\1\0\10\u010a\1\u0195\2\u010a\1\u0195\2\u010a\1\u0195\10\u010a"+
    "\1\u0195\4\u010a\1\u0195\7\u010a\1\0\1\u0196\1\u010c\1\u0135"+
    "\1\u010c\1\u0132\1\u010c\1\u0196\27\u010c\1\u0196\2\u010c\1\u0196"+
    "\2\u010c\1\u0196\10\u010c\1\u0196\4\u010c\1\u0196\7\u010c\1\0"+
    "\1\u0197\1\u010d\1\u0136\3\u010d\1\u0197\1\u0132\26\u010d\1\u0197"+
    "\2\u010d\1\u0197\2\u010d\1\u0197\10\u010d\1\u0197\4\u010d\1\u0197"+
    "\7\u010d\1\0\2\205\1\206\1\205\1\207\65\205\1\0"+
    "\2\210\1\211\4\210\1\207\62\210\1\0\2\216\1\217"+
    "\1\216\1\0\2\216\1\0\1\216\1\0\1\216\3\0"+
    "\2\216\2\0\3\216\1\0\1\216\7\0\11\216\1\0"+
    "\4\216\1\0\2\216\1\0\1\216\1\0\3\216\6\0"+
    "\2\225\1\226\1\225\1\227\65\225\1\0\2\230\1\231"+
    "\4\230\1\227\62\230\1\0\2\235\1\236\1\235\1\0"+
    "\2\235\1\0\1\235\1\0\1\235\3\0\2\235\2\0"+
    "\3\235\1\0\1\235\7\0\11\235\1\0\4\235\1\0"+
    "\2\235\1\0\1\235\1\0\3\235\20\0\1\367\60\0"+
    "\1\u0198\5\0\1\u0198\11\0\1\u0198\5\0\1\u0198\7\0"+
    "\2\u0198\1\0\2\u0198\1\0\2\u0198\7\0\2\u0198\3\0"+
    "\2\u0198\7\0\1\u0199\1\u011e\1\u011f\1\u011e\1\0\1\u011e"+
    "\1\u0199\1\0\1\u011e\1\u0123\13\u011e\1\0\10\u011e\1\u0199"+
    "\2\u011e\1\u0199\2\u011e\1\u0199\10\u011e\1\u0199\4\u011e\1\u0199"+
    "\7\u011e\1\0\1\u019a\1\u0121\1\u0149\1\u0121\1\u0146\1\u0121"+
    "\1\u019a\27\u0121\1\u019a\2\u0121\1\u019a\2\u0121\1\u019a\10\u0121"+
    "\1\u019a\4\u0121\1\u019a\7\u0121\1\0\1\u019b\1\u0122\1\u014a"+
    "\3\u0122\1\u019b\1\u0146\26\u0122\1\u019b\2\u0122\1\u019b\2\u0122"+
    "\1\u019b\10\u0122\1\u019b\4\u0122\1\u019b\7\u0122\65\0\1\u019c"+
    "\52\0\2\u019d\25\0\1\u019e\1\341\1\342\1\341\1\0"+
    "\1\341\1\u019e\1\0\1\341\1\u0103\1\341\3\0\2\341"+
    "\2\0\3\341\1\0\1\341\7\0\1\u019e\2\341\1\u019e"+
    "\2\341\1\u019e\2\341\1\0\4\341\1\0\1\u019e\1\341"+
    "\1\0\1\341\1\0\1\u019e\2\341\6\0\1\u019f\1\u010a"+
    "\1\u010b\1\u010a\1\0\1\u010a\1\u019f\1\0\1\u010a\1\u010e"+
    "\13\u010a\1\0\10\u010a\1\u019f\2\u010a\1\u019f\2\u010a\1\u019f"+
    "\10\u010a\1\u019f\4\u010a\1\u019f\7\u010a\1\0\1\u01a0\1\u010c"+
    "\1\u0135\1\u010c\1\u0132\1\u010c\1\u01a0\27\u010c\1\u01a0\2\u010c"+
    "\1\u01a0\2\u010c\1\u01a0\10\u010c\1\u01a0\4\u010c\1\u01a0\7\u010c"+
    "\1\0\1\u01a1\1\u010d\1\u0136\3\u010d\1\u01a1\1\u0132\26\u010d"+
    "\1\u01a1\2\u010d\1\u01a1\2\u010d\1\u01a1\10\u010d\1\u01a1\4\u010d"+
    "\1\u01a1\7\u010d\1\0\1\u01a2\5\0\1\u01a2\11\0\1\u01a2"+
    "\5\0\1\u01a2\7\0\2\u01a2\1\0\2\u01a2\1\0\2\u01a2"+
    "\7\0\2\u01a2\3\0\2\u01a2\7\0\1\u01a3\1\u011e\1\u011f"+
    "\1\u011e\1\0\1\u011e\1\u01a3\1\0\1\u011e\1\u0123\13\u011e"+
    "\1\0\10\u011e\1\u01a3\2\u011e\1\u01a3\2\u011e\1\u01a3\10\u011e"+
    "\1\u01a3\4\u011e\1\u01a3\7\u011e\1\0\1\u01a4\1\u0121\1\u0149"+
    "\1\u0121\1\u0146\1\u0121\1\u01a4\27\u0121\1\u01a4\2\u0121\1\u01a4"+
    "\2\u0121\1\u01a4\10\u0121\1\u01a4\4\u0121\1\u01a4\7\u0121\1\0"+
    "\1\u01a5\1\u0122\1\u014a\3\u0122\1\u01a5\1\u0146\26\u0122\1\u01a5"+
    "\2\u0122\1\u01a5\2\u0122\1\u01a5\10\u0122\1\u01a5\4\u0122\1\u01a5"+
    "\7\u0122\47\0\1\u01a6\24\0\2\341\1\342\1\341\1\0"+
    "\2\341\1\0\1\341\1\u0103\1\341\3\0\2\341\2\0"+
    "\3\341\1\0\1\341\7\0\11\341\1\0\4\341\1\0"+
    "\2\341\1\0\1\341\1\0\3\341\6\0\1\u01a7\1\u010a"+
    "\1\u010b\1\u010a\1\0\1\u010a\1\u01a7\1\0\1\u010a\1\u010e"+
    "\13\u010a\1\0\10\u010a\1\u01a7\2\u010a\1\u01a7\2\u010a\1\u01a7"+
    "\10\u010a\1\u01a7\4\u010a\1\u01a7\7\u010a\1\0\1\u01a8\1\u010c"+
    "\1\u0135\1\u010c\1\u0132\1\u010c\1\u01a8\27\u010c\1\u01a8\2\u010c"+
    "\1\u01a8\2\u010c\1\u01a8\10\u010c\1\u01a8\4\u010c\1\u01a8\7\u010c"+
    "\1\0\1\u01a9\1\u010d\1\u0136\3\u010d\1\u01a9\1\u0132\26\u010d"+
    "\1\u01a9\2\u010d\1\u01a9\2\u010d\1\u01a9\10\u010d\1\u01a9\4\u010d"+
    "\1\u01a9\7\u010d\1\0\1\u01aa\1\u011e\1\u011f\1\u011e\1\0"+
    "\1\u011e\1\u01aa\1\0\1\u011e\1\u0123\13\u011e\1\0\10\u011e"+
    "\1\u01aa\2\u011e\1\u01aa\2\u011e\1\u01aa\10\u011e\1\u01aa\4\u011e"+
    "\1\u01aa\7\u011e\1\0\1\u01ab\1\u0121\1\u0149\1\u0121\1\u0146"+
    "\1\u0121\1\u01ab\27\u0121\1\u01ab\2\u0121\1\u01ab\2\u0121\1\u01ab"+
    "\10\u0121\1\u01ab\4\u0121\1\u01ab\7\u0121\1\0\1\u01ac\1\u0122"+
    "\1\u014a\3\u0122\1\u01ac\1\u0146\26\u0122\1\u01ac\2\u0122\1\u01ac"+
    "\2\u0122\1\u01ac\10\u0122\1\u01ac\4\u0122\1\u01ac\7\u0122\1\0"+
    "\2\u010a\1\u010b\1\u010a\1\0\2\u010a\1\0\1\u010a\1\u010e"+
    "\13\u010a\1\0\44\u010a\1\0\1\u01ad\1\u010c\1\u0135\1\u010c"+
    "\1\u0132\1\u010c\1\u01ad\27\u010c\1\u01ad\2\u010c\1\u01ad\2\u010c"+
    "\1\u01ad\10\u010c\1\u01ad\4\u010c\1\u01ad\7\u010c\1\0\1\u01ae"+
    "\1\u010d\1\u0136\3\u010d\1\u01ae\1\u0132\26\u010d\1\u01ae\2\u010d"+
    "\1\u01ae\2\u010d\1\u01ae\10\u010d\1\u01ae\4\u010d\1\u01ae\7\u010d"+
    "\1\0\2\u011e\1\u011f\1\u011e\1\0\2\u011e\1\0\1\u011e"+
    "\1\u0123\13\u011e\1\0\44\u011e\1\0\1\u01af\1\u0121\1\u0149"+
    "\1\u0121\1\u0146\1\u0121\1\u01af\27\u0121\1\u01af\2\u0121\1\u01af"+
    "\2\u0121\1\u01af\10\u0121\1\u01af\4\u0121\1\u01af\7\u0121\1\0"+
    "\1\u01b0\1\u0122\1\u014a\3\u0122\1\u01b0\1\u0146\26\u0122\1\u01b0"+
    "\2\u0122\1\u01b0\2\u0122\1\u01b0\10\u0122\1\u01b0\4\u0122\1\u01b0"+
    "\7\u0122\1\0\2\u010c\1\u0135\1\u010c\1\u0132\65\u010c\1\0"+
    "\2\u010d\1\u0136\4\u010d\1\u0132\62\u010d\1\0\2\u0121\1\u0149"+
    "\1\u0121\1\u0146\65\u0121\1\0\2\u0122\1\u014a\4\u0122\1\u0146"+
    "\62\u0122";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack(yy_packed);


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  9,  1,  1,  1,  1,  1,  1,  1,  9,  1,  9,  1,  1, 
     9,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  9,  1,  1,  1,  9, 
     9,  1,  1,  1,  9,  1,  3,  9,  9,  1,  1,  1,  9,  1,  9,  1, 
     1,  1,  1,  1,  1,  1,  1,  9,  9,  1,  1,  1,  1,  1,  9,  1, 
     1,  1,  1,  1,  1,  1,  9,  3,  0,  1,  1,  1,  0,  1,  0,  0, 
     0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  9,  0,  0,  0,  0,  0, 
     9,  0,  0,  0,  0,  1,  1,  0,  1,  1,  0,  1,  1, 13,  7,  0, 
     1,  1,  0,  1,  0,  0,  9,  0,  0,  1,  0,  1,  1,  1,  0,  0, 
     9,  0,  9,  1,  0,  0,  9,  0,  0,  1,  1,  1,  1,  0,  0,  1, 
     0,  0, 13,  7,  1,  9,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0, 
     1,  0,  1,  0,  0,  1,  0,  0,  1,  0,  0,  1,  0,  0,  1,  1, 
     1,  1,  1,  0,  1,  0,  0,  1,  0,  1,  1,  1,  0,  1,  0,  0, 
     1,  0,  1,  1,  1,  0,  1,  1,  1,  9,  9,  0,  0,  0,  0,  0, 
     0,  0,  1,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  0,  0,  1, 
     1,  1,  0,  0,  1,  1,  0,  1,  0,  1,  1,  1,  0,  0,  0,  9, 
     0,  0,  9,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  9,  1,  1, 
     1,  1,  1,  0,  0,  1,  1,  1,  0,  0,  1,  1,  1,  0,  0,  0, 
     0,  0,  9,  0,  1,  1,  1,  0,  0,  9,  0,  0,  1,  0,  0,  0, 
     0,  0,  0,  1,  0,  0,  1,  1,  1,  1,  1,  0,  0,  1,  1,  1, 
     0,  0,  1,  1,  1,  0,  0,  1,  0,  0,  0,  1,  1,  1,  0,  9, 
     0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1, 
     1,  1,  1,  0,  0,  1,  1,  1,  0,  0,  1,  1,  1,  0,  0,  0, 
     0,  0,  0,  0,  0,  1,  1,  9,  0,  0,  1,  0,  0,  0,  0,  0, 
     0,  1,  0,  1,  0,  0,  1,  0,  0,  1,  1,  1,  0,  0,  1,  0, 
     1,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  9,  0,  0,  0, 
     0,  9,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[16384];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL;

  /** yy_atEOF == true <=> the scanner has returned a value for EOF */
  private boolean yy_atEOF;

  /* user code: */
	private final static String UNDEFINED = "undefined";
	private String fBufferedContext = null;
	private int fBufferedStart;
//	private int fBufferedTextLength;
	private int fBufferedLength;
//	private StringBuffer fBufferedText = null;
	private CSSTextRegionFactory fRegionFactory = CSSTextRegionFactory.getInstance();
	private int fInitialState = YYINITIAL;
	public final static int BUFFER_SIZE_NORMAL = 16384;
	public final static int BUFFER_SIZE_SMALL = 256;
	private int fInitialBufferSize = BUFFER_SIZE_NORMAL;

	public void setInitialState(int state) {
		fInitialState = state;
	}
	
	public void setInitialBufferSize(int size) {
		fInitialBufferSize = size;
	}

	/* user method */
  	public final ITextRegion getNextToken() throws IOException {
		String context;
		String nextTokenType;
		boolean spaceFollows;
//		StringBuffer text;
		int start;
		int textLength;
		int length;
		if (fBufferedContext != null) {
			context = fBufferedContext;
//			text = fBufferedText;
			start = fBufferedStart;
			textLength = length = fBufferedLength;

			fBufferedContext = null;
		} else {
			context = primGetNextToken();
//			text = new StringBuffer(yytext());
			start = yychar;
			textLength = length = yylength();
		}

		if (context != null) {
			if (context == UNDEFINED) {
				// undef -> concatenate undef's
				nextTokenType = primGetNextToken();
				while (nextTokenType == UNDEFINED) {
//					text.append(yytext());
					textLength += yylength();
					length = textLength;
					nextTokenType = primGetNextToken();
				}
				fBufferedContext = nextTokenType;
//				fBufferedText = new StringBuffer(yytext());
				fBufferedStart = yychar;
				fBufferedLength = yylength();
			} else {
				nextTokenType = null;
				spaceFollows = false;
				if (CSSRegionUtil.isDeclarationValueType(context)) { // declaration value can contain VALUE_S
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_DECLARATION_VALUE_S);
				} else if (canContainSpace(context)) {
					nextTokenType = primGetNextToken();
					spaceFollows = (nextTokenType == CSS_S);
				}
				if (nextTokenType != null) { // nextToken is retrieved
					if (spaceFollows) {
						// next is space -> append
//						text.append(yytext());
						length += yylength();
					} else {
						// next is NOT space -> push this for next time, return itself
						fBufferedContext = nextTokenType;
//						fBufferedText = new StringBuffer(yytext());
						fBufferedStart = yychar;
						fBufferedLength = yylength();
					}
				}
			}
		}

		if (context != null) {
			if (context == UNDEFINED) {
				context = CSS_UNKNOWN;
			}
			return fRegionFactory.createRegion(context, start, textLength, length);
		} else {
			return null;
		}
  	}

	/* user method */
	/* for standalone use */
  	public final List parseText() throws IOException {
  		List tokens = new ArrayList();

  		CSSTextToken token;
		for (String kind = primGetNextToken(); kind != null; kind = primGetNextToken()) {
			token = new CSSTextToken();
			token.kind = kind;  				
			token.start = yychar;
			token.length = yylength();
			token.image = yytext();
			tokens.add(token);
		}

  		return tokens;
  	}
  	
  	/* user method */
  	private boolean canContainSpace(String type) {
  		if (type == CSS_DELIMITER || type == CSS_RBRACE || type == CSS_DECLARATION_DELIMITER) {
  			return false;
  		} else {
  			return true;
  		}
  	}

	/* user method */
	public final int getOffset() {
		return yychar;
	}
	
	/* user method */
	public final boolean isEOF() {
		return yy_atEOF;
	}

	/* user method */
	public void reset(char[] charArray) {
		reset(new CharArrayReader(charArray), 0);
	}

	/* user method */
	public final void reset(java.io.Reader in, int newOffset) {
		/** the input device */
		yy_reader = in;

		/** the current state of the DFA */
		yy_state = 0;

		/** the current lexical state */
		yy_lexical_state = fInitialState; //YYINITIAL;

		/** this buffer contains the current text to be matched and is
			the source of the yytext() string */
		if (yy_buffer.length != fInitialBufferSize) {
			yy_buffer = new char[fInitialBufferSize];
		}
		java.util.Arrays.fill(yy_buffer, (char)0);

		/** the textposition at the last accepting state */
		yy_markedPos = 0;

		/** the textposition at the last state to be included in yytext */
		yy_pushbackPos = 0;

		/** the current text position in the buffer */
		yy_currentPos = 0;

		/** startRead marks the beginning of the yytext() string in the buffer */
		yy_startRead = 0;

		/** endRead marks the last character in the buffer, that has been read
			from input */
		yy_endRead = 0;

		/** number of newlines encountered up to the start of the matched text */
		yyline = 0;

		/** the number of characters up to the start of the matched text */
		yychar = 0;

		/**
		 * the number of characters from the last newline up to the start of the 
		 * matched text
		 */
		yycolumn = 0; 

		/** 
		 * yy_atBOL == true <=> the scanner is currently at the beginning of a line
		 */
		yy_atBOL = false;
		
		/** yy_atEOF == true <=> the scanner has returned a value for EOF */
		yy_atEOF = false;

		/* user variables */
		//		fUndefined.delete(0, fUndefined.length());
	}

	/* user method */
	public CSSTokenizer() {
		super();
	}



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CSSTokenizer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CSSTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the unpacked transition table
   */
  private static int [] yy_unpack(String packed) {
    int [] trans = new int[21004];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 13906) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return trans;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 170) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (yy_currentPos < yy_endRead) return yy_buffer[yy_currentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (yy_atEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if ( numRead == -1 ) return YYEOF;

    yy_endRead+= numRead;

    return yy_buffer[yy_currentPos++];
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */
    yy_reader.close();
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }

  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }

  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    try {
      System.out.println(YY_ERROR_MSG[errorCode]);
    }
    catch (ArrayIndexOutOfBoundsException e) {
      System.out.println(YY_ERROR_MSG[YY_UNKNOWN_ERROR]);
    }

    System.exit(1);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number) {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;

    yy_pushbackPos = -1;
    boolean yy_was_pushback;

    while (true) {

      yychar+= yylength();

      boolean yy_counted = false;
      for (yy_currentPos = yy_startRead; yy_currentPos < yy_markedPos;
                                                      yy_currentPos++) {
        switch (yy_buffer[yy_currentPos]) {
        case '\r':
          yyline++;
          yy_counted = true;
          break;
        case '\n':
          if (yy_counted)
            yy_counted = false;
          else {
            yyline++;
          }
          break;
        default:
          yy_counted = false;
        }
      }

      if (yy_counted) {
        if ( yy_advance() == '\n' ) yyline--;
        if ( !yy_atEOF ) yy_currentPos--;
      }

      yy_action = -1;

      yy_currentPos = yy_startRead = yy_markedPos;

      yy_state = yy_lexical_state;

      yy_was_pushback = false;

      yy_forAction: {
        while (true) {

          yy_input = yy_advance();

          if ( yy_input == YYEOF ) break yy_forAction;

          int yy_next = yytrans[ yy_rowMap[yy_state] + yycmap[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = YY_ATTRIBUTE[yy_state];
          if ( (yy_attributes & 2) > 0 )
            yy_pushbackPos = yy_currentPos;

          if ( (yy_attributes & 1) > 0 ) {
            yy_was_pushback = (yy_attributes & 4) > 0;
            yy_action = yy_state; 
            yy_markedPos = yy_currentPos; 
            if ( (yy_attributes & 8) > 0 ) break yy_forAction;
          }

        }
      }

      if (yy_was_pushback)
        yy_markedPos = yy_pushbackPos;

      switch (yy_action) {    

        case 421: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IMPORTANT;  }
        case 433: break;
        case 412: 
          {  yybegin(ST_FONT_FACE_DELIMITER); return CSS_FONT_FACE;  }
        case 434: break;
        case 375: 
          {  yybegin(ST_CHARSET_NAME); return CSS_CHARSET;  }
        case 435: break;
        case 335: 
          {  yybegin(ST_IMPORT_URI); return CSS_IMPORT;  }
        case 436: break;
        case 297: 
          {  yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA;  }
        case 437: break;
        case 290: 
        case 327: 
        case 398: 
        case 400: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_URI;  }
        case 438: break;
        case 269: 
        case 307: 
        case 385: 
        case 387: 
          {  yybegin(ST_IMPORT_MEDIUM); return CSS_URI;  }
        case 439: break;
        case 255: 
          {  yybegin(ST_PAGE_PSEUDO_PAGE); return CSS_PAGE;  }
        case 440: break;
        case 218: 
          {  return CSS_COMMENT;  }
        case 441: break;
        case 217: 
          {  return CSS_CDO;  }
        case 442: break;
        case 211: 
        case 245: 
        case 283: 
        case 284: 
        case 323: 
        case 324: 
        case 363: 
        case 364: 
        case 394: 
        case 395: 
        case 407: 
        case 417: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_UNICODE_RANGE;  }
        case 443: break;
        case 165: 
          {  return CSS_CDC;  }
        case 444: break;
        case 162: 
          {  return CSS_DECLARATION_VALUE_S;  }
        case 445: break;
        case 156: 
        case 210: 
        case 244: 
        case 282: 
        case 322: 
        case 362: 
        case 393: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_HASH;  }
        case 446: break;
        case 150: 
        case 205: 
        case 208: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_STRING;  }
        case 447: break;
        case 57: 
        case 59: 
        case 128: 
        case 129: 
        case 193: 
        case 235: 
        case 273: 
        case 313: 
        case 353: 
          {  yybegin(ST_SELECTOR_ATTRIBUTE_OPERATOR); return CSS_SELECTOR_ATTRIBUTE_NAME;  }
        case 448: break;
        case 56: 
          {  yybegin(ST_SELECTOR); return CSS_SELECTOR_SEPARATOR;  }
        case 449: break;
        case 55: 
        case 125: 
          {  yybegin(ST_SELECTOR); return CSS_SELECTOR_COMBINATOR;  }
        case 450: break;
        case 52: 
          {  yybegin(ST_DECLARATION); return CSS_LBRACE;  }
        case 451: break;
        case 49: 
        case 51: 
        case 123: 
        case 124: 
        case 192: 
        case 234: 
        case 272: 
        case 312: 
        case 352: 
          {  yybegin(ST_PAGE_DELIMITER); return CSS_PAGE_SELECTOR;  }
        case 452: break;
        case 48: 
          {  yybegin(YYINITIAL); return CSS_LBRACE;  }
        case 453: break;
        case 47: 
          {  yybegin(ST_MEDIA_MEDIUM); return CSS_MEDIA_SEPARATOR;  }
        case 454: break;
        case 44: 
        case 46: 
        case 120: 
        case 121: 
        case 191: 
        case 233: 
        case 271: 
        case 311: 
        case 351: 
          {  yybegin(ST_MEDIA_DELIMITER); return CSS_MEDIUM;  }
        case 455: break;
        case 43: 
          {  yybegin(ST_IMPORT_MEDIUM); return CSS_MEDIA_SEPARATOR;  }
        case 456: break;
        case 20: 
        case 23: 
        case 89: 
        case 90: 
        case 164: 
        case 214: 
        case 249: 
        case 292: 
        case 331: 
          {  yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ELEMENT_NAME;  }
        case 457: break;
        case 22: 
        case 54: 
        case 87: 
        case 126: 
        case 163: 
          {  return CSS_S;  }
        case 458: break;
        case 27: 
          {  yybegin(YYINITIAL); return CSS_RBRACE;  }
        case 459: break;
        case 29: 
          {  yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_UNIVERSAL;  }
        case 460: break;
        case 32: 
          {  yybegin(ST_SELECTOR_ATTRIBUTE_NAME); return CSS_SELECTOR_ATTRIBUTE_START;  }
        case 461: break;
        case 36: 
          {  yybegin(YYINITIAL); return CSS_DELIMITER;  }
        case 462: break;
        case 40: 
        case 42: 
        case 117: 
        case 118: 
        case 190: 
        case 232: 
        case 270: 
        case 310: 
        case 350: 
          {  yybegin(ST_IMPORT_DELIMITER); return CSS_MEDIUM;  }
        case 463: break;
        case 60: 
          {  yybegin(ST_SELECTOR_ATTRIBUTE_VALUE); return CSS_SELECTOR_ATTRIBUTE_OPERATOR;  }
        case 464: break;
        case 62: 
          {  yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ATTRIBUTE_END;  }
        case 465: break;
        case 63: 
        case 67: 
        case 131: 
        case 134: 
        case 137: 
        case 194: 
        case 196: 
        case 199: 
        case 236: 
        case 274: 
        case 314: 
        case 354: 
          {  yybegin(ST_SELECTOR_ATTRIBUTE_END); return CSS_SELECTOR_ATTRIBUTE_VALUE;  }
        case 466: break;
        case 68: 
        case 70: 
        case 139: 
        case 140: 
        case 201: 
        case 239: 
        case 277: 
        case 317: 
        case 357: 
          {  yybegin(ST_DECLARATION_SEPARATOR); return CSS_DECLARATION_PROPERTY;  }
        case 467: break;
        case 71: 
          {  yybegin(ST_DECLARATION); return CSS_DECLARATION_DELIMITER;  }
        case 468: break;
        case 72: 
          {  yybegin(ST_DECLARATION_PRE_VALUE); return CSS_DECLARATION_SEPARATOR;  }
        case 469: break;
        case 73: 
        case 155: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_NUMBER;  }
        case 470: break;
        case 74: 
        case 79: 
        case 83: 
        case 147: 
        case 153: 
        case 154: 
        case 159: 
        case 203: 
        case 212: 
        case 241: 
        case 279: 
        case 319: 
        case 359: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_IDENT;  }
        case 471: break;
        case 78: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PARENTHESIS_CLOSE;  }
        case 472: break;
        case 85: 
        case 86: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_OPERATOR;  }
        case 473: break;
        case 91: 
        case 166: 
        case 215: 
        case 250: 
        case 293: 
        case 332: 
        case 373: 
          {  yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_CLASS;  }
        case 474: break;
        case 93: 
        case 167: 
        case 216: 
        case 251: 
        case 294: 
        case 333: 
        case 374: 
          {  yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_ID;  }
        case 475: break;
        case 102: 
        case 176: 
        case 226: 
        case 258: 
        case 260: 
        case 300: 
        case 338: 
        case 378: 
          {  yybegin(ST_SELECTOR_MODIFIER); return CSS_SELECTOR_PSEUDO;  }
        case 476: break;
        case 106: 
        case 178: 
        case 181: 
          {  yybegin(ST_CHARSET_DELIMITER); return CSS_STRING;  }
        case 477: break;
        case 112: 
        case 184: 
        case 187: 
          {  yybegin(ST_IMPORT_MEDIUM); return CSS_STRING;  }
        case 478: break;
        case 141: 
        case 202: 
        case 240: 
        case 278: 
        case 318: 
        case 358: 
        case 390: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_DIMENSION;  }
        case 479: break;
        case 144: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_PERCENTAGE;  }
        case 480: break;
        case 146: 
        case 247: 
          {  yybegin(ST_DECLARATION_VALUE); return CSS_DECLARATION_VALUE_FUNCTION;  }
        case 481: break;
        case 19: 
        case 21: 
        case 24: 
        case 25: 
        case 26: 
        case 28: 
        case 30: 
        case 31: 
        case 33: 
        case 34: 
        case 35: 
        case 37: 
        case 38: 
        case 39: 
        case 41: 
        case 45: 
        case 50: 
        case 53: 
        case 58: 
        case 61: 
        case 64: 
        case 65: 
        case 66: 
        case 69: 
        case 75: 
        case 76: 
        case 77: 
        case 80: 
        case 81: 
        case 82: 
        case 84: 
          { 
	return UNDEFINED;
 }
        case 482: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
              return null;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }    

  /**
   * Runs the scanner on input files.
   *
   * This main method is the debugging routine for the scanner.
   * It prints each returned token to System.out until the end of
   * file is reached, or an error occured.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    for (int i = 0; i < argv.length; i++) {
      CSSTokenizer scanner = null;
      try {
        scanner = new CSSTokenizer( new java.io.FileReader(argv[i]) );
      }
      catch (java.io.FileNotFoundException e) {
        System.out.println("File not found : \""+argv[i]+"\"");
        System.exit(1);
      }
      catch (java.io.IOException e) {
        System.out.println("Error opening file \""+argv[i]+"\"");
        System.exit(1);
      }
      catch (ArrayIndexOutOfBoundsException e) {
        System.out.println("Usage : java CSSTokenizer <inputfile>");
        System.exit(1);
      }

      try {
        do {
          System.out.println(scanner.primGetNextToken());
        } while (!scanner.yy_atEOF);

      }
      catch (java.io.IOException e) {
        System.out.println("An I/O error occured while scanning :");
        System.out.println(e);
        System.exit(1);
      }
      catch (Exception e) {
        e.printStackTrace();
        System.exit(1);
      }
    }
  }


}
