/*
* Copyright (c) 2005. IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*/

package org.eclipse.wst.rdb.sqleditor.internal.sql;

import java.util.List;

import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

/**
 * Provides services to retrieve, construct list of proposals of database
 * objects (schemas, tables, columns) based on a given connection info.
 * 
 * @author Hetty Dougherty
 *  
 */
public interface ISQLDBProposalsService {    

    /**
     * Gets the <code>ConnectionInfo</code> used to provide content assist.
     * 
     * @return the current <code>ConnectionInfo</code> object
     */
    ConnectionInfo getConnectionInfo();

    /**
     * Gets the current database name.
     * 
     * @return the database name
     */
    String getDatabaseName();   
    
    /**
     * Gets the default (implied) schema name.
     * 
     * @return the default (implied) schema name           
     */
    public String getSchemaName();
   
    /**
     * Sets the default (implied) schema name.
     *     
     * @param schemaName the default (implied) schema name to set
     *            
     */
    public void setSchemaName( String schemaName );   

    /**
     * Populates the list database of database object proposals (schemas, tables, 
     * columns) using given list of tokens (DB identifiers) indicating the start of
     * the expression for which the user wants DB proposals. For example, if the
     * user provides the list (MYSCHEMA, TABLE1), the list of proposals will be the
     * columns of table MYSCHEMA.TABLE1.  Retrieve the list using getDBProposals().
     * 
     * @param tokenList list of tokens indicating the start of the expression for 
     * which the user wants DB proposals
     * @return true if database objects have loaded, for example
     *         as a result of reestablishing a connection, otherwise false
     */
    public boolean populate( List tokenList );

    /**
     * Gets the list of <code>SQLDBProposal</code> objects for the content assist proposals.
     * Call populate to populate this list.
     * 
     * @return the list of proposals
     * @see populate( List tokenList )
     */
    List getDBProposals();
}