/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.properties.internal.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.ui.properties.internal.CommonUIPropertiesPlugin;
import org.eclipse.wst.common.ui.properties.internal.l10n.Messages;
import org.eclipse.wst.common.ui.properties.internal.provisional.IDynamicTabItem;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISection;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISectionDescriptor;
import org.eclipse.wst.common.ui.properties.internal.view.Tab;

public class TabDescriptor
implements Cloneable,
IDynamicTabItem {
    private static final String ATT_ID = "id";
    private static final String ATT_LABEL = "label";
    private static final String ATT_IMAGE = "image";
    private static final String ATT_INDENTED = "indented";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_AFTER_TAB = "afterTab";
    private static final String TOP = "top";
    private static final String TAB_ERROR = Messages.TabDescriptor_Tab_error;
    private String id;
    private String label;
    private Image image;
    private boolean selected;
    private boolean indented;
    private String category;
    private String afterTab;
    private List sectionDescriptors;

    public TabDescriptor(IConfigurationElement configurationElement) {
        if (configurationElement != null) {
            String indentedString;
            this.id = configurationElement.getAttribute(ATT_ID);
            this.label = configurationElement.getAttribute(ATT_LABEL);
            String imageString = configurationElement.getAttribute(ATT_IMAGE);
            if (imageString != null) {
                this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier(), (String)imageString).createImage();
            }
            this.indented = (indentedString = configurationElement.getAttribute(ATT_INDENTED)) != null && indentedString.equals("true");
            this.category = configurationElement.getAttribute(ATT_CATEGORY);
            this.afterTab = configurationElement.getAttribute(ATT_AFTER_TAB);
            if (this.id == null || this.label == null || this.category == null) {
                this.handleTabError(configurationElement, null);
            }
        }
        if (this.getAfterTab() == null) {
            this.afterTab = TOP;
        }
        this.sectionDescriptors = new ArrayList(5);
        this.selected = false;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    protected String getAfterTab() {
        return this.afterTab;
    }

    protected String getCategory() {
        return this.category;
    }

    protected boolean append(ISectionDescriptor target) {
        if (!target.getTargetTab().equals(this.id)) {
            return false;
        }
        if (this.insertSectionDescriptor(target)) {
            return true;
        }
        this.sectionDescriptors.add(target);
        return true;
    }

    private boolean insertSectionDescriptor(ISectionDescriptor target) {
        if (target.getAfterSection().equals(TOP)) {
            this.sectionDescriptors.add(0, target);
            return true;
        }
        int i = 0;
        while (i < this.sectionDescriptors.size()) {
            ISectionDescriptor descriptor = (ISectionDescriptor)this.sectionDescriptors.get(i);
            if (target.getAfterSection().equals(descriptor.getId())) {
                this.sectionDescriptors.add(i + 1, target);
                return true;
            }
            if (descriptor.getAfterSection().equals(target.getId())) {
                this.sectionDescriptors.add(i, target);
                return true;
            }
            ++i;
        }
        return false;
    }

    public Tab createTab() {
        ArrayList<ISection> sections = new ArrayList<ISection>(this.sectionDescriptors.size());
        Iterator iter = this.sectionDescriptors.iterator();
        while (iter.hasNext()) {
            ISectionDescriptor descriptor = (ISectionDescriptor)iter.next();
            ISection section = descriptor.getSectionClass();
            sections.add(section);
        }
        Tab tab = new Tab();
        tab.setSections(sections.toArray(new ISection[sections.size()]));
        return tab;
    }

    protected List getSectionDescriptors() {
        return this.sectionDescriptors;
    }

    protected void setSectionDescriptors(List sectionDescriptors) {
        this.sectionDescriptors = sectionDescriptors;
    }

    public String toString() {
        return this.getId();
    }

    private void handleTabError(IConfigurationElement configurationElement, CoreException exception) {
        String pluginId = configurationElement.getDeclaringExtension().getNamespaceIdentifier();
        String message = MessageFormat.format(TAB_ERROR, pluginId);
        Status status = new Status(4, pluginId, 6, message, (Throwable)exception);
        CommonUIPropertiesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() == object.getClass()) {
            TabDescriptor descriptor = (TabDescriptor)object;
            if (this.getCategory().equals(descriptor.getCategory()) && this.getId().equals(descriptor.getId()) && this.getSectionDescriptors().size() == descriptor.getSectionDescriptors().size()) {
                Iterator i = this.getSectionDescriptors().iterator();
                Iterator j = descriptor.getSectionDescriptors().iterator();
                while (i.hasNext()) {
                    ISectionDescriptor source = (ISectionDescriptor)i.next();
                    ISectionDescriptor target = (ISectionDescriptor)j.next();
                    if (source.getId().equals(target.getId())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.getCategory().hashCode();
        hashCode ^= this.getId().hashCode();
        Iterator i = this.getSectionDescriptors().iterator();
        while (i.hasNext()) {
            ISectionDescriptor section = (ISectionDescriptor)i.next();
            hashCode ^= section.getId().hashCode();
        }
        return hashCode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            Status status = new Status(4, CommonUIPropertiesPlugin.getPlugin().getBundle().getSymbolicName(), 6, exception.getMessage(), (Throwable)exception);
            CommonUIPropertiesPlugin.getPlugin().getLog().log((IStatus)status);
            return null;
        }
    }

    protected void setImage(Image image) {
        this.image = image;
    }

    protected void setIndented(boolean indented) {
        this.indented = indented;
    }

    protected void setSelected(boolean selected) {
        this.selected = selected;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isIndented() {
        return this.indented;
    }

    public String getText() {
        return this.label;
    }
}

