/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;

public class DefaultVersionComparator
implements Comparator {
    public final int compare(Object obj1, Object obj2) throws VersionFormatException {
        Comparable[] parsed1 = this.parse((String)obj1);
        Comparable[] parsed2 = this.parse((String)obj2);
        int i = 0;
        while (i < parsed1.length && i < parsed2.length) {
            int res = parsed1[i].compareTo(parsed2[i]);
            if (res != 0) {
                return res;
            }
            ++i;
        }
        if (parsed1.length > parsed2.length) {
            return 1;
        }
        if (parsed1.length < parsed2.length) {
            return -1;
        }
        return 0;
    }

    protected String getSeparators() {
        return ".";
    }

    protected Comparable parse(String version, String segment, int position) throws VersionFormatException {
        try {
            if (position == 0) {
                return new Integer(segment);
            }
            return new BigDecimal("." + segment);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionFormatException(this, version);
        }
    }

    private Comparable[] parse(String ver) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(ver, this.getSeparators());
        while (t.hasMoreTokens()) {
            segments.add(t.nextToken());
        }
        Comparable[] parsed = new Comparable[segments.size()];
        int i = 0;
        int n = segments.size();
        while (i < n) {
            parsed[i] = this.parse(ver, (String)segments.get(i), i);
            ++i;
        }
        return parsed;
    }
}

