/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class XMLUtils {
    public static final String serialize(Element e, boolean omitXMLDeclaration) {
        if (e != null) {
            try {
                DOMSource domSource = new DOMSource(e);
                Transformer serializer = TransformerFactory.newInstance().newTransformer();
                serializer.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
                serializer.setOutputProperty("indent", "yes");
                serializer.setOutputProperty("encoding", "UTF-8");
                serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                serializer.transform(domSource, new StreamResult(baos));
                baos.close();
                return new String(baos.toByteArray(), "UTF-8");
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static final String serialize(DocumentFragment df, boolean omitXMLDeclaration) {
        if (df != null) {
            try {
                DOMSource domSource = new DOMSource(df);
                Transformer serializer = TransformerFactory.newInstance().newTransformer();
                serializer.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
                serializer.setOutputProperty("indent", "yes");
                serializer.setOutputProperty("encoding", "UTF-8");
                serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                serializer.transform(domSource, new StreamResult(baos));
                baos.close();
                return new String(baos.toByteArray(), "UTF-8");
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static final Document createNewDocument(DocumentBuilder docBuilder) throws ParserConfigurationException {
        if (docBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            docBuilder = factory.newDocumentBuilder();
        }
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static Element stringToElement(String s) throws ParserConfigurationException, SAXException, UnsupportedEncodingException, IOException {
        return XMLUtils.stringToElement(s, false);
    }

    public static Element stringToElement(String s, boolean namespaceAware) throws ParserConfigurationException, SAXException, UnsupportedEncodingException, IOException {
        return XMLUtils.byteArrayToElement(s.getBytes("UTF-8"), namespaceAware);
    }

    public static Element byteArrayToElement(byte[] b, boolean namespaceAware) throws ParserConfigurationException, SAXException, UnsupportedEncodingException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(namespaceAware);
        docBuilderFactory.setValidating(false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new ByteArrayInputStream(b));
        return doc.getDocumentElement();
    }
}

