/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.ui.dialogs.RevertDialog;
import org.tigris.subversion.subclipse.ui.operations.RevertOperation;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;

public class RevertSynchronizeOperation
extends SVNSynchronizeOperation {
    private String url;
    private IResource[] resources;
    private IResource[] resourcesToRevert;
    private boolean revert;
    private boolean prompted;

    public RevertSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, String url, IResource[] resources) {
        super(configuration, elements);
        this.url = url;
        this.resources = resources;
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.prompted) {
            return;
        }
        this.prompted = true;
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (RevertSynchronizeOperation.this.resources == null || RevertSynchronizeOperation.this.resources.length == 0) {
                    RevertSynchronizeOperation.this.revert = false;
                    return;
                }
                RevertDialog dialog = new RevertDialog(RevertSynchronizeOperation.this.getShell(), RevertSynchronizeOperation.this.resources, RevertSynchronizeOperation.this.url);
                RevertSynchronizeOperation.this.revert = dialog.open() == 0;
                if (RevertSynchronizeOperation.this.revert) {
                    RevertSynchronizeOperation.this.resourcesToRevert = dialog.getSelectedResources();
                }
            }
        });
        if (this.revert) {
            new RevertOperation(this.getPart(), this.resourcesToRevert).run();
        }
    }
}

