/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.formatter;

import java.util.HashMap;
import java.util.Map;

public class DefaultCodeFormatterOptions {
    private static final int DEFAULT_INDENT_SIZE = 4;
    private static final int DEFAULT_TAB_SIZE = 4;
    public static final int TAB = 1;
    public static final int SPACE = 2;
    public static final int MIXED = 4;
    public int indentation_size;
    public int tab_char;
    public int tab_size;
    public int comment_line_length;

    public static DefaultCodeFormatterOptions getDefaultSettings() {
        DefaultCodeFormatterOptions defaultCodeFormatterOptions = new DefaultCodeFormatterOptions();
        defaultCodeFormatterOptions.setDefaultSettings();
        return defaultCodeFormatterOptions;
    }

    public static DefaultCodeFormatterOptions getEclipseDefaultSettings() {
        DefaultCodeFormatterOptions defaultCodeFormatterOptions = new DefaultCodeFormatterOptions();
        defaultCodeFormatterOptions.setEclipseDefaultSettings();
        return defaultCodeFormatterOptions;
    }

    public static DefaultCodeFormatterOptions getRubyConventionsSettings() {
        DefaultCodeFormatterOptions defaultCodeFormatterOptions = new DefaultCodeFormatterOptions();
        defaultCodeFormatterOptions.setRubyConventionsSettings();
        return defaultCodeFormatterOptions;
    }

    private DefaultCodeFormatterOptions() {
    }

    public DefaultCodeFormatterOptions(Map map) {
        this.setDefaultSettings();
        if (map == null) {
            return;
        }
        this.set(map);
    }

    public void setDefaultSettings() {
        this.tab_char = 1;
        this.tab_size = 4;
        this.indentation_size = 4;
    }

    public void setEclipseDefaultSettings() {
        this.setRubyConventionsSettings();
    }

    public void setRubyConventionsSettings() {
        this.setDefaultSettings();
        this.tab_char = 2;
        this.tab_size = 2;
        this.indentation_size = 2;
    }

    public Map getMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("org.rubypeople.rdt.core.formatter.comment.line_length", Integer.toString(this.comment_line_length));
        hashMap.put("org.rubypeople.rdt.core.formatter.indentation.size", Integer.toString(this.indentation_size));
        switch (this.tab_char) {
            case 2: {
                hashMap.put("org.rubypeople.rdt.core.formatter.tabulation.char", "space");
                break;
            }
            case 1: {
                hashMap.put("org.rubypeople.rdt.core.formatter.tabulation.char", "tab");
                break;
            }
            case 4: {
                hashMap.put("org.rubypeople.rdt.core.formatter.tabulation.char", "mixed");
            }
        }
        hashMap.put("org.rubypeople.rdt.core.formatter.tabulation.size", Integer.toString(this.tab_size));
        return hashMap;
    }

    public void set(Map map) {
        Object v;
        Object v2;
        Object v3;
        Object v4 = map.get("org.rubypeople.rdt.core.formatter.comment.line_length");
        if (v4 != null) {
            try {
                this.comment_line_length = Integer.parseInt((String)v4);
            }
            catch (NumberFormatException numberFormatException) {
                this.comment_line_length = 80;
            }
            catch (ClassCastException classCastException) {
                this.comment_line_length = 80;
            }
        }
        if ((v3 = map.get("org.rubypeople.rdt.core.formatter.indentation.size")) != null) {
            try {
                this.indentation_size = Integer.parseInt((String)v3);
            }
            catch (NumberFormatException numberFormatException) {
                this.indentation_size = 4;
            }
            catch (ClassCastException classCastException) {
                this.indentation_size = 4;
            }
        }
        if ((v2 = map.get("org.rubypeople.rdt.core.formatter.tabulation.size")) != null) {
            try {
                this.tab_size = Integer.parseInt((String)v2);
            }
            catch (NumberFormatException numberFormatException) {
                this.tab_size = 4;
            }
            catch (ClassCastException classCastException) {
                this.tab_size = 4;
            }
        }
        if ((v = map.get("org.rubypeople.rdt.core.formatter.tabulation.char")) != null) {
            this.tab_char = "tab".equals(v) ? 1 : ("space".equals(v) ? 2 : 4);
        }
    }
}

