/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.rubypeople.rdt.internal.ui.text.RubyHeuristicScanner;

public class RubyPairMatcher
implements ICharacterPairMatcher {
    protected char[] fPairs;
    protected IDocument fDocument;
    protected int fOffset;
    protected int fStartPos;
    protected int fEndPos;
    protected int fAnchor;

    public RubyPairMatcher(char[] cArray) {
        this.fPairs = cArray;
    }

    public IRegion match(IDocument iDocument, int n) {
        this.fOffset = n;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = iDocument;
        if (this.fDocument != null && this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
    }

    public void clear() {
    }

    protected boolean matchPairsAt() {
        int n = this.fPairs.length;
        int n2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            char c = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int n3 = 0;
            while (n3 < this.fPairs.length) {
                if (c == this.fPairs[n3]) {
                    this.fStartPos = this.fOffset - 1;
                    n = n3;
                }
                n3 += 2;
            }
            n3 = 1;
            while (n3 < this.fPairs.length) {
                if (c == this.fPairs[n3]) {
                    this.fEndPos = this.fOffset - 1;
                    n2 = n3;
                }
                n3 += 2;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[n2 - 1], this.fPairs[n2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            } else if (this.fStartPos > -1) {
                this.fAnchor = 1;
                this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[n], this.fPairs[n + 1], this.fDocument);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    protected int searchForClosingPeer(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        RubyHeuristicScanner rubyHeuristicScanner = new RubyHeuristicScanner(iDocument, "___ruby_partitioning", TextUtilities.getContentType((IDocument)iDocument, (String)"___ruby_partitioning", (int)n, (boolean)false));
        return rubyHeuristicScanner.findClosingPeer(n + 1, c, c2);
    }

    protected int searchForOpeningPeer(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        RubyHeuristicScanner rubyHeuristicScanner = new RubyHeuristicScanner(iDocument, "___ruby_partitioning", TextUtilities.getContentType((IDocument)iDocument, (String)"___ruby_partitioning", (int)n, (boolean)false));
        int n2 = rubyHeuristicScanner.findOpeningPeer(n - 1, c, c2);
        if (n2 == -1) {
            return -1;
        }
        return n2;
    }
}

