/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.vsftp;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.event.IvyEvent;
import fr.jayasoft.ivy.event.IvyListener;
import fr.jayasoft.ivy.repository.AbstractRepository;
import fr.jayasoft.ivy.repository.BasicResource;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.vsftp.VsftpResource;
import fr.jayasoft.ivy.util.IvyThread;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class VsftpRepository
extends AbstractRepository {
    private static final String PROMPT = "vsftp> ";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("MMM dd, yyyy HH:mm", Locale.US);
    private String _host;
    private String _username;
    private String _authentication = "gssapi";
    private Reader _in;
    private Reader _err;
    private PrintWriter _out;
    private volatile StringBuffer _errors = new StringBuffer();
    private long _readTimeout = 30000L;
    private long _reuseConnection = 300000L;
    private volatile long _lastCommand;
    private volatile boolean _inCommand;
    private Process _process;
    private Thread _connectionCleaner;
    private Thread _errorsReader;
    private volatile long _errorsLastUpdateTime;
    private Ivy _ivy = null;

    public Resource getResource(String source) throws IOException {
        this.initIvy();
        return new VsftpResource(this, source);
    }

    private void initIvy() {
        this._ivy = IvyContext.getContext().getIvy();
    }

    protected Resource getInitResource(String source) throws IOException {
        try {
            Resource resource = this.lslToResource(source, this.sendCommand("ls -l " + source, true, true));
            return resource;
        }
        catch (IOException ex) {
            this.cleanup(ex);
            throw ex;
        }
        finally {
            this.cleanup();
        }
    }

    public void get(final String source, File destination) throws IOException {
        this.initIvy();
        try {
            int index;
            this.fireTransferInitiated(this.getResource(source), 5);
            File destDir = destination.getParentFile();
            if (destDir != null) {
                this.sendCommand("lcd " + destDir.getAbsolutePath());
            }
            if (destination.exists()) {
                destination.delete();
            }
            String srcName = (index = source.lastIndexOf(47)) == -1 ? source : source.substring(index + 1);
            final File to = destDir == null ? new File(srcName) : new File(destDir, srcName);
            final IOException[] ex = new IOException[1];
            IvyThread get = new IvyThread(){

                public void run() {
                    this.initContext();
                    try {
                        VsftpRepository.this.sendCommand("get " + source, VsftpRepository.this.getExpectedDownloadMessage(source, to), 0L);
                    }
                    catch (IOException e) {
                        ex[0] = e;
                    }
                }
            };
            get.start();
            long prevLength = 0L;
            long lastUpdate = System.currentTimeMillis();
            long timeout = this._readTimeout;
            while (get.isAlive()) {
                long length;
                this.checkInterrupted();
                long l = length = to.exists() ? to.length() : 0L;
                if (length > prevLength) {
                    this.fireTransferProgress(length - prevLength);
                    lastUpdate = System.currentTimeMillis();
                    prevLength = length;
                } else if (System.currentTimeMillis() - lastUpdate > timeout) {
                    Message.verbose("download hang for more than " + timeout + "ms. Interrupting.");
                    get.interrupt();
                    if (to.exists()) {
                        to.delete();
                    }
                    throw new IOException(source + " download timeout from " + this.getHost());
                }
                try {
                    get.join(100L);
                }
                catch (InterruptedException e) {
                    if (to.exists()) {
                        to.delete();
                    }
                    this.cleanup();
                    return;
                }
            }
            if (ex[0] != null) {
                if (to.exists()) {
                    to.delete();
                }
                throw ex[0];
            }
            to.renameTo(destination);
            this.fireTransferCompleted(destination.length());
        }
        catch (IOException ex) {
            this.fireTransferError(ex);
            this.cleanup(ex);
            throw ex;
        }
        finally {
            this.cleanup();
        }
    }

    public List list(String parent) throws IOException {
        this.initIvy();
        try {
            String response;
            if (!parent.endsWith("/")) {
                parent = parent + "/";
            }
            if ((response = this.sendCommand("ls -l " + parent, true, true)).startsWith("ls")) {
                List list = null;
                return list;
            }
            String[] lines = response.split("\n");
            ArrayList<String> ret = new ArrayList<String>(lines.length);
            for (int i = 0; i < lines.length; ++i) {
                while (lines[i].endsWith("\r") || lines[i].endsWith("\n")) {
                    lines[i] = lines[i].substring(0, lines[i].length() - 1);
                }
                if (lines[i].trim().length() == 0) continue;
                ret.add(parent + lines[i].substring(lines[i].lastIndexOf(32) + 1));
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        catch (IOException ex) {
            this.cleanup(ex);
            throw ex;
        }
        finally {
            this.cleanup();
        }
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        this.initIvy();
        try {
            if (this.getResource(destination).exists()) {
                if (overwrite) {
                    this.sendCommand("rm " + destination, this.getExpectedRemoveMessage(destination));
                } else {
                    return;
                }
            }
            int index = destination.lastIndexOf(47);
            String destDir = null;
            if (index != -1) {
                destDir = destination.substring(0, index);
                this.mkdirs(destDir);
                this.sendCommand("cd " + destDir);
            }
            String to = destDir != null ? destDir + "/" + source.getName() : source.getName();
            this.sendCommand("put " + source.getAbsolutePath(), this.getExpectedUploadMessage(source, to), 0L);
            this.sendCommand("mv " + to + " " + destination);
        }
        catch (IOException ex) {
            this.cleanup(ex);
            throw ex;
        }
        finally {
            this.cleanup();
        }
    }

    private void mkdirs(String destDir) throws IOException {
        int index;
        if (this.dirExists(destDir)) {
            return;
        }
        if (destDir.endsWith("/")) {
            destDir = destDir.substring(0, destDir.length() - 1);
        }
        if ((index = destDir.lastIndexOf(47)) != -1) {
            this.mkdirs(destDir.substring(0, index));
        }
        this.sendCommand("mkdir " + destDir);
    }

    private boolean dirExists(String dir) throws IOException {
        return !this.sendCommand("ls " + dir, true).startsWith("ls: ");
    }

    protected String sendCommand(String command) throws IOException {
        return this.sendCommand(command, false, this._readTimeout);
    }

    protected void sendCommand(String command, Pattern expectedResponse) throws IOException {
        this.sendCommand(command, expectedResponse, this._readTimeout);
    }

    protected void sendCommand(String command, Pattern expectedResponse, long timeout) throws IOException {
        String response = this.sendCommand(command, true, timeout);
        if (!expectedResponse.matcher(response).matches()) {
            Message.debug("invalid response from server:");
            Message.debug("expected: '" + expectedResponse + "'");
            Message.debug("was:      '" + response + "'");
            throw new IOException(response);
        }
    }

    protected String sendCommand(String command, boolean sendErrorAsResponse) throws IOException {
        return this.sendCommand(command, sendErrorAsResponse, this._readTimeout);
    }

    protected String sendCommand(String command, boolean sendErrorAsResponse, boolean single) throws IOException {
        return this.sendCommand(command, sendErrorAsResponse, single, this._readTimeout);
    }

    protected String sendCommand(String command, boolean sendErrorAsResponse, long timeout) throws IOException {
        return this.sendCommand(command, sendErrorAsResponse, false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sendCommand(String command, boolean sendErrorAsResponse, boolean single, long timeout) throws IOException {
        single = false;
        this.checkInterrupted();
        this._inCommand = true;
        this._errorsLastUpdateTime = 0L;
        Object object = this;
        synchronized (object) {
            if (!single || this._in != null) {
                this.ensureConnectionOpened();
                Message.debug("sending command '" + command + "' to " + this.getHost());
                this.updateLastCommandTime();
                this._out.println(command);
                this._out.flush();
            } else {
                this.sendSingleCommand(command);
            }
        }
        try {
            object = this.readResponse(sendErrorAsResponse, timeout);
            return object;
        }
        finally {
            this._inCommand = false;
            if (single) {
                this.closeConnection();
            }
        }
    }

    protected String readResponse(boolean sendErrorAsResponse) throws IOException {
        return this.readResponse(sendErrorAsResponse, this._readTimeout);
    }

    protected synchronized String readResponse(final boolean sendErrorAsResponse, long timeout) throws IOException {
        final StringBuffer response = new StringBuffer();
        final IOException[] exc = new IOException[1];
        final boolean[] done = new boolean[1];
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                VsftpRepository vsftpRepository = VsftpRepository.this;
                synchronized (vsftpRepository) {
                    try {
                        boolean getPrompt = false;
                        for (int attempts = 0; !getPrompt && attempts < 5; ++attempts) {
                            int c;
                            while ((c = VsftpRepository.this._in.read()) != -1) {
                                attempts = 0;
                                response.append((char)c);
                                if (response.length() < VsftpRepository.PROMPT.length() || !response.substring(response.length() - VsftpRepository.PROMPT.length(), response.length()).equals(VsftpRepository.PROMPT)) continue;
                                response.setLength(response.length() - VsftpRepository.PROMPT.length());
                                getPrompt = true;
                                break;
                            }
                            if (getPrompt) continue;
                            try {
                                Thread.sleep(50L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        if (getPrompt) {
                            if (VsftpRepository.this._errorsLastUpdateTime == 0L) {
                                VsftpRepository.this._errorsLastUpdateTime = VsftpRepository.this._lastCommand;
                            }
                            while (System.currentTimeMillis() - VsftpRepository.this._errorsLastUpdateTime < 50L) {
                                try {
                                    Thread.sleep(30L);
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                    break;
                                }
                            }
                        }
                        if (VsftpRepository.this._errors.length() > 0) {
                            if (sendErrorAsResponse) {
                                response.append(VsftpRepository.this._errors);
                                VsftpRepository.this._errors.setLength(0);
                            } else {
                                throw new IOException(VsftpRepository.chomp(VsftpRepository.this._errors).toString());
                            }
                        }
                        VsftpRepository.chomp(response);
                        done[0] = true;
                    }
                    catch (IOException e) {
                        exc[0] = e;
                    }
                    finally {
                        VsftpRepository.this.notify();
                    }
                }
            }
        };
        IvyThread reader = null;
        if (timeout == 0L) {
            r.run();
        } else {
            reader = new IvyThread(r);
            reader.start();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.updateLastCommandTime();
        if (exc[0] != null) {
            throw exc[0];
        }
        if (!done[0]) {
            if (reader != null && reader.isAlive()) {
                reader.interrupt();
                for (int i = 0; i < 5 && reader.isAlive(); ++i) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (reader.isAlive()) {
                    reader.stop();
                }
            }
            throw new IOException("connection timeout to " + this.getHost());
        }
        if ("Not connected.".equals(response)) {
            Message.info("vsftp connection to " + this.getHost() + " reset");
            this.closeConnection();
            throw new IOException("not connected to " + this.getHost());
        }
        Message.debug("received response '" + response + "' from " + this.getHost());
        return response.toString();
    }

    private synchronized void sendSingleCommand(String command) throws IOException {
        this.exec(this.getSingleCommand(command));
    }

    protected synchronized void ensureConnectionOpened() throws IOException {
        if (this._in == null) {
            Message.verbose("connecting to " + this.getUsername() + "@" + this.getHost() + "... ");
            String connectionCommand = this.getConnectionCommand();
            this.exec(connectionCommand);
            try {
                this.readResponse(false);
                if (this._reuseConnection > 0L) {
                    this._connectionCleaner = new IvyThread(){

                        public void run() {
                            this.initContext();
                            try {
                                long sleep = 10L;
                                while (VsftpRepository.this._in != null && sleep > 0L) {
                                    3.sleep(sleep);
                                    sleep = VsftpRepository.this._reuseConnection - (System.currentTimeMillis() - VsftpRepository.this._lastCommand);
                                    if (!VsftpRepository.this._inCommand) continue;
                                    sleep = sleep <= 0L ? VsftpRepository.this._reuseConnection : sleep;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            VsftpRepository.this.disconnect();
                        }
                    };
                    this._connectionCleaner.start();
                }
                if (this._ivy != null) {
                    this._ivy.addIvyListener(new IvyListener(){

                        public void progress(IvyEvent event) {
                            VsftpRepository.this.disconnect();
                            event.getSource().removeIvyListener(this);
                        }
                    }, "post-resolve");
                }
            }
            catch (IOException ex) {
                this.closeConnection();
                throw new IOException("impossible to connect to " + this.getUsername() + "@" + this.getHost() + " using " + this.getAuthentication() + ": " + ex.getMessage());
            }
            Message.verbose("connected to " + this.getHost());
        }
    }

    private void updateLastCommandTime() {
        this._lastCommand = System.currentTimeMillis();
    }

    private void exec(String command) throws IOException {
        Message.debug("launching '" + command + "'");
        this._process = Runtime.getRuntime().exec(command);
        this._in = new InputStreamReader(this._process.getInputStream());
        this._err = new InputStreamReader(this._process.getErrorStream());
        this._out = new PrintWriter(this._process.getOutputStream());
        this._errorsReader = new IvyThread(){

            public void run() {
                this.initContext();
                try {
                    int c;
                    while (VsftpRepository.this._err != null && (c = VsftpRepository.this._err.read()) != -1) {
                        VsftpRepository.this._errors.append((char)c);
                        VsftpRepository.this._errorsLastUpdateTime = System.currentTimeMillis();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this._errorsReader.start();
    }

    private void checkInterrupted() {
        if (this._ivy != null) {
            this._ivy.checkInterrupted();
        }
    }

    private void cleanup(Exception ex) {
        if (ex.getMessage().equals("connection timeout to " + this.getHost())) {
            this.closeConnection();
        } else {
            this.disconnect();
        }
    }

    private void cleanup() {
        if (this._reuseConnection == 0L) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        if (this._in != null) {
            Message.verbose("disconnecting from " + this.getHost() + "... ");
            try {
                this.sendCommand("exit", false, 300L);
            }
            catch (IOException iOException) {
            }
            finally {
                this.closeConnection();
                Message.verbose("disconnected of " + this.getHost());
            }
        }
    }

    private synchronized void closeConnection() {
        if (this._connectionCleaner != null) {
            this._connectionCleaner.interrupt();
        }
        if (this._errorsReader != null) {
            this._errorsReader.interrupt();
        }
        try {
            this._process.destroy();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this._in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this._err.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this._out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._connectionCleaner = null;
        this._errorsReader = null;
        this._process = null;
        this._in = null;
        this._out = null;
        this._err = null;
        Message.debug("connection to " + this.getHost() + " closed");
    }

    protected Resource lslToResource(String file, String responseLine) {
        if (responseLine == null || responseLine.startsWith("ls")) {
            return new BasicResource(file, false, 0L, 0L, false);
        }
        String[] parts = responseLine.split("\\s+");
        if (parts.length != 9) {
            Message.debug("unrecognized ls format: " + responseLine);
            return new BasicResource(file, false, 0L, 0L, false);
        }
        try {
            long contentLength = Long.parseLong(parts[3]);
            String date = parts[4] + " " + parts[5] + " " + parts[6] + " " + parts[7];
            return new BasicResource(file, true, contentLength, FORMAT.parse(date).getTime(), false);
        }
        catch (Exception ex) {
            Message.warn("impossible to parse server response: " + responseLine + ": " + ex);
            return new BasicResource(file, false, 0L, 0L, false);
        }
    }

    protected String getSingleCommand(String command) {
        return "vsh -noprompt -auth " + this._authentication + " " + this._username + "@" + this._host + " " + command;
    }

    protected String getConnectionCommand() {
        return "vsftp -noprompt -auth " + this._authentication + " " + this._username + "@" + this._host;
    }

    protected Pattern getExpectedDownloadMessage(String source, File to) {
        return Pattern.compile("Downloading " + to.getName() + " from [^\\s]+");
    }

    protected Pattern getExpectedRemoveMessage(String destination) {
        return Pattern.compile("Removing [^\\s]+");
    }

    protected Pattern getExpectedUploadMessage(File source, String to) {
        return Pattern.compile("Uploading " + source.getName() + " to [^\\s]+");
    }

    public String getAuthentication() {
        return this._authentication;
    }

    public void setAuthentication(String authentication) {
        this._authentication = authentication;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    private static StringBuffer chomp(StringBuffer str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        while ("\n".equals(str.substring(str.length() - 1)) || "\r".equals(str.substring(str.length() - 1))) {
            str.setLength(str.length() - 1);
        }
        return str;
    }

    public String toString() {
        return this.getName() + " " + this.getUsername() + "@" + this.getHost() + " (" + this.getAuthentication() + ")";
    }

    public void setReuseConnection(long time) {
        this._reuseConnection = time;
    }

    public long getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this._readTimeout = readTimeout;
    }
}

