/* desktop-agnostic-vfs.vapi generated by valac 0.16.1, do not modify. */

[CCode (cprefix = "DesktopAgnostic", lower_case_cprefix = "desktop_agnostic_")]
namespace DesktopAgnostic {
	namespace VFS {
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public class Bookmark : GLib.Object {
			public Bookmark ();
			public string? alias { get; set; }
			public DesktopAgnostic.VFS.File file { get; set; }
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public abstract class File : GLib.Object {
			public File ();
			public abstract bool copy (DesktopAgnostic.VFS.File destination, bool overwrite) throws GLib.Error;
			public abstract GLib.SList<DesktopAgnostic.VFS.File> enumerate_children () throws GLib.Error;
			public abstract bool exists ();
			public abstract string[] get_icon_names () throws GLib.Error;
			public abstract string get_mime_type () throws GLib.Error;
			public virtual string? get_thumbnail_path ();
			protected abstract void init (string uri);
			public bool is_executable ();
			public abstract bool is_native ();
			public bool is_readable ();
			public bool is_writable ();
			public abstract bool launch () throws GLib.Error;
			public abstract bool load_contents (out string contents, out size_t length) throws GLib.Error;
			public abstract DesktopAgnostic.VFS.FileMonitor monitor ();
			public abstract bool remove () throws GLib.Error;
			public abstract bool replace_contents (string contents) throws GLib.Error;
			public abstract DesktopAgnostic.VFS.AccessFlags access_flags { get; }
			public abstract DesktopAgnostic.VFS.FileType file_type { get; }
			protected abstract string? impl_path { owned get; }
			protected abstract string impl_uri { owned get; }
			public abstract void* implementation { get; }
			public abstract DesktopAgnostic.VFS.File? parent { owned get; }
			public string? path { owned get; construct; }
			public string uri { owned get; construct; }
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public class Glob : GLib.Object {
			public Glob ();
			public void append (string pattern) throws DesktopAgnostic.VFS.GlobError;
			public static DesktopAgnostic.VFS.Glob execute (string pattern) throws DesktopAgnostic.VFS.GlobError;
			public static DesktopAgnostic.VFS.Glob execute_with_flags (string pattern, int flags) throws DesktopAgnostic.VFS.GlobError;
			public unowned string[]? get_paths ();
			public int flags { get; set; }
			public size_t offset { get; }
			public string pattern { get; set; }
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public class GtkBookmarks : GLib.Object {
			public GtkBookmarks (DesktopAgnostic.VFS.File? file = null, bool monitor = true);
			public GLib.SList<DesktopAgnostic.VFS.Bookmark>? bookmarks { get; }
			public DesktopAgnostic.VFS.File? file { construct; }
			public signal void changed ();
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public interface FileMonitor : GLib.Object {
			public abstract bool cancel ();
			public abstract void emit (DesktopAgnostic.VFS.File? other, DesktopAgnostic.VFS.FileMonitorEvent event);
			public abstract bool cancelled { get; }
			public signal void changed (DesktopAgnostic.VFS.File file, DesktopAgnostic.VFS.File? other, DesktopAgnostic.VFS.FileMonitorEvent event);
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public interface Implementation : GLib.Object {
			public abstract GLib.SList<DesktopAgnostic.VFS.File> files_from_uri_list (string uri_list) throws GLib.Error;
			public abstract void init ();
			public abstract void shutdown ();
			public abstract unowned DesktopAgnostic.VFS.VolumeMonitor volume_monitor_get_default ();
			public abstract GLib.Type file_monitor_type { get; }
			public abstract GLib.Type file_type { get; }
			public abstract string name { get; }
			public abstract GLib.Type trash_type { get; }
			public abstract GLib.Type volume_type { get; }
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public interface Trash : GLib.Object {
			public abstract void empty ();
			public abstract void send_to_trash (DesktopAgnostic.VFS.File file) throws GLib.Error;
			public abstract uint file_count { get; }
			public signal void file_count_changed ();
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public interface Volume : GLib.Object {
			public delegate void Callback ();
			public abstract bool can_eject ();
			public abstract void eject (DesktopAgnostic.VFS.Volume.Callback callback);
			public abstract bool eject_finish () throws DesktopAgnostic.VFS.VolumeError;
			public abstract bool is_mounted ();
			public abstract void mount (DesktopAgnostic.VFS.Volume.Callback callback);
			public abstract bool mount_finish () throws DesktopAgnostic.VFS.VolumeError;
			public abstract void unmount (DesktopAgnostic.VFS.Volume.Callback callback);
			public abstract bool unmount_finish () throws DesktopAgnostic.VFS.VolumeError;
			public abstract string? icon { owned get; }
			public abstract string name { get; }
			public abstract DesktopAgnostic.VFS.File uri { get; }
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public interface VolumeMonitor : GLib.Object {
			public abstract void* implementation { get; }
			public abstract GLib.List<DesktopAgnostic.VFS.Volume> volumes { owned get; }
			public signal void volume_mounted (DesktopAgnostic.VFS.Volume volume);
			public signal void volume_unmounted (DesktopAgnostic.VFS.Volume volume);
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public enum AccessFlags {
			NONE,
			READ,
			WRITE,
			EXECUTE
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public enum FileMonitorEvent {
			UNKNOWN,
			CHANGED,
			CREATED,
			DELETED,
			ATTRIBUTE_CHANGED
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public enum FileType {
			UNKNOWN,
			REGULAR,
			DIRECTORY,
			SYMBOLIC_LINK,
			SPECIAL
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public errordomain FileError {
			FILE_NOT_FOUND,
			EXISTS,
			INVALID_TYPE
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public errordomain GlobError {
			NOSPACE,
			ABORTED,
			NOMATCH,
			BAD_PATTERN,
			BAD_FLAGS,
			ERRNO
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public errordomain VolumeError {
			MOUNT,
			UNMOUNT,
			EJECT
		}
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static DesktopAgnostic.VFS.File? file_new_for_path (string path) throws GLib.Error;
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static DesktopAgnostic.VFS.File? file_new_for_uri (string uri) throws GLib.Error;
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static GLib.SList<DesktopAgnostic.VFS.File>? files_from_uri_list (string uri_list) throws GLib.Error;
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static unowned DesktopAgnostic.VFS.Implementation? get_default () throws GLib.Error;
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static string[] get_icon_names_for_mime_type (string mime_type);
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static void init () throws GLib.Error;
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static void shutdown () throws GLib.Error;
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static unowned DesktopAgnostic.VFS.Trash trash_get_default () throws GLib.Error;
		[CCode (cheader_filename = "libdesktop-agnostic/vfs.h")]
		public static unowned DesktopAgnostic.VFS.VolumeMonitor? volume_monitor_get_default () throws GLib.Error;
	}
}
