import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-ipod',
    version='0.3',
    description='iPod devices support',
    long_description='iPod devices support',
    license='GPLv3',
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.conf', 'artwork/*.png']},
    entry_points="""\
    [elisa.core.components.resource_provider]
    IpodResource = elisa.plugins.ipod.ipod_resource:IpodResource
    """,
    controller_mappings=[('/poblesec/music/ipod',
                          'elisa.plugins.ipod.controller:ArtistsIpodListSwitcherController'),
                         ('/poblesec/music/ipod/albums',
                          'elisa.plugins.ipod.controller:AlbumsIpodListSwitcherController'),
                         ('/poblesec/music/ipod/tracks',
                          'elisa.plugins.ipod.controller:TracksIpodListSwitcherController'),],
    decorator_mappings=[('/poblesec/devices',
                         'elisa.plugins.ipod.controller:ipod_decorator')],
    cmdclass=cmdclass)
