/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2011 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GTH_IMAGE_H
#define GTH_IMAGE_H

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "gth-file-data.h"

G_BEGIN_DECLS

typedef enum {
	GTH_IMAGE_FORMAT_CAIRO_SURFACE,
	GTH_IMAGE_FORMAT_GDK_PIXBUF,
	GTH_IMAGE_FORMAT_GDK_PIXBUF_ANIMATION,
	GTH_IMAGE_N_FORMATS
} GthImageFormat;

#define GTH_TYPE_IMAGE            (gth_image_get_type ())
#define GTH_IMAGE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTH_TYPE_IMAGE, GthImage))
#define GTH_IMAGE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTH_TYPE_IMAGE, GthImageClass))
#define GTH_IS_IMAGE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTH_TYPE_IMAGE))
#define GTH_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTH_TYPE_IMAGE))
#define GTH_IMAGE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GTH_TYPE_IMAGE, GthImageClass))

typedef struct _GthImage         GthImage;
typedef struct _GthImageClass    GthImageClass;
typedef struct _GthImagePrivate  GthImagePrivate;

struct _GthImage
{
	GObject __parent;
	GthImagePrivate *priv;
};

struct _GthImageClass
{
	GObjectClass __parent_class;
};


typedef GthImage * (*GthImageLoaderFunc) (GthFileData   *file_data,
					  int            requested_size,
					  int           *original_width,
					  int           *original_height,
					  gpointer       user_data,
					  GCancellable  *cancellable,
					  GError       **error);


GType                 gth_image_get_type              (void);
GthImage *            gth_image_new                   (void);
GthImage *            gth_image_new_for_pixbuf        (GdkPixbuf          *value);
void                  gth_image_set_cairo_surface     (GthImage           *image,
						       cairo_surface_t    *value);
cairo_surface_t *     gth_image_get_cairo_surface     (GthImage           *image);
void                  gth_image_set_pixbuf            (GthImage           *image,
						       GdkPixbuf          *value);
GdkPixbuf *           gth_image_get_pixbuf            (GthImage           *image);
void                  gth_image_set_pixbuf_animation  (GthImage           *image,
						       GdkPixbufAnimation *value);
GdkPixbufAnimation *  gth_image_get_pixbuf_animation  (GthImage           *image);
gboolean              gth_image_is_animation          (GthImage           *image);

G_END_DECLS

#endif /* GTH_IMAGE_H */
