/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.plaf.ColorChooserUI;

public class JColorChooser
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 9168066781620640889L;
    private ColorSelectionModel selectionModel;
    private JComponent previewPanel;
    private AbstractColorChooserPanel[] chooserPanels;
    private boolean dragEnabled;
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String PREVIEW_PANEL_PROPERTY = "previewPanel";
    public static final String CHOOSER_PANELS_PROPERTY = "chooserPanels";
    protected AccessibleContext accessibleContext;

    public JColorChooser() {
        this(new DefaultColorSelectionModel());
    }

    public JColorChooser(Color color) {
        this(new DefaultColorSelectionModel(color));
    }

    public JColorChooser(ColorSelectionModel colorSelectionModel) {
        if (colorSelectionModel == null) {
            colorSelectionModel = new DefaultColorSelectionModel();
        }
        this.selectionModel = colorSelectionModel;
        this.updateUI();
    }

    public void setColor(Color color) {
        if (color != null) {
            this.selectionModel.setSelectedColor(color);
        }
    }

    public void setColor(int n, int n2, int n3) {
        this.selectionModel.setSelectedColor(new Color(n, n2, n3));
    }

    public void setColor(int n) {
        this.setColor(new Color(n, false));
    }

    public static Color showDialog(Component component, String string, Color color) {
        JColorChooser jColorChooser = new JColorChooser(color);
        JDialog jDialog = JColorChooser.createDialog(component, string, true, jColorChooser, null, null);
        jDialog.getContentPane().add(jColorChooser);
        jDialog.pack();
        jDialog.show();
        return jColorChooser.getColor();
    }

    static void makeModal(JDialog jDialog) {
        try {
            JDialog jDialog2 = jDialog;
            synchronized (jDialog2) {
                try {
                    while (jDialog.isVisible()) {
                        jDialog.wait();
                    }
                    Object var2_2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static Component findParent(Component component) {
        Container container = SwingUtilities.getAncestorOfClass(JColorChooser.class$("java.awt.Frame"), component);
        if (container != null) {
            return container;
        }
        container = SwingUtilities.getAncestorOfClass(JColorChooser.class$("java.awt.Dialog"), component);
        return container;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static JDialog createDialog(Component component, String string, boolean bl, JColorChooser jColorChooser, ActionListener actionListener, ActionListener actionListener2) {
        Component component2 = JColorChooser.findParent(component);
        if (component2 == null) {
            throw new AWTError("No suitable parent found for Component.");
        }
        JDialog jDialog = component2 instanceof Frame ? new JDialog((Frame)component2, string, true) : new JDialog((Dialog)component2, string, true);
        jDialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        DefaultOKCancelListener defaultOKCancelListener = new DefaultOKCancelListener(jDialog);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(actionListener);
        jButton.addActionListener(defaultOKCancelListener);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(actionListener2);
        jButton2.addActionListener(defaultOKCancelListener);
        JButton jButton3 = new JButton("Reset");
        jButton3.addActionListener(new DefaultResetListener(jColorChooser));
        jDialog.getContentPane().add((Component)jColorChooser, "North");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jDialog.getContentPane().add((Component)jPanel, "South");
        return jDialog;
    }

    public ColorChooserUI getUI() {
        return (ColorChooserUI)this.ui;
    }

    public void setUI(ColorChooserUI colorChooserUI) {
        super.setUI(colorChooserUI);
    }

    public void updateUI() {
        this.setUI((ColorChooserUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ColorChooserUI";
    }

    public Color getColor() {
        return this.selectionModel.getSelectedColor();
    }

    public void setPreviewPanel(JComponent jComponent) {
        if (jComponent != this.previewPanel) {
            JComponent jComponent2 = this.previewPanel;
            this.previewPanel = jComponent;
            this.firePropertyChange(PREVIEW_PANEL_PROPERTY, jComponent2, this.previewPanel);
        }
    }

    public JComponent getPreviewPanel() {
        return this.previewPanel;
    }

    public void addChooserPanel(AbstractColorChooserPanel abstractColorChooserPanel) {
        if (abstractColorChooserPanel == null) {
            return;
        }
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.chooserPanels;
        AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = new AbstractColorChooserPanel[abstractColorChooserPanelArray == null ? 1 : abstractColorChooserPanelArray.length + 1];
        if (abstractColorChooserPanelArray != null) {
            System.arraycopy(abstractColorChooserPanelArray, 0, abstractColorChooserPanelArray2, 0, abstractColorChooserPanelArray.length);
        }
        abstractColorChooserPanelArray2[abstractColorChooserPanelArray2.length - 1] = abstractColorChooserPanel;
        this.chooserPanels = abstractColorChooserPanelArray2;
        abstractColorChooserPanel.installChooserPanel(this);
        this.firePropertyChange(CHOOSER_PANELS_PROPERTY, abstractColorChooserPanelArray, abstractColorChooserPanelArray2);
    }

    public AbstractColorChooserPanel removeChooserPanel(AbstractColorChooserPanel abstractColorChooserPanel) {
        int n = -1;
        for (int i = 0; i < this.chooserPanels.length; ++i) {
            if (abstractColorChooserPanel != this.chooserPanels[i]) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return null;
        }
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.chooserPanels;
        if (this.chooserPanels.length == 1) {
            this.chooserPanels = null;
        } else {
            AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = new AbstractColorChooserPanel[this.chooserPanels.length - 1];
            System.arraycopy(this.chooserPanels, 0, abstractColorChooserPanelArray2, 0, n);
            System.arraycopy(this.chooserPanels, n, abstractColorChooserPanelArray2, n - 1, this.chooserPanels.length - n);
            this.chooserPanels = abstractColorChooserPanelArray2;
        }
        abstractColorChooserPanel.uninstallChooserPanel(this);
        this.firePropertyChange(CHOOSER_PANELS_PROPERTY, abstractColorChooserPanelArray, this.chooserPanels);
        return abstractColorChooserPanel;
    }

    public void setChooserPanels(AbstractColorChooserPanel[] abstractColorChooserPanelArray) {
        if (abstractColorChooserPanelArray != this.chooserPanels) {
            if (this.chooserPanels != null) {
                for (int i = 0; i < this.chooserPanels.length; ++i) {
                    if (this.chooserPanels[i] == null) continue;
                    this.chooserPanels[i].uninstallChooserPanel(this);
                }
            }
            AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = this.chooserPanels;
            this.chooserPanels = abstractColorChooserPanelArray;
            if (abstractColorChooserPanelArray != null) {
                for (int i = 0; i < abstractColorChooserPanelArray.length; ++i) {
                    if (abstractColorChooserPanelArray[i] == null) continue;
                    abstractColorChooserPanelArray[i].installChooserPanel(this);
                }
            }
            this.firePropertyChange(CHOOSER_PANELS_PROPERTY, abstractColorChooserPanelArray2, this.chooserPanels);
        }
    }

    public AbstractColorChooserPanel[] getChooserPanels() {
        return this.chooserPanels;
    }

    public ColorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ColorSelectionModel colorSelectionModel) {
        if (colorSelectionModel == null) {
            throw new AWTError("ColorSelectionModel is not allowed to be null.");
        }
        this.selectionModel = colorSelectionModel;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    protected String paramString() {
        return "JColorChooser";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJColorChooser(this);
        }
        return this.accessibleContext;
    }

    static class DefaultResetListener
    implements ActionListener {
        private JColorChooser chooser;
        private Color init;

        public DefaultResetListener(JColorChooser jColorChooser) {
            this.chooser = jColorChooser;
            this.init = jColorChooser.getColor();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.setColor(this.init);
        }
    }

    static class DefaultOKCancelListener
    implements ActionListener {
        private JDialog dialog;

        public DefaultOKCancelListener(JDialog jDialog) {
            this.dialog = jDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.hide();
        }
    }

    protected class AccessibleJColorChooser
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JColorChooser this$0;
        private static final long serialVersionUID = -2038297864782299082L;

        protected AccessibleJColorChooser(JColorChooser jColorChooser) {
            this.this$0 = jColorChooser;
            super(jColorChooser);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }
    }
}

