/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;

public final class JobAttributes
implements Cloneable {
    private int copies;
    private DefaultSelectionType selection;
    private DestinationType destination;
    private DialogType dialog;
    private String filename;
    private int maxPage;
    private int minPage;
    private MultipleDocumentHandlingType multiple;
    private int[][] pageRanges;
    private int fromPage;
    private int toPage;
    private String printer;
    private SidesType sides;

    public JobAttributes() {
        this.copies = 1;
        this.selection = DefaultSelectionType.ALL;
        this.destination = DestinationType.PRINTER;
        this.dialog = DialogType.NATIVE;
        this.maxPage = Integer.MAX_VALUE;
        this.minPage = 1;
        this.multiple = MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES;
        this.sides = SidesType.ONE_SIDED;
    }

    public JobAttributes(JobAttributes jobAttributes) {
        this.set(jobAttributes);
    }

    public JobAttributes(int n, DefaultSelectionType defaultSelectionType, DestinationType destinationType, DialogType dialogType, String string, int n2, int n3, MultipleDocumentHandlingType multipleDocumentHandlingType, int[][] nArray, String string2, SidesType sidesType) {
        if (n <= 0 || defaultSelectionType == null || destinationType == null || dialogType == null || n2 < n3 || n3 <= 0 || multipleDocumentHandlingType == null || sidesType == null) {
            throw new IllegalArgumentException();
        }
        this.copies = n;
        this.selection = defaultSelectionType;
        this.destination = destinationType;
        this.dialog = dialogType;
        this.filename = string;
        this.maxPage = n2;
        this.minPage = n3;
        this.multiple = multipleDocumentHandlingType;
        this.setPageRanges(nArray);
        this.printer = string2;
        this.sides = sidesType;
    }

    public Object clone() {
        return new JobAttributes(this);
    }

    public void set(JobAttributes jobAttributes) {
        this.copies = jobAttributes.copies;
        this.selection = jobAttributes.selection;
        this.destination = jobAttributes.destination;
        this.dialog = jobAttributes.dialog;
        this.filename = jobAttributes.filename;
        this.maxPage = jobAttributes.maxPage;
        this.minPage = jobAttributes.minPage;
        this.multiple = jobAttributes.multiple;
        this.pageRanges = (int[][])jobAttributes.pageRanges.clone();
        this.printer = jobAttributes.printer;
        this.sides = jobAttributes.sides;
        this.fromPage = jobAttributes.fromPage;
        this.toPage = jobAttributes.toPage;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.copies = n;
    }

    public void setCopiesToDefault() {
        this.copies = 1;
    }

    public DefaultSelectionType getDefaultSelection() {
        return this.selection;
    }

    public void setDefaultSelection(DefaultSelectionType defaultSelectionType) {
        if (defaultSelectionType == null) {
            throw new IllegalArgumentException();
        }
        this.selection = defaultSelectionType;
    }

    public DestinationType getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationType destinationType) {
        if (destinationType == null) {
            throw new IllegalArgumentException();
        }
        this.destination = destinationType;
    }

    public DialogType getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogType dialogType) {
        if (dialogType == null) {
            throw new IllegalArgumentException();
        }
        this.dialog = dialogType;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public int getFromPage() {
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.pageRanges != null) {
            return this.pageRanges[0][0];
        }
        if (this.toPage != 0) {
            return this.toPage;
        }
        return this.minPage;
    }

    public void setFromPage(int n) {
        if (n < this.minPage || n > this.toPage && this.toPage != 0 || n > this.maxPage) {
            throw new IllegalArgumentException();
        }
        if (this.pageRanges == null) {
            this.fromPage = n;
        }
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int n) {
        if (n < this.minPage) {
            throw new IllegalArgumentException();
        }
        this.maxPage = n;
        if (n < this.fromPage) {
            this.fromPage = n;
        }
        if (n < this.toPage) {
            this.toPage = n;
        }
        if (this.pageRanges != null) {
            int n2;
            for (n2 = this.pageRanges.length - 1; n2 >= 0 && n < this.pageRanges[n2][1]; --n2) {
            }
            if (n >= this.pageRanges[++n2][0]) {
                this.pageRanges[n2++][1] = n;
            }
            if (n2 == 0) {
                this.pageRanges = null;
            } else if (n2 < this.pageRanges.length) {
                int[][] nArrayArray = new int[n2][];
                System.arraycopy(this.pageRanges, 0, nArrayArray, 0, n2);
                this.pageRanges = nArrayArray;
            }
        }
    }

    public int getMinPage() {
        return this.minPage;
    }

    public void setMinPage(int n) {
        if (n <= 0 || n > this.maxPage) {
            throw new IllegalArgumentException();
        }
        this.minPage = n;
        if (n > this.toPage) {
            this.toPage = n;
        }
        if (n > this.fromPage) {
            this.fromPage = n;
        }
        if (this.pageRanges != null) {
            int n2;
            int n3 = this.pageRanges.length;
            for (n2 = 0; n2 < n3 && n > this.pageRanges[n2][0]; ++n2) {
            }
            if (n <= this.pageRanges[n2 - 1][1]) {
                this.pageRanges[--n2][0] = n;
            }
            if (n2 == n3) {
                this.pageRanges = null;
            } else if (n2 > 0) {
                int[][] nArrayArray = new int[n3 - n2][];
                System.arraycopy(this.pageRanges, n2, nArrayArray, 0, n3 - n2);
                this.pageRanges = nArrayArray;
            }
        }
    }

    public MultipleDocumentHandlingType getMultipleDocumentHandling() {
        return this.multiple;
    }

    public void setMultipleDocumentHandling(MultipleDocumentHandlingType multipleDocumentHandlingType) {
        if (multipleDocumentHandlingType == null) {
            throw new IllegalArgumentException();
        }
        this.multiple = multipleDocumentHandlingType;
    }

    public void setMultipleDocumentHandlingToDefault() {
        this.multiple = MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES;
    }

    public int[][] getPageRanges() {
        if (this.pageRanges == null) {
            return new int[][]{{this.getFromPage(), this.getToPage()}};
        }
        int n = this.pageRanges.length;
        int[][] nArrayArray = new int[n][];
        while (--n >= 0) {
            nArrayArray[n] = (int[])this.pageRanges[n].clone();
        }
        return nArrayArray;
    }

    public void setPageRanges(int[][] nArray) {
        int n;
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        while (--n >= 0) {
            int[] nArray2 = nArray[n];
            if (nArray2 != null && nArray2.length == 2 && nArray2[0] >= this.minPage && nArray2[1] >= nArray2[0] && nArray2[1] <= this.maxPage && (n == 0 || nArray2[0] > nArray[n - 1][1])) continue;
            throw new IllegalArgumentException();
        }
        n = nArray.length;
        if (this.fromPage > 0 && nArray[0][0] > this.fromPage) {
            this.fromPage = nArray[0][0];
        }
        if (this.toPage > 0 && nArray[n - 1][1] < this.toPage) {
            this.toPage = nArray[n - 1][1];
        }
        this.pageRanges = new int[n][];
        while (--n >= 0) {
            this.pageRanges[n] = (int[])nArray[n].clone();
        }
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String string) {
        this.printer = string;
    }

    public SidesType getSides() {
        return this.sides;
    }

    public void setSides(SidesType sidesType) {
        if (sidesType == null) {
            throw new IllegalArgumentException();
        }
        this.sides = sidesType;
    }

    public void setSidesToDefault() {
        this.sides = SidesType.ONE_SIDED;
    }

    public int getToPage() {
        if (this.toPage != 0) {
            return this.toPage;
        }
        if (this.pageRanges != null) {
            return this.pageRanges[this.pageRanges.length - 1][1];
        }
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        return this.maxPage;
    }

    public void setToPage(int n) {
        if (n < this.minPage || this.fromPage > n && this.fromPage != 0 || n > this.maxPage) {
            throw new IllegalArgumentException();
        }
        if (this.pageRanges == null) {
            this.toPage = n;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JobAttributes)) {
            return false;
        }
        JobAttributes jobAttributes = (JobAttributes)object;
        if (this.copies != jobAttributes.copies || this.selection != jobAttributes.selection || this.destination != jobAttributes.destination || this.dialog != jobAttributes.dialog || !this.filename.equals(jobAttributes.filename) || this.maxPage != jobAttributes.maxPage || this.minPage != jobAttributes.minPage || this.multiple != jobAttributes.multiple || this.fromPage != jobAttributes.fromPage || this.toPage != jobAttributes.toPage || !this.printer.equals(jobAttributes.printer) || this.sides != jobAttributes.sides || this.pageRanges == null != (jobAttributes.pageRanges == null)) {
            return false;
        }
        if (this.pageRanges != jobAttributes.pageRanges) {
            int n = this.pageRanges.length;
            while (--n >= 0) {
                if (this.pageRanges[n][0] == jobAttributes.pageRanges[n][0] && this.pageRanges[n][1] == jobAttributes.pageRanges[n][1]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.selection.value << 6 ^ this.destination.value << 5 ^ this.dialog.value << 3 ^ this.multiple.value << 2 ^ this.sides.value ^ (this.filename == null ? 0 : this.filename.hashCode()) ^ (this.printer == null ? 0 : this.printer.hashCode());
        n ^= this.copies << 27 ^ this.maxPage << 22 ^ this.minPage << 17;
        if (this.pageRanges == null) {
            n ^= this.getFromPage() << 13 ^ this.getToPage() << 8;
        } else {
            int n2 = this.pageRanges.length;
            while (--n2 >= 0) {
                n ^= this.pageRanges[n2][0] << 13 ^ this.pageRanges[n2][1] << 8;
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("copies=").append(this.copies).append(",defaultSelection=").append(this.selection).append(",destination=").append(this.destination).append(",dialog=").append(this.dialog).append(",fileName=").append(this.filename).append(",fromPage=").append(this.getFromPage()).append(",maxPage=").append(this.maxPage).append(",minPage=").append(this.minPage).append(",multiple-document-handling=").append(this.multiple).append(",page-ranges=[");
        if (this.pageRanges == null) {
            stringBuffer.append(this.minPage).append(':').append(this.minPage).append(']');
        } else {
            for (int i = 0; i < this.pageRanges.length; ++i) {
                stringBuffer.append(this.pageRanges[i][0]).append(':').append(this.pageRanges[i][1]).append(',');
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.append("],printer=").append(this.printer).append(",sides=").append(this.sides).append(",toPage=").append(this.getToPage()).toString();
    }

    public static final class SidesType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"one-sided", "two-sided-long-edge", "two-sided-short-edge"};
        public static final SidesType ONE_SIDED = new SidesType(0);
        public static final SidesType TWO_SIDED_LONG_EDGE = new SidesType(1);
        public static final SidesType TWO_SIDED_SHORT_EDGE = new SidesType(2);

        SidesType(int n) {
            super(n, NAMES);
        }
    }

    public static final class MultipleDocumentHandlingType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"separate-documents-collated-copies", "separate-documents-uncollated-copies"};
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_COLLATED_COPIES = new MultipleDocumentHandlingType(0);
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = new MultipleDocumentHandlingType(1);

        MultipleDocumentHandlingType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DialogType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"common", "native", "none"};
        public static final DialogType COMMON = new DialogType(0);
        public static final DialogType NATIVE = new DialogType(1);
        public static final DialogType NONE = new DialogType(2);

        DialogType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DestinationType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"file", "printer"};
        public static final DestinationType FILE = new DestinationType(0);
        public static final DestinationType PRINTER = new DestinationType(1);

        DestinationType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DefaultSelectionType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"all", "range", "selection"};
        public static final DefaultSelectionType ALL = new DefaultSelectionType(0);
        public static final DefaultSelectionType RANGE = new DefaultSelectionType(1);
        public static final DefaultSelectionType SELECTION = new DefaultSelectionType(2);

        DefaultSelectionType(int n) {
            super(n, NAMES);
        }
    }
}

