/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public final class SegmentInfos
extends Vector {
    public static final int FORMAT = -1;
    public static final int FORMAT_LOCKLESS = -2;
    public static final int FORMAT_SINGLE_NORM_FILE = -3;
    public int counter = 0;
    private long version = System.currentTimeMillis();
    private long generation = 0L;
    private long lastGeneration = 0L;
    private static PrintStream infoStream;
    private static int defaultGenFileRetryCount;
    private static int defaultGenFileRetryPauseMsec;
    private static int defaultGenLookaheadCount;

    public final SegmentInfo info(int i) {
        return (SegmentInfo)this.elementAt(i);
    }

    public static long getCurrentSegmentGeneration(String[] files) {
        if (files == null) {
            return -1L;
        }
        long max = -1L;
        int prefixLen = "segments".length() + 1;
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (!file.startsWith("segments") || file.equals("segments.gen")) continue;
            if (file.equals("segments")) {
                if (max != -1L) continue;
                max = 0L;
                continue;
            }
            long v = Long.parseLong(file.substring(prefixLen), 36);
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public static long getCurrentSegmentGeneration(Directory directory) throws IOException {
        String[] files = directory.list();
        if (files == null) {
            throw new IOException("Cannot read directory " + directory);
        }
        return SegmentInfos.getCurrentSegmentGeneration(files);
    }

    public static String getCurrentSegmentFileName(String[] files) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getCurrentSegmentGeneration(files));
    }

    public static String getCurrentSegmentFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getCurrentSegmentGeneration(directory));
    }

    public String getCurrentSegmentFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public String getNextSegmentFileName() {
        long nextGeneration = this.generation == -1L ? 1L : this.generation + 1L;
        return IndexFileNames.fileNameFromGeneration("segments", "", nextGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(Directory directory, String segmentFileName) throws IOException {
        boolean success = false;
        IndexInput input = directory.openInput(segmentFileName);
        this.generation = segmentFileName.equals("segments") ? 0L : Long.parseLong(segmentFileName.substring(1 + "segments".length()), 36);
        this.lastGeneration = this.generation;
        try {
            int format = input.readInt();
            if (format < 0) {
                if (format < -3) {
                    throw new IOException("Unknown format version: " + format);
                }
                this.version = input.readLong();
                this.counter = input.readInt();
            } else {
                this.counter = format;
            }
            for (int i = input.readInt(); i > 0; --i) {
                this.addElement(new SegmentInfo(directory, format, input));
            }
            if (format >= 0) {
                this.version = input.getFilePointer() >= input.length() ? System.currentTimeMillis() : input.readLong();
            }
            success = true;
        }
        finally {
            input.close();
            if (!success) {
                this.clear();
            }
        }
    }

    public final void read(Directory directory) throws IOException {
        this.lastGeneration = -1L;
        this.generation = -1L;
        new FindSegmentsFile(directory){

            public Object doBody(String segmentFileName) throws IOException {
                SegmentInfos.this.read(this.directory, segmentFileName);
                return null;
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Directory directory) throws IOException {
        String segmentFileName = this.getNextSegmentFileName();
        this.generation = this.generation == -1L ? 1L : ++this.generation;
        IndexOutput output = directory.createOutput(segmentFileName);
        try {
            output.writeInt(-3);
            output.writeLong(++this.version);
            output.writeInt(this.counter);
            output.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.info(i).write(output);
            }
        }
        finally {
            output.close();
        }
        try {
            output = directory.createOutput("segments.gen");
            try {
                output.writeInt(-2);
                output.writeLong(this.generation);
                output.writeLong(this.generation);
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.lastGeneration = this.generation;
    }

    public Object clone() {
        SegmentInfos sis = (SegmentInfos)super.clone();
        for (int i = 0; i < sis.size(); ++i) {
            sis.setElementAt(((SegmentInfo)sis.elementAt(i)).clone(), i);
        }
        return sis;
    }

    public long getVersion() {
        return this.version;
    }

    public static long readCurrentVersion(Directory directory) throws IOException {
        return (Long)new FindSegmentsFile(directory){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doBody(String segmentFileName) throws IOException {
                IndexInput input = this.directory.openInput(segmentFileName);
                int format = 0;
                long version = 0L;
                try {
                    format = input.readInt();
                    if (format < 0) {
                        if (format < -3) {
                            throw new IOException("Unknown format version: " + format);
                        }
                        version = input.readLong();
                    }
                }
                finally {
                    input.close();
                }
                if (format < 0) {
                    return new Long(version);
                }
                SegmentInfos sis = new SegmentInfos();
                sis.read(this.directory, segmentFileName);
                return new Long(sis.getVersion());
            }
        }.run();
    }

    public static void setInfoStream(PrintStream infoStream) {
        SegmentInfos.infoStream = infoStream;
    }

    public static void setDefaultGenFileRetryCount(int count) {
        defaultGenFileRetryCount = count;
    }

    public static int getDefaultGenFileRetryCount() {
        return defaultGenFileRetryCount;
    }

    public static void setDefaultGenFileRetryPauseMsec(int msec) {
        defaultGenFileRetryPauseMsec = msec;
    }

    public static int getDefaultGenFileRetryPauseMsec() {
        return defaultGenFileRetryPauseMsec;
    }

    public static void setDefaultGenLookaheadCount(int count) {
        defaultGenLookaheadCount = count;
    }

    public static int getDefaultGenLookahedCount() {
        return defaultGenLookaheadCount;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String message) {
        if (infoStream != null) {
            infoStream.println(Thread.currentThread().getName() + ": " + message);
        }
    }

    static {
        defaultGenFileRetryCount = 10;
        defaultGenFileRetryPauseMsec = 50;
        defaultGenLookaheadCount = 10;
    }

    public static abstract class FindSegmentsFile {
        File fileDirectory;
        Directory directory;

        public FindSegmentsFile(File directory) {
            this.fileDirectory = directory;
        }

        public FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws IOException {
            String segmentFileName = null;
            long lastGen = -1L;
            long gen = 0L;
            int genLookaheadCount = 0;
            IOException exc = null;
            boolean retry = false;
            int method = 0;
            while (true) {
                String[] files = null;
                if (0 == method && (gen = SegmentInfos.getCurrentSegmentGeneration(files = this.directory != null ? this.directory.list() : this.fileDirectory.list())) == -1L) {
                    String s = "";
                    for (int i = 0; i < files.length; ++i) {
                        s = s + " " + files[i];
                    }
                    throw new FileNotFoundException("no segments* file found: files:" + s);
                }
                if (1 == method || 0 == method && lastGen == gen && retry) {
                    method = 1;
                    for (int i = 0; i < defaultGenFileRetryCount; ++i) {
                        IndexInput genInput = null;
                        try {
                            genInput = this.directory.openInput("segments.gen");
                        }
                        catch (IOException e) {
                            SegmentInfos.message("segments.gen open: IOException " + e);
                        }
                        if (genInput != null) {
                            try {
                                int version = genInput.readInt();
                                if (version == -2) {
                                    long gen0 = genInput.readLong();
                                    long gen1 = genInput.readLong();
                                    SegmentInfos.message("fallback check: " + gen0 + "; " + gen1);
                                    if (gen0 == gen1) {
                                        if (gen0 <= gen) break;
                                        SegmentInfos.message("fallback to 'segments.gen' check: now try generation " + gen0 + " > " + gen);
                                        gen = gen0;
                                        break;
                                    }
                                }
                            }
                            catch (IOException err2) {
                            }
                            finally {
                                genInput.close();
                            }
                        }
                        try {
                            Thread.sleep(defaultGenFileRetryPauseMsec);
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                if (2 == method || 1 == method && lastGen == gen && retry) {
                    method = 2;
                    if (genLookaheadCount < defaultGenLookaheadCount) {
                        ++genLookaheadCount;
                        SegmentInfos.message("look ahead increment gen to " + ++gen);
                    }
                }
                if (lastGen == gen) {
                    if (retry) {
                        throw exc;
                    }
                    retry = true;
                } else {
                    retry = false;
                }
                lastGen = gen;
                segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen);
                try {
                    Object v = this.doBody(segmentFileName);
                    if (exc != null) {
                        SegmentInfos.message("success on " + segmentFileName);
                    }
                    return v;
                }
                catch (IOException err) {
                    String prevSegmentFileName;
                    if (exc == null) {
                        exc = err;
                    }
                    SegmentInfos.message("primary Exception on '" + segmentFileName + "': " + err + "'; will retry: retry=" + retry + "; gen = " + gen);
                    if (retry || gen <= 1L || !this.directory.fileExists(prevSegmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen - 1L))) continue;
                    SegmentInfos.message("fallback to prior segment file '" + prevSegmentFileName + "'");
                    try {
                        Object v = this.doBody(prevSegmentFileName);
                        if (exc != null) {
                            SegmentInfos.message("success on fallback " + prevSegmentFileName);
                        }
                        return v;
                    }
                    catch (IOException err2) {
                        SegmentInfos.message("secondary Exception on '" + prevSegmentFileName + "': " + err2 + "'; will retry");
                        continue;
                    }
                }
                break;
            }
        }

        protected abstract Object doBody(String var1) throws IOException;
    }
}

