/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import msfgui.MsfException;
import msfgui.MsfFrame;
import msfgui.MsfguiApp;
import msfgui.RpcConnection;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class SearchWindow
extends MsfFrame {
    public List modules;
    private RpcConnection rpcConn;
    protected DefaultListModel mod;
    private JRadioButton auxiliaryRadioButton;
    private JRadioButton descriptionRadioButton;
    private ButtonGroup detailGroup;
    private JRadioButton exploitsRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JButton launchButton;
    private JRadioButton payloadsRadioButton;
    private JRadioButton referenceRadioButton;
    private JList resultList;
    private JComboBox searchBox;
    private JButton searchButton;
    private JTextField searchField;
    private ButtonGroup typeGroup;

    public SearchWindow(RpcConnection rpcConn) {
        super("Module search window");
        this.rpcConn = rpcConn;
        this.initComponents();
        this.modules = new ArrayList(600);
        this.mod = new DefaultListModel();
        this.resultList.setModel(this.mod);
        this.searchBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                String typed = SearchWindow.this.searchBox.getEditor().getItem().toString();
                if (evt.getKeyCode() == 10) {
                    SearchWindow.this.doAction(typed);
                    return;
                }
                if (evt.getKeyChar() == '\uffff' || typed.equals(SearchWindow.this.searchBox.getItemAt(0).toString())) {
                    return;
                }
                SearchWindow.this.searchBox.hidePopup();
                SearchWindow.this.searchBox.showPopup();
                SearchWindow.this.searchBox.removeAllItems();
                SearchWindow.this.searchBox.addItem(typed);
                for (int i = 0; i < SearchWindow.this.modules.size(); ++i) {
                    if (!((Object[])SearchWindow.this.modules.get(i))[1].toString().contains(typed)) continue;
                    SearchWindow.this.searchBox.addItem(((Object[])SearchWindow.this.modules.get(i))[1]);
                }
                ((JTextField)SearchWindow.this.searchBox.getEditor().getEditorComponent()).select(typed.length(), typed.length());
            }
        });
    }

    private boolean doAction(String typed) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Object[] info = (Object[])this.modules.get(i);
            if (!info[1].toString().equals(typed)) continue;
            ((ActionListener)info[2]).actionPerformed(null);
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.typeGroup = new ButtonGroup();
        this.detailGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.exploitsRadioButton = new JRadioButton();
        this.auxiliaryRadioButton = new JRadioButton();
        this.payloadsRadioButton = new JRadioButton();
        this.searchBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.descriptionRadioButton = new JRadioButton();
        this.referenceRadioButton = new JRadioButton();
        this.searchField = new JTextField();
        this.searchButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.resultList = new JList();
        this.launchButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(SearchWindow.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.typeGroup.add(this.exploitsRadioButton);
        this.exploitsRadioButton.setSelected(true);
        this.exploitsRadioButton.setText(resourceMap.getString("exploitsRadioButton.text", new Object[0]));
        this.exploitsRadioButton.setActionCommand(resourceMap.getString("exploitsRadioButton.actionCommand", new Object[0]));
        this.exploitsRadioButton.setName("exploitsRadioButton");
        this.typeGroup.add(this.auxiliaryRadioButton);
        this.auxiliaryRadioButton.setText(resourceMap.getString("auxiliaryRadioButton.text", new Object[0]));
        this.auxiliaryRadioButton.setActionCommand(resourceMap.getString("auxiliaryRadioButton.actionCommand", new Object[0]));
        this.auxiliaryRadioButton.setName("auxiliaryRadioButton");
        this.typeGroup.add(this.payloadsRadioButton);
        this.payloadsRadioButton.setText(resourceMap.getString("payloadsRadioButton.text", new Object[0]));
        this.payloadsRadioButton.setActionCommand(resourceMap.getString("payloadsRadioButton.actionCommand", new Object[0]));
        this.payloadsRadioButton.setName("payloadsRadioButton");
        this.searchBox.setEditable(true);
        this.searchBox.setModel(new DefaultComboBoxModel<String>(new String[]{"type name here"}));
        this.searchBox.setName("searchBox");
        this.searchBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.searchBoxActionPerformed(evt);
            }
        });
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.detailGroup.add(this.descriptionRadioButton);
        this.descriptionRadioButton.setSelected(true);
        this.descriptionRadioButton.setText(resourceMap.getString("descriptionRadioButton.text", new Object[0]));
        this.descriptionRadioButton.setActionCommand(resourceMap.getString("descriptionRadioButton.actionCommand", new Object[0]));
        this.descriptionRadioButton.setName("descriptionRadioButton");
        this.detailGroup.add(this.referenceRadioButton);
        this.referenceRadioButton.setText(resourceMap.getString("referenceRadioButton.text", new Object[0]));
        this.referenceRadioButton.setActionCommand(resourceMap.getString("referenceRadioButton.actionCommand", new Object[0]));
        this.referenceRadioButton.setName("referenceRadioButton");
        this.searchField.setText(resourceMap.getString("searchField.text", new Object[0]));
        this.searchField.setName("searchField");
        this.searchButton.setText(resourceMap.getString("searchButton.text", new Object[0]));
        this.searchButton.setName("searchButton");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.searchButtonActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.resultList.setName("resultList");
        this.jScrollPane1.setViewportView(this.resultList);
        this.launchButton.setText(resourceMap.getString("launchButton.text", new Object[0]));
        this.launchButton.setName("launchButton");
        this.launchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.launchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 578, Short.MAX_VALUE).addComponent(this.searchField, GroupLayout.Alignment.LEADING, -1, 578, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -2, -1, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchBox, 0, 501, Short.MAX_VALUE)).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.exploitsRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.auxiliaryRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.payloadsRadioButton)).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.descriptionRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceRadioButton)).addComponent(this.searchButton).addComponent(this.launchButton)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.searchBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exploitsRadioButton).addComponent(this.auxiliaryRadioButton).addComponent(this.payloadsRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.descriptionRadioButton).addComponent(this.referenceRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 133, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.launchButton).addContainerGap()));
        this.pack();
    }

    private void searchBoxActionPerformed(ActionEvent evt) {
        if (((long)evt.getModifiers() & 0x10L) != 0L) {
            String typed = this.searchBox.getEditor().getItem().toString();
            this.doAction(typed);
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.mod.removeAllElements();
        String type = this.typeGroup.getSelection().getActionCommand();
        String detail = this.detailGroup.getSelection().getActionCommand();
        String toSearch = this.searchField.getText().toLowerCase();
        block2: for (Object module : this.modules) {
            Object[] modInfo = (Object[])module;
            if (!modInfo[0].equals(type)) continue;
            try {
                Map info = (Map)this.rpcConn.execute("module.info", modInfo[0], modInfo[1]);
                if (detail.equals("reference")) {
                    Object references = info.get("references");
                    if (references == null) continue;
                    Object[] refArray = (Object[])references;
                    for (int i = 0; i < refArray.length; ++i) {
                        Object[] ref = (Object[])refArray[i];
                        if (!ref[1].toString().toLowerCase().contains(toSearch) && !(ref[0].toString().toLowerCase() + "-" + ref[1]).contains(toSearch)) continue;
                        this.mod.addElement(modInfo[1]);
                        continue block2;
                    }
                    continue;
                }
                if (!info.get("name").toString().toLowerCase().contains(toSearch) && !info.get("description").toString().toLowerCase().contains(toSearch)) continue;
                this.mod.addElement(modInfo[1]);
            }
            catch (MsfException ex) {
                JOptionPane.showMessageDialog(this.rootPane, ex);
            }
        }
    }

    private void launchButtonActionPerformed(ActionEvent evt) {
        String type = this.typeGroup.getSelection().getActionCommand();
        String name = this.resultList.getSelectedValue().toString();
        for (Object module : this.modules) {
            Object[] modInfo = (Object[])module;
            if (!modInfo[0].equals(type) || !modInfo[1].equals(name)) continue;
            ((ActionListener)modInfo[2]).actionPerformed(null);
        }
    }
}

