<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Site search bar" => "Barra de busca do sitio",
"Site logo source" => "Orixe do logo do sitio",
"Site ads and banners" => "Publicidade e pancartas do sitio",
"Site Menu" => "Menú do sitio",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Nota: esta característica tamén require que se active phplayers en Administrar->Características",
"HTML in Wiki Pages" => "HTML en páxinas wiki",
"Wiki syntax used when a page contains HTML" => "Sintaxe wiki usada cando unha páxina contén HTML",
"full" => "completa",
"partial" => "parcial",
"Wiki attachments preferences" => "Preferencias de ficheiros asociados a Wiki",
"participants" => "participantes",
"subscription" => "subscrición",
"perso" => "perso",
"admin categories tpl" => "Modelo de administrar categorías",
"use in events" => "usar en eventos",
"admin External Wikis" => "Administrar wikis externos",
"admin Html Pages" => "Administrar páxinas Html",
"admin Html Pages template" => "Modelo de administrar páxinas Html",
"send newsletter" => "enviar boletín",
"Edit fields for tracker" => "Editar campos para tracker",
"The tracker needs a text field named Subject" => "O tracker precisa un campo de texto chamado \"Subject\"",
"assign permissions" => "asignar permisos",
"assign to groups" => "asignar a grupos",
"Batch upload (CSV file<a {popup text='login,password,email'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Carga en lote (ficheiro CSV <a {popup text='login,password,email'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
"remove file extension from image name" => "borre a extensión do ficheiro do nome da imaxe",
"convert sub directories to sub galleries" => "converter subdirectorios en subgalerías",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "exemplo de \"misc/screenshots/digicam0001.jpg\" crearase unha galería chamada screenshots",
"use sub directory names as description" => "use nomes de subdirectorios como descrición",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "exemplo de \"misc/screenshots/digicam0001.jpg\" crearase unha descrición misc/screenshots",
"admin the category system" => "administrar o sistema de categorías",
"list galleries" => "listar galerías",
"slideshow_p" => "slideshow_p",
"slideshow backward" => "pase diapositivas atrás",
"slideshow_n" => "slideshow_n",
"slideshow forward" => "pase diapositivas adiante",
"add item" => "agregar ítem",
"list view" => "visualizar lista",
"Format: mm/dd/yyyy hh:mm<br />..." => "Formato: mm/dd/yyyy hh:mm<br />...",
"See strtotime php function" => "Ver función php strtotime",
"Format: mm/dd/yyy hh:mm<br />..." => "Formato: mm/dd/yyy hh:mm<br />...",
"Subscription List" => "Listaxe de subscricións",
"save_to" => "gardar en",
"add a category" => "agregar categoría",
"Creates a link to the named file. If page is not given, the file must be attached to the current page. If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Crea unha ligazón ao ficheiro nomeado. Se non se dá a páxina(atributo \"page\"), o ficheiro debe estar anexo á páxina actual. Se non se dá \"desc\" (descrición), o nome de ficheiro é usado para o texto da ligazón, a menos que \"showdesc\" sexa usado, o que fai que se use a descrición do ficheiro como texto da ligazón. Se se dá image=1, o anexo é tomado como unha imaxe e despregado directamente na páxina, non se xera ligazón.",
"Project Object Created Successfully" => "Obxecto de proxecto creado con éxito",
"Project Name:" => "Nome de proxecto:",
"Project Description:" => "Descrición do proxecto:",
"Project Active" => "Proxecto activo",
"Current Objects:" => "Obxectos actuais:",
"Add a File Gallery" => "Engadir unha galería de ficheiros",
"Project Admin" => "Administrador do proxecto",
"Project Members" => "Membros do proxecto",
"Not Set" => "Non configurado",
"rebuild cache" => "reconstruír caché",
"monitor this gallery" => "monitorizar esta galería",
"stop monitoring this gallery" => "deixar de monitorizar esta galería",
"Number Members" => "Número de membros",
"Number Admins" => "Número de Admins",
"No projects found" => "Non se atoparon proxectos",
"install" => "instalar",
"Project Created:" => "Proxecto creado:",
"Project Info" => "Proxecto Info",
"Project Admins:" => "Administradores do proxecto:",
"Project Members:" => "Membros do proxecto:",
"Edit Project" => "Editar proxecto",
"Add Blog" => "Engadir blog",
"Add Articles" => "Engadir artigos",
"Add Calendar" => "Engadir calendario",
"Add FAQ" => "Engadir PMF",
"Add File Gallery" => "Engadir galería de ficheiros",
"Add Forum" => "Engadir foro",
"Add Image Gallery" => "Engadir galería de imaxes",
"Add Newsletter" => "Engadir boletín",
"Add URL" => "Engadir URL",
"Project Registration" => "Rexistro de proxecto",
"Your project was successfully submitted.  It may be subject\nto approval. Once available, you can create/link your project objects\nto your project page." => "O seu proxecto foi enviado con éxito. Pode ser suxeito a aprobación.\n Unha vez dispoñible, pode crear/ligar os seus obxectos de proxecto\na súa páxina de proxecto.",
"List all projects" => "Listar todos os proxectos",
"Take care when you register your project, the project name\ncannot be changed afterwards. Please also provide an accurate \nproject description. If you havent worked out these details please\ndo so before your register the project." => "Teña coidado cando rexistre o seu proxecto: o nome do proxecto\n non se pode cambiar despois. Por favor, provea tamén unha descrición\n axustada. Se non ten traballados estes detalles, por favor fágao antes de rexistrar o proxecto",
"Please choose your project categories carefully. You can\nhowever change this later on your project admin panel." => "Por favor, elixa as categorías do seu proxecto con coidado. De todos modos\n pode cambiar isto máis tarde no seu panel de administración do proxecto.",
"All project names are converted to lowercase." => "Todos os nomes de proxecto son convertidos a minúsculas.",
"wiki pages" => "páxinas do wiki",
"first" => "primeiro",
"admin mode" => "modo administrador",
"trash" => "papeleira",
"empty trash" => "baleirar papeleira",
"remove from trash" => "sacar da papeleira",
"use start date and time" => "usar data e hora de inicio",
"use end date and time" => "usar data e hora de fin",
"reload" => "recargar",
"Not rated yet" => "Non cualificado aínda",
"Jukebox preference" => "Preferencias da gramola",
"This is not a Tikiwiki File. Check if this file was uploaded and if it is dangerous." => "Este non é un ficheiro de Tikiwiki. Comprobe se este ficheiro foi cargado e se é perigoso.",
"This file is modified." => "Este ficheiro foi modificado.",
"Removed %s from group %s" => "Borrado %s de grupo %s",
"The passwords didn't match" => "Os contrasinais non coinciden",
"Invalid username or activation code" => "Nome de usuario ou código de activacion incorrectos",
"Tiki RSS feed for the tracker: " => "Fonte RSS de Tiki para o tracker: ",
"Error: No" => "Erro: Non",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"post" => "publicar",
"HomeworkMenu" => "Menú de deberes ",
"standard" => "estándar",
"cache" => "caché",
"backlinks" => "retroligazóns",
"perms" => "permisos",
"similar" => "similar",
"undo" => "desfacer",
"slides" => "diapositivas",
"log in" => "inicie sesión",
"Jukebox" => "Gramola",
"ok" => "correcto",
"TikiTabs" => "lingüetas Tiki",
"admin banning tpl" => "Modelo para administrar expulsión",
"cat" => "cat",
"prio" => "prio ",
"admin FortuneCookie" => "administrar CuquidaSorte",
"admin FortuneCookie tpl" => "Modelo de administrar CuquidaSorte",
"dsn" => "dsn",
"extwiki" => "wikiext",
"flag" => "marca ",
"posts" => "artigos",
"coms" => "coms",
"ppd" => "ppd",
"admin Webmail" => "administrar correo web",
"admin QuickTags" => "administrar etiquetas rápidas",
"admin Trackers tpl" => "Modelo de administrar trackers",
"items" => "ítems",
"admin" => "administrar",
"admin admin tpl" => "Modelo de Administrar Copias de Seguridade",
"Chair" => "Cadeira",
"tbheight" => "altura da táboa",
"imagescale" => "escala da imaxe",
"creates an editable drawing named foo" => "crea un debuxo editable chamado foo",
"admin quicktags" => "administrar etiquetas rápidas",
"admin roles" => "administrar roles",
"monitor" => "monitor",
"Ins" => "Ins.",
"admin Banners" => "administrar pancartas",
"admin Banners tpl" => "Modelo de administrar pancartas",
"admin cache" => "administrar caché",
"admin cache tpl" => "Modelo de administrar caché",
"admin DynamicContent tpl" => "Modelo de administrar contido dinámico",
"adm" => "adm.",
"blog posts" => "artigos de blog",
"admin Tiki Shoutbox" => "administrar taboleiro de anuncios Tiki",
"admin Tiki Shoutbox tpl" => "Modelo de administrar taboleiro de anuncios Tiki",
"item" => "ítem",
"You do not have permission to use this feature." => "Non ten permiso para usar esta característica.",
"refresh" => "refresco",
"uploaded by" => "cargado por",
"not specified" => "non especificada",
"There was a problem with your upload." => "Houbo un problema coa súa carga.",
"The file you are trying to upload is too big." => "O ficheiro que intenta cargar é demasiado grande.",
"The file you are trying to upload was only partially uploaded." => "O ficheiro que intenta cargar foi só parcialmente cargado.",
"You must select a file for upload." => "Debe seleccionar un ficheiro para cargar.",
" line " => " liña ",
"permission." => "permiso",
"Error: Invalid" => "Erro: incorrecto ",
"Error: Call to hw_page_fetch_by_id failed!" => "Erro: fallou a chamada a hw_page_fetch_by_id!",
"%s is an empty archive file" => "%s é un ficheiro de arquivo baleiro",
"Invalid remote file on url %s" => "Ficheiro remoto incorrecto en %s",
"Project Group for " => "Grupo do proxecto para ",
"Project Admin Group for " => "Grupo administrador do proxecto para ",
"%A %d of %B, %Y" => "%A %d de %B de %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d de %B de %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d de %b de %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d de %b de %Y[%H:%M %Z]",
"no description" => "sen descrición",
"Updated" => "Actualizado",
"Textarea options: options,width,height,max with option is 1 or 0, rest is size indicated in chars and lines, max is the maximum number of characters that can be saved." => "Opcións de área de texto: opcións, anchura, alto, max. con opción 0 ou 1, o resto é tamaño indicado en caracteres e liñas, max. é o máximo número de caracteres que se gardará",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "Selector do usuario: use opcións para a alimentación automática do campo: pode usar 1 para o nome (login) do autor e 2 para o nome (login) do modificador.",
"Image options: xSize,ySize indicated in pixels." => "Opcións de imaxe: Tamx,Tamy indicados en píxeles.",
"Category options: parentId" => "Opcións de categoría: Idpai",
"Item Link options: trackerId,fieldId links to item from trackerId which fieldId matches the content of that field." => "Opcións de ligazón a ítem: trackerId,campoId liga a ítem desde trackerId, onde campoId corresponde co contido dese campo.",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere." => "Opcións da lista de ítems: Idtracker, CampoIdAlá, CampoIdAquí, MostrarCampoIdAlá amosa a lista de MostrarCampoIdAlá desde ítem no tracker Idtracker, onde CampoIdAlá corresponde con CampoIdAquí.",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} insire artigos na páxina wiki",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num é opcional e é o número ordinal do anexo na lista. Se non se dá, despregarase unha lista de todos os anexos. Inline fai que o comentario sexa o texto da ligazón.",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} inserir a saída dunha fonte rss nunha páxina wiki",
"You need to supply information for : " => "Debe fornecer a información para: ",
"missing tracker ID for plugin TRACKER" => "falta o ID de tracker para o plugin TRACKER",
"delete" => "eliminar",
"show categories" => "mostrar categorías",
"Tip: hold down CTRL to select multiple categories" => "Consello: manteña premido CTRL para elixir múltiples categorías",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Consello: deseleccione a cela de verificación de arriba para descategorizar esta páxina/obxecto",
"author" => "autor",
"user level" => "nivel de usuario",
"send email to user" => "enviar correo a usuario",
"score" => "puntos",
"delete selected" => "borrar seleccionados",
"move" => "mover",
"Posted messages" => "Mensaxes enviadas",
"set" => "poñer",
"replies" => "respostas",
"new reply" => "nova resposta",
"cancel" => "cancelar",
"add" => "engadir",
"someone coming from IP Address" => "alguén accedendo desde o enderezo IP",
"requested a reminder of the password for the" => "solicitou un recordatorio do contrasinal para o",
"requested a reset of the password for the" => "solicitou un reinicio da clave para o",
"The old password remains active until you activate the new one by following this link:" => "A clave antiga mantense activa ata que active a nova seguindo esta ligazón:",
"This is only a temporary password. After you logged in with it, you will get to the 'change password' dialog." => "Esta é só unha clave temporal. Logo de que entre con ela, obterá o diálogo de 'cambiar clave'.",
"Information:" => "Información:",
"New blog post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Novo artigo no blog: {\$mail_title} por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"stop monitoring this map" => "deixar de monitorizar este mapa",
"create" => "crear",
"save" => "gardar",
"edit template" => "editar modelo",
"send" => "enviar",
"If you people want to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Se os seus coñecidos queren ser capaces de responderlle a vostede, ten que marcar <a href='tiki-user_preferences.php'>Permitir mensaxes desde outros usuarios</a>",
"reply to" => "responder a",
"up" => "subir",
"down" => "baixar",
"Hide module contents" => "Ocultar contidos do módulo",
"List Courses" => "Listar cursos",
"Last visitors" => "Últimos visitantes",
"register" => "rexistrarse",
"secure" => "seguro",
"stay in ssl mode" => "permanecer en modo ssl",
"go" => "ir",
"use" => "usar",
"print" => "imprimir",
"create pdf" => "crear pdf",
"monitor this page" => "monitorizar esta páxina",
"stop monitoring this page" => "deixar de monitorizar esta páxina",
"last modification" => "última modificación",
"rename" => "renomear",
"unlock" => "desbloquear",
"lock" => "bloquear",
"history" => "historial",
"export" => "exportar",
"discuss" => "discutir",
"add comment" => "engadir comentario",
"attach file" => "anexar ficheiro",
"translation" => "tradución",
"attachments" => "anexos",
"stats" => "estatísticas",
"last changes" => "cambios recentes",
"list pages" => "listar páxinas",
"back to homepage" => "volver ao inicio",
"Please" => "Por favor",
"to access full functionalities" => "para acceder a todas as funcionalidades",
"cancel edit" => "cancelar a edición",
"No attachments for this page" => "Non hai anexos para esta páxina",
"Skip to navigation" => "Saltar para a navegación",
"reads" => "lecturas",
"cached" => "cacheada",
"Click here to create it" => "Prema aquí para crealo",
"wiki help" => "axuda wiki",
"Site Calendar" => "Calendario do sitio",
"Friendship network" => "Círculo de Amizade",
"Allow permissions for friendship network" => "Permitir permisos para o círculo de amizade",
"Max friendship distance" => "Distancia máxima de amizade",
"Best language" => "Mellor lingua",
"Use Quote plugin for quoting" => "Usar o plugin QUOTE para citar",
"Enable cache images to all galleries" => "Activar cacheo de imaxes en todas as galerías",
"Images cache directory" => "Directorio de caché de imaxes",
"PHP error reporting level for non-admin:" => "Nivel de informe de erro de PHP para non admin:",
"Report PHP errors only for admin" => "Informar erros de PHP só para admin",
"Server name (for absolute URIs)" => "Nome do servidor (para URI absolutas)",
"HTTPS Server" => "Servidor HTTPS",
"Automatic (uses HTTPS variable)" => "Automático (usa variable HTTPS)",
"Wiki_Tiki_Title" => "Título do Wiki",
"Jukebox settings" => "Configuración da gramola",
"Jukebox tracks location" => "Localización das pistas da gramola",
"Jukebox features" => "Características da gramola",
"Default ordering for album listing" => "Orde por defecto para a listaxe de álbums",
"Album title (asc)" => "Título de álbum (asc)",
"Number of tracks (desc)" => "Número de pistas (desc)",
"In album listing show user as" => "Na listaxe de álbums, mostrar usuario como",
"Jukebox listing configuration (when listing available albums)" => "Configuración de listaxes da gramola (cando se listen álbums dispoñibles)",
"Tracks" => "Pistas",
"Genre" => "Xénero",
"Admin->Features" => "Administrar->Características",
"Hide disabled sections" => "Ocultar seccións desactivadas",
"Show disabled sections" => "Mostrar seccións desactivadas",
"Create a group for each user <br />(with the same\nname as the user)" => "Crear un grupo para cada usuario <br />(co mesmo\nnome có usuario)",
"Validate email address (may not work)" => "Validar enderezo de correo (pode non funcionar)",
"Remind passwords by email" => "Recordar contrasinais por correo",
"Require HTTP Basic authentication" => "Require autenticación HTTP",
"HTTP server name" => "Nome do servidor HTTP",
"HTTP URL prefix" => "Prefixo para as URL de HTTP",
"HTTPS server name" => "Servidor HTTP",
"HTTPS URL prefix" => "Prefixo para as URL de HTTP",
"Only for users" => "Só para usuarios",
"Users and admins" => "Usuarios e administradores",
"Users choose project categories" => "Os usuarios elixen as categorías de proxecto",
"Prefix for Project Admin groups" => "Prefixo para grupos de Admin de Proxecto",
"Prefix for Project groups" => "Prefixo para grupos de Proxecto",
"Prefix for Wiki project home page" => "Prefixo para a páxina inicio de proxecto Wiki",
"Prefix for File Galleries" => "Prefixo para a Galería de ficheiros",
"Project Admins group template" => "Modelo de grupo Admins de Proxecto",
"Create New Group" => "Crear novo grupo ",
"Project Members group template" => "Modelo de grupo de Membros de Proxecto",
"Full Text Search" => "Busca en todo o texto",
"Don't forget: to use feature you will need to enable it on" => "Non se esqueza: para usar esta característica deberá activala",
"Custom Code" => "Código Personalizable",
"Site breadcrumbs" => "ruta do acceso do sitio",
"Site logo" => "Logo do sitio",
"Manage attachment preferences" => "Xestionar as preferencias dos anexos",
"Like pages" => "Páxinas similares",
"Enable Feature" => "Activar Función",
"loc" => "loc.",
"lang" => "lingua",
"permissions" => "permisos",
"admin categories" => "administrar categorías",
"create new" => "crear nova",
"edit chart" => "editar chart",
"update" => "actualizar",
"admin charts template" => "modelo de administrar charts",
"admin content templates" => "administrar modelos de contido",
"admin content templates template" => "modelo de administrar modelos de contido",
"use in cms" => "usar en cms",
"use in wiki" => "usar en wiki",
"use in newsletters" => "usar en boletíns",
"use in HTML pages" => "usar en páxinas HTML",
"last modif" => "última modificación",
"sections" => "seccións",
"upload" => "cargar",
"admin Drawings tpl" => "modelo de administrar ilustracións",
"admin forums template" => "modelo de administrar foros",
"Edit existing forums" => "Editar foros existentes",
"online" => "en liña",
"topics" => "temas",
"age" => "idade",
"last post" => "último artigo",
"Assign Permissions (Active)" => "Asignar permisos (activo)",
"Click here to delete this forum" => "Prema aquí para borrar este foro",
"admin hotwords" => "administrar palabras clave",
"admin hotwords template" => "modelo de administrar palabras clave",
"admin HTML page dynamic zones" => "administrar as zonas dinámicas de páxinas HTML",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{{/literal}ed id=nome} ou {literal}{{/literal}ted id=nome} para inserir zonas dinámicas",
"list repositories" => "listar almacéns",
"new repository" => "novo almacén",
"view repository" => "ver almacén",
"view this repository" => "ver este almacén",
"new rule" => "nova regra",
"admin featured links" => "administrar ligazóns destacadas",
"admin featured links template" => "administrar modelo de ligazóns destacadas",
"position" => "posición",
"admin mailin template" => "modelo de administrar entrada de correo",
"section" => "sección",
"sorted section" => "sección ordenada",
"admin menu builder" => "administrar construtor de menús",
"admin menus template" => "modelo administrar menús",
"options" => "opcións",
"admin modules" => "administrar módulos",
"admin modules template" => "modelo de administrar módulos",
"assign module" => "asignar módulo",
"left modules" => "módulos da esquerda",
"right modules" => "módulos da dereita",
"edit/create" => "editar/crear",
"clear cache" => "limpar caché",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Nota 1</b>: se permite que os seus usuarios configuren módulos entón os módulos asignados\n non serán reflectidos na pantalla ata que os configure \ndesde OMeuTiki->Módulos.<br />\n<b>Nota 2</b>: Se asigna módulos a grupos asegúrese de que\n apagou a opción 'mostrar módulos a todos os grupos sempre'\nen Admin->Xeral\n",
"assign" => "asignar",
"left" => "esquerda",
"right" => "dereita",
"order" => "orde",
"create/edit" => "crear/editar",
"use poll" => "usar votación",
"use gallery" => "usar galería",
"use dynamic content" => "usar contido dinámico",
"use rss module" => "usar módulo RSS",
"use menu" => "usar menú",
"use phplayermenu" => "usar menú phplayer",
"use banner zone" => "usar zona de pancartas",
"list newsletters" => "listar boletíns",
"admin newsletters" => "administrar boletíns",
"send newsletters" => "enviar boletíns",
"admin newsletters template" => "modelo de administrar boletíns",
"editions" => "edicións",
"last sent" => "última enviada",
"admin Email Notifications" => "administrar notificacións por correo-e",
"admin notifications template" => "modelo de administrar notificacións",
"use admin email" => "usar o correo-e do administrador",
"event" => "evento",
"admin polls" => "administrar votacións",
"admin polls template" => "modelo de administrar votacións",
"label" => "etiqueta",
"Category: wiki, trackers, etc." => "Categoría: wiki, trackers, etc.",
"admin RSS Modules" => "administrar módulos RSS",
"admin RSSmodules template" => "modelo de administración de módulos RSS",
"edit tpl" => "editar modelo",
"admin shoutbox words" => "administrar palabras do taboleiro de anuncios",
"admin shoutbox words template" => "modelo de administrar palabras do taboleiro de anuncios",
"admin structures template" => "modelo de administrar estruturas",
"export pages" => "exportar páxinas",
"dump tree" => "envorcar árbore",
"create webhelp" => "crear axuda web",
"view webhelp" => "ver axuda web",
"tree" => "árbore",
"create new structure" => "crear nova estrutura",
"survey stats" => "estatísticas da enquisa",
"edit this survey" => "editar enquisa",
"admin surveys" => "administrar enquisas",
"list surveys" => "listar enquisas",
"questions" => "preguntas",
"files" => "ficheiros",
"admin topics template" => "modelo para administrar temas",
"Field is public? (for use thru trackerlist plugin)" => "O campo é público? (para usar co plugin trackerlist)",
"Field is hidden? (visible by admin only)" => "O campo está oculto? (visible só para o administrador)",
"version" => "versión",
"admin groups" => "administrar grupos",
"admin groups template" => "modelo para administrar grupos",
"admin users" => "administrar usuarios",
"admin users template" => "modelo de administrar usuarios",
"edit account settings" => "editar opcións de conta",
"Added users" => "Usuarios engadidos",
"edit article tpl" => "modelo de editar artigo ",
"all" => "todos",
"Assign user" => "Asignar usuario",
"Available groups" => "Grupos dispoñibles",
"assign perms to this group" => "asignar permisos a este grupo",
"admin backups" => "administrar copias de seguridade",
"List of available backups" => "Lista de copias de seguridade dispoñibles",
"Restoring a backup" => "Recuperar unha copia de seguridade",
"Warning!" => "Coidado!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Ao restaurar unha copia de seguridade destrúe todos os datos da súa base Tiki. Todas as súas táboas serán substituídas coa información da copia de seguridade.",
"Click here to confirm restoring" => "Prema aquí para confirmar a restauración",
"Create new backup" => "Crear nova copia de seguridade",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Crear copias de seguridade pode levar moito tempo. Se o proceso non se completa vostede verá unha pantalla en branco. Se pasar iso necesita incrementar o tempo de execución máximo de scripts no seu ficheiro php.ini",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "O seu almacenamento de galería de imaxes está configurado como \"{\$gal_use_dir}\", deberá facerlle a copia de seguridade usando FTP ou SCP.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "O seu almacenamento de galería de ficheiros está configurado como \"{\$fgal_use_dir}\", deberá facerlle a copia de seguridade usando FTP o SCP.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Se algún dos seus foros ten anexos gardados no directorio deberá facerlle a copia de seguridade usando FTP o SCP.",
"Upload a backup" => "Cargar unha copia de seguridade",
"Upload backup" => "Cargar copia de seguridade",
"view blog" => "visualizar blog",
"list blogs" => "listar blogs",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor" => "Nota: se quere usar imaxes por favor garde o artigo primeiro e\npoderá editar/poñer imaxes. Use o código &lt;img&gt; para incluír imaxes cargadas no editor da área de texto\n ou use o URL da imaxe para incluíla usando o editor WYSIWYG",
"save and exit" => "gardar e saír",
"admin category" => "administrar categoría",
"search category" => "buscar categoría",
"deep" => "profundidade",
"edit gallery" => "editar galería",
"rebuild thumbnails" => "reconstruír miniaturas",
"upload image" => "cargar imaxe",
"list gallery" => "listar galería",
"hit" => "acceso",
"original size" => "tamaño orixinal",
"return to gallery" => "volver á galería",
"edit image" => "editar imaxe",
"smaller" => "menor",
"bigger" => "maior",
"prev image" => "imaxe previa",
"next image" => "seguinte imaxe ",
"popup window" => "fiestra emerxente",
"or create a new category" => "ou cree unha nova categoría",
"or create a new location" => "ou cree unha nova localización",
"comma separated usernames" => "nomes de usuarios separados por coma",
"comma separated username:role" => "usuario:rol separados por coma",
"with roles" => "con roles",
"Optional" => "Opcional",
"permission" => "permiso",
"remove from this category &amp; all its children" => "borrar desta categoría e de todos os seus fillos",
"remove from this category only" => "borrar só desta categoría",
"Textheight" => "Altura de texto",
"Height of top Heading" => "Altura do encabezado superior",
"Height of mid Heading" => "Altura do encabezado medio",
"Height of inner Heading" => "Altura do encabezado interno",
"Automatic Page Breaks" => "Saltos automáticos de páxina",
"remove page" => "eliminar páxina",
"admin directory tpl" => "modelo de administrar directorio",
"browse" => "navegar",
"related" => "relacionado",
"validate" => "validar",
"admin directory categories tpl" => "modelo de administrar categorías de directorio",
"add a site" => "engadir un sitio",
"search" => "buscar",
"list articles" => "listar artigos",
"view articles" => "visualizar artigos",
"create zone" => "crear zona",
"save the banner" => "gardar a pancarta",
"edit blog tpl" => "modelo de editar blog",
"try" => "probar",
"display" => "mostrar",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Para máis información, por favor vexa <a href=\"{\$helpurl}WikiSyntax\">SintaxeWiki</a>",
"Emphasis" => "Énfase",
"italics" => "cursivas",
"both" => "ambos",
"use ...page... to separate pages" => "use ...páxina... para separar páxinas",
"make_headings" => "fai encabezados",
"underlines text" => "subliña texto",
"Simple box" => "Caixa simple",
"Will display using the indicated HTML color" => "Mostrarase usando a cor HTML indicada",
"Will display the text centered" => "Mostra o texto centrado",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Motra código/texto preformatado; non e fai procesamento Wiki dentro desas seccións (como con np) e o espazado é fixo (non se fai axuste de palabras).",
"Insert Module Output" => "Insire a saída do módulo",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODULE(module=>algún_módulo)}text{MODULE}{/literal}  pode ser usado para inserir a saída do módulo \"algún_módulo\" dentro da súa páxina Wiki. Vexa <a href=\"{\$helpurl}PluginModule\">PluginModule</a> para máis información.",
"Rendering Program Code" => "Mostra o código de programa",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}algún código{CODE} {/literal} vai mostrar \"algún código\" como código do programa. Este plugin ten outras opcións; vexa <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"create new block" => "crear novo bloque",
"list quizzes" => "listar cuestionarios",
"quiz stats" => "estatísticas de cuestionarios",
"edit this quiz" => "editar este cuestionario",
"admin quizzes" => "administrar cuestionarios",
"admin quizzes tpl" => "modelo de administrar cuestionarios",
"results" => "resultados",
"edit quiz questions" => "editar preguntas do cuestionario",
"edit quiz questions tpl" => "modelo de editar preguntas do cuestionario",
"create page" => "crear páxina",
"edit submissions tpl" => "modelo de editar colaboracións",
"list submissions" => "listar colaboracións",
"edit translations" => "editar traducións",
"edit translations template" => "modelo de editar traducións",
"add to the set" => "agregar ao conxunto",
"Admin ephemerides" => "Administrar efemérides",
"admin Ephemerides tpl" => "modelo de administrar efemérides",
"All ephemerides" => "Todas as efemérides",
"new question" => "nova pregunta",
"approve" => "aprobar",
"configure listing" => "configurar listaxe",
"create new gallery" => "crear nova galería",
"topic" => "tema",
"save and approve" => "garde e aprobe",
"new topic" => "novo tema",
"reject" => "rexeitar",
"visits" => "visitas",
"accept" => "aceptar",
"refuse" => "rexeitar",
"switch" => "cambiar",
"add new" => "engadir novo",
"add role" => "engadir rol",
"new minor" => "novo menor",
"new major" => "novo maior",
"admin processes" => "administrar procesos",
"admin activities" => "administrar actividades",
"edit this process" => "Editar este proceso",
"Activs" => "Activos",
"time" => "tempo",
"send instance" => "enviar exemplar",
"stop" => "deter",
"Wiki quick help" => "Axuda rápida Wiki",
"Quicklinks" => "Ligazóns rápidas",
"Last Edit:" => "Última edición:",
"Grade Paper" => "Traballo de Grao",
"Due Date:" => "Data de entrega:",
"Comparing versions" => "Comparando versións",
"Actual_version" => "Versión actual",
"Diff to version" => "Diferenzas coa versión",
"source" => "fonte",
"Assignments List" => "Lista de tarefas",
"My Work" => "O meu traballo",
"Assignment" => "Tarefa",
"Due Date" => "Data de entrega",
"Grading Queue " => "Cola de Graduación",
"paper" => "traballo",
"papers" => "traballos",
"Edit Assignment" => "Editar tarefa",
"list assignments" => "listar tarefas",
"Due" => "Vencemento",
"create assignment" => "crear asignación",
"result" => "resultado",
"edit repository" => "editar almacén",
"list articles tpl" => "modelo de listar artigos",
"edit new article" => "editar novo artigo",
"create new blog" => "crear novo blog",
"list faqs tpl" => "modelo de listar pmfs",
"upload file" => "cargar ficheiro",
"Edit a file using this form" => "Edite un ficheiro usando este formulario",
"delete selected files" => "borrar ficheiros seleccionados",
"browse gallery" => "explorar galería",
"Flash binary (.sqf or .dcr)" => "Arquivo Flash (.sqf ou .dcr)",
"list posts tpl" => "modelo para listar envíos",
"edit blog" => "editar blog",
"list quizzes tpl" => "modelo de listar cuestionarios",
"edit new submission" => "editar nova colaboración",
"edit quiz stats tpl" => "modelo de editar estatísticas do cuestionario",
"actions" => "accións",
"take survey" => "tomar enquisa",
"list trackers tpl" => "modelo de listar trackers",
"admin live support tpl" => "modelo de administrar asistencia en liña",
"set as operator" => "poñer como operador",
"add topic" => "engadir tema",
"wiki create" => "crear wiki",
"wiki overwrite" => "sobrescribir wiki",
"back" => "atrás",
"Assign permissions to page" => "Asignar permisos para a páxina",
"Current permissions for this page" => "Permisos actuais para esta páxina",
"remove from this page" => "borrar desta páxina",
"remove from this structure" => "borrar desta estrutura",
"No individual permissions; category or global permissions apply" => "Non se aplican permisos individuais, de categoría ou globais",
"this page" => "esta páxina",
"this structure" => "esta estrutura",
"Current permissions for categories that this page belongs to" => "Permisos actuais para as categorías ás que pertence esta páxina",
"Send email notifications when this page changes to" => "Enviar notificación de correo cando esta páxina cambie a",
"add email" => "engadir correo",
"Notifications" => "Notificacións",
"view comments" => "ver comentarios",
"clear" => "limpiar",
"clear stats" => "borrar estatísticas",
"Edit received page" => "Editar páxina recibida",
"admin Referer stats" => "administrar estatísticas de referenciantes",
"admin Referer stats tpl" => "modelo de administrar estatísticas de referenciantes",
"last" => "última",
"send me my password" => "enviar o meu contrasinal",
"searched" => "buscado",
"galleries" => "galerías",
"images" => "imaxes",
"admin send objects tpl" => "modelo de administrar envío de obxectos",
"site" => "sitio",
"path" => "camiño",
"add article" => "engadir artigo",
"create new sheet" => "crear nova folla de cálculo",
"send answers" => "enviar respostas",
"move to right column" => "mover á columna dereita",
"unassign" => "inhabilitar",
"move to left column" => "mover á columna esquerda",
"remove folder" => "borrar carpeta",
"refresh cache" => "refrescar caché",
"General preferences" => "Preferencias xerais",
"Other preferences" => "Outras preferencias",
"HomePage" => "PáxinaInicio",
"Edit information" => "Editar a información",
"Change information" => "Cambiar información",
"edit user files" => "editar ficheiros de usuario",
"no comments" => "sen comentarios",
"stop monitoring this blog" => "deixar de monitorizar este blog",
"edit items" => "editar ítems",
"list charts" => "listar charts",
"last chart" => "último chart",
"view faq" => "ver pmf",
"view faq tpl" => "modelo de ver pmf",
"admin menus tpl" => "modelo de administrar menús",
"add suggestion" => "agregar suxestión",
"monitor this forum" => "monitorizar este foro",
"stop monitoring this forum" => "deixar de monitorizar este foro",
"delete selected topics" => "borrar temas seleccionados",
"topics in this forum" => "temas deste foro",
"stop monitoring this topic" => "deixar de monitorizar este tema",
"Comments below your current threshold" => "Comentarios por debaixo do seu límite actual",
"list attachments" => "listar anexos",
"add contacts" => "engadir contactos",
"DATE-of" => "de",
"The passwords dont match" => "Os contrasinais non coinciden",
"You do not have permission to write the template" => "Non ten permiso para escribir o modelo",
"You cannot edit this page because it is a user personal page" => "Non pode editar esta páxina porque é a páxina persoal dun usuario",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Vaia ao seu <a href=\"tiki-friends.php\">círculo de amizades</a> para aceptar ou rexeitar esta solicitude",
"You must be a student to edit homework pages." => "Debe ser estudante para editar páxinas de deberes.",
"No assignment indicated" => "Non se indicou a tarefa",
"Error: Invalid id for hw_pages table." => "Erro: id incorrecto para táboa hw_pages.",
"Error: This page is being edited by another user." => "Erro: Esta páxina está a editala outro usuario.",
"Permission denied: Students may only view or edit their own work." => "Permiso denegado: Os estudantes só poden ver ou editar o seu propio traballo.",
"Error: Assignment not found." => "Erro: Asignación de deberes non atopada.",
"Permission denied: Students may NOT edit their work after the due date." => "Permiso denegado: Os estudantes NON poden editar o seu traballo despois da data de entrega.",
"Permission denied: The teacher must wait until the due date to edit students' work." => "Permiso denegado: o profesor debe esperar ata a data de entrega para editar o traballo dos estudantes.",
"No entries available yet!" => "Aínda non hai entradas dispoñibles!",
"Permission denied: you must be a teacher to access this page." => "Permiso denegado: debe ser profesor para acceder a esta pácina.",
"Error: No assignment indicated." => "Erro: Non se indicou asignación de deberes.",
"Error: assignment not found." => "Error: asignación de deberes non atopada.",
"You must be a student to view this page." => "Debe ser estudante para ver esta páxina.",
" is not a student." => "non é un estudante.",
"specified." => "especificado.",
"Assignment not found" => "Asignación de deberes non atopada",
"Anonymous Grader" => "Cualificador anónimo",
"Anonymous Peer Reviewer" => "Revisión anónima por un igual",
"No homework page indicated!" => "Non se indicou a páxina de deberes!",
"Error: Could not fetch page" => "Erro: Non podo obter páxina",
"You must be a student to view this page!" => "Debe ser un estudante para visualizar esta páxina!",
"Students may only view their own work!" => "Os estudantes só poden visualizar o seu propio traballo!",
"This function is deprecated in favor of the improved quizzes outside of the Homework feature." => "Esta función está obsoleta en favor dos cuestionarios mellorados fóra da función de Deberes.",
"Permission denied: You cannot rollback this page." => "Permiso denegado: non pode volver atrás esta páxina.",
"No hw page indicated" => "Non se indicou páxina de deberes",
"Error: nonexistant version specified." => "Erro: versión especificada inexistente.",
"Error: Could not fetch assignment " => "Erro: non podo obter asignación de deberes",
"You must be a student to view homework assignments." => "Debe ser estudante para ver as asignacións de deberes.",
"Permission denied you must be a student to view assignments." => "Permiso denegado: debe ser un estudante para visualizar as asignacións de deberes.",
"You must be a teacher or grader to access this page." => "Debe ser un mestre ou un cualificador para acceder a esta páxina.",
"Permission denied: You must be a teacher to edit assignments." => "Permiso denegado: Debe ser un profesor para editar asignación de deberes.",
" error: Can not find assignment " => "erro: non podo atopar asignación de deberes",
"Permission denied you cannot assign permissions for this page" => "Non ten autorización para asignar permisos para esta páxina",
"A new password and your IP address has been sent " => "Enviáronselle unha nova clave e o seu enderezo IP",
"Invalid variable value : " => "Valor incorrecto de variable : ",
"You do not have permission to edit messages" => "Non ten permiso para editar mensaxes",
"Cannot read file" => "Non podo ler o ficheiro",
"Permission denied you cannot upload files" => "Permiso denegado: non pode cargar ficheiros",
"cannot process upload" => "non se puido procesar a carga",
"Your email address has been removed from the list of addresses monitoring this tracker" => "O seu enderezo de correo foi borrado da lista de enderezos monitorizando este tracker",
"Your email address has been added to the list of addresses monitoring this tracker" => "O seu enderezo de correo foi borrado da lista de enderezos monitorizando este tracker",
"Cancel monitoring" => "Cancelar monitor",
"Your email address has been removed from the list of addresses monitoring this item" => "O seu enderezo de correo foi borrado da lista de enderezos monitorizadores deste ítem",
"Your email address has been added to the list of addresses monitoring this item" => "O seu enderezo de correo foi engadido á lista de enderezos monitorizadores deste ítem",
"I did not understand what you said, please try again." => "Non comprendo o que di. Por favor, ténteo de novo.",
"Dls" => "Dls",
"diff" => "diff",
"pdf" => "pdf",
"UTC" => "UTC",
"zoom" => "zoom",
"roles" => "roles",
"P" => "P",
"F" => "F",
"pop" => "pop",
"Russian Federation" => "Rusia",
"new image uploaded by" => "nova imaxe cargada por",
"new subscriptions" => "nova subscrición",
"new item in tracker" => "novo ítem no tracker",
"tikiwiki logo" => "logo do tikiwiki",
"show" => "mostrar",
"hide" => "ocultar",
"message" => "mensaxe",
"Include all post in a blog" => "Incluír todos os artigos dun blog",
"Include an article" => "Inclúe un artigo",
"no such attachment on this page" => "non hai tal anexo nesta páxina",
"select all" => "elixir todo",
"filter" => "filtrar",
"missing fields list" => "lista de campos ausentes",
"move %s in %s" => "mover %s para %s",
"no such file" => "non existe este ficheiro",
"downloads" => "descargas",
"download" => "descargar",
"attach" => "anexar",
"monitor this blog" => "monitorizar este blog",
"hide categories" => "ocultar categorías",
"Admin categories" => "Administrar categorías",
"browse category" => "navegar na categoría",
"reply" => "responder",
"monitor this topic" => "monitorizar este tema",
"active perms" => "permisos activos",
"with checked" => "con marcados",
"move selected files" => "mover ficheiros seleccionados",
"Thank you for you registration. You may log in now." => "Grazas polo seu rexistro. Agora pode iniciar a sesión.",
"Zoom out x4" => "Reducir x4",
"Zoom out x3" => "Reducir x3",
"Zoom in x3" => "Ampliar x3",
"Zoom in x4" => "Ampliar x4",
"from\nthe mapfile:" => "desde\no ficheiro de mapa:",
"compare" => "comparar",
"older version" => "versión máis antiga",
"Click the :: options in the Menu for more options." => "Prema en :: opcións no menú para máis opcións.",
"Please, also see" => "Por favor, mire tamén",
"for more setup details." => "para máis detalles de configuración.",
"Note 1:" => "Nota 1:",
"You can remove this module in" => "Pode eliminar este módulo en",
"as well as assign or edit many others." => "como asignar ou editar moitos outros",
"Note 2:" => "Nota 2:",
"The menu module installed by default is named" => "O módulo de menú instalado por defecto chámase",
"it is a \"custom module\" which includes menu ID " => "é un \"módulo personalizado\" que inclúe ID do menú",
"That menu is stored in database and it can be edited from " => "Ese menú esta gardado na base de datos e pode editarse desde ",
"Do not mix this with the original <em>application_menu</em> module" => "Non mesture este co módulo orixinal <em>application_menu</em>",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Ese pode ser moi personalizado para facer corresponder co tema usado pero só se pode facer editando o ficheiro mod-application_menu.tpl \"manualmente\"",
"del" => "borrar",
"Create pdf" => "Crear pdf",
"1 file attached" => "1 ficheiro anexado",
"categories" => "categorías",
"List pages where I am a creator" => "Listar páxinas onde son modificador",
"by creator" => "por modificador",
"List pages where I am a modificator" => "Listar páxinas onde son o modificador",
"by modificator" => "por modificador",
"at tracker" => "en tracker",
"calendar view" => "vista de calendario",
"check / uncheck all" => "marcar / desmarcar todos",
"Tiki sections and features" => "Seccións e características do Tiki",
"tikiwiki.org help" => "Axuda tikiwiki.org",
"Site Logo and Identity" => "Logo e identidade do sitio ",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use o plugin QUOTE no canto de &ldquo;>&rdquo; para citar",
"Storing files in a directory" => "Gardando ficheiros nun directorio",
"please read" => "por favor, lea",
"yes" => "si",
"Click here for more details." => "Prema aquí para máis detalles.",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "As preferencias do Tiki na base de datos (bd) están configuradas para o máximo de 250 caracteres por defecto ata o de agora. Iso tamén serve para o contido do código personalizable. Marque este campo se quere actualizar as súas preferencias na táboa da base de datos para permitir máis de 250 caracteres (aínda que foi probado e funciona ben en mysql, recoméndase que faga unha copia de seguridade dos seus datos manualmente antes de calquera actualización da base de datos)",
"Users &amp; groups" => "Usuarios &amp; grupos",
"private" => "privado",
"<b>Item</b>" => "<b>ítem</b>",
"<b>Value</b>" => "<b>Valor</b>",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS Modules\" on the application menu, or" => "Esta páxina é para configurar as opcións das fontes RSS xeradas/exportadas polo Tiki. Para ler/importar fontes RSS, busque en \"módulos RSS\" no menú de aplicación, ou",
"<b>Feed</b>" => "<b>Fonte</b>",
"<b>enable/disable</b>" => "<b>habilitar/deshabilitar</b>",
"<b>Max number of items</b>" => "<b>Cantidade máxima de ítems</b>",
"Feed for Articles" => "Fonte para artigos",
"Feed for Weblogs" => "Fonte para blogs",
"Feed for Image Galleries" => "Fonte para galerías de imaxes",
"Feed for File Galleries" => "Fonte para galerías de ficheiros",
"Feed for the Wiki" => "Fonte para o Wiki",
"Feed for individual Image Galleries" => "Fonte para galerías de imaxes individuais",
"Feed for individual File Galleries" => "Fonte para galerías de ficheiros individuais",
"Feed for individual weblogs" => "Fonte para un blog",
"Feed for individual forums" => "Fonte para foros individuais",
"Feed for mapfiles" => "Fonte para ficheiros de mapa",
"Feed for directories" => "Fonte para directorios",
"Feed for tracker items" => "Fonte para ítems de tracker",
"Prefix breadcrumbs with 'Location:' label?" => "Preceder a ruta de acceso coa etiqueta 'Location:'?",
"Site Search" => "Busca en sitio",
"Change style only" => "Cambiar só estilo",
"PDF generation" => "Xeración de PDF",
"Use in CMS" => "Usar en cms",
"Use in Wiki" => "Usar en wiki",
"Use in newsletters" => "Usar en boletíns",
"Use in events" => "Usar en eventos",
"Use in HTML pages" => "Usar en páxinas HTML",
"Edit Existing Forums" => "Editar foros existentes",
"Refresh rate (if dynamic) [secs]" => "Taxa de actualización(se é dinámica) [segs]",
"configure repositories" => "configurar almacéns",
"configure this repository" => "configurar este almacén",
"copy rules" => "copiar regras",
"Create/edit newsletters" => "Crear/editar boletíns",
"subscriptions" => "subscricións",
"archives" => "arquivos",
"Use Admin Email" => "Usar o correo-e do administrador",
"Edit or add poll options" => "Editar ou engadir opcións de votación",
"configure polls" => "configurar votacións",
"Create/edit Polls" => "Crear ou editar votacións",
"Rss channels" => "Canles rss",
"show pubdate" => "mostrar data de publicación",
"activate" => "activar",
"Admin tracker" => "Administrar tracker",
"Edit this tracker" => "Editar tracker ",
"View this tracker items" => "Ver elementos do tracker",
"Edit tracker fields" => "Editar campos do tracker",
"Import/export trackers fields" => "Importar/exportar campos de trackers ",
"Edit tracker" => "Editar tracker",
"Create trackers" => "Crear trackers ",
"Import/export" => "Importar/exportar",
"fields" => "campos",
"active permissions" => "activar permisos",
"Create/edit trackers" => "Crear/editar trackers",
"filename" => "nome de ficheiro",
"filesize" => "tamaño do ficheiro",
"filetype" => "tipo de ficheiro",
"longdesc" => "descrición longa",
"Add a new group" => "Engadir novo grupo",
"Edit item" => "Editar ítem",
"List all members" => "Listar todos os membros",
"Add a new user" => "Engadir un novo usuario",
"manage group assignments" => "xestionar as asignacións de grupo",
"set default groups" => "poñer grupos por defecto",
"Popup Window" => "Fiestra emerxente",
"details" => "detalles",
"change focus" => "cambiar foco",
"quater" => "trimestre",
"quarter" => "trimestre",
"semester" => "semestre",
"No individual permissions global permissions apply" => "Non hai permisos individuais, aplican os permisos globais",
"Welcome to the Tiki Chat Rooms" => "Benvido ás salas de charla do Tiki",
"Please select a chat channel" => "Elixa unha canle de charla",
"enter chat room" => "Entrar ao salón de charla",
"There are no channels setup, please contact a site admin" => "Non hai canles configuradas, por favor contacte co administrador do sitio",
"Chatroom" => "Salón de charla",
"Active Channels" => "Canles activas",
"Users in this channel" => "Usuarios nesta canle",
"Channel Information" => "Información da canle",
"Channel" => "Canle",
"Ratio" => "Razón",
"Use :nickname:message for private messages" => "Usar :alcume:mensaxe para mensaxes privadas",
"Use [URL|description] or [URL] for links" => "Usar [URL|descrición] ou [URL] para ligazóns",
"Use (:smileyname:) for smileys" => "Usar (:nomeemoticona:) para emoticonas",
"Create PDF" => "Crear PDF",
"PDF Settings" => "Configuración de PDF",
"Select Wiki Pages" => "Elixa páxinas wiki",
"Remove Page" => "Eliminar páxina",
"click here to send us an email" => "prema aquí para enviarnos un correo",
"Add or edit a site" => "Engadir ou editar un sitio",
"sites" => "sitios",
"cool sites" => "sitios con máis accesos",
"Use ...page... to separate pages in a multi-page article" => "Use ...páxina... para separar páxinas nun artigo de múltiples páxinas",
"Create Zone" => "Crear zona",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "usar corchetes para unha ligazón externa: [URL] ou [URL| descrición_ligazón] ou [URL|descrición|nocaché] (esta última forma prevén que o wiki coloque esa páxina na cache; por favor, use esa forma para páxinas grandes!).",
"browse image" => "ver imaxe",
"translate" => "traducir",
"Create or edit content" => "Crear ou editar contido",
"this quiz stats" => "estatísticas deste cuestionario",
"answer" => "resposta",
"Edit Translation:" => "Editar tradución:",
"Use this section to set the language of the version you are currently working on." => "Use esta sección para poñer a lingua da versión na cal está a traballar.",
"Set of Translations" => "Conxunto de traducións",
"Select the article for which the current article is the translation." => "Escolla o artigo para o cal o artigo actual é a tradución.",
"Translation of:" => "Tradución de:",
"Enter the name of the page for which the current page is the translation." => "Introduza o nome da páxina para a cal a páxina actual é a tradución.",
"Add to the Set" => "Agregar ao conxunto",
"graph" => "graf",
"Edit FAQ questions" => "Editar preguntas do PMF",
"Edit this file gallery:" => "Editar esta galería de ficheiros:",
"icon" => "icona",
"Other users can upload files to this gallery" => "Outros usuarios poden cargar ficheiros a esta galería",
"Available File Galleries" => "Galerías de ficheiros dispoñibles",
"configure forum" => "configurar foro",
"start" => "comezar",
"end" => "fin",
"Add role" => "Engadir rol",
"active process" => "proceso activo",
"invalid" => "incorrecto",
"invalid process" => "proceso incorrecto",
"valid process" => "proceso válido",
"activities" => "actividades",
"aborted" => "abortada",
"value" => "valor",
"proc" => "proc.",
"exceptions" => "excepcións",
"rollback" => "reverter",
"Create or edit content block" => "Crear ou editar bloque de contido",
"Listing Gallery" => "Contido da galería",
"Gallery Files" => "Ficheiros de Galería",
"Last ver" => "Última  versión",
"Com" => "Com.",
"Vers" => "Vers.",
"subscribe" => "subscribir",
"Sent edition" => "Edición enviada",
"Subscribe to newsletter" => "Subscribirse ao boletín",
"Add or edit a news server" => "Engadir ou editar un servidor de grupos de novas",
"rollback to this version" => "reverter a esta versión",
"Print Wiki Pages" => "Imprimir páginas del Wiki",
"add page" => "engadir páxina",
"entire site" => "todo o sitio",
"click to navigate" => "Premer para navegar",
"Total threads" => "Total de fíos",
"Average threads per topic" => "Media de fíos por tema",
"You can include the file in an HTML/Tiki page using" => "Pode incluír unha ligazón a este ficheiro nunha HTML ou Tiki usando",
"Now enter the file URL" => "Introduza o URL do ficheiro",
" or upload a local file from your disk" => "ou cargue un ficheiro desde o seu disco local",
"Add or edit folder" => "Engadir ou editar carpeta",
"Add or edit a URL" => "Engadir ou editar un URL",
"received" => "recibido/a",
"submitted" => "enviado/a",
"shared" => "compartido/a",
"accepted by task user and creator" => "aceptada polo usuario de tarefa e o creador",
"accepted user and creator" => "aceptado (usuario e creador)",
"not accepted by one user" => "non aceptada por un usuario",
"not accepted user" => " non aceptado (usuario)",
"waiting for me" => "esperando por min",
"waiting for other user" => "esperando por outro usuario",
"red" => "vermello",
"move into trash" => "botar na papeleira",
"waiting / not started" => "esperando / non empezada",
"waiting" => "esperando",
"shared for group" => "compartida para grupo",
"accepted by user" => "aceptada por usuario",
"no / rejected" => "non / rexeitada",
"accepted by creator" => "aceptada polo creador",
"priority" => "prioridade",
"select one" => "seleccione unha",
"undo trash" => "desfacer papeleira",
"show:" => "mostrar:",
"all shared tasks" => "todas as tarefas compartidas",
"previous chart" => "chart anterior",
"next chart" => "seguinte chart",
"pos" => "pos.",
"pre" => "pre.",
"permanency" => "permanencia",
"avg" => "media",
"post new comment" => "enviar comentario",
"Post New Comment" => "Enviar comentario",
"HTML tags are not allowed inside comments" => "Non se admiten etiquetas HTML nos comentarios",
"moderator actions" => "accións de moderador",
"move selected topics" => "mover temas seleccionados",
"unlock selected topics" => "desbloquear temas seleccionados",
"lock selected topics" => "bloquear temas seleccionados",
"merge" => "combinar",
"merge selected topics" => "combinar temas seleccionados",
"reported messages:" => "mensaxes divulgadas:",
"queued messages:" => "mensaxes na cola:",
"emot" => "emot.",
"Edit fields" => "Editar campos",
"View item" => "Visualizar ítem",
"Add a comment" => "Engadir un comentario",
"account" => "conta",
"Projects" => "Proxectos",
"Projects configuration" => "Configuración de proxectos",
"Site Identity features" => "Características de identidade do sitio",
"Click here to delete this category" => "Prema aquí para borrar esta categoría",
"Group doesnt exist" => "O grupo non existe",
"User doesnt exist" => "O usuario non existe",
"Event without Name" => "Evento sen nome",
"Invalid old password" => "O contrasinal introducido é incorrecto",
"No channel indicated" => "Non se indica canle",
"No nickname indicated" => "Non se indica un alcume",
"No permission to view the page" => "Non ten permiso para ver a páxina",
"I have refused your friendship request!" => "Rexeitei a súa solicitude de amizade!",
"Please create a directory named \$map_path to hold your map files." => "Por favor, cree un directorio chamado \$map_path para gardar os seus ficheiros de mapa.",
"Permision denied" => "Permiso denegado",
"clip" => "clip",
"cc" => "cc",
"Phillippines" => "Filipinas",
"sender" => "remitente",
"subject" => "tema",
"date" => "data",
"flagged" => "marcado",
"mark" => "marcar",
"find replied message" => "buscar mensaxe respondida",
"Click" => "Clic",
"posted by" => "posteado por",
"email this post" => "mandar mensaje con este post",
"Tag name" => "Nome da etiqueta",
"Anonymous editors must input anti-bot code" => "Editores anónimos deben introducir un código anti-robot",
"Edit idle timeout" => "Tempo límite de espera para a edición",
"Use page description" => "Usar descrición da páxina",
"Show page title" => "Mostrar título da páxina",
"Show page ID" => "Mostrar ID da páxina",
"Users can lock pages (if perm)" => "Usuarios con permiso poden bloquear páxinas",
"Use WikiWords" => "Use as PalabrasWiki ",
"Use Wiki paragraph formatting" => "Usar formato Wiki de parágrafos ",
"Use external link icons" => "Usar iconas para ligazóns externas",
"User's Page" => "Páxina de Usuario",
"UserPage prefix" => "Prefixo de Páxina de Usuario",
"Maximum number of versions for history" => "Cantidade máxima de versións no historial",
"Never delete versions younger than days" => "Non eliminar nunca versións con antigüidade inferior a (días)",
"Diff style" => "Estilo de Diff",
"Old vers" => "Versións antigas",
"Add or edit event" => "Engadir ou editar evento",
"merge selected notes into" => "combinar notas seleccionadas en",
"Faq Stats" => "Estatísticas de PMFs",
"Edit User Files" => "Editar ficheiros de usuario",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "A súa mensaxe quedou na fila para aprobación; a mensaxe será publicada despois de que\n un moderador a aprobe.",
"Webmail Doc" => "Documentación de Correo Web ",
"Webmail Doc template" => "Modelo de correo web",
"settings" => "configuración",
"mailbox" => "caixa de correo",
"compose" => "redactar",
"contacts" => "contactos",
"back to mailbox" => "volver á caixa do correo",
"full headers" => "ver cabeceiras",
"normal headers" => "cabeceiras normais",
"reply all" => "responder a todos",
"forward" => "reenviar",
"select from address book" => "elixir desde a axenda de enderezos",
"ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Opcións de texto: 1,tamaño, prefixar, sufixar, tamaño máximo en caracteres, prefixar será despregado antes do campo, sufixar será mostrado xusto despois, max. é o número máximo de caracteres que poden gardarse, e o 1 inicial para facer que o seguinte campo de texto ou cela de verificación estea na mesma fila. Se indica só 1, significa que o seguinte campo tamén estará na mesma fila.",
"Checkbox options: put 1 if you need that next field is on the same row." => "Opcións de cela de verificación: poña 1 se precisa que o seguinte campo estea na mesma fila.",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Opcións numéricas: 1,tamaño,prefixar,sufixar. Con tamaño en caracteres, prefixar despregarase antes do campo, sufixar despregarase xusto despois, e o 1 inicial para facer que o seguinte campo de texto ou cela de verificación estea na mesma liña. Se indica só 1, significa que o seguinte campo estará tamén na mesma fila.",
"Dropdown options: list of items separated with commas." => "Opcións despregables: lista de ítems separados por comas.",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Selector de Grupo: use opcións para a alimentación automática do campo: pode usar 1 para o grupo de creación e 2 para o grupo de onde vén a modificación. O grupo por defecto debe de configurarse, ou o primeiro grupo que vén é elixido polo usuario, ou o grupo por defecto é \"Registered\".",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Opcións de acción: etiqueta, enviar, tiki-index.php, páxina:nomedecampo,resaltar=test",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Opcións de enderezo de correo-e:: 0|1|2, onde 0 pon o enderezo en texto simple, 1 pon a codificación hexadecimal da ligazón mailto (é máis difícil para arañas web recoñecelo e enviar correo lixo) e 2 fai o href mailto normal.",
"new sites" => "novos sitios",
"Message Broadcast" => "Difusión da mensaxe",
"Are you sure you want to remove this module?" => "Está seguro de que quere borrar este módulo?",
"database queries used" => "consultas usadas na base de datos",
"{\$atts_cnt} files attached" => "{\$atts_cnt} ficheiros anexados",
"pass" => "contrasinal",
"Page generated in" => "Páxina xerada en",
"sent" => "enviado",
"Homework" => "Deberes",
"Assignments" => "Asignacións",
"Favorites" => "Favoritos",
"Member list" => "Lista de membros",
"Back to Homepage" => "Volver ao inicio",
"Minor" => "Menor",
"Last update from CVS" => "Última actualización desde CVS",
"Translate in" => "Traducir en",
"babelfish it" => "mandar a babelfish",
"Welcome to" => "Benvido a",
"Content Features" => "Características de contido",
"Contact Us (Anonymous)" => "Contactar con nós (Anónimo)",
"Prevent automatic/robot registration" => "Previr rexistro automático/robots",
"Site Logo" => "Logo do sitio",
"Admin Groups Template" => "Modelo para administrar grupos",
"Help on Banning System" => "Axuda respecto ao Sistema de Expulsión",
"Admin banning tpl" => "Modelo para administrar expulsión",
"Create/edit Calendars" => "Crear/editar calendarios",
"Admin Categories tpl" => "Modelo de administrar categorías",
"charts" => "gráficos",
"Admin Charts Template" => "Modelo de administrar charts",
"Chat Administration" => "Administración da Charla",
"Chat Admin" => "Administrar charla",
"Chat Admin tpl" => "Modelo de administrar charla",
"Create/edit channel" => "Crear ou editar canle",
"Half a second" => "Medio segundo",
"second" => "segundo",
"Chat channels" => "Canles de charla ",
"Admin Content Templates Template" => "Modelo de administrar modelos de contido",
"Help on Drawings" => "Axuda en debuxos",
"Admin DSN" => "Administrar DSN",
"tiki-admin_dsn tpl" => "Modelo de tiki-admin_dsn",
"Admin Forums Template" => "Modelo de administrar foros",
"Admin Hotwords Template" => "Modelo de administrar palabras clave",
"Admin Featured Links" => "Administrar ligazóns destacadas",
"Admin Featured Links Template" => "Administrar modelo de ligazóns destacadas",
"Admin Webmail" => "Administrar correo web",
"Admin Mailing Template" => "Modelo de administrar entrada de correo",
"Admin Menu Builder" => "Administrar construtor de menús",
"Admin Menus Template" => "Modelo administrar menús",
"Admin Modules Template" => "Modelo de administrar módulos",
"Assign Module" => "Asignar módulo",
"subscribed" => "subscrito",
"Admin Newsletters Template" => "Modelo de administrar boletíns",
"Admin Notifications Template" => "Modelo de administrar notificacións",
"Admin Polls Template" => "Modelo de administrar votacións",
"Configure Polls" => "Configurar votacións",
"tiki admin quicktags template" => "modelo tiki de administrar etiquetas rápidas ",
"Score System" => "Sistema de Puntuación",
"security admin" => "Administrar seguridade",
"security admin tpl" => "Modelo de administrar seguridade",
"Admin Shoutbox Words Template" => "Modelo de administrar palabras do taboleiro de anuncios",
"Edit survey questions" => "Editar preguntas da enquisa",
"administer surveys template" => "modelo de administrar enquisas",
"system admin" => "administración de sistema",
"system admin tpl" => "modelo de administración do sistema",
"Admin Topics Template" => "Modelo para administrar temas",
"Admin Tracker" => "Administrar tracker",
"Admin Users Template" => "Modelo de administrar usuarios",
"Again" => "Outra vez",
"Article Types tpl" => "modelo para tipos de artigo",
"Assign permissions to group" => "Asignar permisos ao grupo",
"Edit Article Tpl" => "Modelo de editar artigo ",
"Browsing Gallery" => "Navegando pola Galería",
"Admin Directory tpl" => "Modelo de administrar directorio",
"Admin Directory Categories tpl" => "Modelo de administrar categorías de directorio",
"Admin Directory Related" => "Administrar directorio relacionado",
"directory admin related tpl" => "modelo de administrar categorías relacionadas",
"Admin Directory Sites" => "Administrar sitios de directorio",
"Admin Directory Sites tpl" => "modelo de administrar sitios de directorio",
"Validate Sites" => "Validar Sitios",
"directory validate sites tpl" => "modelo de validar sitios de directorio",
"Edit Article" => "Editar artigo",
"Edit Blog Tpl" => "Modelo de editar blog",
"Show Plugins Help" => "Ver axuda de plugins",
"Show Text Formatting Rules" => "Ver Regras para Formatar texto",
"Program dynamic content for block" => "Programar contido dinámico para o bloque",
"Admin quizzes" => "Administrar cuestionarios",
"Admin Quizzes tpl" => "Modelo de administrar cuestionarios",
"Edit Quiz Questions" => "Editar preguntas do cuestionario",
"Edit Quiz Questions Tpl" => "Modelo de editar preguntas do cuestionario",
"Help on Articles" => "Axuda en artigos",
"Edit Submissions Tpl" => "Modelo de editar colaboracións",
"EditTemplates" => "EditarModelos",
"EditTemplates tpl" => "Modelo de EditarModelos",
"Edit Translations" => "Editar traducións",
"Edit Translations Template" => "Modelo de editar traducións",
"Message queue for" => "Cola de mensaxes para",
"back to forum" => "volver ao foro",
"Reported messages for" => "Mensaxes notificadas para",
"friends tpl" => "modelo de amigos",
"galleries tpl" => "modelo de galerías ",
"tiki-import_phpwiki tpl" => "Modelo de tiki-import_phpwiki",
"hist" => "hist.",
"List Articles Tpl" => "Modelo de listar artigos",
"Admin Cache" => "Administrar caché",
"Admin Cache tpl" => "Modelo de administrar caché",
"Help on Dynamic Content" => "Axuda en contido dinámico",
"List FAQs Tpl" => "Modelo de listar pmfs",
"games tpl" => "modelo de xogos ",
"List Posts Tpl" => "Modelo para listar envíos",
"List Quizzes Tpl" => "Modelo de listar cuestionarios",
"Edit Quiz Stats Tpl" => "Modelo de editar estatísticas do cuestionario",
"List Trackers Tpl" => "Modelo de listar trackers",
"Admin Live Support tpl" => "Modelo de administrar asistencia en liña",
"back to admin" => "volver a administración",
"User Calendar" => "Calendario do usuario",
"User Calendar Doc tpl" => "modelo de Calendario de Usuario",
"User Calendar Doc" => "Documentación de Calendario de Usuario",
"User Calendar Preferences Doc tpl" => "Modelo de Preferencias de Calendario do Usuario",
"my tiki tpl" => "modelo de O meu tiki",
"Subscribe to This Newsletter" => "Subscribirse",
"Stats for quiz" => "Estatísticas para cuestionario",
"Received Articles" => "Artigos recibidos",
"received articles tpl" => "modelo de artigos recibidos",
"Help on Communication Center" => "Axuda sobre Centro de Comunicacións",
"received pages tpl" => "modelo de páxinas recibidas",
"Rename page" => "Renomear a páxina",
"to_version" => "á versión",
"search stats tpl" => "modelo de estatísticas de busca",
"Admin Send Objects tpl" => "Modelo de administrar envío de obxectos",
"sheets tpl" => "modelo de follas de cálculo",
"Stats for survey" => "Estatísticas para a enquisa",
"system logs" => "rexistro do sistema",
"system logs tpl" => "modelo de rexistro do sistema",
"Theme Control Center: categories" => "Centro de Control de Decorados: categorías",
"ThemeControl" => "ControlDeDecorados",
"ThemeControl tpl" => "modelo de ControlDe Decorados",
"ThemeControl Objects" => "Obxectos de ControlDeDecorados ",
"theme control objects tpl" => "modelo de obxectos de control de decorados",
"Theme Control Center: sections" => "Centro de Control de Decorados: seccións",
"theme control sections tpl" => "modelo de seccións de control de decorado",
"File Title" => "Título do ficheiro",
"Image Gallery tpl" => "Modelo de Galería de Imágenes",
"User Assigned Modules" => "Módulos Asignados polo Usuario",
"User Assigned Modules tpl" => "modelo de Módulos asignados polo usuario",
"User Bookmarks tpl" => "modelo de marcadores de usuario",
"UserPreferences tpl" => "Modelo de preferencias de usuario",
"User Tasks tpl" => "modelo de Tarefas de Usuario",
"User Watches tpl" => "Modelo de monitores de usuario",
"View FAQ Tpl" => "Modelo de ver pmf",
"Admin Menus tpl" => "Modelo de administrar menús",
"IRC log" => "log de IRC",
"Edit mail account" => "Editar conta de correo",
"Add new mail account" => "Engadir conta de correo",
"User accounts" => "Contas de usuario",
"View All" => "Visualizar todos",
"Msg" => "Msx",
"Can't parse remote HTML page" => "Non podo procesar unha páxina HTML remota",
"Permission denied you cannot remove pages" => "Permiso denegado: non pode borrar páxinas",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"LDAP User OC" => "LDAP User OC",
"LDAP Group Attribute" => "LDAP Group Attribute",
"LDAP Member Is DN" => "LDAP Member Is DN",
"LDAP Admin User" => "LDAP Admin User",
"LDAP Admin Pwd" => "LDAP Admin Pwd",
"Geourl" => "Geourl",
"meta robots" => "meta robots",
"Zoom" => "Zoom",
"SysLog" => "SysLog",
"Cannot write to this file" => "Non podo escribir neste ficheiro",
"Missing title or body when trying to post a comment" => "Falta o título ou o texto",
"\\n for rows" => "\\n para filas",
"Use this thread to discuss the %s page." => "Use esta liña para discutir a páxina %s.",
"Newsletter subscription information at " => "Información de subscrición a boletín en ",
"Changes" => "Cambios",
"categorize this object" => "categorizar este obxecto",
"Your account request have been stored and will be activated by the admin as soon as possible." => "A súa solicitude de conta foi almacenado e será activado polo administrador o máis axiña posible.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Novo artigo enviado: {\$mail_title} por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"New article post at %s" => "Novo artigo enviado en %s",
"Syntax highlighting" => "Resaltado de Sintaxe",
"MyTiki Home" => "Inicio do meu Tiki",
"My Files" => "Os meus ficheiros",
"Mini calendar" => "Calendario",
"FriendsMenu" => "Menú de amigos",
"User list" => "Lista de usuarios",
"Dump" => "Envorcado",
"Send Pages" => "Enviar páxinas",
"Received pages" => "Páxinas recibidas",
"Admin Posts" => "Administrar mensaxes",
"Submit a New Link" => "Enviar unha nova ligazón",
"Browse directory" => "Explorar directorio",
"Admin Directory" => "Administrar directorio",
"Layer Management" => "Xestión de capas",
"List quizzes" => "Listar cuestionarios",
"ShtMenu" => "ShtMenú",
"List trackers" => "Listar trackers",
"Ephemerides Admin" => "Administrar efemérides",
"Charts Admin" => "Administrar gráficas",
"Debugger console" => "Consola de depuración",
"I forgot my pass" => "Esquecín o meu contrasinal",
"Click to see the ratings" => "Prema para ver as cualificacións",
"Send trackback pings to:" => "Enviar pings de trackback a:",
"(comma separated list of URIs)" => "(lista de URIs separadas por comas)",
"This is" => "Isto é",
"by the" => "pola",
"Tiki community" => "Comunidade Tiki",
"User identity features" => "Características da identidade do usuario",
"Use URI as Home Page" => "Usar URI como páxina de inicio",
"OS" => "Sistema operativo",
"Default charset for sending mail:" => "Conxunto de xogo de caracteres por defecto para enviar correo:",
"Mail end of line:" => "Fin de liña do correo:",
"Disallow access to the site (except for those with permission)" => "Desactivar o acceso ao sitio (agás para aqueles con permiso)",
"Message to display when site is closed" => "Mensaxe para mostrar cando o sitio está pechado",
"Disallow access when load is above the threshold (except for those with permission)" => "Desactivar o acceso cando a carga estea por riba do límite (agás para aqueles con permiso)",
"Max average server load threshold in the last minute" => "Límite máximo de carga media do servidor no último minuto",
"Message to display when server is too busy" => "Mensaxe para mostrar cando o servidor está moi ocupado",
"Use cache for external images" => "Usar caché para as imaxes externas",
"Use gzipped output" => "Usar saída comprimida con gzip",
"output compression is active." => "a compresión de saída está activa.",
"compression is handled by" => "a compresión é manexada por",
"Sender Email" => "Correo remitente",
"Allow anonymous users to \"Contact Us\"" => "Permitir a usuarios anónimos o \"Contactarnos\"",
"contact feature disabled" => "Función de contacto deshabilitada",
"Session lifetime in minutes" => "Tempo de vida da sesión en minutos",
"Proxy Host" => "Servidor Proxy",
"Locations separator" => "Separador de localizacións",
"User registration and login" => "Rexistro e inicio de sesión do usuario",
"Use WebServer authentication for Tiki" => "Usar autenticación do servidor web para o Tiki",
"... but need admin validation" => "... pero precisa a validación de admin",
"Use tracker for more user information" => "Usar o tracker para máis información dos usuarios",
"Use tracker for more group information" => "Usar o tracker para máis información dos grupos",
"Request passcode to register" => "Solicitar código de paso para rexistrarse",
"Php GD library required" => "biblioteca Php GD requirida",
"Validate users by email" => "Validar usuarios por correo",
"Store plaintext passwords" => "Gardar os contrasinais en texto simple",
"Reg users can change password" => "Os usuarios rexistrados poden cambiar de contrasinal",
"Reg users can change language" => "Os usuarios rexistrados poden cambiar de lingua",
"Restrict available languages" => "Restrinxir linguas dispoñibles",
"Available languages:" => "Linguas dispoñibles:",
"Force to use chars and nums in passwords" => "Obrigar a usar letras e números nos contrasinais",
"Minimum password length" => "Lonxitude mínima do contrasinal",
"Password invalid after days" => "Invalidar contrasinal logo de días",
"Remember me feature" => "Características Recordarme",
"Remember me name" => "Nome para Recordarme",
"Remember me domain" => "Dominio para Recordarme",
"Remember me path" => "Camiño para Recordarme",
"Protect against CSRF with a confirmation step" => "Protexer contra CSRF cun paso de confirmación",
"Highlight Group" => "Destacar Grupo",
"Create user if not in Tiki?" => "Crear usuario se non estiver no Tiki?",
"Create user if not in Auth?" => "Crear usuario se non estiver en Auth",
"Just use Tiki auth for admin?" => "Usar só a autenticación do Tiki para o administrador?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "URL de LDAP<br />(se posta, prevalecerá sobre o servidor e o porto que seguen)",
"LDAP Host" => "Servidor LDAP",
"LDAP Port" => "Porto LDAP",
"LDAP Scope" => "Scope LDAP",
"LDAP User Attribute" => "LDAP User Attribute LDAP",
"LDAP Group DN" => "LDAP Grupo DN",
"LDAP Group OC" => "LDAP Grupo OC",
"LDAP Member Attribute" => " LDAP Member Attribute",
"CAS server hostname" => "Nome do servidor CAS",
"CAS server port" => "Porto do servidor CAS",
"CAS server path" => "Ruta do servidor CAS",
"Change CAS preferences" => "Cambiar as preferencias CAS",
"Meta Keywords" => "Meta palabras clave",
"Meta Description" => "Meta descrición",
"Meta Author" => "Meta Autor",
"revisit after" => "revisitar despois",
"Allow Smileys" => "Permitir emoticonas",
"Hotwords in New Windows" => "Palabras clave en novas fiestras",
"Trackers attachments preferences" => "Preferencias de anexos a trackers",
"Trackers attachments" => "Arquivos asociados a trackers",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Para agregar/editar páxinas wiki facilmente, agregue o módulo quick_edit via \"Módulos\" no menú de aplicación, ou",
"Create a Tag for the Current Wiki" => "Crear unha etiqueta para o wiki actual",
"Restore the Wiki" => "Restaurar o wiki",
"restore" => "recuperar",
"Remove a Tag" => "Quitar unha etiqueta",
"Wiki Comments Settings" => "Configuracións para comentarios do wiki",
"Wiki Administration" => "Administración wiki",
"Wiki Home Page" => "Páxina de Inicio do Wiki",
"Wiki Discussion" => "Discusión Wiki",
"Wiki Link Format" => "Formato de Ligazón Wiki",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controla o recoñecemento de ligazóns Wiki usando a sintaxe de ligazóns wiki de dúas parénteses <i>((nome páxina))</i>.",
"Wiki Page List Configuration" => "Configuración da listaxe de páxinas wiki",
"Wiki Features" => "Características do Wiki",
"Wiki History" => "Historial do Wiki",
"Wiki Watch" => "Monitor do Wiki",
"browse the category system" => "percorrer o sistema de categorías",
"Admin Charts" => "Administrar gráficas",
"Add new rule" => "Engadir nova regra",
"EMail notifications" => "Notificacións por correo-e",
"Edit this RSS module:" => "Editar este módulo RSS:",
"Create new RSS module" => "Crear novo módulo RSS",
"Tikiwiki settings" => "Configuracións para o Tikiwiki",
"Create/edit questions for survey" => "Crear/editar preguntas para enquisa",
"Active?" => "Activo?",
"Create Trackers" => "Crear trackers ",
"Create/Edit Trackers" => "Crear/editar trackers",
"Create item" => "Crear ítem",
"Assign to Groups" => "Asignar a grupos",
"Delete this type" => "Borrar este tipo",
"Browse gallery" => "Percorrer galería",
"Upload from disk" => "Cargar desde disco",
"Directory batch" => "Carga de directorio",
"Browsing Image" => "Explorando imaxe",
"Again please" => "Repetir, por favor",
"Admin category relationships" => "Administrar as relacións entre categorías",
"Validate links" => "Validar ligazóns",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Os ficheiros con nomes rematados en -{\$user} son modificables, outros son só duplicables e serán usados como modelo.",
"Im- Export Languages" => "Importar ou exportar linguas",
"disable" => "desactivar",
"Create a file gallery" => "Crear galería de ficheiros",
"Support tickets" => "Tíckets de asistencia",
"Return to HomePage" => "Regresar ao inicio",
"Stats for this survey Questions " => "Estatísticas para as preguntas desta enquisa",
"Batch upload" => "Carga por lote",
"1 suggestion" => "1 suxestión",
"suggestions" => "suxestións",
"Minor Edit" => "Menor",
"You can not download files" => "Non pode descargar ficheiros",
"cannot be found" => "non se pode atopar",
"Invalid password.  Your current password is required to change administrative information" => "Contrasinal incorrecto. Requírese o seu contrasinal actual para cambiar información administrativa",
"Please wait 2 minutes between posts" => "Por favor, espere dous minutos entre as mensaxes",
"The text in RED is" => "O texto en VERMELLO é",
"Show Categories" => "Mostrar categorías",
"Hide Categories" => "Ocultar categorías",
"Wiki page %s changed" => "A páxina Wiki %s cambiou",
"Blog features" => "Características dos blogs",
"Blog level comments" => "Comentarios para blogs",
"Post level comments" => "Comentarios para artigos",
"Spellchecking" => "Comprobación ortográfica",
"Default ordering for blog listing" => "Ordenación por defecto para listaxe de blogs",
"Blog listing configuration (when listing available blogs)" => "Configuración de listaxe de blog (cando liste blogs dispoñibles)",
"Last modification time" => "Data da última modificación",
"Blog comments settings" => "Configuración de comentarios en blogs",
"Group calendar sticky popup" => "Emerxente pegañento do calendario de grupo",
"Group calendar item view tab" => "Lingüeta de visualización do ítem do calendario de grupo",
"Show Category Path" => "Mostrar o camiño das categorías",
"Show Category Objects" => "Mostrar obxectos da categoría",
"Search may show forbidden results. Much better performance though." => "A busca pode devolver resultados prohibidos, pero xeran moito mellor rendemento.",
"CMS features" => "Características do CMS",
"Use templates" => "Usar modelo",
"Settings for page articles home" => "Opcións para páxina de inicio de artigos",
"Maximum number of articles in home" => "Cantidade máxima de artigos no inicio",
"Article comments settings" => "Configuracións para comentarios de artigos",
"Fields to display on page" => "Campos para mostrar na páxina",
"Expire Date" => "Data de expiración",
"Copyright Management" => "Xestión de dereitos de copia",
"License Page" => "Páxina de licenza",
"Submit Notice" => "Enviar aviso",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Para agregar/borrar galerías de ficheiros, vaia a \"Galerías de Ficheiros\" no menú de aplicación, ou",
"Uploaded filenames cannot match regex" => "Os nomes dos ficheiros cargados non deben emparellar con esta expresión regular",
"File galleries comments settings" => "Configuración dos comentarios das galerías de ficheiros",
"File galleries search indexing" => "Indexado para a busca de galerías de ficheiros",
"Leave command blank to delete handler" => "Deixe a orde en branco para borrar o manexador",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 onde o nome interno debe ser substituído (exemplo: \"strings %1\" para converter o documento en texto usando a orde strings de unix)",
"Enable auto indexing on file upload or change" => "Activar auto-indexado en caso de carga ou cambio de ficheiro",
"System command" => "Orde de sistema",
"Home Forum" => "Foro inicial",
"Forums features" => "Características dos foros",
"Forum quick jumps" => "Accesos rápidos de foros",
"Ordering for forums in the forum listing" => "Orde dos foros na lista de foros",
"Forum listing configuration" => "Configuración de listaxe de foros",
"Show Babelfish Translation URLs" => "Mostrar os URL de tradución de Babelfish",
"Show Babelfish Translation Logo" => "Mostrar logo de tradución de Babelfish",
"Show Module Controls" => "Mostrar controis de módulo",
"Users can Configure Modules" => "Os usuarios poden configurar os módulos",
"Users can Shade Modules" => "Os usuarios poden sombrear os módulos",
"module decides" => "módulo decide",
"Allow Anonymous Poll Voting" => "Permitir voto anónimo en votacións",
"Performance issues" => "Temas de rendemento",
"Search features" => "Funcións de busca",
"SearchStats" => "Estatística de busca",
"Settings for searching content" => "Configuración para buscar contido",
"Search refresh rate" => "Taxa de actualización de busca",
"this survey stats" => "estatísticas desta enquisa",
"bold" => "grosas",
"italic" => " cursiva ",
"underline" => "subliñado",
"hr" => "hr (liña horizontal de separación)",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./setup.sh\" for example)." => "Apache ten o dereito a escribir no seu sistema de ficheiros, que permite a instalación, borrado ou actualización de paquetes. Cando termine esas operacións, pense en volver eses permisos de novo a un estado seguro (usando ./setup.sh, p/ex)",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that permission (using \"./setup.sh\")." => "Para instalar, borrar ou actualizar paquetes, necesita darlle ao usuario do apache o dereito a escribir ficheiros na súa árbore web (pode usar \"./setup.sh open\" para deixalo así)). Despois da instalación debe borrar eses permisos (usando \"./setup.sh\").",
"You have {\$unread} unread private messages" => "Ten {\$unread} mensaxes privadas non lidas",
"unread private messages" => "mensaxes privadas sen ler",
"WfMenu" => "WfMenu",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"SrvMenu" => "SrvMenu",
"EphMenu" => "EphMenu",
"This module requires parameters trackerId and name set" => "Este módulo requiere cubrir os parámetros Idtracker e nome ",
"you or someone registered this email address at" => "vostede ou alguén rexitrou este enderezo de correo en",
"Your Tiki information registration" => "A súa información de rexistro no Tiki",
"Your registration" => "A súa información de rexistro no Tiki",
"left/right" => "esquerda/dereita",
"Unassign module" => "Inhabilitar módulo",
"home" => "inicio",
"chat" => "charla",
"contact us" => "Póñase en contacto con nós",
"debugger console" => "consola de depuración",
"MyMenu" => "O meu menú",
"User menu" => "Menú do usuario",
"WikiMenu" => "Menú Wiki",
"dump" => "envorcado",
"rankings" => "clasificacións ",
"orphan pages" => "páxinas orfas",
"sandbox" => "caixa de area ",
"received pages" => "páxinas recibidas",
"structures" => "estruturas",
"GalMenu" => "Menú de galerías de imaxes",
"Articles Home" => "Inicio de artigos",
"Send articles" => "Enviar artigos",
"Create/Edit Blog" => "Crear/Editar blog",
"Browse Directory" => "Explorar directorio",
"FileGalMenu" => "MenúGalFicheiro",
"Admin FAQs" => "Administrar PMF",
"Edit mapfiles" => "Editar ficheiros de mapa",
"QuizMenu" => "QuizMenú",
"Admin quiz" => "Administrar cuestionario",
"TrkMenu" => "TrkMenú",
"Admin trackers" => "Administrar os trackers",
"Send newsletters" => "Enviar boletíns",
"Send events" => "Enviar eventos",
"Admin events" => "Administrar eventos",
"Ephemerides" => "Efemérides",
"ChartMenu" => "Menú de gráficos",
"AdmMenu" => "MenúAdm",
"Admin home" => "Inicio de Administración ",
"Backups" => "Copias de seguridade",
"Edit languages" => "Editar linguaxes",
"External wikis" => "Wikis externos",
"Mods Admin" => "Administrar Mods",
"UsrMenu" => "Menú usuario",
"Click here to manage your personal menu" => "Prema aquí para manexar o seu menú persoal",
"Quick edit a Wiki page" => "Edición rápida de páxina wiki",
"Language: " => "Lingua: ",
"Sort posts by:" => "Ordenar artigos por:",
"read more" => "ler más",
"Pass" => "contrasinal",
"System Admin" => "Administrar sistema",
"Misc" => "Misc",
"Displays an miniquiz" => "Amosa un minicuestionario",
"some text" => "algún texto",
"Creates a box with the data" => "Crea unha caixa cos datos",
"creates a title bar" => "crea unha barra de título",
"creates a table" => "crea unha táboa",
"makes a horizontal rule" => "fai unha liña horizontal",
"page|desc" => "páxina|desc",
"displays an image" => "mostra unha imaxe",
"Non cacheable images" => "Imaxes non almacenables en caché",
"height width desc link and align are optional" => " height (altura), width (anchura), desc (descrición), link (ligazón) e align (aliñación) son opcionais",
"Wiki File Attachments" => "Anexos ao Wiki",
"displays rss feed with id=n maximum=m items" => "mostra a fonte rss con id=n e cantidade máxima de ítems=m",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Será substituído polo valor actual do bloque de contido dinámico con id=n",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" imprime unha táboa de contidos para a páxina actual baseada en estruturas (toc) ou encabezados! (maketoc)",
"Unix" => "Unix",
"Windows" => "Windows",
"PEAR::Auth" => "PEAR::Auth",
"Editor" => "Editor",
"phpLayersMenus" => "phpLayersMenus",
"Int" => "Int",
"Manual" => "Manual",
"inter" => "inter",
"val" => "val",
"ver:" => "ver:",
"If:SetNextact" => "If:SetNextact",
"/" => "/",
"This instance of activity is already complete" => "Este exemplo de actividade xa está completado",
"Fatal error: cannot execute automatic activity \$activityId" => "Erro moi grave: non podo executar a actividade automática \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Erro moi grave: poñer a seguinte actividade a unha actividade inexistente",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Erro moi grave: nextActivity non se corresponde con ningún candidato en cambio de actividade programada",
"Fatal error: non-deterministic decision for autorouting activity" => "Erro moi grave: decisión non determinista para a actividade de autoencamiñar",
"Fatal error: trying to send an instance to an activity but no transition found" => "Erro moi grave: intentando enviar un exemplar para unha actividade, pero non se atopou transición",
"Cannot add transition only split activities can have more than one outbound transition" => "Non podo engadir transición, só actividades divididas poden ter máis dunha transición saínte",
"Circular reference found some activity has a transition leading to itself" => "Referencia circular encontrada, algunha actividade ten unha transición que leva a si mesma",
"Process does not have a start activity" => "O proceso non ten ningunha actividade inicial",
"Process does not have exactly one end activity" => "O proceso non ten exactamente unha actividade final",
"End activity is not reachable from start activity" => "A actividade final non é alcanzable desde a actividade inicial",
"is interactive but has no role assigned" => "é interactiva pero non ten rol asignado",
"is non-interactive and non-autorouted but has no role assigned" => "é non interactiva e non autoencamiñada pero non ten perfil asignado",
"is standalone but has transitions" => "é independente pero ten transicións",
"Role" => "Rol",
"is not mapped" => "non está asociada",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "A actividade '.\$res['name'].' é independente e usa o obxecto \$instance",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "A actividade '.\$res['name'].' é interactiva, polo que ten que usar o método \$instance->complete()",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "A actividade '.\$res['name'].' é non-interactiva, polo que non debe usar o método \$instance->complete()",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "A actividade '.\$res['name'].' é cambio, polo que debe usar o método \$instance->setNextActivity(\$actname)",
"Process %d has been activated" => "O proceso %d foi activado",
"Process %d has been deactivated" => "O proceso %d foi desactivado",
"Process %s %s imported" => "Proceso %s %s importado",
"Process %s removed" => "O proceso %s foi eliminado",
"Process %s has been updated" => "O proceso %s foi actualizado",
"Process %s has been created" => "O proceso %s foi creado",
"<return> for rows" => "\\n para filas",
"Any 2 versions" => "Dúas versións calquera",
"latin" => "latino",
"english" => "inglés",
"Report all errors except notices" => "Informar todos os erros agás as notificacións",
"1 day" => "1 día",
"1 week" => "1 semana",
"1 month" => "1 mes",
"Just Tiki" => "Só Tiki",
"Tiki and PEAR::Auth" => "Tiki e PEAR::Auth",
"choose a group ..." => "elixa un grupo...",
"%s enabled" => "%s activado",
"%s disabled" => "%s desactivado",
"Charts" => "Gráficos",
"Forums last topics" => "Últimos temas nos foros ",
"An error occured in a database query!" => "Ocorreu un erro nunha consulta á base de datos!",
"games" => "xogos",
"Altering database table failed" => "Alterar a táboa da base de datos fallou",
"Insert a division block on wiki page" => "Insire un bloque divisor nunha páxina wiki",
"drawing not found" => "debuxo non atopado",
"heads and cells separated by ~|~" => "cabeceiras e celas separadas por ~|~",
"Please provide an Id" => "Por favor, introduza un Id",
"Quicktags" => "Etiquetas rápidas",
"Listing configuration" => "Configuración de listaxe",
"best regards" => "da nosa maior consideración",
"your Tikiwiki" => "o seu Tikiwiki",
"Tiki User Registration Request" => "Solicitude de rexistro de usuario Tiki",
"Tiki email notification" => "Notificación de correo do Tiki",
"Your Tiki account information for %s" => "A súa información de conta Tiki para %s",
"QuickTags" => "Etiquetas rápidas",
"TikiWiki Assistant" => "Asistente Tikiwiki",
"Recently visited pages" => "Páxinas recentemente visitadas",
"Last `\$module_rows` Sites" => "Últimos `\$module_rows` sitios",
"Last Sites" => "Últimos sitios",
"Directory Stats" => "Estatísticas de directorio",
"Sites to validate" => "Sitios para validar",
"Visited links" => "Ligazóns visitadas",
"Top \$module_rows Sites" => "\$module_rows principais sitios",
"Top Sites" => "Sitios máis visitados",
"Top `\$module_rows` topics" => "`\$module_rows` principais temas",
"Last `\$module_rows` forum posts" => "Últimos `\$module_rows` artigos no foro",
"Last `\$module_rows` forum topics" => "Últimos `\$module_rows` temas en foros",
"Last `\$module_rows` actions" => "Últimas `\$module_rows` accións",
"Last `\$module_rows` articles" => "Últimos `\$module_rows` artigos",
"Last articles" => "Últimos artigos",
"Last `\$module_rows` blog posts" => "Últimos `\$module_rows` artigos ao blog",
"Last `\$module_rows` Created blogs" => "Últimos `\$module_rows` blogs creados",
"Last `\$module_rows` Created FAQs" => "Últimas `\$module_rows` PMF creadas",
"Last `\$module_rows` Created Quizzes" => "Últimos `\$module_rows` cuestionarios creados",
"Last `\$module_rows` modified file galleries" => "Últimas `\$module_rows` galerías de ficheiros modificadas",
"Last `\$module_rows` Files" => "Últimos `\$module_rows` ficheiros",
"Last `\$module_rows` galleries" => "Últimas `\$module_rows` galerías",
"Last galleries" => "Últimas galerías",
"Last `\$module_rows` Images" => "Últimas `\$module_rows` imaxes",
"Last `\$module_rows` modified events" => "Últimos `\$module_rows` eventos modificados",
"Last `\$module_rows` changes" => "Últimos `\$module_rows` cambios",
"Last `\$module_rows` Modified Items" => "Últimos `\$module_rows` ítems modificados",
"Last `\$module_rows` Modified blogs" => "Últimos `\$module_rows` blogs modificados",
"Last `\$module_rows` submissions" => "Últimas `\$module_rows` colaboracións",
"Last `\$module_rows` Items" => "Últimos `\$module_rows` ítems",
"Menu" => "Menú",
"New Messages" => "Novas mensaxes",
"New Message" => "Nova mensaxe",
"Top `\$module_rows` articles" => "Mellores`\$module_rows` artigos",
"Top `\$module_rows` File Galleries" => "`\$module_rows` principais galerías de ficheiros",
"Top `\$module_rows` files" => "`\$module_rows` principais ficheiros",
"Top `\$module_rows` Forum Posters" => "Principais `\$module_rows` participantes en Foros",
"Top `\$module_rows` games" => "`\$module_rows` xogos principais",
"Top games" => "Xogos principais",
"Top `\$module_rows` galleries" => "`\$module_rows` Galerías principais ",
"Top `\$module_rows` Images" => "`\$module_rows` Imaxes principais",
"Top `\$module_rows` Pages" => "`\$module_rows` Páxinas principais",
"Top `\$module_rows` Quizzes" => "`\$module_rows` Cuestionarios principais",
"Most `\$module_rows` visited blogs" => "`\$module_rows` blogs máis visitados",
"Top `\$module_rows` Visited FAQs" => "`\$module_rows` PMF máis visitadas",
"Whats related" => "O que está relacionado",
"Last `\$module_rows` wiki comments" => "Últimos `\$module_rows` comentarios wiki",
"on page" => "a páxina",
"show structures" => "mostrar estruturas",
"hide structures" => "ocultar estruturas",
"Creation date" => "Data de creación",
"My workflow" => "O meu fluxo de traballo",
"Feature" => "Característica",
"Number of columns per page when listing categories" => "Número de columnas por páxina cando se listan categorías",
"enable cool sites" => "activar sitios interesantes",
"Featured Help" => "Axuda en Ligazóns Destacadas",
"JsCalendar" => "CalendarioJs",
"PhpLayers Dynamic menus" => "Menús dinámicos PhpLayers",
"Tiki Sheet" => "Folla de cálculo Tiki",
"Drawings" => "Ilustracións",
"Games" => "Xogos",
"Administration Features" => "Características da Administración",
"Banning System" => "Sistema de Expulsión",
"User Features" => "Características do usuario",
"Newsreader" => "Novas",
"Workflow" => "Fluxo de traballo",
"Workflow engine" => "Motor de fluxo de traballo",
"Unknown/Other" => "Descoñecido/Outro",
"(standard)" => "(estándar)",
"(some Unix MTA)" => "(algún MTA de Unix)",
"Tikiwiki.org help" => "Axuda Tikiwiki.org",
"Store session data in database" => "Gardar datos da sesión na base de datos",
"Long date format" => "Formato longo para as datas",
"Short date format" => "Formato curto para as datas",
"Long time format" => "Formato longo para as horas",
"Short time format" => "Formato curto para as horas",
"New password" => "Novo contrasinal",
"HTTP port" => "porto HTTP",
"HTTPS port" => "port HTTPS",
"PAM service" => "Servizo PAM",
"CAS server version" => "Versión do servidor CAS",
"Reg users can change theme" => "Os usuarios rexistrados poden cambiar de decoración",
"Slideshows theme" => "Decoración para diapositivas",
"Template Viewing" => "Vista de modelos",
"Site logo background color" => "Cor de fondo do logo do sitio",
"Site logo title (on mouse over)" => "Título do logo do sitio (aparece cando o rato pasa por riba)",
"Site Breadcrumbs" => "Ruta de acceso do sitio",
"at top of page" => "ao tope da páxina",
"at top of center column" => "ao tope da columna central",
"entire location" => "toda a localización",
"page name" => "nome dz páxina",
"Default RDF version" => "Versión por defecto de RDF",
"Webmaster" => "Administrador da web",
"hits" => "accesos",
"Individual cache" => "Caché individual",
"Perms inherited from closest parent if possible or from global perms" => "Permisos herdados do antecesor máis achegado de ser posible ou de permisos globais",
"Assign permissions automatically" => "Asignar permisos automaticamente",
"recommended for best performance" => "recomendado para mellor rendemento",
"image gal" => "galería de imaxes",
"file gal" => "galería de ficheiros",
"Admin chart items" => "Administrar ítems de charts",
"Edit Chart" => "Editar chart",
"Chart items" => "Ítems de chart",
"No items defined yet" => "Aínda non hai ítems definidos",
"Add or edit a chart" => "Engadir ou editar un chart",
"Users can vote for only one item from this chart per period" => "Os usuarios poden votar só por un ítem deste chart por período",
"Prevent users from voting for the same item more than once" => "Previr os usuarios de votar polo mesmo ítem máis dunha vez",
"Users can suggest new items" => "Os usuarios poden suxerir novos ítems",
"Auto validate user suggestions" => "Autovalidar suxestións do usuario",
"Ranking shows" => "Clasificación mostra",
"All items" => "Todos os ítems",
"Top 10 items" => "Os 10 ítems primeiros",
"Top 20 items" => "Os 20 ítems primeiros",
"Top 40 items" => "Os 40 ítems primeiros",
"Top 50 items" => "Os 50 ítems primeiros",
"Top 100 items" => "Os 100 ítems primeiros",
"Top 250 items" => "Os 250 ítems primeiros ",
"Voting system" => "Sistema de votación",
"Vote items" => "Votar ítems",
"Rank 1..5" => "Puntuación 1..5",
"Rank 1..10" => "Puntuación 1..10",
"Ranking frequency" => "Frecuencia de clasificación",
"Realtime" => "Tempo real",
"Each 5 minutes" => "Cada 5 minutos",
"Show Average" => "Mostrar media",
"Show Votes" => "Mostrar votos",
"Use Cookies for unregistered users" => "Usar cuquis para usuarios non rexistrados",
"Users can vote again after" => "Os usuarios poden votar de novo despois de",
"Anytime" => "En calquera momento",
"Ranks" => "Puntuacións",
"No charts defined yet" => "Aínda non se definiron charts",
"Admin drawings" => "Administrar ilustracións",
"Available drawings" => "Ilustracións dispoñibles",
"Ver" => "Versión",
"no display" => "non mostrar",
"Available polls" => "Votacións dispoñibles",
"Random image from" => "Imaxe ao chou de",
"Dynamic content blocks" => "Bloques de contido dinámico",
"Banner zones" => "Zonas de pancartas",
"Group users" => "Usuarios do grupo",
"Admin Quicktags" => "Administrar Etiquetas rápidas",
"Create/Edit QuickTags" => "Crear/Editar etiquetas rápidas",
"Insert (use 'text' for figuring the selection)" => "Inserir (use 'text' para determinar a selección)",
"Path to the tag icon" => "Camiño á icona da etiqueta",
"Admin RSS Modules" => "Administrar módulos RSS",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Esta páxina é para configurar preferencias de fontes RSS lidas/importados por Tiki. Para xerar/exportar fontes RSS, busque \"Fontes RSS\" no panel de administración, ou",
"show feed title" => "mostrar título da fonte",
"show publish date" => "mostrar data de publicación",
"Templates compiler" => "Compilador de modelos",
"Compile" => "Compilar",
"Member of the default group of creator can modify items?" => "O membro do grupo por defecto do creador pode modificar os ítems?",
"Group Homepage" => "Páxina de inicio de grupo",
"Members List" => "Lista de membros",
"Rejected users" => "Usuarios rexeitados",
"Edit Account Settings" => "Editar opcións de conta",
"Set the default group of the selected users to" => "Poña o grupo por defecto dos usuarios seleccionados en",
"Default Group" => "Grupo por defecto",
"Old password" => "Contrasinal actual",
"Parent category" => "Categoría superior",
"Most visited sub-categories" => "Subcategorías máis visitadas",
"Category description" => "Descrición de categoría",
"Random sub-categories" => "Subcategorías ao chou",
"Allow sites in this category" => "Permitir sitios nesta categoría",
"Show number of sites in this category" => "Mostrar número de sitios nesta categoría",
"Subcategories" => "Subcategorías",
"Admin related categories" => "Administrar categorías relacionadas",
"Add a related category" => "Engadir unha categoría relacionada",
"Related categories" => "Categorías relacionadas",
"Add a Category" => "Agregar categoría",
"in current category" => "na categoría actual",
"Total categories" => "Total de categorías",
"creates the editable drawing foo" => "crea o debuxo editable foo",
"table" => "táboa (sintaxe nova fila = ||)",
"table new" => "nova táboa(sintaxe nova fila = nova liña)",
"external link" => "ligazón externa",
"wiki link'" => "ligazón wiki'",
"heading1" => "encabezado1",
"title bar" => "barra de título",
"box" => "caixa",
"rss feed" => "fonte rss ",
"dynamic content" => "contido dinámico",
"tagline" => "cuqui da sorte ",
"center text" => "centrar texto",
"colored text" => "texto en cores",
"dynamic variable" => "variables dinámicas",
"New wms Metadata" => "Novo metadato wms",
"New Class" => "Nova clase",
"New Projection" => "Nova proxección",
"New Query" => "Nova consulta",
"New Scalebar" => "Nova barra de escala",
"New Layer" => "Nova capa",
"New Label" => "Nova etiqueta",
"New Reference" => "Nova referencia",
"New Legend" => "Nova lenda",
"New Web" => "Nova web",
"New Outputformat" => "Novo formato de saída",
"New Mapfile" => "Novo ficheiro de mapa",
"special chars" => "caracteres especiais",
"special characters" => "caracteres especiais",
"Questions per page" => "Preguntas por páxina",
"Activity completed" => "Actividade completada",
"Admin process activities" => "Administrar actividades do proceso",
"Add or edit an activity" => "Engadir ou editar unha actividade",
"activity" => "actividade",
"split" => "dividir",
"join" => "unir",
"standalone" => "autónoma",
"interactive" => "interactiva",
"auto routed" => "auto encamiñada",
"Expiration Time" => "Tempo de expiración",
"Years" => "Anos",
"Months" => "Meses",
"Minutes" => "Minutos",
"Add transitions" => "Engadir transicións",
"Add transition from:" => "Engadir transición desde:",
"Add transition to:" => "Engadir transición a:",
"No roles associated to this activity" => "Non hai roles asociados a esta actividade",
"Add Role" => "Engadir rol",
"Add New" => "Engadir novo",
"Process activities" => "Actividades de proceso",
"Routing" => "Encamiñamentos",
"Interactive" => "Interactiva",
"Automatic" => "Automática",
"Auto routed" => "Auto encamiñada",
"route" => "camiño",
"(no roles)" => "(sen roles)",
"No activities defined yet" => "Non hai aínda actividades definidas",
"Process Transitions" => "Procesar transicións",
"List of transitions" => "Lista de transicións",
"Origin" => "Orixe",
"No transitions defined yet" => "Non hai aínda transicións definidas",
"Add a transition" => "Engadir transición",
"Process Graph" => " Grafo de proceso ",
"Galaxia Admin Graph" => "Galaxia Administrar Grafo",
"Galaxia Admin Graph tpl" => "modelo de Galaxia Administrar Grafo",
"Edit Tpl" => "Editar modelo",
"This process is invalid" => "Este proceso é incorrecto",
"Process Graph for" => "Procesar Grafo para",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Non hai grafo de proceso dispoñible. Ou o proceso aínda contén erros, ou o grafo non está xerado aínda ou <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> non está instalado axeitadamente.",
"List of processes" => "Lista de procesos",
"Inactive" => "Inactivo",
"Active Process" => "Proceso activo",
"Invalid Process" => "Proceso incorrecto",
"Valid Process" => "Proceso válido",
"Activities" => "Actividades",
"New Minor" => "Novo menor",
"New Major" => "Novo maior",
"No processes defined yet" => "Non hai procesos definidos aínda",
"Admin instance" => "Administrar instancia",
"Process:" => "Proceso:",
"Instance" => "Exemplar",
"Workitems" => "ítems de traballo",
"exception" => "excepción",
"completed" => "completada",
"Send all to" => "Enviar todo a ",
"Don't move" => "Non mover",
"Act status" => "Estado da actividade",
"Ended" => "Terminada",
"Not Defined" => "Non definido",
"Not Interactive" => "Non interactivo",
"Not Ended" => "Non terminada",
"Property" => "Propiedade",
"Add property" => "Engadir propiedade",
"run instance" => "executar exemplar",
"Executed" => "Executado",
"erase" => "borrar",
"Admin processes" => "Administrar procesos",
"Galaxia Admin Processes" => "Galaxia Administrar Procesos",
"Galaxia Admin Processes tpl" => "modelo de Galaxia Administrar Procesos",
"Add or edit a process" => "Engadir ou editar proceso",
"Process Name" => "Nome de proceso",
"is active?" => "está activo?",
"Or upload a process using this form" => "Ou cargue un proceso usando este formulario",
"Admin process roles" => "Administrar roles de proceso",
"Add or edit a role" => "Engadir ou editar un rol",
"Process roles" => "Procesar roles",
"No roles defined yet" => "Non hai aínda roles definidos",
"Map users to roles" => "Asociar usuarios a roles",
"map" => "asociar",
"Map groups to roles" => "Asociar grupos a roles",
"Operation" => "Operación",
"No roles are defined yet so no roles can be mapped" => "Non se definiron aínda roles, polo que non hai roles para asociar",
"List of mappings" => "Listaxe de asociacións",
"No mappings defined yet" => "Non se definiron aínda asociacións",
"Admin process sources" => "Administrar fontes de procesos",
"select source" => "seleccionar fonte",
"Shared code" => "Código compartido",
"Set next user" => "Configurar o seguinte usuario",
"Get property" => "Obter propiedade",
"Set property" => "Configurar propiedade",
"Process form" => "Formulario de proceso",
"Set Next act" => "Configurar seguinte actividade",
"Switch construct" => "Construción \"switch\"",
"Map process roles" => "Asociar roles de proceso",
"Admin Processes" => "Administrar procesos",
"Admin Activities" => "Administrar actividades",
"Admin Roles" => "Administrar roles",
"Edit this Process" => "Editar este proceso",
"Monitor Activities" => "Monitorizar actividades",
"Galaxia Monitor Activities" => "Galaxia Monitorizar Actividades",
"Galaxia Monitor Activities tpl" => "modelo de Galaxia Monitorizar Actividades",
"List of activities" => "Listaxe de actividades",
"Proc" => "Proc.",
"auto" => "auto.",
"int" => "int.",
"routing" => "encamiñamentos",
"Instances" => "Exemplares",
"run" => "executar",
"run activity" => "executar actividade",
"Enter the name of this instance" => "Introduza o nome deste exemplar",
"The name is not valid. Please, enter the name again" => "O nome non é válido, introdúzao de novo",
"monitor processes" => "monitorizar supervisar procesos",
"monitor activities" => "monitorizar supervisar actividades",
"monitor instances" => "monitorizar exemplares",
"monitor workitems" => "monitorizar ítems de traballo",
"Monitor Instances" => "Monitorizar exemplares",
"Galaxia Monitor Instances" => "Galaxia Monitorizar Exemplares",
"Galaxia Monitor Instances tpl" => "modelo de Galaxia Monitorizar Exemplares",
"List of instances" => "Lista de exemplares",
"Not ended" => "Non terminada",
"No instances created yet" => "Non se crearon aínda exemplares",
"Monitor Processes" => "Monitorizar procesos",
"Galaxia Monitor Processes" => "Galaxia Monitorizar Procesos",
"Galaxia Monitor Processes tpl" => "modelo de Galaxia Monitorizar Procesos",
"processes" => "procesos",
"being run" => "está a executarse",
"Exceptions" => "Excepcións",
"Monitor workitems" => "Monitorizar ítems de traballo",
"List of workitems" => "Listaxe de ítems de traballo",
"instance" => "exemplar",
"My activities" => "As miñas actividades",
"Current Activity" => "Actividade actual",
"Assigned To" => "Asignado a",
"exception instance" => " exemplar de excepción",
"exceptions instance" => "exemplar de excepcións",
"Send Instance" => "Enviar exemplar",
"abort instance" => "abortar exemplar",
"grab instance" => "obter exemplar",
"release instance" => "liberar exemplar",
"No activities found" => "Non se atoparon actividades",
"My instances" => "Os meus exemplares ",
"No instances found" => "Non se atoparon exemplares",
"User Activities" => "Actividades de usuario",
"Galaxia User Activities" => "Galaxia Actividades de Usuario",
"Galaxia User Activities tpl" => "modelo de Galaxia Actividades de Usuario",
"process" => "proceso",
"user processes" => "procesos de usuario",
"user activities" => "actividades de usuario",
"user instances" => "exemplares de usuarios",
"User Instances" => "Exemplares de usuario",
"Galaxia User Instances" => "Galaxia Exemplares de Usuario",
"Galaxia User Instances tpl" => "modelo de Galaxia Exemplares de Usuario",
"Inst Status" => "Estado do exemplar",
"Not defined" => "Non definido",
"No instances defined yet" => "Non hai aínda exemplares definidos",
"User Processes" => "Procesos de usuario",
"Galaxia User Processes" => "Galaxia Procesos de Usuario",
"Galaxia User Processes tpl" => "modelo de Galaxia Procesos de Usuario",
"Browsing Workitem" => "Navegando en ítem de traballo",
"Workitem information" => "Información de ítem de traballo",
"Use cache for external pages" => "Usar caché para as páxinas externas",
"All games are from" => "Todos os xogos son de",
"visit the site for more games and fun" => "visite o sitio para máis xogos e diversión",
"Upload a game" => "Cargar un xogo",
"Upload a new game" => "Cargar un novo xogo",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Miniatura (se o xogo se chama foo.swf a imaxe debe ser foo.swf.gif ou foo.swf.jpg ou foo.swf.png)",
"Edit game" => "Editar xogo",
"Played" => "Xogado",
"If you can't see the game then you need a flash plugin for your browser" => "Se non pode ver o xogo, necesita un plugin de Flash para o seu navegador",
"Accepted requests" => "Aceptar solicitudes",
"since" => "desde",
"Assigned items" => "Ítems asignados",
"Select news group" => "Seleccione un grupo de novas",
"Back to servers" => "Volver a servidores",
"Msgs" => "Msxs",
"News from" => "Grupos de novas desde",
"Back to groups" => "Volver a grupos",
"Save position" => "Gardar posición",
"Reading article from" => "Lendo artigo desde",
"Back to list of articles" => "Volver á lista de artigos",
"Newsgroup" => "Grupo de novas",
"Configure news servers" => "Configurar servidores de grupos de novas",
"Configure Newsreader" => "Configurar lector de grupos de novas",
"configure newsreader server tpl" => "modelo para configurar servidor lector de novas",
"Select a news server to browse" => "Seleccionar un servidor de grupos de novas para explorar",
"server" => "servidor",
"Read the news" => "Ler as noticias",
"News server" => "Servidor de grupos de novas",
"Current permissions for this object" => "Permisos actuais para este obxecto",
"No category permissions; global permissions apply" => "Non hai permisos de categoría; aplícanse permisos globais",
"Preview of version" => "Previsualización da versión",
"Source of version" => "Fonte de versión",
"Replicate" => "Replicar",
"Slave" => "Escravo",
"Master" => "Mestre",
"Operations" => "Operacións",
"Operations Log" => "Rexistro de operacións",
"Tiki Shoutbox" => "Taboleiro de anuncios Tiki",
"Click to Navigate" => "Premer para navegar",
"Focus:" => "Foco:",
"big grin" => "gran sorriso",
"cry" => "chorar",
"eek" => "Oh!",
"evil" => "malvado",
"lol" => "rag",
"mr green" => "sr. verde",
"razz" => "burlón",
"redface" => "ruborizado",
"rolleyes" => "caviloso",
"smile" => "sorriso",
"surprised" => "sorprendido",
"twisted" => "revirado",
"arrow" => "frecha",
"santa" => "papá noel",
"Note: Maximum image size is limited to" => "Nota: o tamaño máximo dunha imaxe está limitado a",
"Current folder" => "Carpeta actual",
"This user is your friend" => "Este usuario é o seu amigo",
"Your personal Wiki Page" => "A súa páxina persoal no Wiki",
"Your personal tracker information" => "O seu tracker de información persoal",
"Confirm new password" => "Confirmar o nova contrasinal",
"Current password (required)" => "Contrasinal actual (requirido)",
"Edit Items" => "Editar ítems",
"List Charts" => "Listar charts",
"Last Chart" => "último chart",
"Previous Chart" => "Chart anterior",
"Chart created" => "chart creado",
"Next Chart" => "Seguinte chart",
"Permanency" => "Permanencia",
"chg" => "cambio",
"Avg" => "Media",
"info/vote" => "info/voto",
"Next chart will be generated on" => "O seguinte chart será xerado en",
"View or vote items not listed in the chart" => "Visualizar o votar ítems que non están listados no chart",
"Select something to vote on" => "Seleccionar algo para votar",
"Item information" => "Información de ítem",
"Dif" => "Dif.",
"Best Position" => "Mellor posición",
"Vote this item" => "Votar este ítem",
"Highest" => "Superior",
"Number of voices" => "Número de votos",
"RSS settings" => "Configuración RSS",
"No chart indicated" => "Non se indicó chart",
"No category indicated" => "Non se indicou a categoría",
"Permission denied; you cannot assign permissions for this category" => "Permiso denegado; non pode asignar permisos para esta categoría",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Últimos sitios no directorio \".\$rc[\"name\"].\" .",
"No process indicated" => "Non se indicou proceso",
"Activity name already exists" => "Xa existe ese nome de actividade",
"indicates if the process is active. Invalid processes cant be active" => "indica se o proceso está activo. Os procesos inválidos non poden estar activos",
"No instance indicated" => "Non se indicaron exemplares",
"No activity indicated" => "Non se indicou actividade",
"The process name already exists" => "O nome do proceso xa existe",
"Process already exists" => "O proceso xa existe",
"You cant execute this activity" => "Non pode executar esta actividade",
"You couldn't abort a instance" => "Non pode abortar un exemplar",
"You couldn't exception a instance" => "Non pode facer unha excepción nun exemplar",
"No title indicated" => "Non se indicou título",
"No comment indicated" => "Non se indicou comentario",
"No date indicated" => "Non se indicou data",
"The game file must have .swf or .dcr extension" => "O xogo debe ter unha extensión .swf ou .dcr",
"The thumbnail name must be" => "A nome da miniatura debe ser",
"Please supply both files" => "Por favor, forneza ambos os ficheiros",
"No server indicated" => "Non se indicou servidor",
"Cannot connect to" => "Non podo conectarme a",
"Missing information to read news (server,port,username,password,group) required" => "Falta a información requirida para ler grupos de novas (servidor, porto, usuario, contrasinal, grupo) ",
"Cannot get messages" => "Non podo obter as mensaxes",
"A password and your IP address reminder email has been sent " => "Envióuselle un correo recordatorio do seu contrasinal e enderezo IP",
"changed '%s' from '%s' to '%s'" => "cambiado '%s' de '%s' a '%s'",
"Tiki Calendar" => "Calendario Tiki",
"Admin Menu" => "Administrar menú",
"RSS Modules" => "módulos RSS",
"Chat" => "Charla",
"Import PHPWiki Dump" => "Importar envorcado PHPWiki",
"Last `\$module_rows` visitors" => "Últimos `\$module_rows` visitantes",
"Tiki Logo" => "Logo Tiki",
"User informations" => "Informacións do usuario",
"Group informations" => "Información do grupo",
"Email This Post" => "mandar mensaje con este post",
"RSS feeds" => "Fontes RSS",
"Use titles in blog posts" => "Usar títulos en artigos de blogs",
"Send blog post" => "Enviar artigo de blog",
"A link to this post was sent to the following addresses:" => "Unha ligazón a este artigo enviouse aos seguintes enderezos:",
"Send post to this addresses" => "Enviar artigo a este enderezo",
"List of email addresses separated by commas" => "Lista de enderezos de correo separados por comas",
"Compose Message" => "Escriba unha mensaxe",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> borrado correctamente.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> asignado a %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> borrado de %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "grupo <b>%s</b> establecido como grupo por defecto de usuario <b>%s</b>.",
"Post recommendation at" => "Enviar recomendación en",
"Prevent flooding" => "Previr sobrecarga (flooding)",
"Minimum time between posts" => "Tempo mínimo entre publicacións",
"Moderator user" => "Usuario noderador",
"Moderator group" => "Grupo moderador",
"Send this forums posts to this email" => "Enviar artigos deste foro a este correo-e",
"Prune unreplied messages after" => "Eliminar mensaxes sen respostas despois de",
"Prune old messages after" => "Eliminar mensaxes antigas despois de",
"POP3 server" => "Servidor POP3",
"Max attachment size (bytes)" => "Tamaño máximo do anexo (bytes)",
"Default ordering for topics" => "Orde por defecto para temas",
"Topics per page" => "Temas por páxina",
"Default ordering for threads" => "Orde por defecto para fíos argumentais",
"Includes" => "Inclúe",
"Assign Perms to this Group" => "Asignar permisos a este grupo",
"Assign permissions to category" => "Asignar permisos a unha categoría",
"Current permissions for this category" => "Permisos actuais para esta categoría",
"Remove from this Category Only" => "Borrar só desta categoría",
"Remove from this Category &amp; all its Children" => "Borrar desta categoría e de todos os seus fillos",
"Assign permissions" => "Asignar permisos",
"to group" => "ao grupo",
"this category &amp; all its children" => "esta categoría e todos os seus fillos",
"this category only" => "só esta categoría",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Asignar permisos para <b>todos os fillos</b> é recomendable para un mellor rendemento.",
"ERROR: you must include a subject or a message at least" => "ERRO: debe incluír un asunto ou unha mensaxe polo menos",
"Your registration code:" => "O seu código de rexistro:",
"Registration code" => "Código de rexistro",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "For you to vote, cookies must be allowed" => "For you to vote, cookies must be allowed",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "Copyright management" => "Copyright management",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Andorra" => "Andorra",
// "Anguilla" => "Anguilla",
// "Aruba" => "Aruba",
// "Azerbaijan" => "Azerbaijan",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bhutan" => "Bhutan",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Cape Verde" => "Cape Verde",
// "Catalan Countries" => "Catalan Countries",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "French Guiana" => "French Guiana",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Hong Kong" => "Hong Kong",
// "Isle of Man" => "Isle of Man",
// "Jersey" => "Jersey",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mayotte" => "Mayotte",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Niger" => "Niger",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Oman" => "Oman",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "Sudan" => "Sudan",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Syria" => "Syria",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tunisia" => "Tunisia",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Uganda" => "Uganda",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vatican" => "Vatican",
// "Viet Nam" => "Viet Nam",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgreSQL" => "PostgreSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "(not registered)" => "(not registered)",
// "Please wait %d seconds between posts" => "Please wait %d seconds between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval and will be posted after a moderator approves it" => "Your message has been queued for approval and will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Cannot open this file" => "Cannot open this file",
// "The global quota has been reached" => "The global quota has been reached",
// "The quota has been reached in" => "The quota has been reached in",
// "File gallery quota exceeded" => "File gallery quota exceeded",
// "Number of files transfered to the database" => "Number of files transfered to the database",
// "Number of files transfered to the file system" => "Number of files transfered to the file system",
// "Cannot read to this file" => "Cannot read to this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "The uploaded file exceeds the upload_max_filesize directive in php.ini" => "The uploaded file exceeds the upload_max_filesize directive in php.ini",
// "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form" => "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
// "The uploaded file was only partially uploaded. Please try again" => "The uploaded file was only partially uploaded. Please try again",
// "No file was uploaded" => "No file was uploaded",
// "Missing a temporary folder" => "Missing a temporary folder",
// "Failed to write file to disk" => "Failed to write file to disk",
// "File upload stopped by extension" => "File upload stopped by extension",
// "Invalid file mime type" => "Invalid file mime type",
// "XML file does not validate against the Mediawiki XML schema" => "XML file does not validate against the Mediawiki XML schema",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "Description not available" => "Description not available",
// "Module Title" => "Module Title",
// "Title to display at the top of the box" => "Title to display at the top of the box",
// "No box" => "No box",
// "Show only the content" => "Show only the content",
// "Decorations" => "Decorations",
// "Show module decorations" => "Show module decorations",
// "No title" => "No title",
// "Show module title" => "Show module title",
// "Perspective" => "Perspective",
// "Only display the module if in one of the listed perspectives. Semi-colon separated" => "Only display the module if in one of the listed perspectives. Semi-colon separated",
// "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons" => "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons",
// "Module only applicable for the specified sections. Multiple values can be separated by semi-colons" => "Module only applicable for the specified sections. Multiple values can be separated by semi-colons",
// "Page filter" => "Page filter",
// "Module only applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module only applicable on the specified page names. Multiple values can be separated by semi-colons",
// "No Page" => "No Page",
// "Module not applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module not applicable on the specified page names. Multiple values can be separated by semi-colons",
// "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons" => "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons",
// "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module",
// "Contributor" => "Contributor",
// "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module",
// "Flip" => "Flip",
// "Users can shade module" => "Users can shade module",
// "No numbers" => "No numbers",
// "If set to \"y\", the module will not number list items" => "If set to \"y\", the module will not number list items",
// "Number of rows, or items, to display" => "Number of rows, or items, to display",
// "Default: 10" => "Default: 10",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Title length" => "Title length",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Default number per page" => "Default number per page",
// "Default Ordering" => "Default Ordering",
// "Default article image width" => "Default article image width",
// "0 for original image size" => "0 for original image size",
// "Default article image height" => "Default article image height",
// "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database" => "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Tiki and LDAP" => "Tiki and LDAP",
// "Shibboleth" => "Shibboleth",
// "Available languages" => "Available languages",
// "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset" => "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset",
// "Blogues" => "Blogues",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Exclude these categories" => "Exclude these categories",
// "Users can change site language" => "Users can change site language",
// "Allow users to change the language of the menus and labels" => "Allow users to change the language of the menus and labels",
// "Spell checking" => "Spell checking",
// "Allow anonymous visitors to use the \"Contact Us\" feature" => "Allow anonymous visitors to use the \"Contact Us\" feature",
// "Default charset for sending mail" => "Default charset for sending mail",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "Article RSS Description" => "Article RSS Description",
// "Description to be published as part of the RSS feed for articles" => "Description to be published as part of the RSS feed for articles",
// "Show Country Flag" => "Show Country Flag",
// "Show the country flag" => "Show the country flag",
// "Enable cool sites" => "Enable cool sites",
// "'),\n\t\t\t'type' => 'flag" => "'),\n\t\t\t'type' => 'flag",
// "Number of columns per page when listing directory categories" => "Number of columns per page when listing directory categories",
// "6" => "6",
// "'),\n\t\t\t'type' => 'text" => "'),\n\t\t\t'type' => 'text",
// "Method to Open Directory Links" => "Method to Open Directory Links",
// "PHP errors visible to admin only" => "PHP errors visible to admin only",
// "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators" => "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators",
// "PHP Error reporting level" => "PHP Error reporting level",
// "Level from which errors should be reported" => "Level from which errors should be reported",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Report all PHP errors except notices" => "Report all PHP errors except notices",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Faqs" => "Faqs",
// "Collaboratively authored documents with history of changes" => "Collaboratively authored documents with history of changes",
// "Online diaries or journals" => "Online diaries or journals",
// "Collections of graphic images for viewing or downloading (photo album)" => "Collections of graphic images for viewing or downloading (photo album)",
// "Machine Translation (by Google Translate)" => "Machine Translation (by Google Translate)",
// "Uses Google Translate to translate the content of wiki pages to other languages" => "Uses Google Translate to translate the content of wiki pages to other languages",
// "Experimental. This feature is still under development" => "Experimental. This feature is still under development",
// "Database & form generator" => "Database & form generator",
// "Online discussions on a variety of topics. Threaded or flat" => "Online discussions on a variety of topics. Threaded or flat",
// "Computer files, videos or software for downloading. With check-in & check-out (lock)" => "Computer files, videos or software for downloading. With check-in & check-out (lock)",
// "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"" => "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"",
// "Brief list of votable options; appears in module (left or right column)" => "Brief list of votable options; appears in module (left or right column)",
// "Content mailed to registered users" => "Content mailed to registered users",
// "Events calendar with public, private and group channels" => "Events calendar with public, private and group channels",
// "Insert, track, and manage advertising banners" => "Insert, track, and manage advertising banners",
// "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions" => "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions",
// "Score is a game to motivate participants to increase their contribution by comparing to other users" => "Score is a game to motivate participants to increase their contribution by comparing to other users",
// "Enables searching for content on the website" => "Enables searching for content on the website",
// "Freetags" => "Freetags",
// "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns" => "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns",
// "Action Log" => "Action Log",
// "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis" => "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis",
// "Contribution" => "Contribution",
// "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports" => "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports",
// "Enables internationalization features and multilingual support for then entire site" => "Enables internationalization features and multilingual support for then entire site",
// "Frequently asked questions and answers" => "Frequently asked questions and answers",
// "Questionnaire with multiple choice or open ended question" => "Questionnaire with multiple choice or open ended question",
// "User-submitted Web links" => "User-submitted Web links",
// "Quizzes " => "Quizzes ",
// "Timed questionnaire with recorded scores" => "Timed questionnaire with recorded scores",
// "Simple menu system which can optionally add an external web page in an iframe" => "Simple menu system which can optionally add an external web page in an iframe",
// "The Copyright Management System (or ©MS) is a way of licensing your content" => "The Copyright Management System (or ©MS) is a way of licensing your content",
// "Multimedia" => "Multimedia",
// "The applet is designed to read MP3 or FLV file" => "The applet is designed to read MP3 or FLV file",
// "Experimental. This feature is not actively maintained" => "Experimental. This feature is not actively maintained",
// "Quick comment (graffiti) box. Like a group chat, but not in real time" => "Quick comment (graffiti) box. Like a group chat, but not in real time",
// "Navigable, interactive maps with user-selectable layers" => "Navigable, interactive maps with user-selectable layers",
// "Requires mapserver" => "Requires mapserver",
// "Google Maps" => "Google Maps",
// "Interactive use of Google Maps" => "Interactive use of Google Maps",
// "One-on-one chatting with customer" => "One-on-one chatting with customer",
// "Tell a Friend" => "Tell a Friend",
// "Add a link \"Email this page\" in all the pages" => "Add a link \"Email this page\" in all the pages",
// "HTML pages" => "HTML pages",
// "Static and dynamic HTML content" => "Static and dynamic HTML content",
// "HTML can be used in wiki pages. This is a separate feature" => "HTML can be used in wiki pages. This is a separate feature",
// "Basic form from visitor to admin" => "Basic form from visitor to admin",
// "Minichat" => "Minichat",
// "Real-time group text chatting" => "Real-time group text chatting",
// "Comments Moderation " => "Comments Moderation ",
// "An admin must validate a comment before it is visible" => "An admin must validate a comment before it is visible",
// "Comments Locking" => "Comments Locking",
// "Comments can be closed (no new comments)" => "Comments can be closed (no new comments)",
// "Allow posting of comments as Anonymous" => "Allow posting of comments as Anonymous",
// "Permit anonymous visitors to add a comment without needing to create an account" => "Permit anonymous visitors to add a comment without needing to create an account",
// "Display page description" => "Display page description",
// "Display the page description below the heading when viewing the page" => "Display the page description below the heading when viewing the page",
// "Display page title" => "Display page title",
// "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header" => "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header",
// "Display page ID" => "Display page ID",
// "Display the internal page ID when viewing the page" => "Display the internal page ID when viewing the page",
// "Individual wiki cache" => "Individual wiki cache",
// "Allow users to change the duration of the cache on a per-page basis" => "Allow users to change the duration of the cache on a per-page basis",
// "JS Calendar" => "JS Calendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Output should be HTMLPurified" => "Output should be HTMLPurified",
// "This enable HTPMPurifier on outputs to filter remaining security problems like XSS" => "This enable HTPMPurifier on outputs to filter remaining security problems like XSS",
// "Full Screen" => "Full Screen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus" => "Css Menus",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Quick Permission Assignment" => "Quick Permission Assignment",
// "Quickperms allow to define classes of privileges and grant them to roles on objects" => "Quickperms allow to define classes of privileges and grant them to roles on objects",
// "HTML Purifier" => "HTML Purifier",
// "Ajax" => "Ajax",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Intertiki" => "Intertiki",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "Search engine friendly url" => "Search engine friendly url",
// "SpreadSheet" => "SpreadSheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Save draft" => "Save draft",
// "Requires AJAX (experimental)" => "Requires AJAX (experimental)",
// "Kaltura" => "Kaltura",
// "Users can identify other users as their friends" => "Users can identify other users as their friends",
// "Neglected feature" => "Neglected feature",
// "Action calendar" => "Action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Redirect to a similar wiki page if an exact match is not found" => "Redirect to a similar wiki page if an exact match is not found",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "Daily Reports for User Watches" => "Daily Reports for User Watches",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "TikiTests" => "TikiTests",
// "Use Minified Scripts" => "Use Minified Scripts",
// "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions" => "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions",
// "Check for updates automatically" => "Check for updates automatically",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Lookup the user\\'s preferred language through browser preferences" => "Lookup the user\\'s preferred language through browser preferences",
// "Show pages in user\\'s preferred language" => "Show pages in user\\'s preferred language",
// "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page" => "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page",
// "Changing the page language also changes the site language" => "Changing the page language also changes the site language",
// "Translation assistant" => "Translation assistant",
// "Track translation operations between pages" => "Track translation operations between pages",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users" => "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users",
// "Incomplete translation notice" => "Incomplete translation notice",
// "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete" => "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete",
// "Multilingual structures" => "Multilingual structures",
// "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures" => "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures",
// "Display all languages in a single page" => "Display all languages in a single page",
// "List all languages as a language option in the page language drop list to see all languages at once" => "List all languages as a language option in the page language drop list to see all languages at once",
// "GZip output" => "GZip output",
// "Translation URLs" => "Translation URLs",
// "Show clickable URLs to translate the page to another language using Babel Fish website" => "Show clickable URLs to translate the page to another language using Babel Fish website",
// "Translation icons" => "Translation icons",
// "Show clickable icons to translate the page to another language using Babelfish website" => "Show clickable icons to translate the page to another language using Babelfish website",
// "Also known as emoticons" => "Also known as emoticons",
// "Bloc of content which can be reused and programmed (timed)" => "Bloc of content which can be reused and programmed (timed)",
// "Use File Galleries to store pictures" => "Use File Galleries to store pictures",
// "External link icon" => "External link icon",
// "Semantic links" => "Semantic links",
// "Going beyond Backlinks, allows to define some semantic relationships between wiki pages" => "Going beyond Backlinks, allows to define some semantic relationships between wiki pages",
// "Web Services" => "Web Services",
// "Can consume webservices in JSON or YAML" => "Can consume webservices in JSON or YAML",
// "Breadcrumbs" => "Breadcrumbs",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Show module controls" => "Show module controls",
// "Perspectives" => "Perspectives",
// "Permits to override preferences" => "Permits to override preferences",
// "Search and replace" => "Search and replace",
// "Permits find and replace of content in the edit box" => "Permits find and replace of content in the edit box",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Category path" => "Category path",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "Screencasts" => "Screencasts",
// "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share" => "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share",
// "Screencasts upload location" => "Screencasts upload location",
// "Local path or webdav path to the file upload location" => "Local path or webdav path to the file upload location",
// "Trailing slash required" => "Trailing slash required",
// "Screencasts HTTP prefix" => "Screencasts HTTP prefix",
// "Prefix to use for the files when generating a link to it" => "Prefix to use for the files when generating a link to it",
// "Screencast upload type" => "Screencast upload type",
// "Mode used to upload files. WebDav is used to upload to remote servers" => "Mode used to upload files. WebDav is used to upload to remote servers",
// "Webdav" => "Webdav",
// "Screencasts authentication user" => "Screencasts authentication user",
// "When using webdav to upload files, used as the username of the authentication credentials" => "When using webdav to upload files, used as the username of the authentication credentials",
// "Screencasts authentication password" => "Screencasts authentication password",
// "When using webdav to upload files, used as the password of the authentication credentials" => "When using webdav to upload files, used as the password of the authentication credentials",
// "Screencasts max file size" => "Screencasts max file size",
// "Maximum file size used for screencasts" => "Maximum file size used for screencasts",
// "Value provided in bytes" => "Value provided in bytes",
// "Page List" => "Page List",
// "The pagelist feature allows to maintain lists of pages and their associated score and priority" => "The pagelist feature allows to maintain lists of pages and their associated score and priority",
// "Database search" => "Database search",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Pertinence" => "Pertinence",
// "Object type" => "Object type",
// "Last modified date" => "Last modified date",
// "Blog-level" => "Blog-level",
// "Batch uploading" => "Batch uploading",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Forum name search" => "Forum name search",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Store password as plain text" => "Store password as plain text",
// "Admins can search for features in the admin panels" => "Admins can search for features in the admin panels",
// "Encryption method" => "Encryption method",
// "tikihash (old)" => "tikihash (old)",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Add a Powered by Tiki link on your site's footer" => "Add a Powered by Tiki link on your site's footer",
// "Podcast directory" => "Podcast directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "Required for podcasts" => "Required for podcasts",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Allow download limit per file" => "Allow download limit per file",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Quota for all the files and archives" => "Quota for all the files and archives",
// "(0 for illimitted)" => "(0 for illimitted)",
// "Quota can be defined for each file gallery" => "Quota can be defined for each file gallery",
// "Default quota for each new gallery" => "Default quota for each new gallery",
// "Show quota bar in the list page" => "Show quota bar in the list page",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Display thread configuration bar only when number of posts exceed" => "Display thread configuration bar only when number of posts exceed",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Description length" => "Description length",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Default ordering" => "Default ordering",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Multilingual tags" => "Multilingual tags",
// "Permits translation management of tags" => "Permits translation management of tags",
// "Label visible in the browser\\'s title bar on all pages. Also appears in search engines" => "Label visible in the browser\\'s title bar on all pages. Also appears in search engines",
// "Validate new user registrations by email" => "Validate new user registrations by email",
// "Upon registration, the new user will receive an email containing a link to confirm validity" => "Upon registration, the new user will receive an email containing a link to confirm validity",
// "Landing page used for the wiki when no page is specified. The page will be created if it does not exist" => "Landing page used for the wiki when no page is specified. The page will be created if it does not exist",
// "Default language" => "Default language",
// "Site language used when no other language is specified by the user" => "Site language used when no other language is specified by the user",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "The default help system may not be complete. You can help with the TikiWiki documentation" => "The default help system may not be complete. You can help with the TikiWiki documentation",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "[-180 180]" => "[-180 180]",
// "[0 360]" => "[0 360]",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Url to go when clicking on a username" => "Url to go when clicking on a username",
// "Default: " => "Default: ",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user" => "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user",
// "If passwords <em>are stored</em> as plain text, the password will be emailed to the user" => "If passwords <em>are stored</em> as plain text, the password will be emailed to the user",
// "Verify for available translations in the database" => "Verify for available translations in the database",
// "Language inclusion threshold" => "Language inclusion threshold",
// "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages" => "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "Log SQL" => "Log SQL",
// "Log queries using more than (seconds)" => "Log queries using more than (seconds)",
// "This may impact performance" => "This may impact performance",
// "Mail end of line" => "Mail end of line",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "Memcache" => "Memcache",
// "Enable connection to memcached servers to store temporary information" => "Enable connection to memcached servers to store temporary information",
// "Requires the PHP memcache extension" => "Requires the PHP memcache extension",
// "Memcache flags" => "Memcache flags",
// "Configuration switches for memcache connection" => "Configuration switches for memcache connection",
// "Memcache servers" => "Memcache servers",
// "Server list which may be accessed. For each server, the address, port and weight must be specified" => "Server list which may be accessed. For each server, the address, port and weight must be specified",
// "One per line. address:port (weight)" => "One per line. address:port (weight)",
// "Memcache key prefix" => "Memcache key prefix",
// "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts" => "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts",
// "Memcache expiration" => "Memcache expiration",
// "Duration for which the data will be kept" => "Duration for which the data will be kept",
// "Cache wiki data in memcache" => "Cache wiki data in memcache",
// "Cache wiki output in memcache" => "Cache wiki output in memcache",
// "Cache forum output in memcache" => "Cache forum output in memcache",
// "Allow users to define icons for menus entries" => "Allow users to define icons for menus entries",
// "Default path for the icons" => "Default path for the icons",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Use individual page description for Wiki pages instead" => "Use individual page description for Wiki pages instead",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "Multi-domain" => "Multi-domain",
// "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance" => "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance",
// "Multi-domain Configuration" => "Multi-domain Configuration",
// "Comma-separated values mapping the domain name to the perspective ID" => "Comma-separated values mapping the domain name to the perspective ID",
// "One domain per line. Comma separated with perspective ID" => "One domain per line. Comma separated with perspective ID",
// "Wiki buttons" => "Wiki buttons",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Top " => "Top ",
// "Bottom" => "Bottom",
// "Neither" => "Neither",
// "Show categories" => "Show categories",
// "Show objects" => "Show objects",
// "Host" => "Host",
// "Proxy host" => "Proxy host",
// "Quantify change size" => "Quantify change size",
// "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page" => "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page",
// "Keep track of the unsuccessful attemps to translate strings" => "Keep track of the unsuccessful attemps to translate strings",
// "Restrict supported languages" => "Restrict supported languages",
// "Limit the languages made available on the site" => "Limit the languages made available on the site",
// "Refresh mode" => "Refresh mode",
// "Random" => "Random",
// "Parse the results" => "Parse the results",
// "Sender email" => "Sender email",
// "Email address that will be used as the sender for outgoing emails" => "Email address that will be used as the sender for outgoing emails",
// "Session storage location" => "Session storage location",
// "Select where the session information should be stored. Memcache sessions require memcache to be configured" => "Select where the session information should be stored. Memcache sessions require memcache to be configured",
// "Default (from php.ini)" => "Default (from php.ini)",
// "Session lifetime" => "Session lifetime",
// "Value provided in minutes" => "Value provided in minutes",
// "Silent session" => "Silent session",
// "Do not automatically start sessions" => "Do not automatically start sessions",
// "Session cookie name" => "Session cookie name",
// "Session cookie name used instead of the PHP default configuration" => "Session cookie name used instead of the PHP default configuration",
// "Display available translations" => "Display available translations",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Choices" => "Choices",
// "Site title location" => "Site title location",
// "Location of the site title in the browser title bar relative to the current page\\'s descriptor" => "Location of the site title in the browser title bar relative to the current page\\'s descriptor",
// "Browser title display mode" => "Browser title display mode",
// "When breadcrumbs are used, method in which the browser title should be displayed" => "When breadcrumbs are used, method in which the browser title should be displayed",
// "Most specific first" => "Most specific first",
// "Least specific first (site)" => "Least specific first (site)",
// "Current only" => "Current only",
// "Include smarty notices in PHP error report" => "Include smarty notices in PHP error report",
// "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur" => "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Check frequency" => "Check frequency",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "Minify javascript" => "Minify javascript",
// "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared" => "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared",
// "Use Jquery autocomplete user selector for better performance when number of users exceed" => "Use Jquery autocomplete user selector for better performance when number of users exceed",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Show user\\'s real name instead of login (when possible)" => "Show user\\'s real name instead of login (when possible)",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Always" => "Always",
// "Module decides" => "Module decides",
// "500Kb" => "500Kb",
// "1Mb" => "1Mb",
// "1.5Mb" => "1.5Mb",
// "2Mb" => "2Mb",
// "2.5Mb" => "2.5Mb",
// "3Mb" => "3Mb",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Wiki link format" => "Wiki link format",
// "Character set used when detecting wiki links within pages" => "Character set used when detecting wiki links within pages",
// "Latin" => "Latin",
// "Display by default only pages in current language" => "Display by default only pages in current language",
// "In Wiki page lists, display by default only pages in current language" => "In Wiki page lists, display by default only pages in current language",
// "Display page version" => "Display page version",
// "Display the page version information when viewing the page" => "Display the page version information when viewing the page",
// "Page name display stripper" => "Page name display stripper",
// "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed" => "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed",
// "Wiki author list style" => "Wiki author list style",
// "Changes the list format used to display the authors of the page" => "Changes the list format used to display the authors of the page",
// "Creator & Author" => "Creator & Author",
// "none (disabled)" => "none (disabled)",
// "Specify wiki author list style per page" => "Specify wiki author list style per page",
// "Allows to modify the style in which the author list is displayed on a per-page basis" => "Allows to modify the style in which the author list is displayed on a per-page basis",
// "Wiki action bar location" => "Wiki action bar location",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Both" => "Both",
// "Wiki navigation bar location" => "Wiki navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line location" => "Wiki top line location",
// "Enable page cache globally for wiki pages" => "Enable page cache globally for wiki pages",
// "Allow comments per page" => "Allow comments per page",
// "Enable control for comments on wiki pages individually" => "Enable control for comments on wiki pages individually",
// "Disable" => "Disable",
// "Enable (default On)" => "Enable (default On)",
// "Enable (default Off)" => "Enable (default Off)",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "Permits editing of a plugin, via a popup form, without needing to edit the whole page" => "Permits editing of a plugin, via a popup form, without needing to edit the whole page",
// "Load page on navigation" => "Load page on navigation",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "Enable plugin %0" => "Enable plugin %0",
// "Inline plugin %0 (hide plugin edit icon)" => "Inline plugin %0 (hide plugin edit icon)",
// "When inlined, the plugin edit icon will not appear" => "When inlined, the plugin edit icon will not appear",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Default" => "Default",
// "Office 2003" => "Office 2003",
// "Silver" => "Silver",
// "Nothing was changed, please check profile for errors" => "Nothing was changed, please check profile for errors",
// "An error occurred: " => "An error occurred: ",
// "Applying profile" => "Applying profile",
// "Added (or modified)" => "Added (or modified)",
// "Preference set" => "Preference set",
// "Group changed (or modified)" => "Group changed (or modified)",
// "User %0 was added to %1" => "User %0 was added to %1",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "No name" => "No name",
// "Bad object" => "Bad object",
// "The passwords do not match" => "The passwords do not match",
// "uploaded the file" => "uploaded the file",
// "changes" => "changes",
// "No changes" => "No changes",
// "Yesterday" => "Yesterday",
// "more changes of the same type.." => "more changes of the same type..",
// "changed the picture gallery" => "changed the picture gallery",
// "uploaded the picture" => "uploaded the picture",
// "onto" => "onto",
// "removed the picture" => "removed the picture",
// "edited the wikipage" => "edited the wikipage",
// "this history" => "this history",
// "all history" => "all history",
// "edited the file gallery" => "edited the file gallery",
// "removed the file" => "removed the file",
// "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category" => "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category",
// "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category" => "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category",
// "created the subcategory" => "created the subcategory",
// "removed the subcategory" => "removed the subcategory",
// "edited the category" => "edited the category",
// "removed the article" => "removed the article",
// "created the article" => "created the article",
// "edited the article" => "edited the article",
// "replied to the blog" => "replied to the blog",
// "created the topic" => "created the topic",
// "at forum" => "at forum",
// "to the topic" => "to the topic",
// "Nothing has happened" => "Nothing has happened",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "You are not in group of friends to have the content of this block displayed for you" => "You are not in group of friends to have the content of this block displayed for you",
// "Smarty block.display.php: Missing error param" => "Smarty block.display.php: Missing error param",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "tip" => "tip",
// "warning" => "warning",
// "note" => "note",
// "errors" => "errors",
// "information" => "information",
// "Tab View" => "Tab View",
// "No Tabs" => "No Tabs",
// "If you want the saved version instead of this autosaved one" => "If you want the saved version instead of this autosaved one",
// "AutoSave" => "AutoSave",
// "Your edit session will expire in" => "Your edit session will expire in",
// "You must PREVIEW or SAVE your work now, to avoid losing your edits" => "You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Your edit session has expired" => "Your edit session has expired",
// "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page" => "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page",
// "Help page" => "Help page",
// "Admin Feature" => "Admin Feature",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Preference name not specified" => "Preference name not specified",
// "Preference %0 is not defined" => "Preference %0 is not defined",
// "Invert Sort" => "Invert Sort",
// "No rows found" => "No rows found",
// "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox",
// "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox",
// "Toggle sections" => "Toggle sections",
// "sec" => "sec",
// "Gender" => "Gender",
// "Permission denied: the specified wiki page cannot be used as Smarty template resource" => "Permission denied: the specified wiki page cannot be used as Smarty template resource",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Help link" => "Help link",
// "Edit Plugin" => "Edit Plugin",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "smiling" => "smiling",
// "grinning" => "grinning",
// "crying" => "crying",
// "frightened" => "frightened",
// "evil stuff" => "evil stuff",
// "exclamation mark " => "exclamation mark ",
// "frowning" => "frowning",
// "light bulb" => "light bulb",
// "idea " => "idea ",
// "LOL" => "LOL",
// "laughing out loud " => "laughing out loud ",
// "mr. green laughing" => "mr. green laughing",
// "The file was uploaded with success" => "The file was uploaded with success",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "No file was uploaded. Was a file selected " => "No file was uploaded. Was a file selected ",
// "A temporary folder is missing" => "A temporary folder is missing",
// "Unknown error" => "Unknown error",
// "Flash player not available" => "Flash player not available",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "Bold" => "Bold",
// "pics/icons/text_bold.png" => "pics/icons/text_bold.png",
// "Italic" => "Italic",
// "pics/icons/text_italic.png" => "pics/icons/text_italic.png",
// "Strikethrough" => "Strikethrough",
// "pics/icons/text_strikethrough.png" => "pics/icons/text_strikethrough.png",
// "Non-parsed" => "Non-parsed",
// "pics/icons/noparse.png" => "pics/icons/noparse.png",
// "Align Center" => "Align Center",
// "pics/icons/text_align_center.png" => "pics/icons/text_align_center.png",
// "Horizontal Bar" => "Horizontal Bar",
// "pics/icons/page.png" => "pics/icons/page.png",
// "Page Break" => "Page Break",
// "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif" => "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif",
// "Block Quote" => "Block Quote",
// "pics/icons/box.png" => "pics/icons/box.png",
// "pics/icons/book.png" => "pics/icons/book.png",
// "Unordered List" => "Unordered List",
// "pics/icons/text_list_bullets.png" => "pics/icons/text_list_bullets.png",
// "Ordered List" => "Ordered List",
// "pics/icons/text_list_numbers.png" => "pics/icons/text_list_numbers.png",
// "Special Characters" => "Special Characters",
// "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif" => "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif",
// "img/smiles/icon_smile.gif" => "img/smiles/icon_smile.gif",
// "Foreground color" => "Foreground color",
// "pics/icons/palette.png" => "pics/icons/palette.png",
// "Background Color" => "Background Color",
// "pics/icons/palette_bg.png" => "pics/icons/palette_bg.png",
// "Wiki Link" => "Wiki Link",
// "pics/icons/page_link.png" => "pics/icons/page_link.png",
// "External Link" => "External Link",
// "pics/icons/world_link.png" => "pics/icons/world_link.png",
// "pics/icons/table.png" => "pics/icons/table.png",
// "Table Builder" => "Table Builder",
// "pics/icons/find.png" => "pics/icons/find.png",
// "Find Text" => "Find Text",
// "pics/icons/text_replace.png" => "pics/icons/text_replace.png",
// "Text Replace" => "Text Replace",
// "Full Screen Edit" => "Full Screen Edit",
// "pics/icons/arrow_in.png" => "pics/icons/arrow_in.png",
// "pics/icons/arrow_out.png" => "pics/icons/arrow_out.png",
// "Choose or upload images" => "Choose or upload images",
// "pics/icons/pictures.png" => "pics/icons/pictures.png",
// "Switch Editor (wiki or WYSIWYG)" => "Switch Editor (wiki or WYSIWYG)",
// "pics/icons/pencil_go.png" => "pics/icons/pencil_go.png",
// "Admin Toolbars" => "Admin Toolbars",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "IP selector" => "IP selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "country selector" => "country selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "in group" => "in group",
// "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "Zip Code" => "Zip Code",
// "Mailbox uninitialised??" => "Mailbox uninitialised??",
// "No mail body found" => "No mail body found",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and enables users to define zones to highlight information on the image" => "Displays an image and enables users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Inserts a list of articles in the page" => "Inserts a list of articles in the page",
// "Articles displayed" => "Articles displayed",
// "The number of articles to display in the list" => "The number of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Start date" => "Start date",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "End date" => "End date",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Makes the text between the {ATTACH} tags the link text instead of the file name or description" => "Makes the text between the {ATTACH} tags the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width less than 100%, make text wrap around the box" => "for box with width less than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Includes a calendar and/or a list of calendar events" => "Includes a calendar and/or a list of calendar events",
// "Calendar filter" => "Calendar filter",
// "If set to a calendar identifier, restricts the events displayed to those in the specified calendar" => "If set to a calendar identifier, restricts the events displayed to those in the specified calendar",
// "View type" => "View type",
// "Determines how to show events" => "Determines how to show events",
// "Possible values" => "Possible values",
// "\"table\" shows events in a calendar" => "\"table\" shows events in a calendar",
// "Default value" => "Default value",
// "Calendar view type time span" => "Calendar view type time span",
// "If in calendar (or \"table\") view type, determines the time span displayed by the calendar" => "If in calendar (or \"table\") view type, determines the time span displayed by the calendar",
// "View the navigation bar" => "View the navigation bar",
// "Decide or not to show the navigation bar" => "Decide or not to show the navigation bar",
// "Includes a calendar" => "Includes a calendar",
// "~np~{CALENDAR(calendarId=>1)}{CALENDAR}" => "~np~{CALENDAR(calendarId=>1)}{CALENDAR}",
// "Id is optional. If not given, all calendars viewable by default are used" => "Id is optional. If not given, all calendars viewable by default are used",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "With sub-categories" => "With sub-categories",
// "Show object name" => "Show object name",
// "Show type" => "Show type",
// "Incorrect param" => "Incorrect param",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as fortune cookies or taglines" => "Also known as fortune cookies or taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "Items to show" => "Items to show",
// "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown" => "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown",
// "Show time since event" => "Show time since event",
// "If y, will display amount of time since the event (default). If n will simply display that the event is over" => "If y, will display amount of time since the event (default). If n will simply display that the event is over",
// "since " => "since ",
// "until " => "until ",
// " is over" => " is over",
// "Data Channel" => "Data Channel",
// "Displays a form to trigger data channels" => "Displays a form to trigger data channels",
// "List of fields to display. One field per line. Comma delimited: fieldname,label" => "List of fields to display. One field per line. Comma delimited: fieldname,label",
// "Channel Name" => "Channel Name",
// "Name of the channel as registered by the administrator" => "Name of the channel as registered by the administrator",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "Span" => "Span",
// "Teletype" => "Teletype",
// "Paragraph" => "Paragraph",
// "Block quote" => "Block quote",
// "left|right|center|justify" => "left|right|center|justify",
// "Justify" => "Justify",
// "Float position" => "Float position",
// "left|right, for box with width less than 100%, make text wrap around the box" => "left|right, for box with width less than 100%, make text wrap around the box",
// "Determine how other elements can wrap around the element" => "Determine how other elements can wrap around the element",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block, span, blockquote or other text formatting on wiki page" => "Insert a division block, span, blockquote or other text formatting on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class for the fancylist" => "CSS class for the fancylist",
// "Creates a fancy-looking list" => "Creates a fancy-looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases" => "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases",
// "Heading row" => "Heading row",
// "Header rows of the table. Use >> to separate multiple rows" => "Header rows of the table. Use >> to separate multiple rows",
// "Heading CSS class" => "Heading CSS class",
// "CSS class to apply to the heading row" => "CSS class to apply to the heading row",
// "Header horizontal align" => "Header horizontal align",
// "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify" => "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify",
// "Header vertical align" => "Header vertical align",
// "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline" => "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline",
// "Column sort" => "Column sort",
// "Pre-sorted columns" => "Pre-sorted columns",
// "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]" => "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]",
// "Column widths" => "Column widths",
// "Column widths followed by px for pixels or % for percentages. Each column separated by |" => "Column widths followed by px for pixels or % for percentages. Each column separated by |",
// "Cell horizontal align" => "Cell horizontal align",
// "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify" => "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify",
// "Cell vertical align" => "Cell vertical align",
// "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline" => "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline",
// "The feature must be activated" => "The feature must be activated",
// "heads and cells separated by |" => "heads and cells separated by |",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include. e.g. files/test.swf" => "Complete URL to the movie to include. e.g. files/test.swf",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes in the wiki page" => "Inserts a section for collected footnotes in the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed User Friends" => "Allowed User Friends",
// "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo" => "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups or group of friends" => "Display wiki text if user is in one of listed groups or group of friends",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "GroupMailCore" => "GroupMailCore",
// "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile" => "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile",
// "From Email" => "From Email",
// "Email address to report" => "Email address to report",
// "Tracker Id" => "Tracker Id",
// "Id of GroupMail Logs tracker (set up in alias by profile)" => "Id of GroupMail Logs tracker (set up in alias by profile)",
// "From Field Id" => "From Field Id",
// "Id of GroupMail Logs tracker field (usually set up in alias by profile)" => "Id of GroupMail Logs tracker field (usually set up in alias by profile)",
// "operator Field Id" => "operator Field Id",
// "subject Field Id" => "subject Field Id",
// "message Field Id" => "message Field Id",
// "content Field Id" => "content Field Id",
// "account Field Id" => "account Field Id",
// "datetime Field Id" => "datetime Field Id",
// "Displays GroupMail functions on a wiki page" => "Displays GroupMail functions on a wiki page",
// "Group Stats" => "Group Stats",
// "Groups separated by " => "Groups separated by ",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Displays some stat about group belonging" => "Displays some stat about group belonging",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 5.0)" => " (experimental - possible successor to img in 5.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)" => "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Display images" => "Display images",
// "Image source" => "Image source",
// "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required" => "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Attachment ID" => "Attachment ID",
// "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery" => "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery",
// "Full size image appears when thumbnail is clicked" => "Full size image appears when thumbnail is clicked",
// "Mouseover" => "Mouseover",
// "Full size image will pop up while cursor is over the thumbnail (and disappear when not)" => "Full size image will pop up while cursor is over the thumbnail (and disappear when not)",
// "Mouseover (Sticky)" => "Mouseover (Sticky)",
// "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup" => "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup",
// "Popup" => "Popup",
// "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked" => "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked",
// "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery" => "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery",
// "Browse Popup" => "Browse Popup",
// "Same as \"browse\" except that the page opens in a new window or tab" => "Same as \"browse\" except that the page opens in a new window or tab",
// "Download dialog box will appear for file gallery images when thumbnail is clicked" => "Download dialog box will appear for file gallery images when thumbnail is clicked",
// "Enlarge button" => "Enlarge button",
// "Button for enlarging image" => "Button for enlarging image",
// "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting" => "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting",
// "Link relation" => "Link relation",
// "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation" => "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation",
// "Image map" => "Image map",
// "Maximum image size" => "Maximum image size",
// "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings" => "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings",
// "Align image" => "Align image",
// "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box" => "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box",
// "Image style" => "Image style",
// "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects",
// "Align image block" => "Align image block",
// "Aligns the box containing the image" => "Aligns the box containing the image",
// "Image block style" => "Image block style",
// "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects",
// "Description style" => "Description style",
// "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects" => "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects",
// "Wrapping control" => "Wrapping control",
// "Control how other items wrap around the image" => "Control how other items wrap around the image",
// "CSS class" => "CSS class",
// "CSS class to apply to the image" => "CSS class to apply to the image",
// "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description" => "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description",
// "Alternate text" => "Alternate text",
// "Alternate text that displays when image does not load" => "Alternate text that displays when image does not load",
// "Default config settings" => "Default config settings",
// "Default configuration settings (usually set by admin)" => "Default configuration settings (usually set by admin)",
// "Mandatory admin setting" => "Mandatory admin setting",
// "Mandatory configuration settings (usually set by admin)" => "Mandatory configuration settings (usually set by admin)",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''" => "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''",
// "''Use one and only one of the following parameters: fileId, attId, id, or src.''" => "''Use one and only one of the following parameters: fileId, attId, id, or src.''",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Invite" => "Invite",
// "Invite an email in groups" => "Invite an email in groups",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Including group" => "Including group",
// "Default group" => "Default group",
// "Group from the item group selector / creator field" => "Group from the item group selector / creator field",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "Kaltura video" => "Kaltura video",
// "Displays a KALTURA video on the wiki page" => "Displays a KALTURA video on the wiki page",
// "Kaltura Entry Id" => "Kaltura Entry Id",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Number of results displayed in the list" => "Number of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Progress" => "List Progress",
// "Indicates the internationalization progress of the page list" => "Indicates the internationalization progress of the page list",
// "List Name" => "List Name",
// "Name of the list as configured in the page list admin panel" => "Name of the list as configured in the page list admin panel",
// "Limit" => "Limit",
// "Maximum amount of results to display" => "Maximum amount of results to display",
// "Filter to apply to the page list" => "Filter to apply to the page list",
// "Score Limit" => "Score Limit",
// "Value used as the denominator for the score" => "Value used as the denominator for the score",
// "List Directory" => "List Directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Mayan Calendars Info" => "Mayan Calendars Info",
// "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count" => "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count",
// "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%" => "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%",
// "Gregorian date" => "Gregorian date",
// "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date" => "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date",
// "Mayan Calendars" => "Mayan Calendars",
// " is not a valid date format. should be dd.mm.yyyy" => " is not a valid date format. should be dd.mm.yyyy",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Member List" => "Member List",
// "Lists the members of selected groups and allows to add or remove members if permissions are granted" => "Lists the members of selected groups and allows to add or remove members if permissions are granted",
// "List of groups to handle through the interface. Colon separated" => "List of groups to handle through the interface. Colon separated",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inline in a wiki page. More parameters can be added, not supported by UI" => "Displays a module inline in a wiki page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when mouseover text is clicked. Use http:// for external links" => "Destination link when mouseover text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouseover box width. Default: 400px" => "Mouseover box width. Default: 400px",
// "Mouseover box height. Default: 200px" => "Mouseover box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px" => "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Background color of the popup" => "Background color of the popup",
// "'),\n\t\t\t\t'filter' => 'striptags" => "'),\n\t\t\t\t'filter' => 'striptags",
// "Text color in the popup" => "Text color in the popup",
// "Padding" => "Padding",
// "Effect" => "Effect",
// "Effect speed" => "Effect speed",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a MySpace Flash mp3 playlist in the wiki page" => "Displays a MySpace Flash mp3 playlist in the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "List pages part of a named list" => "List pages part of a named list",
// "Offset" => "Offset",
// "Pagination start element" => "Pagination start element",
// "list parameter missing or doesn\\'t exist" => "list parameter missing or doesn\\'t exist",
// "% of page hits" => "% of page hits",
// "Page Hits" => "Page Hits",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Poll ID" => "Poll ID",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "User List (showing Real Name)" => "User List (showing Real Name)",
// " (experimental, should be merged with UserList in Tiki5)" => " (experimental, should be merged with UserList in Tiki5)",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Exclude" => "Exclude",
// "Displays a list of users showing their real name" => "Displays a list of users showing their real name",
// "Displays a list of registered users showing their Real Names" => "Displays a list of registered users showing their Real Names",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "y|n Show close button (default y)" => "y|n Show close button (default y)",
// "Width (e.g. 100% or 250px - default \"\")" => "Width (e.g. 100% or 250px - default \"\")",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Number of results displayed" => "Number of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "Screencast" => "Screencast",
// "Display a screencast uploaded on the page" => "Display a screencast uploaded on the page",
// "Label to use as a replacement to the default text" => "Label to use as a replacement to the default text",
// "ID as provided automatically during the upload" => "ID as provided automatically during the upload",
// "Insert Screencast" => "Insert Screencast",
// "Screencast ID wasn't specified or doesn't exist" => "Screencast ID wasn't specified or doesn't exist",
// "Watch a video of these instructions" => "Watch a video of these instructions",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Stat" => "Stat",
// "Displays some stats" => "Displays some stats",
// "separated by " => "separated by ",
// "Parent Id" => "Parent Id",
// "Added last hour" => "Added last hour",
// "Added last 24 hours" => "Added last 24 hours",
// "Added since the beginning of the day" => "Added since the beginning of the day",
// "Added(a) or viewed(v) since the beginning of the day" => "Added(a) or viewed(v) since the beginning of the day",
// "Added last 7 days" => "Added last 7 days",
// "Added(a) or viewed(v) last 7 days" => "Added(a) or viewed(v) last 7 days",
// "Added since the beginning of the week" => "Added since the beginning of the week",
// "Added(a) or viewed(v) since the beginning of the week" => "Added(a) or viewed(v) since the beginning of the week",
// "Added last month" => "Added last month",
// "Added(a) or viewed(v) last month" => "Added(a) or viewed(v) last month",
// "Added since the beginning of the month" => "Added since the beginning of the month",
// "Added(a) or viewed(v) since the beginning of the month" => "Added(a) or viewed(v) since the beginning of the month",
// "Added last year" => "Added last year",
// "Added(a) or viewed(v) last year" => "Added(a) or viewed(v) last year",
// "Added since the beginning of the year" => "Added since the beginning of the year",
// "Added(a) or viewed(v) since the beginning of the year" => "Added(a) or viewed(v) since the beginning of the year",
// "Subscript" => "Subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Show subscribe box" => "Show subscribe box",
// "Show default setting and buttons" => "Show default setting and buttons",
// "Show group description" => "Show group description",
// "Colon separated list of groups" => "Colon separated list of groups",
// "After changing default" => "After changing default",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tabs" => "Tabs",
// "Provides tabs built using the smarty tabset block" => "Provides tabs built using the smarty tabset block",
// "Tabs content separated by /////" => "Tabs content separated by /////",
// "Tabset name" => "Tabset name",
// "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs" => "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs",
// "Tab titles" => "Tab titles",
// "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3" => "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3",
// "Displays a set of tabs" => "Displays a set of tabs",
// "No tab title specified. At least one has to be set to make the tabs appear" => "No tab title specified. At least one has to be set to make the tabs appear",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Tag Name" => "Tag Name",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent to the style attribute of an HTML tag" => "Equivalent to the style attribute of an HTML tag",
// "Displays text between HTML tags" => "Displays text between HTML tags",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Pipe-separated list of page names to exclude from results" => "Pipe-separated list of page names to exclude from results",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum number of levels to display. On very large structures, this should be limited" => "Maximum number of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top-scoring users" => "List top-scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "URL used for the field links" => "URL used for the field links",
// "Url target" => "Url target",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "Reset" => "Reset",
// "Label for the reset button, to return all fields to their default values" => "Label for the reset button, to return all fields to their default values",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following fields are incorrect" => "Following fields are incorrect",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Filters" => "Filters",
// "Display List" => "Display List",
// "Line" => "Line",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Notice" => "Notice",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Show Item Rank" => "Show Item Rank",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Maximum number of items" => "Maximum number of items",
// "Show pagination" => "Show pagination",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "More Url" => "More Url",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "Show nothing if no items" => "Show nothing if no items",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Group name" => "Group name",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Display the user\\'s real name instead of login name" => "Display the user\\'s real name instead of login name",
// "Userpref" => "Userpref",
// "Display wiki text if user has a pref set to a value" => "Display wiki text if user has a pref set to a value",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Cannot create aliased page" => "Cannot create aliased page",
// "You attempted to create the following page" => "You attempted to create the following page",
// "That page is an alias for the following pages" => "That page is an alias for the following pages",
// "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this" => "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "User %s does not have the permission" => "User %s does not have the permission",
// "The message has been sent to" => "The message has been sent to",
// "The message will be sent to" => "The message will be sent to",
// "User %s does not want to receive messages" => "User %s does not want to receive messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page" => "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page",
// "Item types filter" => "Item types filter",
// "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes" => "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes",
// "Possible item type values" => "Possible item type values",
// "Google AdSense" => "Google AdSense",
// "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code" => "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code",
// "Advertisement channel, as optionally provided by Google" => "Advertisement channel, as optionally provided by Google",
// "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"" => "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"",
// "Global banner format as provided by Google. For example: \"display=468*60_as\"" => "Global banner format as provided by Google. For example: \"display=468*60_as\"",
// "Background color, as optionally provided by Google" => "Background color, as optionally provided by Google",
// "Border color, as optionally provided by Google" => "Border color, as optionally provided by Google",
// "Link color, as optionally provided by Google" => "Link color, as optionally provided by Google",
// "Text color, as optionally provided by Google" => "Text color, as optionally provided by Google",
// "URL color, as optionally provided by Google" => "URL color, as optionally provided by Google",
// "Article archives" => "Article archives",
// "Shows links to the published articles for each month" => "Shows links to the published articles for each month",
// "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles",
// "Default: \"n\"" => "Default: \"n\"",
// "Category filter" => "Category filter",
// "If set to a category identifier, only consider the articles in the specified category" => "If set to a category identifier, only consider the articles in the specified category",
// "Example value: 13" => "Example value: 13",
// "Not set by default" => "Not set by default",
// "Topic filter (by names)" => "Topic filter (by names)",
// "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values" => "Example values",
// "Topic filter (by identifiers)" => "Topic filter (by identifiers)",
// "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values: 13, !13, 1+3, !1+5+7" => "Example values: 13, !13, 1+3, !1+5+7",
// "Types filter" => "Types filter",
// "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered" => "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered",
// "Example values: Event, !Event, Event+Review, !Event+Classified+Article" => "Example values: Event, !Event, Event+Review, !Event+Classified+Article",
// "Language filter" => "Language filter",
// "If set to a language code, only consider the articles in the specified language" => "If set to a language code, only consider the articles in the specified language",
// "Article Topics" => "Article Topics",
// "Lists all article topics with links to their articles" => "Lists all article topics with links to their articles",
// "Lists the specified number of published articles in the specified order" => "Lists the specified number of published articles in the specified order",
// "Show publication time" => "Show publication time",
// "If set to \"y\", article publication times are shown" => "If set to \"y\", article publication times are shown",
// "Show creation time" => "Show creation time",
// "If set to \"y\", article creation times are shown" => "If set to \"y\", article creation times are shown",
// "Show rating selector" => "Show rating selector",
// "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating" => "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating",
// "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image" => "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image",
// "If set to a category identifier, only lists the articles in the specified category" => "If set to a category identifier, only lists the articles in the specified category",
// "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed" => "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed",
// "If set to a language code, only lists the articles in the specified language" => "If set to a language code, only lists the articles in the specified language",
// "Specifies how the articles should be sorted" => "Specifies how the articles should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date" => "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date",
// "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead" => "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead",
// "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles",
// "Absolute URL" => "Absolute URL",
// "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example" => "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example",
// "TikiWiki assistant" => "TikiWiki assistant",
// "Displays an assistant to guide new Tiki admins" => "Displays an assistant to guide new Tiki admins",
// "Last blog post comments" => "Last blog post comments",
// "Displays the specified number of the blog post comments most recently added" => "Displays the specified number of the blog post comments most recently added",
// "More in tooltips" => "More in tooltips",
// "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "No date" => "No date",
// "If set to \"y\", the date at which comments were posted is not displayed in the module box" => "If set to \"y\", the date at which comments were posted is not displayed in the module box",
// "Last visited pages" => "Last visited pages",
// "Displays the last Wiki pages visited by the user" => "Displays the last Wiki pages visited by the user",
// "Maximum length" => "Maximum length",
// "Maximum number of characters in page names allowed before truncating" => "Maximum number of characters in page names allowed before truncating",
// "Includes a calendar or a list of calendar events" => "Includes a calendar or a list of calendar events",
// "Displayed month (relative)" => "Displayed month (relative)",
// "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span" => "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span",
// "Displays links to categories as a tree" => "Displays links to categories as a tree",
// "Object type filter" => "Object type filter",
// "Object type filter to apply when accessing a linked category. Example values" => "Object type filter to apply when accessing a linked category. Example values",
// "Deep" => "Deep",
// "Show subcategories objects when accessing a linked category. Possible values: on (default), off" => "Show subcategories objects when accessing a linked category. Possible values: on (default), off",
// "PHP Layers menu style" => "PHP Layers menu style",
// "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree" => "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree",
// "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)" => "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)",
// "Category Transitions" => "Category Transitions",
// "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules" => "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules",
// "Change Category" => "Change Category",
// "Enables to categorize an object" => "Enables to categorize an object",
// "Category identifier" => "Category identifier",
// "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier" => "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier",
// "Note that the root category is not displayed" => "Note that the root category is not displayed",
// "Defaults to 0 (root)" => "Defaults to 0 (root)",
// "No top" => "No top",
// "In non-detailed view, disallow uncategorizing. Example value: 1" => "In non-detailed view, disallow uncategorizing. Example value: 1",
// "Display path" => "Display path",
// "Instead of category names, diplay their path in the category tree starting from the category root defined" => "Instead of category names, diplay their path in the category tree starting from the category root defined",
// "Example value: 1" => "Example value: 1",
// "Multiple categories" => "Multiple categories",
// "If set to \"n\", only allows categorizing in one category (from those displayed)" => "If set to \"n\", only allows categorizing in one category (from those displayed)",
// "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize" => "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize",
// "Shy" => "Shy",
// "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default" => "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default",
// "Detailed" => "Detailed",
// "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list" => "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list",
// "If set to \"n\", the detailed list of categories will not offer to unassign a category" => "If set to \"n\", the detailed list of categories will not offer to unassign a category",
// "If set to \"y\", allow to assign new categories" => "If set to \"y\", allow to assign new categories",
// "Example values: y, n" => "Example values: y, n",
// "Default value: y" => "Default value: y",
// "Default value: n" => "Default value: n",
// "Image URL not in category" => "Image URL not in category",
// "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category" => "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category",
// "Example value" => "Example value",
// "Image URL in category" => "Image URL in category",
// "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category" => "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category",
// "Categorize %s" => "Categorize %s",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Displays the number of pages received (via Communications)" => "Displays the number of pages received (via Communications)",
// "Last directory sites" => "Last directory sites",
// "Displays the specified number of the directory sites most recently added" => "Displays the specified number of the directory sites most recently added",
// "Directory category identifier" => "Directory category identifier",
// "If set to a directory category identifier, only displays the sites in the specified directory category" => "If set to a directory category identifier, only displays the sites in the specified directory category",
// "If set to \"y\", displays a button labelled \"More\" that links to the directory" => "If set to \"y\", displays a button labelled \"More\" that links to the directory",
// "Directory statistics" => "Directory statistics",
// "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links" => "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links",
// "Top directory sites" => "Top directory sites",
// "Displays the specified number of the directory sites from most visited to least visited" => "Displays the specified number of the directory sites from most visited to least visited",
// "Displays the site\\'s first featured links" => "Displays the site\\'s first featured links",
// "Displays links to file galleries" => "Displays links to file galleries",
// "Best rated topics" => "Best rated topics",
// "Displays the specified number of the forum topics with the best ratings" => "Displays the specified number of the forum topics with the best ratings",
// "Displays the latest forum posts" => "Displays the latest forum posts",
// "If set to \"y\", only displays topics" => "If set to \"y\", only displays topics",
// "Displays the specified number of the forums with the most comments" => "Displays the specified number of the forums with the most comments",
// "Displays the specified number of the forum topics with the most reads" => "Displays the specified number of the forum topics with the most reads",
// "Displays the specified number of the forums with the most visits" => "Displays the specified number of the forums with the most visits",
// "Freetags editor" => "Freetags editor",
// "Shows current freetags and enables to add and remove some if permissions allow" => "Shows current freetags and enables to add and remove some if permissions allow",
// "Freetags Wiki" => "Freetags Wiki",
// "Displays current freetags on wiki pages and enables to add tags if permissions allow" => "Displays current freetags on wiki pages and enables to add tags if permissions allow",
// "Similar freetags" => "Similar freetags",
// "Shows wiki pages with similar freetags" => "Shows wiki pages with similar freetags",
// "Similar pages" => "Similar pages",
// "Most popular tags" => "Most popular tags",
// "Shows the most popular freetags. More popularity is indicated by a larger font" => "Shows the most popular freetags. More popularity is indicated by a larger font",
// "Display type" => "Display type",
// "If set to \"cloud\", links are displayed as a cloud" => "If set to \"cloud\", links are displayed as a cloud",
// "Default: \"list\"" => "Default: \"list\"",
// "Maximum elements" => "Maximum elements",
// "If set to a number, limits the number of tags displayed" => "If set to a number, limits the number of tags displayed",
// "User preferred tags" => "User preferred tags",
// "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font" => "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font",
// "My preferred tags" => "My preferred tags",
// "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site" => "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site",
// "Groups emulation" => "Groups emulation",
// "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site" => "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site",
// "Emulate Groups" => "Emulate Groups",
// "Displays the specified number of last actions" => "Displays the specified number of last actions",
// "Show user" => "Show user",
// "If set to \"y\", user names are displayed in the module box" => "If set to \"y\", user names are displayed in the module box",
// "Show date" => "Show date",
// "If set to \"y\", action dates are displayed in the module box" => "If set to \"y\", action dates are displayed in the module box",
// "Maximum number of characters in action descriptions before truncating" => "Maximum number of characters in action descriptions before truncating",
// "Lists the specified number of blogs posts from newest to oldest" => "Lists the specified number of blogs posts from newest to oldest",
// "If set to \"y\", the date of posts is not displayed in the module box" => "If set to \"y\", the date of posts is not displayed in the module box",
// "Blog identifier" => "Blog identifier",
// "If set to a blog identifier, restricts the blog posts to those in the identified blog" => "If set to a blog identifier, restricts the blog posts to those in the identified blog",
// "Last category objects" => "Last category objects",
// "Lists the specified number of objects of the given type in the given category, starting from the most recently created" => "Lists the specified number of objects of the given type in the given category, starting from the most recently created",
// "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed" => "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed",
// "Maximum number of characters in object names allowed before truncating" => "Maximum number of characters in object names allowed before truncating",
// "Type of the objects to list. Example values" => "Type of the objects to list. Example values",
// "Displays the specified number of blogs from newest to oldest" => "Displays the specified number of blogs from newest to oldest",
// "Displays the specified number of FAQs from newest to oldest" => "Displays the specified number of FAQs from newest to oldest",
// "Displays the specified number of quizzes from newest to oldest" => "Displays the specified number of quizzes from newest to oldest",
// "Displays the specified number of file galleries, starting from the most recently modified" => "Displays the specified number of file galleries, starting from the most recently modified",
// "List the specified number of files, starting from the most recently added" => "List the specified number of files, starting from the most recently added",
// "Gallery identifiers" => "Gallery identifiers",
// "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers" => "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers",
// "Example value: 13, 2:13, 1:2:3:5:6" => "Example value: 13, 2:13, 1:2:3:5:6",
// "Last modified image galleries" => "Last modified image galleries",
// "Displays the specified number of image galleries, starting from the most recently modified" => "Displays the specified number of image galleries, starting from the most recently modified",
// "List the specified number of images, starting from the most recently added" => "List the specified number of images, starting from the most recently added",
// "Gallery identifier" => "Gallery identifier",
// "If set to an image gallery identifier, restricts the images to those in the identified gallery" => "If set to an image gallery identifier, restricts the images to those in the identified gallery",
// "Link content" => "Link content",
// "Display the links as image names or thumbnails" => "Display the links as image names or thumbnails",
// "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"" => "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"",
// "Displays the specified number of calendar events, starting from the most recently modified" => "Displays the specified number of calendar events, starting from the most recently modified",
// "Calendar identifier" => "Calendar identifier",
// "If set to a calendar identifier, restricts the events to those in the identified calendar" => "If set to a calendar identifier, restricts the events to those in the identified calendar",
// "Maximum number of characters in event names allowed before truncating" => "Maximum number of characters in event names allowed before truncating",
// "Lists the specified number of pages, starting from the most recently modified" => "Lists the specified number of pages, starting from the most recently modified",
// "Link target" => "Link target",
// "Target URL of the \"...more\" link at the bottom of the module" => "Target URL of the \"...more\" link at the bottom of the module",
// "Displays the specified number of blogs, starting from the most recently modified" => "Displays the specified number of blogs, starting from the most recently modified",
// "Lists the specified number of article submissions from newest to oldest" => "Lists the specified number of article submissions from newest to oldest",
// "Last tracker comments" => "Last tracker comments",
// "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted" => "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted",
// "Tracker identifier" => "Tracker identifier",
// "If set to a tracker identifier, only displays the comments on the given tracker" => "If set to a tracker identifier, only displays the comments on the given tracker",
// "Item identifier" => "Item identifier",
// "If set to an item identifier, only displays the comments on the given item" => "If set to an item identifier, only displays the comments on the given item",
// "Last tracker items" => "Last tracker items",
// "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required" => "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required",
// "Identifier of the tracker from which items are listed" => "Identifier of the tracker from which items are listed",
// "Field identifier" => "Field identifier",
// "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored" => "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored",
// "Field name" => "Field name",
// "Name of the field from which values are listed" => "Name of the field from which values are listed",
// "Example value: age" => "Example value: age",
// "Specifies how the items should be sorted" => "Specifies how the items should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date" => "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date",
// "Status filter" => "Status filter",
// "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values" => "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values",
// "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set" => "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set",
// "You do not have permission to view this tracker" => "You do not have permission to view this tracker",
// "Last Validated FAQs Questions" => "Last Validated FAQs Questions",
// "Displays the specified number of validated questions FAQs from newest to oldest" => "Displays the specified number of validated questions FAQs from newest to oldest",
// "Faq identifier" => "Faq identifier",
// "If set to a faq identifier, restricts the chosen questions to those in the identified faq" => "If set to a faq identifier, restricts the chosen questions to those in the identified faq",
// "Number of characters to display" => "Number of characters to display",
// "Displays information about the specified number of users in decreasing order of last login time" => "Displays information about the specified number of users in decreasing order of last login time",
// "Show avatars" => "Show avatars",
// "If set to \"y\", show user avatars" => "If set to \"y\", show user avatars",
// "Maximum number of characters in user names allowed before truncating" => "Maximum number of characters in user names allowed before truncating",
// "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console" => "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console",
// "Login box" => "Login box",
// "Input size" => "Input size",
// "Number of characters for username and password input fields" => "Number of characters for username and password input fields",
// "Logo" => "Logo",
// "Site logo, title and subtitle" => "Site logo, title and subtitle",
// "Menu page" => "Menu page",
// "Displays a Wiki page" => "Displays a Wiki page",
// "Page to display in the menu. Example value: HomePage" => "Page to display in the menu. Example value: HomePage",
// "Unread inter-user messages" => "Unread inter-user messages",
// "Displays to users their number of new inter-user messages and a link to their message box" => "Displays to users their number of new inter-user messages and a link to their message box",
// "Small live chat box" => "Small live chat box",
// "Channels" => "Channels",
// "List of chat channels. Channel names are separated by a comma (\",\")" => "List of chat channels. Channel names are separated by a comma (\",\")",
// "By default, a single channel named \"default\" exists" => "By default, a single channel named \"default\" exists",
// "Months links" => "Months links",
// "Links to the objects of a given type for the current month and those preceding it" => "Links to the objects of a given type for the current month and those preceding it",
// "Type of objects to link to" => "Type of objects to link to",
// "\"blogs\" for blog posts, \"cms\" for published articles" => "\"blogs\" for blog posts, \"cms\" for published articles",
// "Object identifier" => "Object identifier",
// "Identifier of an object with children to link to" => "Identifier of an object with children to link to",
// "This is required for the blog Object type" => "This is required for the blog Object type",
// "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3" => "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3",
// "List by month" => "List by month",
// "Displays the number of article submissions waiting examination and a link to the list" => "Displays the number of article submissions waiting examination and a link to the list",
// "Displays the specified number of old articles (which do not show on articles home page anymore)" => "Displays the specified number of old articles (which do not show on articles home page anymore)",
// "Enables to change current perspective" => "Enables to change current perspective",
// "Quick Edit" => "Quick Edit",
// "Enables to quickly create or edit Wiki pages" => "Enables to quickly create or edit Wiki pages",
// "Template identifier" => "Template identifier",
// "If set to a template identifier, the specified template is used for creating new Wiki pages" => "If set to a template identifier, the specified template is used for creating new Wiki pages",
// "If set, send the form to the given location (relative to Tiki\\'s root) for processing" => "If set, send the form to the given location (relative to Tiki\\'s root) for processing",
// "SUBMIT label" => "SUBMIT label",
// "The label on the button to submit the form" => "The label on the button to submit the form",
// "Size attribute (horizontal, in characters) of the text input field for page names" => "Size attribute (horizontal, in characters) of the text input field for page names",
// "Optional heading to display at the top of the module\\'s content" => "Optional heading to display at the top of the module\\'s content",
// "If set to a category identifier, pages created through the module are automatically categorized in the specified category" => "If set to a category identifier, pages created through the module are automatically categorized in the specified category",
// "Random image" => "Random image",
// "Displays a random image" => "Displays a random image",
// "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery" => "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery",
// "Show link" => "Show link",
// "If set to \"n\", the image thumbnail does not link to the image" => "If set to \"n\", the image thumbnail does not link to the image",
// "Default: \"y\"" => "Default: \"y\"",
// "Show name" => "Show name",
// "If set to \"y\", the name of the image is displayed" => "If set to \"y\", the name of the image is displayed",
// "If set to \"y\", the description of the image is displayed" => "If set to \"y\", the description of the image is displayed",
// "Displays the specified number of random wiki pages" => "Displays the specified number of random wiki pages",
// "New user registrationmore tiki-re" => "New user registrationmore tiki-re",
// "Feeds List" => "Feeds List",
// "List of feeds available on this site" => "List of feeds available on this site",
// "Search Box" => "Search Box",
// "Advanced search (for wiki, articles, blogs etc)" => "Advanced search (for wiki, articles, blogs etc)",
// "Search Box (new)" => "Search Box (new)",
// "Search Wiki Page" => "Search Wiki Page",
// "Search for a wiki page by name" => "Search for a wiki page by name",
// "Search Wiki Page (new)" => "Search Wiki Page (new)",
// "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from" => "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from",
// "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages" => "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages",
// "Tooltip" => "Tooltip",
// "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content" => "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content",
// "Label on the button to post a message" => "Label on the button to post a message",
// "Wait label" => "Wait label",
// "Label on the button to post a message when the message is being posted if AJAX is enabled" => "Label on the button to post a message when the message is being posted if AJAX is enabled",
// "Maximum messages shown" => "Maximum messages shown",
// "Number of messages to display" => "Number of messages to display",
// "Please wait.." => "Please wait..",
// "Since last visit (simple)" => "Since last visit (simple)",
// "Displays to logged in users the number of new or updated objects since their last login date and time" => "Displays to logged in users the number of new or updated objects since their last login date and time",
// "Since last visit" => "Since last visit",
// "Displays to logged in users new or updated objects since a point in time, by default their last login date and time" => "Displays to logged in users new or updated objects since a point in time, by default their last login date and time",
// "Show users" => "Show users",
// "If set to \"n\", do not show new users" => "If set to \"n\", do not show new users",
// "Show trackers" => "Show trackers",
// "If set to \"n\", do not show tracker changes" => "If set to \"n\", do not show tracker changes",
// "Calendar focus" => "Calendar focus",
// "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar" => "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar",
// "Since your last visit.." => "Since your last visit..",
// "new posts" => "new posts",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "Switch Language" => "Switch Language",
// "Displays a language picker to change the language of the site" => "Displays a language picker to change the language of the site",
// "Display mode" => "Display mode",
// "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist" => "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist",
// "Prefix" => "Prefix",
// "Changes the default displayed prefix from \\\"Site Language:\\\"" => "Changes the default displayed prefix from \\\"Site Language:\\\"",
// "Switch theme" => "Switch theme",
// "Enables to quickly change the theme" => "Enables to quickly change the theme",
// "Terminology" => "Terminology",
// "Support for multilingual terminology" => "Support for multilingual terminology",
// "Tiki Tests" => "Tiki Tests",
// "Tiki test suite helper" => "Tiki test suite helper",
// "Displays the specified number of blogs with links to them, from the most active one to the least" => "Displays the specified number of blogs with links to them, from the most active one to the least",
// "Blog activity measurement can be more or less accurate" => "Blog activity measurement can be more or less accurate",
// "Lists the specified number of articles with links to them, from the most visited one to the least" => "Lists the specified number of articles with links to them, from the most visited one to the least",
// "Displays the specified number of file galleries with links to them, starting with the one with most hits" => "Displays the specified number of file galleries with links to them, starting with the one with most hits",
// "Displays the specified number of files with links to them, starting with the one with most hits" => "Displays the specified number of files with links to them, starting with the one with most hits",
// "Displays the specified number of users who posted to forums, starting with the one having most posts" => "Displays the specified number of users who posted to forums, starting with the one having most posts",
// "Top image galleries" => "Top image galleries",
// "Displays the specified number of image galleries with links to them, starting with the one with most hits" => "Displays the specified number of image galleries with links to them, starting with the one with most hits",
// "Displays the specified number of images with links to them, from the most visited one to the least" => "Displays the specified number of images with links to them, from the most visited one to the least",
// "Top Objects" => "Top Objects",
// "Displays the specified number of objects, starting with the one having the most hits" => "Displays the specified number of objects, starting with the one having the most hits",
// "Displays the specified number of wiki pages with links to them, starting with the one having the most hits" => "Displays the specified number of wiki pages with links to them, starting with the one having the most hits",
// "Displays the specified number of quizzes with links to them, starting with the one having the most hits" => "Displays the specified number of quizzes with links to them, starting with the one having the most hits",
// "Displays the specified number of blogs with links to them, from the most visited one to the least" => "Displays the specified number of blogs with links to them, from the most visited one to the least",
// "Displays the specified number of FAQs with links to them, from the most visited one to the least" => "Displays the specified number of FAQs with links to them, from the most visited one to the least",
// "Page translation" => "Page translation",
// "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed" => "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed",
// "Reference language" => "Reference language",
// "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed" => "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed",
// "Lists the specified number of calendar events, ordered by their start date" => "Lists the specified number of calendar events, ordered by their start date",
// "Calendars filter" => "Calendars filter",
// "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")" => "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")",
// "Maximum days in the future" => "Maximum days in the future",
// "Maximum distance to event start dates in days (looking forward)" => "Maximum distance to event start dates in days (looking forward)",
// "Maximum days in the past" => "Maximum days in the past",
// "Maximum distance to event end dates in days (looking backward)" => "Maximum distance to event end dates in days (looking backward)",
// "cellpadding" => "cellpadding",
// "cellspacing" => "cellspacing",
// "If set to \"y\", event descriptions are displayed" => "If set to \"y\", event descriptions are displayed",
// "Show end date and time" => "Show end date and time",
// "If set to \"y\", event end dates and times are displayed, when appropriate" => "If set to \"y\", event end dates and times are displayed, when appropriate",
// "Use custom calendar background colors" => "Use custom calendar background colors",
// "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)" => "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)",
// "Show information in tooltips" => "Show information in tooltips",
// "If set to \"n\", event tooltips will not display event information" => "If set to \"n\", event tooltips will not display event information",
// "Date format" => "Date format",
// "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>" => "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>",
// "site preference for short date format followed by site preference for short time format" => "site preference for short date format followed by site preference for short time format",
// "If set to an integer, event names are allowed that number of characters as a maximum before being truncated" => "If set to an integer, event names are allowed that number of characters as a maximum before being truncated",
// "Displays to registered users their blogs" => "Displays to registered users their blogs",
// "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed" => "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed",
// "User image galleries" => "User image galleries",
// "Displays to registered users their image galleries" => "Displays to registered users their image galleries",
// "Displays to registered users the specified number of wiki pages which they were the last to edit" => "Displays to registered users the specified number of wiki pages which they were the last to edit",
// "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations" => "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations",
// "Lists the public user tasks of a chosen group, with links to tasks" => "Lists the public user tasks of a chosen group, with links to tasks",
// "User-Group Tracker" => "User-Group Tracker",
// "User and Group tracker links" => "User and Group tracker links",
// "Displays the specified number of users and their score, starting from the one with the highest score" => "Displays the specified number of users and their score, starting from the one with the highest score",
// "Webmail Inbox" => "Webmail Inbox",
// "Displays Webmail Inbox" => "Displays Webmail Inbox",
// "Account Id" => "Account Id",
// "Webmail account identifier (if not set uses user\\'s current account)" => "Webmail account identifier (if not set uses user\\'s current account)",
// "GroupMail: Group (e.g. \"Help Team\")" => "GroupMail: Group (e.g. \"Help Team\")",
// "GroupMail: Tracker Id (to store GroupMail activity)" => "GroupMail: Tracker Id (to store GroupMail activity)",
// "GroupMail: From Field (Id of field in tracker to store email From header)" => "GroupMail: From Field (Id of field in tracker to store email From header)",
// "Subject Field Id" => "Subject Field Id",
// "GroupMail: Subject Field (Id of field in tracker to store email Subject header)" => "GroupMail: Subject Field (Id of field in tracker to store email Subject header)",
// "Message Field Id" => "Message Field Id",
// "GroupMail: Message Field (Id of field in tracker to store email message identifier)" => "GroupMail: Message Field (Id of field in tracker to store email message identifier)",
// "Content Field Id" => "Content Field Id",
// "GroupMail: Content Field (Id of field in tracker to store email message body content)" => "GroupMail: Content Field (Id of field in tracker to store email message body content)",
// "Account Field Id" => "Account Field Id",
// "GroupMail: Account Field (Id of field in tracker to store Webmail account name)" => "GroupMail: Account Field (Id of field in tracker to store Webmail account name)",
// "DateTime Field Id" => "DateTime Field Id",
// "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)" => "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)",
// "Operator Field Id" => "Operator Field Id",
// "GroupMail: Operator Field (Id of field in tracker to store operator name (username))" => "GroupMail: Operator Field (Id of field in tracker to store operator name (username))",
// "Maximum number of characters in subjects allowed before truncating" => "Maximum number of characters in subjects allowed before truncating",
// "Webmail error" => "Webmail error",
// "No accounts set up (or no current account set)" => "No accounts set up (or no current account set)",
// "Wiki Page" => "Wiki Page",
// "What is related" => "What is related",
// "Lists objects which share a category with the viewed object" => "Lists objects which share a category with the viewed object",
// "Displays information about users currently logged in" => "Displays information about users currently logged in",
// "Content to display" => "Content to display",
// "Display the number of users logged in, the list of users logged in, or both" => "Display the number of users logged in, the list of users logged in, or both",
// "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"" => "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"",
// "Cluster mode" => "Cluster mode",
// "If set to \"1\", separate users based on which host/server they logged on" => "If set to \"1\", separate users based on which host/server they logged on",
// "Last comments" => "Last comments",
// "Lists the specified number of comments starting from the most recently posted" => "Lists the specified number of comments starting from the most recently posted",
// "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "Type of the objects from which comments will be listed. Possible values" => "Type of the objects from which comments will be listed. Possible values",
// "Last article comments" => "Last article comments",
// "YouTube" => "YouTube",
// "Displays YouTube videos and/or a link to a YouTube user\\'s page" => "Displays YouTube videos and/or a link to a YouTube user\\'s page",
// "Video identifiers" => "Video identifiers",
// "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")" => "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")",
// "YouTube user identifier" => "YouTube user identifier",
// "If set to a YouTube user identifier, display a link to the videos of this user" => "If set to a YouTube user identifier, display a link to the videos of this user",
// "Width of each video in pixels" => "Width of each video in pixels",
// "Height of each video in pixels" => "Height of each video in pixels",
// "Videos on YouTube" => "Videos on YouTube",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin external feeds" => "Can admin external feeds",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can list newsletters" => "Can list newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin toolbars" => "Can admin toolbars",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can change tracker pending items" => "Can change tracker pending items",
// "Can change tracker closed items" => "Can change tracker closed items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "Can invite user in groups" => "Can invite user in groups",
// "Can delete his own account" => "Can delete his own account",
// "Can use the Tiki Importer" => "Can use the Tiki Importer",
// "Can admin categories" => "Can admin categories",
// "Can see the category in a listing" => "Can see the category in a listing",
// "Can change the categories on the object" => "Can change the categories on the object",
// "Can add objects in the category" => "Can add objects in the category",
// "Can remove objects from the category" => "Can remove objects from the category",
// "Can create new categories" => "Can create new categories",
// "Can view the perspective" => "Can view the perspective",
// "Can view the group" => "Can view the group",
// "Can view the group members" => "Can view the group members",
// "Can add group members" => "Can add group members",
// "Can remove group members" => "Can remove group members",
// "Can join or leave the group" => "Can join or leave the group",
// "Can trigger the transition between two states" => "Can trigger the transition between two states",
// "Can admin kaltura feature" => "Can admin kaltura feature",
// "Can upload video on kaltura server" => "Can upload video on kaltura server",
// "Can edit information of kaltura entry" => "Can edit information of kaltura entry",
// "Can create kaltura remix video" => "Can create kaltura remix video",
// "Can delete kaltura entry" => "Can delete kaltura entry",
// "Can download kaltura entry" => "Can download kaltura entry",
// "Can list kaltura entries" => "Can list kaltura entries",
// "Can view kaltura entry" => "Can view kaltura entry",
// "Can upload screencasts to wiki pages" => "Can upload screencasts to wiki pages",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "groups are emulated" => "groups are emulated",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature listorphanStructure" => "feature listorphanStructure",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki dft list pages lang to current" => "wiki dft list pages lang to current",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki comments allow per page" => "wiki comments allow per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit icons toggle" => "wiki edit icons toggle",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "feature pagelist" => "feature pagelist",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin calendar" => "wikiplugin calendar",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin datachannel" => "wikiplugin datachannel",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin groupmailcore" => "wikiplugin groupmailcore",
// "wikiplugin groupstat" => "wikiplugin groupstat",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin invite" => "wikiplugin invite",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin listprogress" => "wikiplugin listprogress",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mcalendar" => "wikiplugin mcalendar",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin memberlist" => "wikiplugin memberlist",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin pagelist" => "wikiplugin pagelist",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin realnamelist" => "wikiplugin realnamelist",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin screencast" => "wikiplugin screencast",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin stat" => "wikiplugin stat",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin tabs" => "wikiplugin tabs",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin userpref" => "wikiplugin userpref",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline calendar" => "wikiplugininline calendar",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline datachannel" => "wikiplugininline datachannel",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline groupmailcore" => "wikiplugininline groupmailcore",
// "wikiplugininline groupstat" => "wikiplugininline groupstat",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline invite" => "wikiplugininline invite",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline listprogress" => "wikiplugininline listprogress",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mcalendar" => "wikiplugininline mcalendar",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline memberlist" => "wikiplugininline memberlist",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline pagelist" => "wikiplugininline pagelist",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline realnamelist" => "wikiplugininline realnamelist",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline screencast" => "wikiplugininline screencast",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline stat" => "wikiplugininline stat",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline tabs" => "wikiplugininline tabs",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline userpref" => "wikiplugininline userpref",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature webservices" => "feature webservices",
// "feature semantic" => "feature semantic",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal root id" => "fgal root id",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastModif" => "fgal list lastModif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "fgal quota" => "fgal quota",
// "fgal quota per fgal" => "fgal quota per fgal",
// "fgal quota default" => "fgal quota default",
// "fgal quota show" => "fgal quota show",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings threshold" => "forum thread user settings threshold",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list rating" => "art list rating",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "trackerCreatorGroupName" => "trackerCreatorGroupName",
// "tracker jquery user selector threshold" => "tracker jquery user selector threshold",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "users prefs mailCurrentAccount" => "users prefs mailCurrentAccount",
// "validateRegistration" => "validateRegistration",
// "validator emails" => "validator emails",
// "url after validation" => "url after validation",
// "urlOnUsername" => "urlOnUsername",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature search preferences" => "feature search preferences",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "feature cal manual time" => "feature cal manual time",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "title rss forums" => "title rss forums",
// "title rss forum" => "title rss forum",
// "title rss directories" => "title rss directories",
// "title rss articles" => "title rss articles",
// "title rss blogs" => "title rss blogs",
// "title rss image galleries" => "title rss image galleries",
// "title rss file galleries" => "title rss file galleries",
// "title rss wiki" => "title rss wiki",
// "title rss image gallery" => "title rss image gallery",
// "title rss file gallery" => "title rss file gallery",
// "title rss blog" => "title rss blog",
// "title rss tracker" => "title rss tracker",
// "title rss trackers" => "title rss trackers",
// "title rss calendar" => "title rss calendar",
// "title rss mapfiles" => "title rss mapfiles",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupnameatr" => "auth ldap groupnameatr",
// "auth ldap groupdescatr" => "auth ldap groupdescatr",
// "auth ldap usergroupattr" => "auth ldap usergroupattr",
// "auth ldap groupgroupattr" => "auth ldap groupgroupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "ldap create user tiki" => "ldap create user tiki",
// "ldap create user ldap" => "ldap create user ldap",
// "ldap skip admin" => "ldap skip admin",
// "auth ldap permit tiki users" => "auth ldap permit tiki users",
// "auth ldap debug" => "auth ldap debug",
// "auth ldap ssl" => "auth ldap ssl",
// "auth ldap starttls" => "auth ldap starttls",
// "auth ldap type" => "auth ldap type",
// "auth ldap syncuserattr" => "auth ldap syncuserattr",
// "auth ldap syncgroupattr" => "auth ldap syncgroupattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "category jail" => "category jail",
// "expanded category jail" => "expanded category jail",
// "expanded category jail key" => "expanded category jail key",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "feature translation incomplete notice" => "feature translation incomplete notice",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "language inclusion threshold" => "language inclusion threshold",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag pagedesc" => "metatag pagedesc",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature custom html head content" => "feature custom html head content",
// "users prefs theme" => "users prefs theme",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "box shadow start" => "box shadow start",
// "box shadow end" => "box shadow end",
// "feature custom center column header" => "feature custom center column header",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "site title location" => "site title location",
// "site title breadcrumb" => "site title breadcrumb",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "section comments parse" => "section comments parse",
// "toolbar global" => "toolbar global",
// "toolbar global comments" => "toolbar global comments",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "feature kaltura" => "feature kaltura",
// "wikiplugin kaltura" => "wikiplugin kaltura",
// "wikiplugininline kaltura" => "wikiplugininline kaltura",
// "default kaltura editor" => "default kaltura editor",
// "partnerId" => "partnerId",
// "secret" => "secret",
// "adminSecret" => "adminSecret",
// "kdpUIConf" => "kdpUIConf",
// "kdpWidget" => "kdpWidget",
// "kcwUIConf" => "kcwUIConf",
// "kseUIConf" => "kseUIConf",
// "kaeUIConf" => "kaeUIConf",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature htmlpurifier output" => "feature htmlpurifier output",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature machine translation" => "feature machine translation",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature perspective" => "feature perspective",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature daily report watches" => "feature daily report watches",
// "feature quick object perms" => "feature quick object perms",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session storage" => "session storage",
// "session lifetime" => "session lifetime",
// "session silent" => "session silent",
// "session cookie name" => "session cookie name",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "page n times in a structure" => "page n times in a structure",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "menus items icons" => "menus items icons",
// "menus items icons path" => "menus items icons path",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery ui theme" => "feature jquery ui theme",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature wiki screencasts" => "feature wiki screencasts",
// "feature wiki screencasts base" => "feature wiki screencasts base",
// "feature wiki screencasts httpbase" => "feature wiki screencasts httpbase",
// "feature wiki screencasts upload type" => "feature wiki screencasts upload type",
// "feature wiki screencasts user" => "feature wiki screencasts user",
// "feature wiki screencasts pass" => "feature wiki screencasts pass",
// "feature wiki screencasts max size" => "feature wiki screencasts max size",
// "feature tikitests" => "feature tikitests",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "memcache enabled" => "memcache enabled",
// "memcache flags" => "memcache flags",
// "memcache servers" => "memcache servers",
// "memcache expiration" => "memcache expiration",
// "memcache prefix" => "memcache prefix",
// "memcache wiki data" => "memcache wiki data",
// "memcache wiki output" => "memcache wiki output",
// "memcache forum output" => "memcache forum output",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "zend mail handler" => "zend mail handler",
// "zend mail smtp server" => "zend mail smtp server",
// "zend mail smtp auth" => "zend mail smtp auth",
// "zend mail smtp user" => "zend mail smtp user",
// "zend mail smtp pass" => "zend mail smtp pass",
// "zend mail smtp port" => "zend mail smtp port",
// "zend mail smtp security" => "zend mail smtp security",
// "feature group transition" => "feature group transition",
// "feature category transition" => "feature category transition",
// "terminology profile installed" => "terminology profile installed",
// "multidomain active" => "multidomain active",
// "multidomain config" => "multidomain config",
// "feature use minified scripts" => "feature use minified scripts",
// "tiki minify javascript" => "tiki minify javascript",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "mailCurrentAccount" => "mailCurrentAccount",
// "Click Here to Insert in Wiki Syntax" => "Click Here to Insert in Wiki Syntax",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Errors" => "Errors",
// "Comments Locked" => "Comments Locked",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "Post new message" => "Post new message",
// "required" => "required",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "System error" => "System error",
// "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue" => "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue",
// "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation" => "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation",
// "The query was" => "The query was",
// "The built query was likely" => "The built query was likely",
// "Stacktrace" => "Stacktrace",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "File gallery" => "File gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate permissions" => "Duplicate permissions",
// "View inserted gallery" => "View inserted gallery",
// "System" => "System",
// "Any file" => "Any file",
// "Podcast (audio)" => "Podcast (audio)",
// "Podcast (video)" => "Podcast (video)",
// "Gallery is visible to non-admin users" => "Gallery is visible to non-admin users",
// "Gallery is public" => "Gallery is public",
// "Any user with permission (not only the gallery owner) can upload files" => "Any user with permission (not only the gallery owner) can upload files",
// "Files can be locked at download" => "Files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "Owner of the gallery" => "Owner of the gallery",
// "Quota" => "Quota",
// "Used" => "Used",
// "Min" => "Min",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Display Properties" => "Display Properties",
// "Descending" => "Descending",
// "Ascending" => "Ascending",
// "Max rows per page" => "Max rows per page",
// "Select which items to display when listing galleries" => "Select which items to display when listing galleries",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Go to Login Page" => "Go to Login Page",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "The checkbox is disabled because this preference is disabled globally" => "The checkbox is disabled because this preference is disabled globally",
// "Please, enable the preference globally first" => "Please, enable the preference globally first",
// "You can ask your site Admin to enable the preference" => "You can ask your site Admin to enable the preference",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Show an icon in a column" => "Show an icon in a column",
// "Start the Slideshow" => "Start the Slideshow",
// "Pause the Slideshow" => "Pause the Slideshow",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Calendars" => "RSS Calendars",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "A new topic was posted to forum" => "A new topic was posted to forum",
// "You are invited by" => "You are invited by",
// "You join this group" => "You join this group",
// "Join me on %s" => "Join me on %s",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "Assign to a group" => "Assign to a group",
// "Best regards" => "Best regards",
// "User Tracker" => "User Tracker",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Someone" => "Someone",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Report for" => "Report for",
// "Last Report sent on" => "Last Report sent on",
// "Changes in detail" => "Changes in detail",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "updated" => "updated",
// "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "A file was attached to {\$mail_page}" => "A file was attached to {\$mail_page}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "A file was attached to %s" => "A file was attached to %s",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Zoom in" => "Zoom in",
// "from the mapfile" => "from the mapfile",
// "hits last 7 days" => "hits last 7 days",
// "Confirmation" => "Confirmation",
// "Please Confirm" => "Please Confirm",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "is reply to" => "is reply to",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "Toggle Vertically" => "Toggle Vertically",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "More.." => "More..",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as admin" => "as admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "Missing %0 of the following categories" => "Missing %0 of the following categories",
// "%0 extra of the following categories" => "%0 extra of the following categories",
// "Unknown comparison" => "Unknown comparison",
// "Impossible condition, %0 of" => "Impossible condition, %0 of",
// "Apply" => "Apply",
// "Assign into category" => "Assign into category",
// "Unassign category" => "Unassign category",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "List everything tagged" => "List everything tagged",
// "All Groups" => "All Groups",
// "Your Groups" => "Your Groups",
// "Emulated Groups" => "Emulated Groups",
// "Switch to Groups" => "Switch to Groups",
// "Simulate" => "Simulate",
// "No records to display" => "No records to display",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Enter user name and click 'Switch'.<br />Useful for testing permissions" => "Enter user name and click 'Switch'.<br />Useful for testing permissions",
// "Switch user" => "Switch user",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Wiki feed" => "Wiki feed",
// "Feed" => "Feed",
// "Blogs feed" => "Blogs feed",
// "Articles feed" => "Articles feed",
// "Image Galleries feed" => "Image Galleries feed",
// "File Galleries feed" => "File Galleries feed",
// "Forums feed" => "Forums feed",
// "Maps feed" => "Maps feed",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Shout date" => "Shout date",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "Find term" => "Find term",
// "If not found, you will be given a chance to create it" => "If not found, you will be given a chance to create it",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Group information" => "Group information",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Webmail inbox" => "Webmail inbox",
// "Refresh (non-ajax)" => "Refresh (non-ajax)",
// "TAKE" => "TAKE",
// "View contact" => "View contact",
// "on host" => "on host",
// "User does not accept messages" => "User does not accept messages",
// "Send a message" => "Send a message",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "Use Ctrl+Click to select multiple options" => "Use Ctrl+Click to select multiple options",
// "Requires" => "Requires",
// "You need to set" => "You need to set",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "By" => "By",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Global site configuration, date formats, admin password etc" => "Global site configuration, date formats, admin password etc",
// "Switches for major features" => "Switches for major features",
// "User resistration, remember me cookie settings and authentication methods" => "User resistration, remember me cookie settings and authentication methods",
// "User specific features and settings" => "User specific features and settings",
// "Profiles" => "Profiles",
// "Repository configuration, browse and apply profiles" => "Repository configuration, browse and apply profiles",
// "Look & Feel" => "Look & Feel",
// "Theme selection, layout settings and UI effect controls" => "Theme selection, layout settings and UI effect controls",
// "i18n" => "i18n",
// "Internationalization and localization - mulitlingual features" => "Internationalization and localization - mulitlingual features",
// "Editing and Plugins" => "Editing and Plugins",
// "Text editing settings applicable to many areas. Plugin activation and plugin alias management" => "Text editing settings applicable to many areas. Plugin activation and plugin alias management",
// "Module appearance settings" => "Module appearance settings",
// "Information to include in the header of each page" => "Information to include in the header of each page",
// "Performance" => "Performance",
// "Server performance settings" => "Server performance settings",
// "Security" => "Security",
// "Site security settings" => "Site security settings",
// "Feeds" => "Feeds",
// "Web feeds" => "Web feeds",
// "Connect" => "Connect",
// "Wiki page settings and features" => "Wiki page settings and features",
// "Defaults and configuration for file galleries" => "Defaults and configuration for file galleries",
// "Settings for blogs" => "Settings for blogs",
// "Defaults and configuration for image galleries (will be phased out in favour of file galleries)" => "Defaults and configuration for image galleries (will be phased out in favour of file galleries)",
// "Settings and features for articles" => "Settings and features for articles",
// "Settings and features for forums" => "Settings and features for forums",
// "Settings and features for trackers" => "Settings and features for trackers",
// "Settings and features for polls" => "Settings and features for polls",
// "Settings and features for calendars" => "Settings and features for calendars",
// "Settings and features for categories" => "Settings and features for categories",
// "Values of actions for users rank score" => "Values of actions for users rank score",
// "Settings and features for freetags" => "Settings and features for freetags",
// "Search configuration" => "Search configuration",
// "Settings and features for FAQs" => "Settings and features for FAQs",
// "Settings and features for directory of links" => "Settings and features for directory of links",
// "Settings and features for maps" => "Settings and features for maps",
// "Defaults and API key for Google Maps" => "Defaults and API key for Google Maps",
// "?" => "?",
// "Site-wide copyright information" => "Site-wide copyright information",
// "Message settings" => "Message settings",
// "User files settings" => "User files settings",
// "Webmail settings" => "Webmail settings",
// "Options for WYSIWYG editor" => "Options for WYSIWYG editor",
// "InterTiki" => "InterTiki",
// "Set up links between Tiki servers" => "Set up links between Tiki servers",
// "Manage semantic wiki links" => "Manage semantic wiki links",
// "Webservices" => "Webservices",
// "Register and manage web services" => "Register and manage web services",
// "Sef URL" => "Sef URL",
// "Search Engine Friendly URLs" => "Search Engine Friendly URLs",
// "Kaltura video configuration" => "Kaltura video configuration",
// "Create a blog" => "Create a blog",
// "Requires a separate download" => "Requires a separate download",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Blogs Listings" => "Blogs Listings",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "Week" => "Week",
// "Month" => "Month",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Depends user language" => "Depends user language",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Title of articles home page" => "Title of articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Batch upload (CSV file)" => "Batch upload (CSV file)",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Articles Listing" => "Articles Listing",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "User features" => "User features",
// "Highlight group" => "Highlight group",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Feature is disabled" => "Feature is disabled",
// "Enable now" => "Enable now",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU" => "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU",
// "Join the community" => "Join the community",
// "Promote your site" => "Promote your site",
// "To submit your site to TikiWiki.org" => "To submit your site to TikiWiki.org",
// "Submit site" => "Submit site",
// "Help Tiki spread" => "Help Tiki spread",
// "Help improve Tiki" => "Help improve Tiki",
// "To submit a feature request or to report a bug" => "To submit a feature request or to report a bug",
// "Click here to go to our development site" => "Click here to go to our development site",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Enable copyright management for" => "Enable copyright management for",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "Global features" => "Global features",
// "Main feature" => "Main feature",
// "Additional" => "Additional",
// "Programmer" => "Programmer",
// "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application" => "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application",
// "Experimental" => "Experimental",
// "Will be phased out" => "Will be phased out",
// "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology" => "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology",
// "Seem ok but.." => "Seem ok but..",
// "These features are not reported to be broken, but they are not actively developed and/or widely used" => "These features are not reported to be broken, but they are not actively developed and/or widely used",
// "Need polish" => "Need polish",
// "These features are generally known to have issues, and/or need admin help and/or user patience to work" => "These features are generally known to have issues, and/or need admin help and/or user patience to work",
// "Feedbacks" => "Feedbacks",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "Create a Gallery" => "Create a Gallery",
// "Move files from database to directory" => "Move files from database to directory",
// "Move files from directory to database" => "Move files from directory to database",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "Score is disabled" => "Score is disabled",
// "Upload Regex" => "Upload Regex",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Search Indexing" => "Search Indexing",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "System Command" => "System Command",
// "Create a forum" => "Create a forum",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "When listing forums" => "When listing forums",
// "Forums Listing" => "Forums Listing",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "3D Tag Browser" => "3D Tag Browser",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Physics engine" => "Physics engine",
// "No Gallery exists" => "No Gallery exists",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates now" => "Check for updates now",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences",
// "Mail" => "Mail",
// "Mail Sender" => "Mail Sender",
// "Sendmail" => "Sendmail",
// "SMTP" => "SMTP",
// "SMTP Server" => "SMTP Server",
// "Authentication" => "Authentication",
// "These values will be stored in plain text in the database" => "These values will be stored in plain text in the database",
// "Logging and Reporting" => "Logging and Reporting",
// "Visible to admin only" => "Visible to admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Spam protection" => "Spam protection",
// "MultiDomain" => "MultiDomain",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Changing this feature will immediately log you out when you save this preference" => "Changing this feature will immediately log you out when you save this preference",
// "Contact" => "Contact",
// "Miscellaneous" => "Miscellaneous",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Redirects" => "Redirects",
// "If a requested page doesn't exist, redirect to a similarly named page" => "If a requested page doesn't exist, redirect to a similarly named page",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Site Access" => "Site Access",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details" => "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details",
// "Google Maps API Key" => "Google Maps API Key",
// "Defaults" => "Defaults",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "Edit or export/import Languages" => "Edit or export/import Languages",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Kaltura Registration" => "Kaltura Registration",
// "If you don't have a Kaltura Partner Id, " => "If you don't have a Kaltura Partner Id, ",
// "to register" => "to register",
// "Kaltura Partner Settings" => "Kaltura Partner Settings",
// "Partner Id" => "Partner Id",
// "User Secret" => "User Secret",
// "Admin Secret" => "Admin Secret",
// "Kaltura Dynamic Player" => "Kaltura Dynamic Player",
// "KDP UI Configuration Id" => "KDP UI Configuration Id",
// "KDP Widget Id" => "KDP Widget Id",
// "Kaltura Contribution Wizard" => "Kaltura Contribution Wizard",
// "KCW UI Configuration Id" => "KCW UI Configuration Id",
// "Kaltura Remix Editors" => "Kaltura Remix Editors",
// "Kaltura Simple Editor UI Configuration Id" => "Kaltura Simple Editor UI Configuration Id",
// "Kaltura Advance Editor UI Configuration Id" => "Kaltura Advance Editor UI Configuration Id",
// "Wysiwyg" => "Wysiwyg",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Validator emails (separated by comma) if different than the sender email" => "Validator emails (separated by comma) if different than the sender email",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Url a user is redirected after account validation" => "Url a user is redirected after account validation",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to LDAP for these changes to take effect" => "You must change the Authentication Method to LDAP for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in LDAP" => "Create user if not in LDAP",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Use Tiki authentication for users created in tiki" => "Use Tiki authentication for users created in tiki",
// "LDAP Bind settings" => "LDAP Bind settings",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Write LDAP debug Information in Tiki Logs" => "Write LDAP debug Information in Tiki Logs",
// "Use SSL (ldaps)" => "Use SSL (ldaps)",
// "Use TLS" => "Use TLS",
// "LDAP Bind Type" => "LDAP Bind Type",
// "Default: userattr=username,UserDN,BaseDN" => "Default: userattr=username,UserDN,BaseDN",
// "userattr=username,BaseDN" => "userattr=username,BaseDN",
// "Active Directory (username@domain)" => "Active Directory (username@domain)",
// "Plain Username" => "Plain Username",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Synchronize user attributes to tiki everytime the user logs in" => "Synchronize user attributes to tiki everytime the user logs in",
// "LDAP Group" => "LDAP Group",
// "Synchronize group attributes to tiki everytime the user logs in" => "Synchronize group attributes to tiki everytime the user logs in",
// "Note: this enables the usage of LDAP groups" => "Note: this enables the usage of LDAP groups",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group description attribute" => "Group description attribute",
// "Group OC" => "Group OC",
// "LDAP Group Member - if group membership can be found in group attributes" => "LDAP Group Member - if group membership can be found in group attributes",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP User Group - if group membership can be found in user attributes" => "LDAP User Group - if group membership can be found in user attributes",
// "Group attribute in group entry" => "Group attribute in group entry",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "CAS" => "CAS",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "Themes" => "Themes",
// "Theme options" => "Theme options",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme Screenshot" => "Theme Screenshot",
// "Each group can have its theme" => "Each group can have its theme",
// "Slideshow theme" => "Slideshow theme",
// "View Templates" => "View Templates",
// "Custom HTML &lt;head&gt; Content" => "Custom HTML &lt;head&gt; Content",
// "Custom Site Header" => "Custom Site Header",
// "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users" => "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users",
// "Site Logo and Title" => "Site Logo and Title",
// "Logo source (image path)" => "Logo source (image path)",
// "Logo background color" => "Logo background color",
// "Examples" => "Examples",
// "Logo background style" => "Logo background style",
// "Logo alignment" => "Logo alignment",
// "Logo title (on mouse over)" => "Logo title (on mouse over)",
// "Site title" => "Site title",
// "Search Bar" => "Search Bar",
// "Login Bar" => "Login Bar",
// "Top Bar" => "Top Bar",
// "Requires CSS Menus or PHPLayers" => "Requires CSS Menus or PHPLayers",
// "Menu ID" => "Menu ID",
// "Display current Tiki version" => "Display current Tiki version",
// "Custom Center Column Header" => "Custom Center Column Header",
// "only if module" => "only if module",
// "Prefix breadcrumbs with &quot;Location : &quot" => "Prefix breadcrumbs with &quot;Location : &quot",
// "Top of page" => "Top of page",
// "Top of center column" => "Top of center column",
// "Entire location" => "Entire location",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of &lt;body&gt; Code" => "Custom End of &lt;body&gt; Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Leave <strong>blank</strong> to use the default sender email" => "Leave <strong>blank</strong> to use the default sender email",
// "Email this page" => "Email this page",
// "Shadow layer" => "Shadow layer",
// "Additional layers for shadows, rounded corners or other decorative styling" => "Additional layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Module (box) shadow start" => "Module (box) shadow start",
// "Module (box) shadow end" => "Module (box) shadow end",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "UI Effects" => "UI Effects",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "Tooltips" => "Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "Autocomplete" => "Autocomplete",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "Superfish" => "Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "Reflection" => "Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery UI Theme" => "JQuery UI Theme",
// "JQuery UI Theme: Themes for look and feel of JQuery UI widgets" => "JQuery UI Theme: Themes for look and feel of JQuery UI widgets",
// "For future use" => "For future use",
// "Cycle" => "Cycle",
// "slideshow" => "slideshow",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules" => "Effect for modules",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Main JQuery effect" => "Main JQuery effect",
// "Speed" => "Speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "CSS selectors to be fixed" => "CSS selectors to be fixed",
// "Separate multiple elements with a comma (&nbsp;,&nbsp;)" => "Separate multiple elements with a comma (&nbsp;,&nbsp;)",
// "HTMLDomElements to be fixed" => "HTMLDomElements to be fixed",
// "Favicon" => "Favicon",
// "Context Menus" => "Context Menus",
// "Currently used in File Galleries only" => "Currently used in File Galleries only",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Separators" => "Separators",
// "Meta tags" => "Meta tags",
// "Geo URL" => "Geo URL",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Hint: If you lose your login module, use tiki-login_scr.php to be able to login" => "Hint: If you lose your login module, use tiki-login_scr.php to be able to login",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "Save Preferences" => "Save Preferences",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>" => "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>",
// "Loading profile" => "Loading profile",
// "Are you sure you want to apply the profile" => "Are you sure you want to apply the profile",
// "Sending" => "Sending",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "Apply Profiles" => "Apply Profiles",
// "A Friendly Warning" => "A Friendly Warning",
// "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles" => "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles",
// "Option 1: Quick Filter" => "Option 1: Quick Filter",
// "Option 2: Manual Filter" => "Option 2: Manual Filter",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "applied" => "applied",
// "Profile repository" => "Profile repository",
// "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again" => "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Profile tester" => "Profile tester",
// "This will run the profile and make potentially unrecoverable changes in your database" => "This will run the profile and make potentially unrecoverable changes in your database",
// "Test Profile Name" => "Test Profile Name",
// "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or" => "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or",
// "External feeds" => "External feeds",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search type" => "Search type",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "The indexation is always updated" => "The indexation is always updated",
// "Tiki search" => "Tiki search",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "The Tiki search indexes must be refreshed if you turn the Tiki search on" => "The Tiki search indexes must be refreshed if you turn the Tiki search on",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Search Results" => "Search Results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file" => "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "Parse wiki syntax in comments in all sections apart from Forums" => "Parse wiki syntax in comments in all sections apart from Forums",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "External links and images" => "External links and images",
// "External links will be identified with" => "External links will be identified with",
// "Plugins" => "Plugins",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "Plugin Aliases" => "Plugin Aliases",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Tracker attachments" => "Tracker attachments",
// "Switch storage" => "Switch storage",
// "No records" => "No records",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on" => "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on",
// "Validate choice" => "Validate choice",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Allow override per page" => "Allow override per page",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Toggle display of section and plugin edit icons" => "Toggle display of section and plugin edit icons",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Remove a tag" => "Remove a tag",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "WikiWords" => "WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History all instead of only page data, description, and change comment" => "History all instead of only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "A page can occur multiple times in a structure" => "A page can occur multiple times in a structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "Users can lock pages" => "Users can lock pages",
// "Wiki watch" => "Wiki watch",
// "Watch minor edits" => "Watch minor edits",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Page Listings" => "Page Listings",
// "Pages not in structure" => "Pages not in structure",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Camera settings" => "Camera settings",
// "Upload Type" => "Upload Type",
// "Data location" => "Data location",
// "HTTP Prefix" => "HTTP Prefix",
// "WebDav username" => "WebDav username",
// "WebDav password" => "WebDav password",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Development Notice" => "Development Notice",
// "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default" => "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default",
// "Database Version Problem" => "Database Version Problem",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Administration features" => "Administration features",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look & feel" => "Look & feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "External Pages Cache" => "External Pages Cache",
// "Content Templates" => "Content Templates",
// "External Wikis" => "External Wikis",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "See Statistics" => "See Statistics",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create / Edit Calendar" => "Create / Edit Calendar",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom URL" => "Custom URL",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Remove from this Category" => "Remove from this Category",
// "Use the Administration page of each enabled feature to allow the use of content templates" => "Use the Administration page of each enabled feature to allow the use of content templates",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// ".." => "..",
// "Create/Edit Forums" => "Create/Edit Forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate perms" => "Duplicate perms",
// "Duplicate" => "Duplicate",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "mn" => "mn",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed" => "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "Create/Edit Menu" => "Create/Edit Menu",
// "Icons" => "Icons",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "Configure icons for menu entries" => "Configure icons for menu entries",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "The following required parameters are missing" => "The following required parameters are missing",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "assign_name\">Module Name" => "assign_name\">Module Name",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Use Dynamic Content" => "Use Dynamic Content",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Drafts" => "Drafts",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Admin page lists" => "Admin page lists",
// "Current lists" => "Current lists",
// "Edit this list" => "Edit this list",
// "Remove this list" => "Remove this list",
// "Edit list" => "Edit list",
// "Add list" => "Add list",
// "Seed with pages from a category" => "Seed with pages from a category",
// "Add page" => "Add page",
// "Page priority" => "Page priority",
// "Page score" => "Page score",
// "Edit {\$list.name|escape}" => "Edit {\$list.name|escape}",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Add poll to pages" => "Add poll to pages",
// "This menu shows only Polls with 'status': \"template\"" => "This menu shows only Polls with 'status': \"template\"",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Admin External Feeds" => "Admin External Feeds",
// "Tips" => "Tips",
// "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or" => "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or",
// "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed" => "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed",
// "Edit this feed" => "Edit this feed",
// "Create new external feed" => "Create new external feed",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP functions" => "PHP functions",
// "Function" => "Function",
// "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini" => "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini",
// "TikiWiki settings" => "TikiWiki settings",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "XML Zip Import" => "XML Zip Import",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "XML Zip" => "XML Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create/Edit Surveys" => "Create/Edit Surveys",
// "Closed" => "Closed",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Advanced feature" => "Advanced feature",
// "View mode" => "View mode",
// "Wiki and WYSIWYG" => "Wiki and WYSIWYG",
// "Wiki only" => "Wiki only",
// "WYSIWYG only" => "WYSIWYG only",
// "Load" => "Load",
// "Reset to Global" => "Reset to Global",
// "Reset to defaults" => "Reset to defaults",
// "Auto Reloading" => "Auto Reloading",
// "Row" => "Row",
// "Formatting Tools" => "Formatting Tools",
// "Plugin Tools" => "Plugin Tools",
// "Edit tool" => "Edit tool",
// "Wysiwyg Token" => "Wysiwyg Token",
// "Plugin name" => "Plugin name",
// "Custom Tools" => "Custom Tools",
// "Add a new custom tool" => "Add a new custom tool",
// "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save" => "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "trackers" => "trackers",
// "with" => "with",
// "Create Tracker" => "Create Tracker",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Groups will include" => "Groups will include",
// "Creator is assigned to the group" => "Creator is assigned to the group",
// "and it becomes his default group" => "and it becomes his default group",
// "and it becomes the new item group creator" => "and it becomes the new item group creator",
// "But copy the default group in this fiedlId before updating the group" => "But copy the default group in this fiedlId before updating the group",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "User can take ownership of item created by anonymous" => "User can take ownership of item created by anonymous",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the creator group can modify items" => "Member of the creator group can modify items",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Identify creation user in tracker item" => "Identify creation user in tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "Identify lastModif user in tracker item" => "Identify lastModif user in tracker item",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "and display last comment user/date" => "and display last comment user/date",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Duplicate Tracker" => "Duplicate Tracker",
// "Manage permissions" => "Manage permissions",
// "Inherits Permissions from" => "Inherits Permissions from",
// "User Choice" => "User Choice",
// "Inherit permissions directly from following groups" => "Inherit permissions directly from following groups",
// "Selected groups only. Use Ctrl+Click to select more than one" => "Selected groups only. Use Ctrl+Click to select more than one",
// "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)" => "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Users are automatically unassigned from the group after" => "Users are automatically unassigned from the group after",
// "0 or empty for never" => "0 or empty for never",
// "Assign group <em>management</em> permissions" => "Assign group <em>management</em> permissions",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Remove from Group" => "Remove from Group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Feedback" => "Feedback",
// "Updated users" => "Updated users",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Confirm user email" => "Confirm user email",
// "Invalid email" => "Invalid email",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP" => "Tikiwiki is configured to delegate the password managment to LDAP",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "CSV file layout" => "CSV file layout",
// "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2" => "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Actions on this article type" => "Actions on this article type",
// "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems" => "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems",
// "Click this button to try it now" => "Click this button to try it now",
// "Global object permissions" => "Global object permissions",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user|escape} to Groups" => "Assign User {\$assign_user|escape} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "Available Files" => "Available Files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Report to Webmaster" => "Report to Webmaster",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Trackers Items" => "Trackers Items",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "All Images" => "All Images",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Cyclic" => "Cyclic",
// "Include the image in a tiki page using the following syntax" => "Include the image in a tiki page using the following syntax",
// "To include the image in an HTML page" => "To include the image in an HTML page",
// "To link to this page from another tiki page" => "To link to this page from another tiki page",
// "Browsing Video" => "Browsing Video",
// "Edit Video" => "Edit Video",
// "First Video" => "First Video",
// "Prev Video" => "Prev Video",
// "Next Video" => "Next Video",
// "Last Video" => "Last Video",
// "Video Title" => "Video Title",
// "Move video" => "Move video",
// "You can view this video in your browser using" => "You can view this video in your browser using",
// "You can include the video in a tiki page using one of these lines" => "You can include the video in a tiki page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "Edit Calendar" => "Edit Calendar",
// "New event" => "New event",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "No description" => "No description",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "D" => "D",
// "W" => "W",
// "M" => "M",
// "%d/%m" => "%d/%m",
// "Advanced parameters for iCal export" => "Advanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Change your password" => "Change your password",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Most visited directory sub-categories" => "Most visited directory sub-categories",
// "Directory Category description" => "Directory Category description",
// "Random directory sub-categories" => "Random directory sub-categories",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Add a related directory category" => "Add a related directory category",
// "Directory Category" => "Directory Category",
// "Related directory categories" => "Related directory categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Total directory categories" => "Total directory categories",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max impressions for a user" => "Max impressions for a user",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "A category is mandatory" => "A category is mandatory",
// "The file will be saved in" => "The file will be saved in",
// "Wiki Syntax" => "Wiki Syntax",
// "For more information, please see" => "For more information, please see",
// "Wiki Page Editor" => "Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Also available here" => "Also available here",
// "Plugins help" => "Plugins help",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "More help here" => "More help here",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Edit quiz results" => "Edit quiz results",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "\"The page already exists. It was selected in the list below.\"" => "\"The page already exists. It was selected in the list below.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Video Information" => "Edit Video Information",
// "Browse Videos" => "Browse Videos",
// "The following video was successfully edited" => "The following video was successfully edited",
// "You can include the video in an HTML page using one of these lines" => "You can include the video in an HTML page using one of these lines",
// "View object" => "View object",
// "Preview your changes" => "Preview your changes",
// "Save the page" => "Save the page",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "This edit session will expire in" => "This edit session will expire in",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Update '{\$page|escape}'" => "Update '{\$page|escape}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Edit wiki page" => "Edit wiki page",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Edit page" => "Edit page",
// "Edit Comment" => "Edit Comment",
// "Edit comment: Enter some text to describe the changes you are currently making" => "Edit comment: Enter some text to describe the changes you are currently making",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Tools" => "Tools",
// "Lock this page" => "Lock this page",
// "Allow comments on this page" => "Allow comments on this page",
// "Regex search " => "Regex search ",
// "Replace with" => "Replace with",
// "Case Insensitivity" => "Case Insensitivity",
// "Upload Screencast" => "Upload Screencast",
// "Incorrect file extension was used for your flash screencast, expecting .swf or .flv" => "Incorrect file extension was used for your flash screencast, expecting .swf or .flv",
// "An unexpected error occurred while uploading your flash screencast" => "An unexpected error occurred while uploading your flash screencast",
// "Incorrect file extension was used for your Ogg screencast, expecting .ogg" => "Incorrect file extension was used for your Ogg screencast, expecting .ogg",
// "A flash screencast is mandatory" => "A flash screencast is mandatory",
// "An unexpected error occurred while uploading your Ogg screencast" => "An unexpected error occurred while uploading your Ogg screencast",
// "Preview not possible" => "Preview not possible",
// "Flash video (required)" => "Flash video (required)",
// "Ogg video (optional)" => "Ogg video (optional)",
// "Add another screencast" => "Add another screencast",
// "Authors' style" => "Authors' style",
// "Description (used for metatags)" => "Description (used for metatags)",
// "My Footnotes" => "My Footnotes",
// "or use" => "or use",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Reported messages for forum" => "Reported messages for forum",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Cancel friendship request" => "Cancel friendship request",
// "Global default" => "Global default",
// "Google Map Locator" => "Google Map Locator",
// "enter address" => "enter address",
// "Find address" => "Find address",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "If you are NOT running a new Tiki installation, make a backup of your database before using this importer" => "If you are NOT running a new Tiki installation, make a backup of your database before using this importer",
// "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode" => "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode",
// "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)" => "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)",
// "Select the software to import from" => "Select the software to import from",
// "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button" => "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button",
// "Congratulations! You have successful imported your data to Tikiwiki" => "Congratulations! You have successful imported your data to Tikiwiki",
// "pages imported from a total of" => "pages imported from a total of",
// "You can see the list of wiki pages in your site" => "You can see the list of wiki pages in your site",
// "here" => "here",
// "Importer log" => "Importer log",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Upgrade" => "Install &amp; Upgrade",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "This install will populate (or upgrade) the database" => "This install will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "A new install will populate the database" => "A new install will populate the database",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Reinstall" => "Reinstall",
// "Upgrade" => "Upgrade",
// "Warning: Category Permissions Will Not Be Upgraded" => "Warning: Category Permissions Will Not Be Upgraded",
// "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them" => "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Install Profile" => "Install Profile",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Upload to Kaltura" => "Upload to Kaltura",
// "List Entries" => "List Entries",
// "Upload Successful" => "Upload Successful",
// "You have successfully added {\$count} new entry/entries" => "You have successfully added {\$count} new entry/entries",
// "Change Details" => "Change Details",
// "Remix" => "Remix",
// "Advanced Editor" => "Advanced Editor",
// "Simple Editor" => "Simple Editor",
// "Views" => "Views",
// "Plays" => "Plays",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Media Entries" => "Media Entries",
// "Mix Entries" => "Mix Entries",
// "Kaltura Remix Entries" => "Kaltura Remix Entries",
// "Kaltura Media Entries" => "Kaltura Media Entries",
// "Loads" => "Loads",
// "Browse Entries" => "Browse Entries",
// "Additional Info" => "Additional Info",
// "Media Type" => "Media Type",
// "No entries" => "No entries",
// "No media entries found. " => "No media entries found. ",
// "Click here " => "Click here ",
// "to upload" => "to upload",
// "No mix entries found. " => "No mix entries found. ",
// "to create a new mix" => "to create a new mix",
// "Playlist Type" => "Playlist Type",
// "No playlists found. " => "No playlists found. ",
// "to create a playlist" => "to create a playlist",
// "Object Permissions List" => "Object Permissions List",
// "Manage Permissions" => "Manage Permissions",
// "If an object is not in the special section, then only the default perms are on" => "If an object is not in the special section, then only the default perms are on",
// "Special" => "Special",
// "users registered" => "users registered",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Page aliases found" => "Page aliases found",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "However, some page aliases fitting the query were found (see Aliases section above)" => "However, some page aliases fitting the query were found (see Aliases section above)",
// "Perform action with checked" => "Perform action with checked",
// "Xml Zip" => "Xml Zip",
// "offline" => "offline",
// "Back to admin" => "Back to admin",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Mods Configuration" => "Mods Configuration",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "licence" => "licence",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "y" => "y",
// "Records" => "Records",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you created or contributed to" => "To display the objects you created or contributed to",
// "MyInfo" => "MyInfo",
// "Contacts Preferences" => "Contacts Preferences",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "Edit Permissions" => "Edit Permissions",
// "Currently editing Global permissions" => "Currently editing Global permissions",
// "This object's direct permissions override any global permissions or category permissions affecting this object" => "This object's direct permissions override any global permissions or category permissions affecting this object",
// "This category's direct permissions override any global permissions affecting objects in it" => "This category's direct permissions override any global permissions affecting objects in it",
// "To edit global permissions" => "To edit global permissions",
// "No permissions yet applied to this object but category permissions affect this object and are displayed below" => "No permissions yet applied to this object but category permissions affect this object and are displayed below",
// "To edit category permissions" => "To edit category permissions",
// "No direct permissions yet applied to this object. Global permissions apply" => "No direct permissions yet applied to this object. Global permissions apply",
// "Currently inherited permissions displayed" => "Currently inherited permissions displayed",
// "Assign global permissions" => "Assign global permissions",
// "Reset to Global Perms" => "Reset to Global Perms",
// "Reset Perms" => "Reset Perms",
// "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions",
// "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions",
// "Permissions Clipboard" => "Permissions Clipboard",
// "Copy the permissions set here" => "Copy the permissions set here",
// "Paste" => "Paste",
// "Paste copied permissions from " => "Paste copied permissions from ",
// "Assign or remove permissions on <em>all</em> child categories" => "Assign or remove permissions on <em>all</em> child categories",
// "Are you sure you want to effect all child categories?\\nThere is no undo" => "Are you sure you want to effect all child categories?\\nThere is no undo",
// "Assign or remove permissions on all pages of the sub-structure" => "Assign or remove permissions on all pages of the sub-structure",
// "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo" => "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo",
// "Select groups" => "Select groups",
// "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for" => "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for",
// "Select all" => "Select all",
// "Select features" => "Select features",
// "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for" => "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for",
// "Show permissions for disabled features" => "Show permissions for disabled features",
// "Feature name" => "Feature name",
// "Quick Permissions" => "Quick Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>",
// "Assign Quick-Permissions to this object" => "Assign Quick-Permissions to this object",
// "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)" => "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "Rank" => "Rank",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "Received Pages" => "Received Pages",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "Select your group" => "Select your group",
// "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "octets" => "octets",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Reply To Email" => "Reply To Email",
// "if not" => "if not",
// "Save as Draft" => "Save as Draft",
// "Save your changes" => "Save your changes",
// "Save any changes and send to all subscribers" => "Save any changes and send to all subscribers",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "This text was automatically translated by Google Translate from the following page: " => "This text was automatically translated by Google Translate from the following page: ",
// "page: %0/%1" => "page: %0/%1",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Most viewed objects in period" => "Most viewed objects in period",
// "Usage chart" => "Usage chart",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Advanced mode" => "Advanced mode",
// "Retry" => "Retry",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "Or using as a thumbnail with ShadowBox" => "Or using as a thumbnail with ShadowBox",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "File title" => "File title",
// "required field for podcasts" => "required field for podcasts",
// "File description" => "File description",
// "Unzip zip files" => "Unzip zip files",
// "Author, if different from the Creator" => "Author, if different from the Creator",
// "Maximum number of downloads" => "Maximum number of downloads",
// "Add File" => "Add File",
// "Maximum file size is around" => "Maximum file size is around",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// " Syntax tips" => " Syntax tips",
// "Link to file from a Wiki page" => "Link to file from a Wiki page",
// "For image files" => "For image files",
// "To display in a Wiki page" => "To display in a Wiki page",
// "Display thumbnail that enlarges" => "Display thumbnail that enlarges",
// "No gallery available" => "No gallery available",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a bookmark" => "a bookmark",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Default view" => "Default view",
// "Manage Fields" => "Manage Fields",
// "Basic Data" => "Basic Data",
// "User Icon" => "User Icon",
// "(non public)" => "(non public)",
// "This user is your friend " => "This user is your friend ",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Additional Information" => "Additional Information",
// "User Contribution" => "User Contribution",
// "has contributed to the following content" => "has contributed to the following content",
// "has not contributed to any content yet" => "has not contributed to any content yet",
// "Forum comments" => "Forum comments",
// "Send Me A Message" => "Send Me A Message",
// "Send me a message " => "Send me a message ",
// "The following message will be sent to user" => "The following message will be sent to user",
// "Message Body" => "Message Body",
// "Toggle" => "Toggle",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Display info tooltip on mouseover for every user who allows his/her information to be public" => "Display info tooltip on mouseover for every user who allows his/her information to be public",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Deletion" => "Account Deletion",
// "Are you really sure you want to delete your account " => "Are you really sure you want to delete your account ",
// "Check this box if you really want to delete your account" => "Check this box if you really want to delete your account",
// "Delete my account" => "Delete my account",
// "User Watches and preferences" => "User Watches and preferences",
// "You need to set your email to receive email notifications" => "You need to set your email to receive email notifications",
// "Report Preferences" => "Report Preferences",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use reports to summarise notifications about objects you are watching" => "Use reports to summarise notifications about objects you are watching",
// "Use reports" => "Use reports",
// "Interval in witch you want to get the reports" => "Interval in witch you want to get the reports",
// "Short report" => "Short report",
// "Detailed report" => "Detailed report",
// "HTML-Email" => "HTML-Email",
// "Send me an email also if nothing happened" => "Send me an email also if nothing happened",
// "Reports are disabled, only standard reporting is available" => "Reports are disabled, only standard reporting is available",
// "Sites you are watching" => "Sites you are watching",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Tracker Items" => "Tracker Items",
// "Pending" => "Pending",
// "Edit/Delete" => "Edit/Delete",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Incoming servers (used in this order)" => "Incoming servers (used in this order)",
// "IMAP server" => "IMAP server",
// "Mbox filepath" => "Mbox filepath",
// "Maildir mail directory" => "Maildir mail directory",
// "Use SSL" => "Use SSL",
// "Outgoing server" => "Outgoing server",
// "Account details" => "Account details",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "This is the active account" => "This is the active account",
// "IMAP" => "IMAP",
// "Mbox" => "Mbox",
// "Maildir" => "Maildir",
// "POP3" => "POP3",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Auto refresh set for every \$autoRefresh seconds" => "Auto refresh set for every \$autoRefresh seconds",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Part" => "Part",
// "View edit icons" => "View edit icons",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Fullscreen" => "Fullscreen",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Character Limit Exceeded" => "Character Limit Exceeded",
// "Character Count" => "Character Count",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of votes" => "Number of votes",
// "Your rating" => "Your rating",
// "You did not vote yet" => "You did not vote yet",
// "My rating" => "My rating",
// "Click to vote for this value" => "Click to vote for this value",
// "Clik to delete your vote" => "Clik to delete your vote",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Email address the person you want to invite" => "Email address the person you want to invite",
// "Set in these groups" => "Set in these groups",
// "Leave" => "Leave",
// "Undecided" => "Undecided",
// "Last Day" => "Last Day",
// "Last Week" => "Last Week",
// "Last Month" => "Last Month",
// "Last Year" => "Last Year",
// "Your default group" => "Your default group",
// "Change default group" => "Change default group",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Creator &amp; Last Editor" => "Creator &amp; Last Editor",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%0 enabled" => "%0 enabled",
// "%0 disabled" => "%0 disabled",
// "%0 set" => "%0 set",
// "%0 unset" => "%0 unset",
// "Administration" => "Administration",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Current version is up to date : <b>%0</b>" => "Current version is up to date : <b>%0</b>",
// "A new major release branch is available" => "A new major release branch is available",
// "A new %0 major release branch is available" => "A new %0 major release branch is available",
// "Feeds settings" => "Feeds settings",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Text area" => "Text area",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Kaltura settings" => "Kaltura settings",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Object doesn't exists" => "Object doesn't exists",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "No display" => "No display",
// "You must specify a directory" => "You must specify a directory",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "The list name must be specified" => "The list name must be specified",
// "Sorry, your list could not be added. Please check that it doesn\\'t already exist" => "Sorry, your list could not be added. Please check that it doesn\\'t already exist",
// "Sorry, your list could not be updated. Please check that it already exists" => "Sorry, your list could not be updated. Please check that it already exists",
// "risky" => "risky",
// "off" => "off",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "Are you sure you want to delete this custom tool" => "Are you sure you want to delete this custom tool",
// "JavaScript is required for this page" => "JavaScript is required for this page",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "Group name can not be empty" => "Group name can not be empty",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Email validation requested but email address not set" => "Email validation requested but email address not set",
// "Password not set" => "Password not set",
// "User login contains invalid characters" => "User login contains invalid characters",
// "Deleted account %s" => "Deleted account %s",
// "%s %s assigned to %s %s" => "%s %s assigned to %s %s",
// "group %s set as the default group of user %s" => "group %s set as the default group of user %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Last modifications to the blog" => "Last modifications to the blog",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Calendar event : " => "Calendar event : ",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl" => "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field" => "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field",
// "Last sites of directory \" . \$rc[\"name\"] . \" " => "Last sites of directory \" . \$rc[\"name\"] . \" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Translation of this page is incomplete" => "Translation of this page is incomplete",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "The file you selected is too large to upload" => "The file you selected is too large to upload",
// "Incorrect file extension was used for your 0gg screencast, expecting .ogg" => "Incorrect file extension was used for your 0gg screencast, expecting .ogg",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "Not supported yet" => "Not supported yet",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "Operations executed successfully" => "Operations executed successfully",
// "Invalid software name" => "Invalid software name",
// "Page saved (version %d)" => "Page saved (version %d)",
// "You have requested that this page be machine translated" => "You have requested that this page be machine translated",
// "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it" => "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Permission denied: You cannot upload videos" => "Permission denied: You cannot upload videos",
// "You need to set your Kaltura account details: " => "You need to set your Kaltura account details: ",
// "Could not establish Kaltura session. Try again" => "Could not establish Kaltura session. Try again",
// "Permission denied: You cannot remix videos" => "Permission denied: You cannot remix videos",
// "Permission denied: You cannot change video version" => "Permission denied: You cannot change video version",
// "Permission denied: You cannot delete kaltura video" => "Permission denied: You cannot delete kaltura video",
// "Permission denied: You cannot download kaltura video" => "Permission denied: You cannot download kaltura video",
// "Permission denied: You cannot edit video information" => "Permission denied: You cannot edit video information",
// "Permission denied: You cannot view video" => "Permission denied: You cannot view video",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Quota too big" => "Quota too big",
// "Quota too small" => "Quota too small",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "This gallery does not exist" => "This gallery does not exist",
// "Permission denied: You cannot view this page" => "Permission denied: You cannot view this page",
// "Invalid action" => "Invalid action",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Resend" => "Resend",
// "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email" => "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files" => "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files",
// "map edit" => "map edit",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Note not found" => "Note not found",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "You are already logged in" => "You are already logged in",
// "You must choose a group" => "You must choose a group",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "Missing User Name" => "Missing User Name",
// "User Already Exists" => "User Already Exists",
// "Valid User Name" => "Valid User Name",
// "Missing Email" => "Missing Email",
// "Valid Email" => "Valid Email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "A password reminder email has been sent " => "A password reminder email has been sent ",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "A problem occured during file uploading" => "A problem occured during file uploading",
// "File which was causing trouble was at rank" => "File which was causing trouble was at rank",
// "The error was" => "The error was",
// "invalid email" => "invalid email",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "Incorrect file extension" => "Incorrect file extension",
// "Your screencast has been uploaded successfully" => "Your screencast has been uploaded successfully",
// "Your screencasts have been uploaded successfully" => "Your screencasts have been uploaded successfully",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "Incorrect thread" => "Incorrect thread",
// "There are a problem connecting to that account" => "There are a problem connecting to that account",
// "There are a problem deleting that mail" => "There are a problem deleting that mail",
// "Mail ID" => "Mail ID",
// "There are a problem deleting mails" => "There are a problem deleting mails",
// "Are you sure you want to delete this account" => "Are you sure you want to delete this account",
// "Taking" => "Taking",
// "Putting back" => "Putting back",
// "Checking" => "Checking",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"Angola" => "Angola",
"Antigua" => "Antigua",
"Armenia" => "Armenia",
"Australia" => "Australia",
"Austria" => "Austria",
"Bahamas" => "Bahamas",
"Bahrain" => "Bahrain",
"Bangladesh" => "Bangladesh",
"Barbados" => "Barbados",
"Bolivia" => "Bolivia",
"Brunei" => "Brunei",
"Bulgaria" => "Bulgaria",
"Chile" => "Chile",
"China" => "China",
"Colombia" => "Colombia",
"Cuba" => "Cuba",
"Ecuador" => "Ecuador",
"Estonia" => "Estonia",
"Guam" => "Guam",
"Guatemala" => "Guatemala",
"Honduras" => "Honduras",
"India" => "India",
"Indonesia" => "Indonesia",
"Iraq" => "Iraq",
"Israel" => "Israel",
"Kenya" => "Kenya",
"Kiribati" => "Kiribati",
"Kuwait" => "Kuwait",
"Malawi" => "Malawi",
"Malta" => "Malta",
"Mozambique" => "Mozambique",
"Nauru" => "Nauru",
"Nepal" => "Nepal",
"Nicaragua" => "Nicaragua",
"Niue" => "Niue",
"Portugal" => "Portugal",
"Samoa" => "Samoa",
"Somalia" => "Somalia",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Vanuatu" => "Vanuatu",
"Venezuela" => "Venezuela",
"Zambia" => "Zambia",
"tracker" => "tracker",
"Wiki" => "Wiki",
"Blogs" => "Blogs",
"Trackers" => "Trackers",
"blog" => "blog",
"WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
"Blog" => "Blog",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"PHPLayers" => "PHPLayers",
"XMLRPC API" => "XMLRPC API",
"Local" => "Local",
"Mb" => "Mb",
"Normal" => "Normal",
"Top" => "Top",
"Tracker" => "Tracker",
"min" => "min",
"km" => "km",
"wiki" => "wiki",
"arts" => "arts",
"blogs" => "blogs",
"max" => "max",
"url" => "url",
"Info" => "Info",
"Avatar" => "Avatar",
"Chart" => "Chart",
"Desc" => "Desc",
"URL" => "URL",
"%" => "%",
"Url" => "Url",
"Id" => "Id",
"id" => "id",
"Total" => "Total",
"d=diff" => "d=diff",
"Ip" => "Ip",
"Diff" => "Diff",
"[-]" => "[-]",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"avatar" => "avatar",
"IP" => "IP",
"LDAP" => "LDAP",
"URL:" => "URL:",
"PAM" => "PAM",
"Robots" => "Robots",
"Similar" => "Similar",
"phpinfo" => "phpinfo",
"DSN" => "DSN",
"bytes" => "bytes",
"x" => "x",
"Cat" => "Cat",
"Perso" => "Perso",
"h" => "h",
"CMS" => "CMS",
"Coms" => "Coms",
"Cacheable" => "Cacheable",
"Data" => "Data",
"PHP variable" => "PHP variable",
"Tiki variable" => "Tiki variable",
"bcc" => "bcc",
"RSS" => "RSS",
"+" => "+",
"Roles" => "Roles",
"%m/%d" => "%m/%d",
"editor" => "editor",
"normal" => "normal",
"idea" => "idea",
"neutral" => "neutral",
"v" => "v",
"Tikiwiki Mods" => "Tikiwiki Mods",
"Plugin" => "Plugin",
"tikiwiki.org" => "tikiwiki.org",
"pvs" => "pvs",
"#" => "#",
"act" => "act",
"top" => "top",
"Pos" => "Pos",
"Cc" => "Cc",
"CC" => "CC",
"BCC" => "BCC",
"TOP" => "TOP",
"%H:%M %Z" => "%H:%M %Z",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Esta característica está desactivada",
"Permission denied. You cannot view pages" => "Non ten permiso para ver páxinas",
"This script cannot be called directly" => "Este script non pode ser chamado directamente",
"The copyright management feature is not enabled." => "A opción de manexo de dereitos de copia non está activada.",
"No page indicated" => "Non se indica unha páxina",
"You must supply all the information, including title and year." => "Debe dar toda a información, incluíndo título e ano.",
"You do not have permission to use this feature" => "Non ten permiso para usar esta función",
"This feature is for admins only" => "Esta función é só para administradores",
"Type" => "Tipo",
"Name" => "Nome",
"Description" => "Descrición",
"Size" => "Tamaño",
"Created" => "Creada",
"Last Modified" => "Última modificación",
"Creator" => "Creador",
"Author" => "Autor",
"Comment" => "Comentario",
"Files" => "Ficheiros",
"Hits" => "Accesos",
"Locked by" => "Bloqueado por",
"Path" => "Ruta",
"Algeria" => "Alxeria",
"American Samoa" => "Samoa_Americana",
"Argentina" => "Arxentina",
"Belarus" => "Bielorrusia",
"Belgium" => "Bélxica",
"Bermuda" => "Bermudas",
"Brazil" => "Brasil",
"Canada" => "Canadá",
"Cayman Islands" => "Illas_Caimán",
"Cook Islands" => "Illas_Cook",
"Costa Rica" => "Costa_Rica",
"Croatia" => "Croacia",
"Cyprus" => "Chipre",
"Czech Republic" => "República_Checa",
"Denmark" => "Dinamarca",
"Dominican Republic" => "República_Dominicana",
"Egypt" => "Exipto",
"El Salvador" => "O_Salvador",
"Federated States of Micronesia" => "Estados_Federados_de_Micronesia",
"Fiji" => "Fixi",
"Finland" => "Finlandia",
"France" => "Francia",
"French Polynesia" => "Polinesa_Francesa",
"Germany" => "Alemaña",
"Greece" => "Grecia",
"Haiti" => "Haití",
"Hungary" => "Hungría",
"Iceland" => "Islandia",
"Iran" => "Irán",
"Ireland" => "Irlanda",
"Italy" => "Italia",
"Ivory Coast" => "Costa do Marfil",
"Jamaica" => "Xamaica",
"Japan" => "Xapón",
"Jordan" => "Xordania",
"Kazakstan" => "Kazakhistán",
"Latvia" => "Letonia",
"Lebanon" => "Líbano",
"Lithuania" => "Lituania",
"Luxemburg" => "Luxemburgo",
"Malaysia" => "Malaisia",
"Marshall Islands" => "Illas_Marshall",
"Mauritius" => "Mauricio",
"Mexico" => "México",
"Morocco" => "Marrocos",
"Netherlands" => "Holanda",
"New Caledonia" => "Nova_Caledonia",
"New Zealand" => "Nova_Zelandia",
"Nigeria" => "Nixeria",
"None" => "Ningún",
"Norway" => "Noruega",
"Other" => "Outro",
"Pakistan" => "Paquistán",
"Panama" => "Panamá",
"Papua New Guinea" => "Papúa_Nova_Guinea",
"Paraguay" => "Paraguai",
"Peru" => "Perú",
"Poland" => "Polonia",
"Puerto Rico" => "Porto_Rico",
"Quatar" => "Qatar",
"Romania" => "Romanía",
"Russia" => "Rusia",
"Saudi Arabia" => "Arabia_Saudí",
"Singapore" => "Singapur",
"Slovakia" => "Eslovaquia",
"Slovenia" => "Eslovenia",
"Solomon Islands" => "Illas_Salomón",
"South Africa" => "Sudáfrica",
"South Korea" => "Corea_do_Sur",
"Spain" => "España",
"Sri Lanka" => "Sri_Lanka",
"St Vincent Grenadines" => "San_Vincente_e_as_Granadinas",
"Surinam" => "Suriname",
"Sweden" => "Suecia",
"Switzerland" => "Suíza",
"Taiwan" => "Taiwán",
"Thailand" => "Tailandia",
"Trinidad Tobago" => "Trinidade_e_Tobago",
"Turkey" => "Turquía",
"Ukraine" => "Ucraína",
"United Arab Emirates" => "Emiratos_Árabes_Unidos",
"United Kingdom" => "Reino_Unido",
"United States" => "Estados_Unidos_de_América",
"Uruguay" => "Uruguai",
"Wales" => "Gales",
"Yugoslavia" => "Iugoslavia",
"Zimbabwe" => "Cimbabue",
"Arabic" => "Árabe",
"Catalan" => "Catalán",
"Simplified Chinese" => "Chinés simplificado",
"Chinese" => "Chinés",
"Czech" => "Checoslovaco",
"Danish" => "Danés",
"German" => "Alemán",
"English" => "Inglés",
"English British" => "Inglés británico",
"Spanish" => "Español",
"Greek" => "Grego",
"French" => "Francés",
"Hebrew" => "Hebreo",
"Croatian" => "Croata",
"Italian" => "Italiano",
"Japanese" => "Xaponés",
"Korean" => "Coreano",
"Hungarian" => "Húngaro",
"Dutch" => "Holandés",
"Norwegian" => "Noruegués",
"Polish" => "Polaco",
"Português" => "Portugués",
"Brazilian Portuguese" => "Portugués brasileiro",
"Russian" => "Ruso",
"Pijin Solomon" => "Pinyin Salomón",
"Slovak" => "Eslovaco",
"Serbian" => "Serbio",
"Serbian Latin" => "Serbio latín",
"Swedish" => "Sueco",
"Tuvaluan" => "Tuvaluano",
"Traditional Chinese" => "Chinés tradicional",
"Ukrainian" => "Ucraíno",
"Permission denied" => "Permiso denegado",
"The file is not a CSV file or has not a correct syntax" => "O ficheiro non é un ficheiro CSV ou non ten a sintaxe correcta",
"locked" => "bloqueado",
"locked by" => "bloqueado por",
"Administration:" => "Administración:",
"in" => "en",
"continued" => "continuado",
"New Image Uploaded by" => "Nova imaxe cargada por",
"New Subscriptions" => "Nova subscrición",
"New Item in Tracker" => "Novo ítem no tracker",
"by" => "por",
"Image Gallery" => "Galería de imaxes",
"Articles" => "Artigos",
"Forums" => "Foros",
"Directory" => "Directorio",
"File Gallery" => "Galería de ficheiros",
"FAQs" => "PMF",
"Quizzes" => "Cuestionarios",
"Survey" => "Enquisa",
"Newsletter" => "Boletín",
"article" => "artigo",
"directory" => "directorio",
"faq" => "pmf",
"file gallery" => "galería de ficheiros",
"forum" => "foro",
"image gallery" => "galería de imaxes",
"newsletter" => "boletín",
"poll" => "votación",
"quiz" => "cuestionario",
"survey" => "enquisa",
"wiki page" => "páxina wiki",
"image" => "imaxe",
"calendar" => "calendario",
"Invalid filename (using filters for filenames)" => "Nome de ficheiro incorrecto (usando filtros para nomes de ficheiro)",
"Cannot upload this file - maximum upload size exceeded" => "Non se pode cargar este ficheiro, superouse o tamaño máximo de carga",
"Anonymous" => "Anónimo",
"You have mistyped the anti-bot verification code; please try again." => "Tecleou mal o código de verificacion anti-robot; ténteo de novo.",
"Wrong password. Cannot post comment" => "Contrasinal incorrecto. Non pode publicar comentario",
"You have to enter a title and text" => "Debe introducir un título e texto",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::aplicar: conta de liñas non coincide: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_comprobación: fallo",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_comprobación: a secuencia de edición non é óptima",
"Line:" => "Liña:",
"Lines:" => "Liñas:",
"Find" => "Buscar",
"find" => "atopar",
"prev" => "ant.",
"Page" => "Páxina",
"next" => "prox.",
"Link" => "Ligazón",
"Page name" => "Nome da páxina",
"File Galleries" => "Galerías de ficheiros",
"Wiki Home" => "Inicio do Wiki",
"Home" => "Inicio",
"previous page" => "páxina anterior",
"next page" => "páxina seguinte",
"posted on" => "anunciado en",
"Continue" => "Continúe",
"By:" => "Por:",
"Read" => "Ler",
"List articles" => "Listar artigos",
"Last post" => "Último artigo",
"Invalid imagename (using filters for filenames)" => "Nome de imaxe incorrecto (usando filtros para nomes de ficheiros)",
"Errors detected" => "Erros detectados",
"Upload was not successful" => "A carga non se realizou con éxito",
"No image yet, sorry." => " Síntoo, sen imaxe aínda ",
"No valid ogr2ogr executable" => "Executable ogr2ogr non válido",
"Could not create \$tdo.mif in data directory" => "Non podo crear \$tdo.mif no directorio de datos",
"Could not create \$tdo.mid in data directory" => "Non podo crear \$tdo.mid no directorio de datos",
"unknown" => "descoñecido",
"User Map Generated in:" => "Mapa de usuario xerado en:",
"Image Map Generated in:" => "Mapa de imaxe xerado en:",
"NONE" => "NINGÚN",
"File %s not found" => "Ficheiro %s non encontrado",
"File %s is not a valid archive" => "O ficheiro %s non é un arquivo válido",
"Impossible to open %s : %s" => "Imposible abrir %s : %s",
"Language" => "Lingua",
"Section" => "Sección",
"Theme" => "Decoración",
"Rows" => "Filas",
"Title" => "Título",
"Topic" => "Tema",
"Visible" => "visible",
"Rating" => "Cualificación",
"Reads" => "Lecturas",
"Images" => "Imaxes",
"Newest first" => "Primeiro os máis novos",
"Oldest first" => "Primeiro os máis vellos",
"Points" => "Puntos",
"Authentication method" => "Método de autenticación",
"Tiki and PAM" => "Tiki e PAM",
"CAS (Central Authentication Service)" => "CAS (Servizo Central de Autenticación)",
"Web Server" => "Servidor Web",
"Creation date (desc)" => "Data de creación (desc)",
"Last modification date (desc)" => "Data da última modificación (desc)",
"Blog title (asc)" => "Título do blog (asc)",
"Number of posts (desc)" => "Número de artigos (desc)",
"Visits (desc)" => "Visitas (desc)",
"Activity (desc)" => "Actividade (desc)",
"Disabled" => "Desactivado",
"Plain text" => "Texto sinxelo",
"Link to user information" => "Ligazón a información de usuario",
"User avatar" => "Avatar de usuario",
"Contact user" => "Contactar usuario",
"Count admin pageviews" => "Contar accesos de admin",
"default mapfile" => "ficheiro de mapa por defecto",
"Validate URLs" => "Validar os URL",
"Links per page" => "Ligazóns por páxina",
"Method to open directory links" => "Método para abrir ligazóns do directorio",
"replace current window" => "substituír a fiestra actual",
"new window" => "nova fiestra",
"inline frame" => "marco incrustado",
"No error reporting" => "Sen informe de erros",
"Report all PHP errors" => "Informar todos os erros de PHP",
"Default number of comments per page" => "Cantidade, por defecto, de comentarios por páxina",
"Comments default ordering" => "Orde por defecto dos comentarios",
"Polls" => "Votacións",
"Newsletters" => "Boletíns",
"Calendar" => "Calendario",
"Banners" => "Pancartas",
"Category" => "Categoría",
"Score" => "Puntuación",
"Search" => "Buscar",
"Multilingual" => "Multilingüe",
"FAQ" => "PMF",
"Surveys" => "Enquisas",
"Featured links" => "Ligazóns destacadas",
"Copyright" => "Dereito de copia",
"Shoutbox" => "Taboleiro de avisos ",
"Maps" => "Mapas",
"Live support system" => "Sistema de asistencia en liña",
"Contact Us" => "Contactar con nós",
"Webmail" => "Correo web",
"Mail-in" => "Entrada de correo",
"Wysiwyg editor" => "Editor wysiwyg",
"Friendship Network" => "Rede de Amizade",
"Banning system" => "Sistema de expulsión",
"Stats" => "Estatísticas",
"Referer Stats" => "Estatísticas de referentes",
"Communications (send/receive objects)" => "Comunicacións (enviar/recibir obxectos)",
"Custom Home" => "Inicio personalizado",
"Mini Calendar" => "Mini calendario",
"User Preferences Screen" => "Pantalla de preferencias do usuario",
"User Notepad" => "Caderno de notas do usuario",
"User Bookmarks" => "Marcadores do usuario",
"User Watches" => "Monitores de usuario",
"User Watches Translations" => "Monitores de traducións do usuario",
"User Menu" => "Menú do Usuario",
"User Tasks" => "Tarefas do usuario",
"User Messages" => "Mensaxes do usuario",
"User Files" => "Ficheiros do usuario",
"Integrator" => "Integrador",
"Debugger Console" => "Consola do depurador",
"Protect against CSRF with a ticket" => "Protexer contra CSRF cun tícket",
"Detect browser language" => "Detectar a lingua do navegador",
"Help System" => "Sistema de axuda",
"Smileys" => "Emoticonas",
"Dynamic Content System" => "Sistema de contido dinámico",
"Display menus as folders" => "Mostrar menús como carpetas",
"Activate" => "Activar",
"Comments" => "Comentarios",
"Submissions" => "Colaboracións",
"Rankings" => "Clasificacións",
"Content templates" => "Modelos de contido",
"Print" => "Imprimir",
"Ignore category viewing restrictions" => "Ignorar restricións de visualización de categoría",
"List pages" => "Listar páxinas",
"Last changes" => "Últimas modificacións",
"Orphan pages" => "Páxinas orfas",
"Referer Search Highlighting" => "Destacar busca",
"Search stats" => "Estatísticas das buscas",
"Ignore individual object permissions" => "Ignorar os permisos individuais de obxectos",
"Visits" => "Visitas",
"Accept wiki syntax" => "Aceptar sintaxe wiki",
"Allow same file to be uploaded more than once" => "Permitir que se poida cargar o mesmo ficheiro máis dunha vez",
"Never" => "Nunca",
"Uploaded filenames must match regex" => "Os nomes dos ficheiros cargados deben emparellar con esta expresión regular",
"Plain" => "Sinxelo",
"Threaded" => "Fío argumental",
"Headers Only" => "Só cabeceiras",
"Title (desc)" => "Título (desc)",
"Title (asc)" => "Título (asc)",
"Topics" => "Temas",
"Posts" => "Artigos",
"Posts per day" => "Artigos por día",
"Creation Date (desc)" => "Data de creación (desc)",
"Topics (desc)" => "Temas (desc)",
"Threads (desc)" => "Fíos de discusión, (desc)",
"Last post (desc)" => "Último artigo (desc)",
"Name (desc)" => "Nome (desc)",
"Name (asc)" => "Nome (asc)",
"Browser title" => "Título (fiestra do navegador)",
"Home page" => "Páxina de inicio",
"Use group homepages" => "Usar páxinas de inicio de grupo",
"Go to group homepage only if login from default homepage" => "Ir á páxina inicial de grupo só se se identifica desde a páxina de inicio por defecto",
"Temporary directory" => "Directorio temporal",
"Help URL" => "URL de axuda",
"Open external links in new window" => "Abrir ligazóns externas nunha fiestra nova",
"Full path to gdaltindex" => "Camiño completo a gdaltindex",
"Full path to ogr2ogr" => "Camiño completo a ogr2ogr",
"Map Zone" => "Zona de Mapa",
"Display modules to all groups always" => "Mostrar sempre os módulos a todos os grupos",
"Hide anonymous-only modules from registered users" => "Ocultar aos usuarios rexistrados os módulos só para usuarios anónimos",
"Content" => "Contido",
"Use database for translation" => "Usar a base de datos para a tradución",
"full path to mapfiles" => "ruta completa aos ficheiros de mapas",
"Wiki Page for Help" => "Páxina Wiki para Axuda",
"Wiki Page for Comments" => "Páxina Wiki para comentarios",
"Maximum mailbox size (messages, 0=unlimited)" => "Tamaño máximo da caixa de correo(mensaxes, 0=ilimitado)",
"Maximum mail archive size (messages, 0=unlimited)" => "Tamaño máximo do arquivo de correos(mensaxes, 0=ilimitado)",
"Maximum sent box size (messages, 0=unlimited)" => "Tamaño máximo da carpeta de enviados (mensaxes, 0=ilimitado)",
"geo.position" => "geo.posición",
"geo.region" => "geo.rexión",
"geo.placename" => "geo.nomelugar",
"Port" => "Porto",
"Proxy port" => "Porto Proxy",
"Record untranslated strings" => "Rexistrar cadeas non traducidas",
"Refresh rate" => "Tempo de actualización",
"Minimum length of search word" => "Tamaño mínimo da palabra que se busca",
"Max. number of words containing a syllable" => "Número máximo de palabras que conteñen unha sílaba",
"Max. age in hours of syllable search cache" => "Tempo máximo en horas de busca de sílabas en caché ",
"LRU list purging rate" => "Taxa de limpeza da lista LRU",
"LRU list length" => "Tamaño da lista LRU",
"Database" => "Base de datos",
"After" => "Despois",
"Before" => "Antes",
"Publish" => "Publicar",
"Use proxy" => "Usar proxy",
"Allow viewing HTML mails?" => "Permitir ver correos en HTML?",
"Maximum size for each attachment" => "Tamaño máximo de cada anexo",
"Unlimited" => "Ilimitado",
"Complete" => "Completo",
"Business style" => "Estilo de negocios",
"Collaborative style" => "Estilo colaborativo",
"Page last modified on" => "Última modificación da páxina o",
"Cache wiki pages (global)" => "Cachear páxinas wiki (global)",
"no cache" => "non cachear",
"minute" => "minuto",
"minutes" => "minutos",
"hour" => "hora",
"hours" => "horas",
"Enable wiki 3D browser" => "Activar navegador wiki 3D",
"Browser height" => "Altura do navegador",
"Navigation depth" => "Profundidade da navegación",
"Existing page node color" => "Cor de nodo dunha páxina existente",
"Missing page node color" => "Cor de nodo dunha páxina inexistente",
"Feed animation interval (milisecs)" => "Intervalo de animación da fonte (milisegs.)",
"Wiki top pages" => " páxinas Wiki máis populares",
"Most relevant pages" => "Páxinas máis relevantes",
"Relevance" => "Relevancia",
"Wiki last pages" => "últimas páxinas Wiki",
"Modified" => "Modificado",
"Forums last posts" => "Últimas mensaxes nos foros",
"Topic date" => "Data do tema",
"Forums most read topics" => "asuntos máis lidos dos foros ",
"Forums best topics" => "Mellores asuntos dos foros ",
"Forums most visited forums" => "Foros máis visitados",
"Forums with most posts" => "Foros con máis mensaxes",
"Wiki top galleries" => "galerías do Wiki máis activas",
"Wiki top file galleries" => "galerías de ficheiros Wiki máis activas",
"Wiki top images" => "imaxes Wiki máis visitadas",
"Wiki top files" => "ficheiros Wiki máis visitados",
"Downloads" => "Descargas",
"Wiki last images" => "últimas imaxes Wiki",
"Upload date" => "Data de carga",
"Wiki last files" => "últimos ficheiros Wiki ",
"Wiki top articles" => "principais artigos Wiki ",
"Most visited blogs" => "Blogs máis visitados",
"Most active blogs" => "Blogs máis activos",
"Activity" => "Actividade",
"Blogs last posts" => " últimos envíos ao Blogs ",
"Post date" => "Data da mensaxe",
"Wiki top authors" => " autores de Wiki máis activos",
"Pages" => "Páxinas",
"Top article authors" => "autores dos artigos máis activos",
"User already exists" => "O usuario xa existe",
"Wrong registration code" => "Código de rexistro erróneo",
"Invalid username" => "Nome de usuario incorrecto",
"Username is too long" => "O nome do usuario é demasiado longo",
"Username cannot contain whitespace" => "O nome do usuario non pode ter espazos",
"Wrong passcode. You need to know the passcode to register at this site" => "Código de paso incorrecto, necesita un código de paso válido para se rexistrar neste sitio",
"Invalid email address. You must enter a valid email address" => " Enderezo de correo incorrecto. Debe introducir un enderezo de correo válido",
"The registration mail can't be sent. Contact the administrator" => "O correo de rexistro non se pode enviar. Póñase en contacto co administrador",
"change" => "cambiar",
"Today" => "Hoxe",
"and" => "e",
"from" => "desde",
"replied" => "respondido",
"Login" => "Iniciar sesión",
"See other users' profiles" => "Ver perfil doutros usuarios",
"Have your profile seen" => "Ter o seu perfil visto",
"Make friends" => "Facer amigos",
"Receive message" => "Recibir mensaxe",
"Send message" => "Enviar mensaxe",
"Read an article" => "Ler un artículo",
"Publish an article" => "Publicar un artigo",
"Have your article read" => "Ter o seu artigo lido",
"Create new file gallery" => "Crear unha nova galería de ficheiros",
"Upload new file to gallery" => "Cargar un novo ficheiro á galería",
"Download other user's file" => "Descargar un ficheiro doutro usuario",
"Have your file downloaded" => "Ter o seu ficheiro descargado",
"Create a new image gallery" => "Crear unha nova galería de imaxes",
"Upload new image to gallery" => "Cargar unha nova imaxe á galería",
"See other users' galleries" => "Ver a galería doutro usuario",
"See other users' images" => "Ver a imaxe doutro usuario",
"Have your gallery seen by other users" => "Ter a súa galería vista por outro usuario",
"Have your image seen" => "Ter a súa imaxe vista",
"Create new blog" => "Crear novo blog",
"Post in a blog" => "Publicar nun blog",
"Read other users' blogs" => "Ler o blog doutro usuario",
"Have your blog read" => "Ter o seu blog lido",
"Create a new wiki page" => "Crear unha nova páxina wiki",
"Edit an existing page" => "Editar unha páxina existente",
"Attach file" => "Anexar ficheiro",
"Gallery" => "Galería",
"Image" => "Imaxe",
"Forum" => "Foro",
"Article" => "Artigo",
"Blog post" => "Artigo de blog",
"Unknown" => "Descoñecido",
"Trackeritem" => "ítem de tracker",
"Directory category" => "Categoría de directorio",
"Prev" => "Anterior",
"Next" => "Seguinte",
"comment" => "comentario",
"Click Here" => "Faga clic aquí",
"Edit Template" => "Editar modelo",
"Hide" => "Ocultar",
"help" => "axuda",
"All" => "Todos",
"The text is" => "O texto é",
"character(s) too long - please edit it." => "caracter(es) demasiado longo - por favor, edíteo.",
"Date Selector" => "Selector de data",
"Select All" => "Elixir todo",
"days" => "días",
"day" => "día",
"mins" => "minutos",
"secs" => "segs",
"done" => "listo",
"Text cut here" => "Corte o texto aquí",
"Task" => "Tarefa",
"for" => "para",
"Priority" => "Prioridade",
"Start date:" => "Data inicial:",
"End date:" => "Data final:",
"Friend" => "Amigo",
"Last seen on" => "Visto por última vez en",
"(idle for %s seconds)" => "(inactivo durante %s segundos)",
"User information - Click for more info" => "Información de Usuario - Prema para máis información",
"More info about \$other_user" => "Máis info acerca de \$other_user",
"(idle for \$idletime seconds)" => "(inactivo durante \$idletime segundos)",
"Yes" => "Si",
"No" => "Non",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Primeiro día da semana: Domingo (o seu ID é 0) - os tradutores necesitan internacionalizar esta cadea!",
"Use this tree to copy the structure" => "Use esta árbore para copiar a estrutura",
"created from structure" => "creada desde estrutura",
"Table of contents" => "Táboa de contidos",
"text" => "texto",
"unknown error" => "erro descoñecido",
"You are not logged in" => "Non iniciou a sesión",
"Page cannot be found" => "A páxina non se atopou",
"Permission denied. You cannot view this section" => "Permiso denegado para acceder a esta sección",
"Help" => "Axuda",
"You are banned from" => "Está expulsado de",
"img-g" => "gal-imx",
"file-g" => "gal-arq",
"faqs" => "pmfs",
"quizzes" => "cuestionarios",
"forums" => "foros",
"Click to edit dynamic variable" => "Prema para editar variable dinámica",
"Update variables" => "Actualizar variables",
"Show" => "Mostrar",
"sad" => "triste",
"confused" => "confundido",
"cool" => "xebre",
"mad" => "tolo",
"%d points" => "%d puntos",
"Removed" => "Eliminado",
"__WARNING__: No such module \$plugin!" => "__ADVERTENCIA__: Non existe o módulo \$plugin!",
"at" => "en",
"new" => "novo",
"Create page:" => "Crear páxina:",
"Unknown language" => "Lingua descoñecida",
"Click here to confirm your action" => "Prema aquí para confirmar a súa acción",
"Sea Surfing (CSRF) detected. Operation blocked." => "Detectado Sea Surfing (CSRF). Operación bloqueada.",
"Heading" => "Encabezado",
"Reduce area height" => "Reducir a altura da área",
"Enlarge area height" => "Ampliar a altura da área",
"Wiki Help" => "Axuda wiki",
"Item Modification" => "Modificación de ítem",
"Item" => "ítem",
"Item creation" => "Creación de ítem",
"Subject" => "Tema",
"Tracker was modified at " => "O tracker foi modificado en ",
"View the tracker item at:" => "Visualiza o ítem de tracker en:",
"text field" => "campo de texto",
"half column" => "media columna",
"size" => "tamaño",
"prepend" => "prefixar",
"append" => "sufixar",
"textarea" => "área de texto",
"checkbox" => "cela de verificación",
"numeric field" => "campo numérico",
"drop down" => "despregable",
"user selector" => "selector do usuario",
"group selector" => "selector de grupo",
"date and time" => "data e hora",
"jscalendar" => "jscalendario",
"action" => "acción",
"header" => "cabeceira",
"category" => "categoría",
"item link" => "ligazón a ítem",
"items list" => "lista de ítems",
"email" => "correo-e",
"system" => "sistema",
"attachment" => "anexo",
"open" => "aberto",
"pending" => "pendente",
"closed" => "pechado",
"Message" => "Mensaxe",
"No extra information for that attached file. " => "Non hai información extra para este ficheiro anexo.",
"child categories" => "subcategorías",
"objects in category" => "obxectos na categoría",
"(AT)" => "(EN)",
"(DOT)" => "(PUNTO)",
"Password should be at least" => "O contrasinal debe ter polo menos",
"characters long" => "caracteres",
"Password must contain both letters and numbers" => "O contrasinal debe ter letras e números",
"State" => "Estado",
"Country" => "País",
"No subject" => "Sen tema",
"Displays browser client info" => "Mostra as informacións do navegador do cliente",
"Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor" => "Crea unha ligazón a unha ancoraxe nunha páxina wiki. Úsese xunto co plugin ANAME, que permite definir a localización e o nome dunha ancoraxe.",
"linktext" => "texto de ligazón",
"Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor" => "Crea unha ancoraxe dentro dunha páxina wiki. Úsese xunto co plugin ALINK, que crea ligazóns á posición",
"Location" => "Localización",
"Field" => "Campo",
"Attachment" => "Anexo",
"File" => "Ficheiro",
"Show description" => "Ver descrición",
"No such attachment on this page" => "Non hai tal anexo nesta páxina",
"Displays an attachment or a list of them" => "Mostra un anexo ou unha lista deles",
"Displays the user Avatar" => "Mostra o avatar do usuario",
"username" => "nome do usuario",
"Back" => "Atrás",
"Backlinks" => "Retroligazóns",
"List all pages that link to specific pages" => "Mostra todas as páxinas que ligan con páxinas específicas",
"No pages links to" => "Ningunha páxina ten ligazón a",
"One page links to" => "Unha páxina con ligazón a",
"pages link to" => "páxinas con ligazóns a",
"Zone" => "Zona",
"Items" => "Ítems",
"Insert theme-styled box on wiki page" => "Inserir un cadro co estilo da decoración na páxina wiki",
"Insert list of items with the current/given category in the wiki page" => "Inserir unha listaxe de ítems para a categoría actual/fornecida na páxina wiki",
"Categories are disabled" => "As categorías están desactivadas",
"Display Tiki objects that have not been categorized" => "Amosa obxectos Tiki que non foron categorizados",
"Objects" => "Obxectos",
"Insert the full category path for each category that this wiki page belongs to" => "Inserir o camiño completo de categoría para cada categoría á que pertence esta páxina wiki",
"Center" => "Centrar",
"Centers the plugin content in the wiki page" => "Centra o contido do plugin na páxina wiki",
"title" => "título",
"Code" => "Código",
"Displays a snippet of code" => "Amosa un fragmento de código",
"code" => "código",
"note: colors and ln are exclusive" => "nota: as cores e ln son exclusivas",
"Dynamic Content" => "Contido dinámico",
"Cookie" => "Cuqui",
"Insert copyright notices" => "Insire avisos de dereitos de copia",
"Example" => "Exemplo",
"seconds" => "segundos",
"Pre" => "Pre.",
"Right" => "Dereita",
"Left" => "Esquerda",
"Clear" => "Limpiar",
"Creates a definition list" => "Crea unha listaxe de definición",
"term" => "termo",
"definition" => "definición",
"one definition per line" => "unha definición por liña",
"Events" => "Eventos",
"Upcoming events" => "Próximos eventos",
"Label" => "Etiqueta",
"Displays the data using the Tikiwiki odd/even table style" => "Amosa os datos usando o estilo de táboa par/impar de Tikiwiki",
"cells" => "celas",
"sort" => "ordenar",
"Displays a Flash (.swf) file in the wiki page" => "Amosa un SWF na páxina wiki",
"failed" => "fallo",
"description" => "descrición",
"Value" => "Valor",
"Displays a graphical GAUGE" => "Amosa un medidor gráfico",
"type" => "tipo",
"Group" => "Grupo",
"groups" => "grupos",
"HTML code" => "código HTML",
"name" => "nome",
"Image ID" => "ID de imaxe",
"Image size" => "Tamaño da imaxe",
"Thumbnail" => "Miniatura",
"Browse" => "Navegar",
"Download" => "Descargar",
"Include" => "Incluír",
"Start" => "Comezo",
"Stop" => "Deter",
"Include a page" => "Incluír unha páxina",
"Email address" => "Enderezo de correo",
"Displays the text only if the language matchs" => "Amosa o texto só se a linguaxe coincide",
"Last Modification" => "última modificación",
"List Pages" => "Listar páxinas",
"Sort" => "Ordenar",
"or" => "ou",
"Filter" => "Filtrar",
"complete" => "completo",
"articles" => "artigos",
"Lists files in a directory" => "Lista de ficheiros nun directorio",
"could not be opened because it doesn't exist or permission was denied" => "non se dá aberto porque non existe ou o permiso foi denegado",
"Map" => "Asociar",
"Feature disabled" => "Opción deshabilitada",
"Template" => "Modelo",
"Style" => "Estilo",
"Groups" => "Grupos",
"Module Name" => "Nome do módulo",
"Please choose a module" => "Por favor, escolla un módulo",
"to be used as argument" => "para ser usado como argumento",
"Displays a module inline in a wiki page" => "Amosa un módulo integrado na páxina",
"Sorry, no such module" => "Síntoo, non existe ese módulo",
"Font" => "Tipo de letra",
"Displays the data using a monospace font" => "Amosa os datos usando un tipo de letra monoespazada",
"Text" => "Texto",
"Sticky" => "Persistente",
"data" => "datos",
"Object" => "Obxecto",
"Days" => "Días",
"Status" => "Estado",
"Picture" => "Imaxe",
"picture not found" => "imaxe non atopada",
"Information" => "Información",
"Displays a list of plugins available in this wiki." => "Fornece unha lista de plugins neste wiki.",
"No version indicated" => "Non se indica unha versión",
"No arguments indicated" => "Non se indican argumentos",
"Poll" => "Votación",
"Displays the output of a poll, fields are indicated with numeric ids." => "Amosar a saída dunha votación, os campos están indicados con id numéricos.",
"missing poll ID for plugin POLL" => "non se atopa ID de votación para o plugin POLL",
"wrote:" => "escribiu:",
"Quote:" => "Cita:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Cita texto rodeándoo cunha caixa, como o comando [QUOTE] de BBCode",
"Preferences" => "Preferencias",
"User Information" => "Información do usuario",
"one data per line" => "un dato por liña",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Toma unhas expresións regulares e analiza o contido entre as marcas REGEX e substitúe o texto.",
"Icon" => "Icona",
"Close" => "Pechar",
"Date" => "Data",
"Automatically creates a link to the appropriate SourceForge object" => "Crear automaticamente unha ligazón ao obxecto de Sourceforge apropiado",
"Pop-up" => "emerxente",
"Sheet Heading" => "Cabeceira da folla",
"TikiSheet" => "Folla de cálculo tiki",
"Edit Sheet" => "Editar folla",
"List wiki pages" => "Lista de páxinas wiki",
"Display" => "Mostrar",
"Last modified by" => "Última modificación por",
"Action" => "Acción",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "O plugin SNARF substitúese a si mesmo co corpo HTML dunha URL. Poden facerse substitucións arbitrarias de expresión regular neste contido usando regex e regexres, o último úsase como segundo argumento a preg_replace.",
"This data is put in a CODE caption." => "Esta información ponse como unha lenda CODE.",
"Missing url parameter for SNARF plugin." => "Parámetro url ausente para o plugin SNARF.",
"Sorts the plugin content in the wiki page" => "Ordenar o contido do plugin na páxina wiki",
"Order" => "Orde",
"Split a page into rows and columns" => "Dividir unha páxina en filas e columnas",
"First" => "Primeiro",
"Edit" => "editar",
"row1col1" => "fila1col1",
"row1col2" => "fila1col2",
"row2col1" => "fila2col1",
"row2col2" => "fila2col2",
"Run a sql query" => "Executar unha consulta sql",
"sql query" => "consulta sql",
"Missing db param" => "Falta parámetro da db",
"Displays text in subscript." => "Amosar o texto como subíndice.",
"Subscribe" => "Subscribirse",
"Displays the thumbnail for an image" => "Amosar a miniatura para unha imaxe",
"Original" => "Orixinal",
"Search the titles of all pages in this wiki" => "Buscar os títulos de todas as páxinas neste wiki",
"No pages found for title search" => "Non se atoparon páxinas na busca por título",
"One page found for title search" => "Atopouse unha páxina na busca por título",
"pages found for title search" => "páxinas atopadas na busca por título",
"Structure ID" => "ID da estrutura",
"Public" => "Público",
"Translate" => "Traducir",
"Fields" => "Campos",
"Email" => "Correo-e",
"to" => "a",
"template" => "modelo",
"Preview" => "previsualizar",
"preview" => "previsualizar",
"View" => "Visualizar",
"Error" => "Erro",
"Displays an input form for tracker submit" => "Amosa un tracker de entrada para enviar ao tracker",
"Fields marked with a * are mandatory." => "Os campos marcados cun * son obrigatorios.",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Amosa a saída do contido dun tracker; os campos indícanse con id numéricos.",
"Mode" => "Modo",
"Delete" => "Borrar",
"Error in tracker ID" => "Erro no ID do tracker",
"No field indicated" => "Non se indicou campo",
"Links to a translated content" => "Ligazóns a contido traducido",
"Flag" => "Marca ",
"Displays the number of registered users" => "Amosa o número de usuarios rexistrados",
"User List" => "Lista de usuarios",
"Real Name" => "Nome real",
"users" => "usuarios",
"Versions" => "Versións",
"Split the text in parts visible only under some conditions" => "Dividir o texto en partes visibles só baixo certas condicións",
"Vote" => "votar",
"Table" => "Táboa",
"External Wiki" => "Wiki externo",
"valid" => "válido",
"width" => "anchura",
"height" => "altura",
"ERROR: Either the subject or body must be non-empty" => "ERRO: o tema ou o corpo non poden quedar baleiros",
"ERROR: No valid users to send the message" => "ERRO: ningún usuario válido para lle enviar a mensaxe",
"Invalid user" => "Usuario incorrecto",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "A carpeta de enviadas está chea. Arquive ou borre algunhas mensaxes enviadas se quere enviar máis mensaxes.",
"User %s can not receive messages, mailbox is full" => "O usuario %s non pode recibir mensaxes, a caixa de correo está chea",
"User %s can not receive messages" => "O usuario %s non pode recibir mensaxes",
"Invalid user: %s" => "Usuario incorrecto: %s",
"Message will be sent to: " => "A mensaxe enviarase a: ",
"Archive is full. Delete some messages from archive first." => "Arquivo cheo. Borre primeiro algunhas mensaxes do arquivo.",
"No more messages" => "Non hai máis mensaxes",
"Categories" => "Categorías",
"Categorize" => "Categorizar",
"Unassign" => "Inhabilitar",
"Assign" => "Asignar",
"Received objects" => "Obxectos recibidos",
"File galleries" => "Galerías de ficheiros",
"Last forum posts" => "Últimos artigos no foro",
"Topics only" => "Só temas",
"Most commented forums" => "Foros con máis mensaxes",
"Most read topics" => "Temas máis lidos",
"Most visited forums" => "Foros máis visitados",
"Google Search" => "Buscar en Google",
"Last actions" => "Últimas accións",
"Last blog posts" => "Últimos artigos nos blogs",
"no object here yet" => "aínda non hai obxectos aquí ",
"Last Created blogs" => "Últimos blogs creados",
"Last Created FAQs" => "Últimas PMF creadas",
"Last Created Quizzes" => "Últimos cuestionarios",
"Last modified file galleries" => "Galerías de ficheiros modificadas recentemente",
"Last Files" => "Últimos ficheiros",
"Last Images" => "Últimas imaxes",
"Last modified events" => "Últimos eventos modificados",
"Last Modified blogs" => "Blogs recentemente modificados",
"Last submissions" => "Últimas colaboracións",
"Last Items" => "Últimos ítems",
"Last Modified Items" => "Ítems recentemente modificados",
"Last Visitors" => "Últimos visitantes",
"Live support" => "Asistencia en liña",
"Messages" => "Mensaxes",
"Waiting Submissions" => "Colaboracións en espera",
"Old articles" => "Artigos antigos",
"Create/Edit" => "Crear/editar",
"Quick Edit a Wiki Page" => "Edición rápida de páxina wiki",
"Random Pages" => "Páxinas ao chou",
"New user registration" => "Rexistro de novo usuario",
"Post" => "Publicar",
"Since your last visit" => "Desde a súa última visita",
"Changes since" => "Cambios desde",
"new comments" => "comentarios novos",
"wiki pages changed" => "páxinas do wiki modificadas",
"new articles" => " artigos novos ",
"new FAQs" => "novas PMF",
"new blogs" => "blogs novos",
"new blog posts" => "novos artigos no blog",
"new image galleries" => "novas galerías de imaxes",
"new images" => "imaxes novas",
"new file galleries" => "novas galerías de ficheiros",
"new files" => "novos ficheiros",
"new polls" => "votacións novas ",
"new users" => "usuarios novos",
"Most Active blogs" => "Blogs máis activos",
"Top articles" => "Artigos máis lidos",
"Top File Galleries" => "Galerías de ficheiros máis visitadas",
"Top files" => "Ficheiros principais",
"Top Forum Posters" => "Principais participantes en foros",
"Top Images" => "Imaxes principais",
"Top Pages" => "Páxinas principais",
"Top Quizzes" => "Cuestionarios principais",
"Top Visited FAQs" => "PMF máis visitadas",
"User Blogs" => "Blogs do usuario",
"My blogs" => "Os meus blogs",
"User bookmarks" => "Marcadores do usuario",
"My galleries" => "As miñas galerías",
"User Pages" => "Páxinas do usuario",
"My Pages" => "As miñas páxinas",
"User tasks" => "Tarefas de usuario",
"The task title must have at least 3 characters" => "O título da tarefa debe ter polo menos tres caracteres",
"Public tasks" => "Tarefas públicas",
"Top users" => "Usuarios principais",
"Online users" => "Usuarios en liña",
"Last wiki comments" => "Últimos comentarios wiki",
"Invalid username or password" => "Usuario ou contrasinal incorrectos",
"country" => "país",
"theme" => "decorado ",
"Anti-Bot verification code" => "Código de verificación anti-robot",
"Random Image" => "Imaxe ao chou",
"Enter the code you see above" => "Introduza o código que ve arriba",
"List of attached files" => "Lista de ficheiros anexos",
"desc" => "descrición",
"uploaded" => "cargado",
"Remove" => "Borrar",
"Upload file" => "Cargar ficheiro",
"Attach" => "Anexar",
"Attach a file to this item" => "Anexar un ficheiro a este ítem",
"Version" => "Versión",
"Attachments" => "Anexos",
"more info" => "máis información",
"No attachments for this item" => "Non hai anexos a este ítem",
"debug" => "depurar",
"Fatal error" => "Erro moi grave",
"Created by" => "Creado por",
"on" => "en",
"Activity=" => "Actividade=",
"Actions" => "Accións",
"Properties" => "Propiedades",
"No records found" => "Non se atoparon rexistros",
"Admin Categories" => "Administrar categorías",
"No categories defined" => "Non se definiron categorías",
"Browse Category" => "Navegar na categoría",
"posts:" => "artigos",
"stars" => "estrelas",
"User Level" => "Nivel de usuario",
"private message" => "mensaxe privada",
"Send eMail to User" => "Enviar correo a usuario",
"user online" => "usuario en liña",
"user offline" => "usuario fóra de liña",
"Reply" => "Responder",
"Approve" => "Aprobar",
"Reject" => "Rexeitar",
"Save to notepad" => "Gardar no caderno de notas",
"Monitor this Topic" => "Monitorizar este tema",
"Stop Monitoring this Topic" => "Deixar de monitorizar este tema",
"Moderator actions" => "Accións do moderador",
"reported:" => "enviado:",
"queued:" => "na cola:",
"Move to topic:" => "Mover ao tema:",
"Move" => "Mover",
"Delete Selected" => "Borrar seleccionados",
"Unlock" => "Desbloquear",
"Lock" => "Bloquear",
"Threshold" => "Límite mínimo",
"Set" => "Poñer",
"Replies" => "Respostas",
"below your current threshold" => "por baixo do teu límite actual",
"New Reply" => "Nova resposta",
"Editing reply" => "Editar resposta",
"Reply to the selected post" => "Responder ao artigo seleccionado",
"Editing comment" => "Editando comentario",
"Comment on the selected post" => "Comentar no artigo seleccionado",
"Post new comment" => "Publicar novo comentario",
"Toolbars" => "Etiquetas rápidas",
"optional" => "opcional",
"Reply to parent post" => "Responder ao artigo pai",
"Post new reply" => "Publicar unha resposta nova",
"Cancel" => "Cancelar",
"Posting replies" => "Publicar respostas",
"Posting comments" => "Publicar comentarios",
"Add Comment" => "Engadir comentario",
"1 comment" => "1 comentario",
"Go back" => "Atrás",
"Return to home page" => "Volver ao inicio",
"Copyrights" => "Dereitos de copia",
"Year" => "Ano",
"Authors" => "Autores",
"Add" => "Engadir",
"Tiki Debugger Console" => "Consola do Depurador Tiki",
"Current URL" => "URL actual",
"Command" => "Orde",
"exec" => "executar",
"Type <code>help</code> to get list of available commands" => "Poña <code>help</code> para obter a lista de ordes dispoñibles",
"Syntax" => "Sintaxe",
"Page generation debugging log" => "Rexistro de depuración de xeración de páxina",
"Features state" => "Estado das características",
"features matched" => "características coincidentes",
"Watchlist" => "Lista de monitores",
"duplicate" => "duplicado",
"There are individual permissions set for this file gallery" => "Hai permisos individuais configurados para esta galería de ficheiros",
"Save" => "Gardar",
"Use" => "Usar",
"unlimited" => "ilimitado",
"none" => "ningún",
"Parent gallery" => "Galería superior",
"Default sort order" => "Orde por defecto",
"Max description display size" => "Tamaño máximo de visualización da descrición",
"Please login" => "Por favor, inicie a sesión",
"There are no wiki pages similar to '{\$page}'" => "Non hai páxinas wiki similares a '{\$page}'",
"Create this page" => "Crear esta páxina",
"(page will be orphaned)" => "(a páxina quedará orfa)",
"Close Window" => "Pechar fiestra",
"Active Perms" => "Permisos activos",
"Perms" => "Permisos",
"Replace" => "Substituír",
"List" => "Listar",
"Name-filename" => "Nome-Nome de ficheiro",
"Filename only" => "Só nome de ficheiro",
"Exact&nbsp;match" => "Correspondencia&nbsp;exacta",
"Number of displayed rows" => "Número de filas mostradas",
"in:" => "en:",
"Go" => "Ir",
"RSS Wiki" => "RSS de Wiki",
"RSS Blogs" => "RSS de blogs",
"RSS Articles" => "RSS Artigos",
"RSS Image Galleries" => "RSS Galerías de Imaxes",
"RSS File Galleries" => "RSS Galerías de Ficheiros",
"RSS Forums" => "RSS Foros",
"RSS Maps" => "RSS Mapas",
"RSS Directories" => "RSS Directorios",
"Perform action with checked:" => "Executar acción cos marcados:",
"Move Selected Files" => "Mover ficheiros seleccionados",
"Assign Permissions" => "Asignar permisos",
"Move to" => "Mover a",
"Filename" => "Nome de ficheiro",
"Hi {\$mail_user} has sent you this link:" => "Ola {\$mail_user} envioulle esta ligazón:",
"Blog post:" => "Artigo de blog:",
"at:" => "en:",
"Somebody or you tried to subscribe this email address at our site:" => "Alguén ou vostede tentou subscribir este enderezo de correo no noso sitio:",
"To the newsletter:" => "Ao boletín:",
"Description:" => "Descrición:",
"In order to confirm your subscription you must access the following URL:" => "Para confirmar a súa subscrición debe acceder ao seguinte URL:",
"User:" => "Usuario:",
"A new message was posted to forum" => "Unha nova mensaxe foi posta no foro",
"New topic:" => "Novo tema:",
"Topic:" => "Tema:",
"You sent a request with the subject:" => "Enviou unha solicitude co tema:",
"Use the subject to indicate the operation to apply:" => "Use o tema para indicar a operación que vai aplicar:",
"GET:WikiName to get a wiki page" => "GET:WikiName para obter unha páxina wiki",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName para actualizar/crear unha páxina wiki (use o corpo para o contido da páxina",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName para agregar datos a unha páxina Wiki (use o corpo para o contido que vai agregar)",
"PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName para agregar contido ao principio",
"Tiki mail-in instructions" => "Instrucións da entrada de correo de Tiki",
"Tiki mail-in auto-reply." => "Auto-resposta da entrada de correo Tiki.",
"Page not found:" => "Páxina non atopada:",
"Hi," => "Ola,",
"A new message was posted to you at {\$mail_machine}" => "Foiche enviada unha nova mensaxe en {\$mail_machine}",
"From" => "Desde",
"New message arrived from %s" => "Nova mensaxe recibida desde %s",
"Hi" => "Ola",
"Enjoy the site!" => "Goce do sitio!",
"has requested an account on" => "solicitou unha conta en",
"To validate that account, please follow the link:" => "Para validar esa conta, siga a ligazón, por favor:",
"User Registration Request" => "Solicitude de rexistro de usuario Tiki",
"You're invited to join my network of friends!" => "Está invitado a unirse ao meu círculo de amigos!",
"The user" => "O usuario",
"registered at your site" => "rexistrouse no seu sitio",
"Bye bye!" => "Ata logo!",
"This email address has been removed to the list of subscriptors of:" => "Este enderezo de correo foi borrado da lista dos subscritores de:",
"Newsletter:" => "Boletín:",
"Bye bye from %s at %s" => "Ata logo desde  %s en %s",
"You can unsubscribe from this newsletter following this link" => "Pode cancelar a subscrición deste boletín seguindo esta ligazón",
"Welcome to our newsletter!" => "Benvido ao noso boletín!",
"This email address has been added to the list of subscriptors of:" => "Este enderezo de correo foi engadido á lista de subscritores de:",
"You can always cancel your subscription using:" => "Pode cancelar a súa subscrición en calquera momento usando:",
"Welcome to %s at %s" => "Benvido a %s en %s",
"Email notification" => "Notificación de correo do Tiki",
"Since this is your registered email address we inform that the password for this account is" => "Xa que este é o seu enderezo de correo-e rexistrado, informámolo de que a clave para esta conta é",
"Your account information for %s" => "A súa información de conta Tiki para %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Un novo artigo enviado por {\$mail_user} a {\$mail_site} en {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Pode editar o envío seguindo esta ligazón:",
"Title:" => "Título:",
"Heading:" => "Encabezado:",
"Body:" => "Corpo:",
"New article submitted at %s" => "Novo artigo enviado a %s",
"You or someone registered this email address at" => "vostede ou alguén rexitrou este enderezo de correo en",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Se quere ser un usuario rexistrado neste sitio, debe seguir a seguinte ligazón para iniciar a sesión por primeira vez:",
"Your registration confirmation" => "A súa información de rexistro no Tiki",
"You will receive an email with information to login for the first time into this site" => "Recibirá un correo con información para iniciar sesión por primeira vez neste sitio",
"Your account request has been stored and will be activated by the admin as soon as possible." => "A súa solicitude de conta foi almacenado e será activado polo administrador o máis axiña posible.",
"View the article at:" => "Visualizar o artigo en:",
"If you don't want to receive these notifications follow this link:" => "Se non desexa recibir estas notificacións, siga esta ligazón:",
"View the blog at:" => "Visualizar o blog en:",
"New blog post at %s" => "Novo artigo no blog en %s",
"changed" => "modificado",
"created" => "creado",
"Removed by" => "Borrado por",
"New" => "Novo",
"File Gallery %s changed" => "Galería de Ficheiros %s cambiada",
"A file was removed from the file gallery" => "Un ficheiro foi borrado da galería de ficheiros",
"File Name" => "Nome do ficheiro",
"A new file was posted to file gallery" => "Un novo ficheiro foi cargado na galería de ficheiros",
"Posted by" => "Enviado por",
"File Description" => "Descrición do ficheiro",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "O mapa {\$mail_page} foi cambiado por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Pode ver o mapa actualizado seguindo esta ligazón:",
"You can edit the map following this link:" => "Pode editar o mapa seguindo esta ligazón:",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A páxina {\$mail_page} foi creada por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A páxina {\$mail_page} foi modificada por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"Comment:" => "Comentario:",
"You can view the page by following this link:" => "Pode visualizar a páxina seguindo esta ligazón:",
"You can view a diff back to the previous version by following this link:" => "Pode ver os cambios con respecto ás versións anteriores seguindo a seguinte ligazón:",
"The changes in this version follow below, followed after by the current full page text." => "Os cambios nesta versión seguen abaixo, seguidos do texto completo actual.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Liñas: {\$oldd} cambiadas a +Líneas: {\$newd}",
"The new page content follows below." => "O contido novo da páxina segue abaixo.",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A páxina {\$mail_page} foi comentada por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"New name" => "Novo nome",
"click on the map to zoom or pan, do not drag" => "prema no mapa para ampliar a panorámica, non arrastre",
"Scale" => "Escala",
"Query" => "Consulta",
"Pan" => "Panorámica",
"Redraw" => "Redebuxar",
"select zoom/pan/query and image size" => "seleccionar zoom/pan/consulta e tamaño da imaxe",
"View the Map Only" => "Ver só o mapa",
"Reset Map" => "Reiniciar o mapa",
"Click on the map or click redraw" => "Prema no mapa ou en redebuxar",
"Last modification date" => "Data da última modificación",
"Overview" => "Resumo",
"Legend" => "Lenda",
"Layer Manager" => "Xestor de Capas",
"Layer" => "Capa",
"On" => "En",
"Download Layer" => "Descargar capa",
"This layer has been set by the maps administrator to not be downloadable" => "Esta capa foi configurada polo administrador de mapas como non descargable",
"you have requested to download the layer:" => "solicitou descargar a capa:",
"Here are the files to download, do not forget to rename them:" => "Aquí están os ficheiros para descargar, non esqueza renomealos:",
"Mapfiles" => "Ficheiros de mapas",
"Mapfile" => "Ficheiro de mapa",
"Available mapfiles" => "Ficheiro de mapa dispoñibles",
"monitor this map" => "monitorizar este mapa",
"Stop Monitoring this Map" => "Deixar de monitorizar este mapa",
"Create a new mapfile" => "Crear un novo ficheiro de mapa",
"Create" => "Crear",
"Mapfile listing" => "Listaxe de ficheiros de mapa",
"Reload" => "Recargar",
"History" => "Historial",
"You can view this map in your browser using" => "Pode ver este mapa no seu navegador usando",
"Zoom out x2" => "Reducir x2",
"Zoom in x2" => "Ampliar x2",
"Mapfile History" => "Historia do ficheiro de mapa",
"of" => "de",
"Compare" => "Comparar",
"Comparing version {\$old.version} with version {\$new.version}" => "Comparar a versión {\$old.version} coa versión {\$new.version}",
"Version:" => "Versión:",
"Current" => "Actual",
"Versions are identical" => "As versións son idénticas",
"Legend:" => "Lenda:",
"v=view" => "v=ver",
"c=compare" => "c=comparar",
"Full side-by-side diff" => "diferenzas lado a lado completo",
"Unified diff" => "diferenzas unificadas",
"Side-by-side view" => "Vista lado a lado",
"User" => "Usuario",
"Older Version" => "Versión máis antiga",
"Directories" => "Directorios",
"back to" => "volver a",
"Upload From Disk:" => "Cargar desde disco:",
"Upload Files" => "Cargar ficheiros",
"Bytes maximum" => "Máximo de bytes",
"Create Directory:" => "Crear directorio:",
"index file (.shp):" => "ficheiro índice (.shp):",
"files to index (regexp):" => "ficheiros para indexar (regexp):",
"Message Archive" => "Arquivo de mensaxe",
"messages" => "mensaxes",
"Archive is full!" => "O arquivo está cheo!",
"Unread" => "Non lidos",
"Flagged" => "Marcado",
"Unflagged" => "Desmarcado",
"Containing" => "Contendo",
"Sender" => "remitente",
"No messages to display" => "Sen mensaxes para mostrar",
"Broadcast message" => "Mensaxe de difusión",
"OK" => "Correcto",
"All users" => "Todos os usuarios",
"Lowest" => "Mínimo",
"Low" => "Baixo",
"High" => "Alto",
"Very High" => "Superior",
"Send" => "Enviar",
"Compose message" => "Escriba unha mensaxe",
"Invalid" => "Incorrecto",
"No messages to download" => "Sen mensaxes para descargar",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "A caixa de correo está chea! Borre ou arquive algunhas mensaxes se quere recibir novas mensaxes.",
"Find replied message" => "buscar mensaxe respondida",
"Archive" => "Arquivo",
"Mark as read" => "Marcar como lido",
"Mark as unread" => "Marcar como non lido",
"Mark as flagged" => "Marcar",
"Mark as unflagged" => "Desmarcar",
"Mark" => "marcar",
"Mailbox" => "caixa de correo",
"Compose" => "Compoñer",
"Broadcast" => "Difusión ampla",
"Sent" => "Enviada",
"Auto-archive age for read messages:" => "Tempo de autoarquivado para mensaxes lidas",
"Read message" => "Ler mensaxe",
"Return to mailbox" => "Volver á caixa de correo",
"replyall" => "responder a todos",
"Unflag" => "Desmarcar",
"Flag this message" => "Marcar esta mensaxe",
"From:" => "Desde:",
"Return to archive" => "Volver ao arquivo",
"Return to outbox" => "Volver á caixa de saída",
"Sent Messages" => "Mensaxes enviadas",
"Replied" => "Respondido",
"Not replied" => "Non respondido",
"move to archive" => "mover a arquivo",
"receiver" => "receptor",
"'name' parameter for tikimodule missed" => "falta o parámetro 'name' para tikimodule",
"Move module up" => "Mover módulo arriba",
"Up" => "Subir",
"Move module down" => "Mover módulo abaixo",
"Down" => "Baixar",
"Move module to opposite side" => "Mover módulo para o lado oposto",
"opp side" => "lado oposto",
"Unassign this module" => "Inhabilitar este módulo",
"Are you sure you want to unassign this module?" => "¿Está seguro de que quere inhabilitar este módulo?",
"Thank you for installing Tikiwiki" => "Grazas por instalar Tikiwiki",
"Select" => "Seleccionar",
"Admin" => "Administrar",
"Admin Modules" => "Administrar módulos",
"Modules" => "Módulos",
"Admin Menus" => "Administrar menús",
"Menus" => "Menús",
"login" => "iniciar sesión",
"Pages:" => "Páxinas:",
"Categories:" => "Categorías:",
"Register" => "Rexistrarse",
"Open operator console" => "Abrir consola de operador",
"Logout" => "Finalizar sesión",
"Switch" => "Cambiar",
"Login through CAS" => "Entrada con CAS",
"Login as admin" => "Iniciar sesión como admin",
"eMail" => "Correo-e",
"Password" => "Contrasinal",
"Remember me" => "Lembrarme",
"week" => "semana",
"month" => "mes",
"year" => "ano",
"Click here to register" => "Prema aquí para rexistrarse",
"Click here if you've forgotten your password" => "Prema aquí se esqueceu o seu contrasinal",
"I forgot my password" => "Esquecín o meu contrasinal",
"Click here to login using the default security protocol" => "Prema aquí para iniciar sesión usando o protocolo por defecto de seguridade",
"Standard" => "Estándar",
"Click here to login using a secure protocol" => "Prema aquí para iniciar sesión usando un protocolo seguro",
"Secure" => "Seguro",
"Stay in ssl Mode" => "Permanecer en modo ssl",
"You have" => "Ten",
"new messages" => "novas mensaxes",
"new message" => "nova mensaxe",
"You have 0 new messages" => "Ten 0 mensaxes novas",
"We have" => "Temos",
"submissions waiting to be examined" => "colaboracións esperando ser examinadas",
"Image Galleries" => "Galerías de imaxes",
"Entire Site" => "Sitio completo",
"Wiki Pages" => "Páxinas do wiki",
"Image Gals" => "Gals. de Imaxes",
"Blog Posts" => "Artigos de blog",
"Search Wiki PageName" => "Buscar nome páxina Wiki",
"Read More" => "Ler máis",
"Since your last visit on" => "Desde a súa última visita en",
"New Images" => "Imaxes novas",
"Wiki Pages Changed" => "Páxinas do wiki modificadas",
"New Files" => "Novos ficheiros",
"New Comments" => "Comentarios novos",
"New Users" => "Usuarios novos",
"click to edit" => "clic para editar",
"Top galleries" => "Galerías principais",
"view" => "visualizar",
"click to view" => "premer para ver",
"Bookmarks" => "Marcadores",
"Cache" => "Caché",
"Done" => "listo",
"Del" => "Borrar",
"select" => "seleccionar",
"Refresh" => "Actualizar",
"online users" => "usuarios en liña",
"online user" => "usuario en liña",
"Send a message to" => "Enviar unha mensaxe a",
"vote" => "votar",
"Warning" => "Coidado",
"Users" => "Usuarios",
"Send Newsletter" => "Enviar boletín",
"RSS feed" => "Fonte RSS",
"Edit blog" => "Editar blog",
"Monitor this Blog" => "Monitorizar este blog",
"Stop Monitoring this Blog" => "Deixar de monitorizar este blog",
"Find:" => "Atopar:",
"pages" => "páxinas",
"To edit the copyright notices" => "Para editar os avisos de dereitos de copia",
"The content on this page is licensed under the terms of the" => "O contido desta páxina está licenciado baixo os termos do",
"Permalink" => "Ligazón permanente",
"comments" => "comentarios",
"First page" => "Primeira páxina",
"Previous page" => "Páxina anterior",
"page" => "páxina",
"Next page" => "Páxina seguinte",
"Last page" => "Última páxina",
"referenced by" => "referenciado por",
"references" => "referencias",
"View Comments" => "Ver comentarios",
"Blog name" => "Nome do blog",
"Calendar View" => "Vista de calendario",
"List View" => "Visualizar lista",
"Tools Calendars" => "Ferramentas de calendarios",
"Check / Uncheck All" => "Marcar / desmarcar todos",
"Tip" => "Consello",
"Cancel Edit" => "Cancelar a edición",
"Change preferences" => "Cambiar preferencias",
"Site Ads and Banners" => "Publicidade e pancartas do sitio",
"General" => "Xeral",
"Features" => "Características",
"Community" => "Comunidade",
"Module" => "Módulo",
"Meta Tags" => "meta etiquetas",
"User files" => "Ficheiros de usuario",
"To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "Para agregar/borrar blogs, vaia a \"Crear/Editar blog\" en \"Blogs\" no menú de aplicación, ou ",
"General Settings" => "Configuracións xerais",
"Home Blog (main blog)" => "Blog inicial (blog principal)",
"Change settings" => "Cambiar configuración",
"Day" => "Día",
"Saturday" => "Sábado",
"Sunday" => "Domingo",
"Monday" => "Luns",
"5 minutes" => "5 minutos",
"Permissions" => "Permisos",
"Look under \"Articles\" on the application menu for links to" => "Busque en \"Artigos\" no menú de aplicación para ligazóns a",
"Import CSV file" => "Importar ficheiro CSV",
"Import" => "Importar",
"Admin Groups" => "Administrar grupos",
"Admin Users" => "Administrar usuarios",
"Number of friends" => "Número de amigos",
"E-mail" => "Correo electrónico",
"Last login" => "Última conexión",
"Distance" => "Distancia",
"default" => "por defecto",
"Number of visited pages to remember" => "Cantidade de páxinas visitadas para recordar",
"Displayed time zone" => "Zona horaria para mostrar",
"User information" => "Información do usuario",
"Private" => "Privado",
"public" => "público",
"Use double-click to edit pages" => "Usar dobre clic para editar páxinas",
"Show user's info on mouseover" => "Mostra a información do usuario ao pasar o punteiro do rato por riba",
"Tasks per page" => "Tarefas por páxina",
"Messages per page" => "Mensaxes por páxina",
"Allow messages from other users" => "Permitir mensaxes doutros usuarios",
"Send me an email for messages with priority equal or greater than" => "Envíeme un correo por mensaxes con prioridade igual ou meirande a",
"Auto-archive read messages after x days" => "Auto-arquivar mensaxes lidas logo de x días",
"never" => "nunca",
"My Tiki" => "O meu Tiki",
"My pages" => "As miñas páxinas",
"My messages" => "As miñas mensaxes",
"My tasks" => "As miñas tarefas",
"My items" => "Os meus ítems",
"To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "Para configurar o seu directorio, busque \"Admin directorio\" baixo \"Directorio\" no menú de aplicación, ou",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Para agregar/eliminar PMF, busque \"Admin PMFs\" en \"PMFs\" no menú de aplicación, ou",
"Settings" => "Configuración",
"Watches" => "Monitores",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Se decide gardar ficheiros nun directorio, debe asegurarse de que o usuario non pode acceder directamente ao directorio.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Ten dúas opcións para lograr isto:<br /><ul><li>Usar un directorio fóra do documento raíz, asegurándose de que o seu script php pode ler e escribir nese directorio</li><li>Usar un directorio dentro do documento raíz e usar .htaccess para evitar que os usuarios listen o contido do directorio</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Para configurar o camiño ao directorio, use camiños similares aos de UNIX, p/ex ficheiros/ ou c:/foo/ficheiros ou /www/ficheiros/",
"Home Gallery (main gallery)" => "Galería inicial (galería principal)",
"MIME Type" => "Tipo MIME",
"Reindex all files for search" => "Reindexar todos os ficheiros para a busca",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Para engadir/eliminar foros, busque por \"Admin foros\" en \"Foros\" no menú de aplicación, ou",
"Home Forum (main forum)" => "Foro inicial (principal)",
"Searches" => "Buscas",
"Browser width" => "Anchura do navegador",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Para engadir/eliminar galerías de imaxes, vaia a \"Galerías de Imaxes\" no menú de aplicación, ou",
"You can upload images of a size of " => "Pode cargar imaxes dun tamaño de",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Modifique as variables do php.ini file_uploads, upload_max_filesize, post_max_size e variables da base de datos (max_allowed_packet para mysql) para cambiar este valor",
"Home Gallery" => "Galería Inicial",
"Galleries features" => "Características de galerías",
"Uses Slideshow" => "Usa diapositivas",
"Use database to store images" => "Usar a base de datos para gardar imaxes",
"Use a directory to store images" => "Usar directorio para almacenar imaxes",
"Directory path" => "Ruta do directorio",
"Library to use for processing images" => "Biblioteca para procesar imaxes",
"Uploaded image names must match regex" => "Os nomes das imaxes deben emparellar con esta expresión regular",
"Uploaded image names cannot match regex" => "Os nomes das imaxes non deben emparellar con esta expresión regular",
"Directory Batch Loading" => "Carga en lote de directorio",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Se activa carga en lote de directorio, debe configurar un directorio lexible desde o servidor web (é preferible fóra do espazo web de páxinas). Logo configure unha forma de cargar imaxes nese directorio, xa sexa por scp, ftp ou outros protocolos",
"Enable directory batch loading" => "Activar a carga en lote de directorio",
"Batch loading directory" => "Directorio de carga en lote",
"Max Rows per page" => "Cantidade máxima de filas por páxina",
"Images per row" => "Imaxes por fila",
"Thumbnails size X" => "Tamaño X para miniaturas",
"Thumbnails size Y" => "Tamaño Y para miniaturas",
"pixels" => "píxeles",
"Set features" => "Establecer configuración",
"Exterminator" => "Exterminador",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Eliminar imaxes da galería do sistema, que non se están usando en páxinas wiki, artigos ou artigos do blog",
"All galleries" => "Todas as galerías",
"System Gallery" => "Galería do sistema",
"Gallery listing configuration" => "Configuración da listaxe de galerías",
"Parent" => "Pai",
"Last modified" => "Última modificación",
"Change configuration" => "Cambiar configuración",
"Image galleries comments settings" => "Configuración para os comentarios en galerías de imaxes",
"General Preferences" => "Preferencias xerais",
"Site Identity" => "Identidade do sitio",
"Username" => "Usuario",
"Home Page" => "Páxina Inicial",
"Custom home" => "Inicio personalizado",
"Date and Time Formats" => "Formatos de data e hora",
"Date and Time Format Help" => "Axuda de formatos de data e hora",
"Change admin password" => "Cambiar o contrasinal de admin",
"Change password" => "Cambiar contrasinal",
"Syntax error" => "Erro de sintaxe",
"port" => "porto",
"click here" => "faga clic aquí",
"Enable/disable Tiki features in " => "Activar/desactivar características do Tiki en ",
", but configure them elsewhere" => ", pero configúreas noutro lado",
"Tiki and HTTP Auth" => "Tiki e HTTP Auth",
"Registration" => "Rexistro",
"Users can register" => "Usuarios poden rexistrarse",
"Account validated successfully." => "Conta validada con éxito.",
"Use challenge/response authentication" => "Usar autenticación por challenge/response ",
"Allow secure (https) login" => "Permitir inicio de sesión seguro (https)",
"Require secure (https) login" => "Requirir inicio de sesión seguro (https)",
"Duration:" => "Duración:",
"Currently unused" => "Actualmente non usado",
"Version 1.0" => "Versión 1.0",
"Version 2.0" => "Versión 2.0",
"Users can change theme" => "Os usuarios rexistrados poden cambiar de decoración",
"Restrict available themes" => "Restrinxir decoracións dispoñibles",
"Available styles:" => "Estilos dispoñibles:",
"Edit CSS" => "Editar CSS",
"Theme Control" => "Control de decoración",
"Tiki Template Viewing" => "Vista de modelo de Tiki",
"Edit Templates" => "Editar modelos",
"General Layout options" => "Opcións xerais de deseño",
"logged as" => "iniciou a sesión como",
"Alt. description (e.g. for text browsers)" => "Descrición alt. (p. ex. para navegadores de texto)",
"Subtitle" => "Subtítulo",
"Site menu bar" => "Barra de menú do sitio",
"Custom code" => "Código personalizable",
"Left column" => "Columna esquerda",
"always" => "sempre",
"user decides" => "o usuario decide",
"Users can Flip Columns" => "Os usuarios poden cambiar as columnas",
"Right column" => "Columna dereita",
"Site location bar" => "Barra de localización do sitio",
"Larger font for" => "Fonte máis grande para",
"Use page description:" => "Usar descrición de páxina:",
"Bottom bar" => "Barra ao pé",
"Maximum number of records in listings" => "Número máximo de rexistros en listaxes",
"Use direct pagination links" => "Usar ligazóns de paxinación directa",
"Direction" => "Dirección",
"Use Tabs" => "Usar lingüetas",
"Layout per section" => "Deseño por sección",
"Admin layout per section" => "Administrar deseño por sección",
"Favicon icon file name:" => "Nome do ficheiro da icona Favicon:",
"Favicon icon MIME type:" => "Tipo MIME da icona Favicon:",
"image/png" => "imaxe/png",
"image/bmp" => "imaxe/bmp",
"image/x-icon" => "imaxe/x-icon",
"Generate User Map" => "Xerar Mapa do Usuario",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Para engadir/eliminar votacións, busque \"Votacións\" en \"Admin\" no menú de aplicación, ou",
"Waiting" => "Esperando",
"Last update" => "Última actualización",
"Image galleries" => "Galerías de imaxes",
"Feed for forums" => "Fonte para foros",
"Specification" => "Especificación",
"You can see users rank by score in the module users_rank, for that go to" => "Pode ver clasificación de usuarios por puntos no módulo users_rank, para iso vaia a ",
"Admin modules" => "Administrar módulos",
"Expiration" => "Expiración",
"Automonospaced text" => "Texto auto-monoespazado",
"Tables syntax" => "Sintaxe de táboas",
"|| for rows" => "|| para filas",
"AutoLinks" => "Autoligazóns",
"Hotwords" => "Palabras clave",
"rows" => "filas",
"Required" => "Requirido",
"Parameters" => "Parámetros",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Para configurar os seus trackers, busque en \"Administrar trackers\" baixo \"Trackers\" no menú de aplicación, ou",
"Use database to store files" => "Usar a base de datos para gardar ficheiros",
"Use a directory to store files" => "Usar un directorio para almacenar ficheiros",
"dls" => "descargas",
"Storage" => "Almacenamento",
"Change all to db" => "Cambiar todo para a base de datos",
"Change all to file" => "Cambiar todo para ficheiro",
"Quota (Mb)" => "Cota (Mb)",
"Use database to store userfiles" => "Usar a base de datos para almacenar ficheiros de usuario",
"Use a directory to store userfiles" => "Usar un directorio para almacenar ficheiros de usuario",
"Create New" => "Crear nova",
"List authors" => "Listar autores",
"Not Installed" => "Non instalado",
"Warn on edit conflict" => "Advertir en conflitos de edición",
"Undo" => "Desfacer",
"Footnotes" => "Notas ao pé",
"Permission" => "Permiso",
"Allow HTML" => "Permitir HTML",
"Sandbox" => "Caixa de area",
"Dumps" => "Envorcados",
"Generate dump" => "Xerar envorcado",
"Download last dump" => "Descargar último envorcado",
"Pictures" => "Imaxes",
"Remove unused pictures" => "Quitar imaxes non usadas",
"Export" => "Exportar",
"Export Wiki Pages" => "Exportar páxinas wiki",
"Accept dashes and underscores in WikiWords" => "Aceptar guións e subliñado en PalabrasWiki",
"Link plural WikiWords to their singular forms" => "Liga PalabrasWiki en plural coas súas forma en singular",
"Only with last version" => "Só coa última versión",
"Side-by-side diff" => "diferenzas lado a lado",
"Discuss pages on forums" => "Discutir páxinas nos foros",
"Structures" => "Estruturas",
"Open page as structure" => "Abrir páxina como estrutura",
"Import HTML" => "Importar HTML",
"Page creators are admin of their pages" => "Os creadores de páxinas son os seus administradores",
"MultiPrint" => "Multi-impresión",
"Create watch for author on page creation" => "Crear monitor para autor na creación da páxina",
"Enable watch events when I am the editor" => "Activar monitor de eventos cando eu son o editor",
"Enable watches on comments" => "Activar monitores en comentarios",
"Links" => "Ligazóns",
"Wiki 3D Browser Configuration" => "Configuración do navegador wiki 3D",
"Wiki attachments" => "Anexos ao Wiki",
"Change" => "Cambiar",
"Shoutbox Words" => "Palabras do taboleiro de avisos",
"Live Support" => "Asistencia en liña",
"Contact us" => "Contactar con nós",
"Banning" => "Expulsión",
"Mail Notifications" => "Notificacións por correo",
"Cookies" => "Cuquis",
"Search Stats" => "Estatísticas de busca",
"Statistics" => "Estatísticas",
"Weeks" => "Semanas",
"Setting" => "Valor",
"viewed" => "visto",
"Add or edit a rule" => "Engadir ou editar regra",
"Rule title" => "Título da regra",
"Username regex matching" => "Nomes de usuario emparellando con expresión regular",
"IP regex matching" => "IP emparellando expresión regular",
"Banned from sections" => "Expulsado das seccións",
"Rule activated by dates" => "Activación de regras por datas",
"Rule active from" => "Regra activa desde",
"Rule active until" => "Regra activa ata",
"Custom message to the user" => "Mensaxe personalizada para o usuario",
"Rules" => "Regras",
"User/IP" => "Usuario/IP",
"Sections" => "Seccións",
"Admin Calendars" => "Administrar calendarios",
"List of Calendars" => "Lista de Calendarios",
"Loc" => "Loc.",
"Participants" => "Participantes",
"Lang" => "Lingua",
"Prio" => "Prio ",
"Subscription" => "Subscrición",
"Custom Locations" => "Localizacións personalizadas",
"Custom Participants" => "Participantes personalizables ",
"Custom Categories" => "Categorías personalizadas",
"Custom Languages" => "Linguas personalizadas",
"Custom Subscription List" => "Listaxe de subcricion personalizable",
"Custom Priorities" => "Prioridades personalizadas",
"Personal Calendar" => "Calendario persoal",
"Red" => "Vermello",
"Current category" => "Categoría actual",
"Child categories" => "Subcategorías",
"Edit permissions for this category" => "Editar permisos para esta categoría",
"Edit this category:" => "Editar esta categoría:",
"Add new category" => "Engadir nova categoría",
"Objects in category" => "Obxectos na categoría",
"No records found." => "Non se atoparon rexistros",
"Add objects to category" => "Engadir obxectos á categoría",
"Admin templates" => "Administrar modelos",
"Edit this template:" => "Editar este modelo:",
"Create new template" => "Crear novo modelo",
"Use wysiwyg editor" => "Usar editor wysiwyg",
"Use normal editor" => "Usar editor normal",
"HTML Pages" => "Páxinas HTML",
"Templates" => "Modelos",
"Admin cookies" => "Administrar cuquis",
"Create/edit cookies" => "Crear ou editar cuquis",
"Upload Cookies from textfile" => "Cargar cuquis desde un ficheiro de texto",
"Upload from disk:" => "Cargar desde o disco:",
"Upload" => "Cargar",
"Remove all cookies" => "Borrar todas as cuquis",
"cookie" => "Cuqui",
"Admin dsn" => "Administrar dsn",
"Create/edit dsn" => "Crear/editar dsn",
"Admin external wikis" => "Administrar wikis externos",
"View template" => "Ver modelo",
"tiki admin external wikis template" => "modelo de administrar wikis externos ",
"Edit template" => "Editar modelo",
"Create/Edit External Wiki" => "Crear/Editar Wiki externo",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (usa \$page para ser substituído polo nome de páxina na URL exemplo: http://www.exemplo.com/tiki-index.php?page=\$page)",
"ExtWiki" => "Wikiext",
"Admin Forums" => "Administrar foros",
"Create new forum" => "Crear novo foro",
"List forums" => "Listar foros",
"Age" => "Idade",
"PPD" => "Ppd",
"Edit this Forum:" => "Editar este foro:",
"Create New Forum" => "Crear novo foro",
"There are individual permissions set for this forum" => "Existen permisos individuais definidos para este foro",
"Name:" => "Nome:",
"Create new" => "Crear novo",
"Password protected" => "Protexido por contrasinal",
"Forum password" => "Contrasinal de foro",
"Topic list configuration" => "Configuración da listaxe de temas",
"Posts can be rated" => "Os artigos poden ser cualificados",
"Display last post titles" => "Mostra os últimos títulos de enviados",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Reenviar mensaxes deste foro a este enderezo de correo-e, nun formato que poida ser usado para enviar mensaxes de volta ao enderezo de correo entrante do foro",
"Send mails even when the post is generated by inbound mail" => "Enviar correos mesmo cando o envío é xerado por unha mensaxe entrante",
"Append a reply link to outbound mails" => "Agregar unha ligazón de resposta ás mensaxes saíntes",
"Originating e-mail address for mails from this forum" => "Enderezo orixe de correo-e para correos deste foro",
"Add messages from this email to the forum" => "Engadir as mensaxes desde este correo-e ao foro",
"Use topic smileys" => "Usar emoticonas do tema",
"Show topic summary" => "Mostrar sumario do tema",
"User information display" => "Mostrar información do usuario",
"Online" => "En liña",
"Approval type" => "Tipo de aprobación",
"Store attachments in:" => "Gardar anexos en:",
"Admin Hotwords" => "Administrar palabras clave",
"Add Hotword" => "Engadir palabra clave",
"Word" => "Palabra",
"Admin HTML pages" => "Administrar páxinas HTML",
"Edit this page" => "Editar esta páxina",
"View page" => "Ver páxina",
"Edit zone" => "Editar sección",
"Dynamic zones" => "Zonas dinámicas",
"zone" => "zona",
"content" => "contido",
"Mass update" => "Actualización masiva",
"Create new HTML page" => "Crear nova páxina HTML",
"Edit this HTML page:" => "Editar esta páxina HTML:",
"Apply template" => "Aplicar modelo",
"Dynamic" => "Dinámica",
"Static" => "Estática",
"Last Modif" => "última modificación",
"Edit Repository:" => "Editar almacén:",
"Create New Repository" => "Crear novo almacén",
"List Repositories" => "Listar almacéns",
"New Repository" => "Novo almacén",
"View Repository" => "Ver almacén",
"Human readable repository name" => "Nome do almacén en formato lexible",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Camiño ao almacén (sistema de ficheiros local: relativo/absoluto respecto a raíz de web, remoto: prefixado con 'http://')",
"File name of start page" => "Ficheiro da páxina inicial",
"Start page" => "Páxina de inicio",
"CSS file to load when browse this repository" => "Ficheiro CSS para cargar cando se navegue por este almacén",
"CSS file" => "Ficheiro CSS",
"Is repository visible to users" => "É o almacén visible para os usuarios",
"Can files from repository be cached" => "Os ficheiros do repositorio poden ser almacenados na caché",
"Are files from repository can be cached" => "Os ficheiros do almacén poden ser almacenados na caché",
"Clear all cached pages of this repository" => "Borrar todas as páxinas cacheadas deste almacén",
"Clear cache" => "Borrar caché",
"Seconds count 'till cached page will be expired" => "Conta de segundos ata que expire a páxina almacenada na caché",
"Cache expiration" => "Expiración de caché",
"Human readable text description of repository" => "Descrición lexible do almacén",
"Available Repositories" => "Almacéns dispoñibles ",
"CSS File" => "Ficheiro CSS",
"Edit rules" => "Editar regras",
"Edit Rules for Repository:" => "Editar regras para o almacén:",
"Configure Repositories" => "Configurar almacéns",
"Configure this Repository" => "Configurar este almacén",
"View this Repository" => "Ver este almacén",
"New Rule" => "Nova regra",
"Copy Rules" => "Copiar regras",
"view/hide copy rules dialog" => "ver/ocultar diálogo de copia de regras",
"Source repository" => "Almacén de orixe",
"Copy" => "Copiar",
"According this order rules will be applied ('0' or empty = auto)" => "Segundo esta orde as regras serán aplicadas ('0' ou baleiro= auto)",
"Rule order" => "Orde de regras",
"Text to search for" => "Texto para buscar",
"Text to replace" => "Texto para substituír",
"Is this regular expression or simple search/replacer" => "É esta unha expresión regular ou unha simple busca/substitución",
"Regex" => "Expresión regular",
"Is case sensitive (for simple replacer)" => "É sensible a maiúsc/minúsc (para substitución simple)",
"Case sensitive" => "Maiúsc/Minúsc",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "subconxunto de caracteres: imsxeADSXUu, que son modificadores de expresión regular",
"Regex modifiers" => "Modificadores de expresión regular",
"Human readable text description of rule" => "Descrición lexible da regra",
"Check to enable this rule" => "Seleccione para habilitar esta regra",
"Enabled" => "Activado",
"Preview options" => "Opcións de previsualización",
"Apply all rules or just this to generate preview" => "Aplicar todas as regras ou só esta para xerar a previsualización",
"Apply all rules" => "Aplicar todas as regras",
"View source code after rules applied" => "Ver código fonte despois de que as regras sexan aplicadas",
"Code preview" => "Vista previa de Código",
"Generate HTML preview" => "Xerar vista previa HTML",
"HTML preview" => "vista previa HTML",
"Test file from repository to generate preview for (empty = configured start page)" => "Ficheiro de proba do almacén para o cal xerar vista previa (baleiro = páxina inicial configurada)",
"Preview Results" => "Resultados da vista previa",
"Rules List" => "Lista de regras",
"Case" => "Maiúsc./Minúsc.",
"Configure/Options" => "Configurar/Opcións",
"Admin layout" => "Administrar deseño",
"Theme control" => "Control de decoración",
"layout options" => "opcións de deseño",
"Top bar" => "Barra de encabezado",
"Generate positions by hits" => "Ordenar automaticamente por accesos",
"List of featured links" => "Lista de ligazóns destacadas",
"Position" => "Posición",
"Add Featured Link" => "Engadir unha ligazón destacada",
"Edit this Featured Link:" => "Editar esta ligazón destacada:",
"Create new Featured Link" => "Crear unha nova ligazón destacada",
"disables the link" => "deshabilita a ligazón",
"Link type" => "Tipo de ligazón",
"replace current page" => "substituír a páxina actual",
"framed" => "nun marco",
"open new window" => "abrir nova fiestra",
"Mail-in accounts" => "Contas de entrada de correo",
"Account" => "Conta",
"Add new Mail-in account" => "Engada unha nova conta de entrada de correo",
"Edit Mail-in account" => "Editar conta de entrada de correo",
"Account name" => "Nome de conta",
"POP server" => "Servidor POP",
"SMTP server" => "Servidor SMTP",
"SMTP requires authentication" => "SMTP require autenticación",
"article-put" => "poñer-artigo",
"wiki-get" => "recibir-wiki",
"wiki-put" => "poñer-wiki",
"wiki-append" => "concatenar-wiki",
"Article Topic" => "Tema do artigo",
"Admin Topics" => "Administrar temas",
"Article Type" => "Tipo de artigo",
"Admin Types" => "Administrar tipos",
"Active" => "Activo",
"Allow anonymous acces" => "Permitir usuarios anónimos",
"Allow attachments" => "Permitir archivos anexos",
"Discard to the end from" => "Descartar ata a fin desde",
"Check Mail-in accounts" => "Comprobar contas de correo entrante",
"Check automatically" => "Comprobar automaticamente",
"Frequency" => "Frecuencia",
"List menus" => "Listar menús",
"Edit this menu" => "Editar menú",
"Edit menu options" => "Editar opcións do menú",
"Show Quick Urls" => "Mostrar asURL rápidas",
"Some useful URLs" => "Algunhas URL útiles",
"Hide Quick Urls" => "Ocultar as URL Rápidas",
"option" => "opción",
"separator" => "separador",
"Choose" => "Elixir",
"Home Blog" => "Blog de inicio",
"Home Image Gal" => "Gal de imaxes ppal",
"Home Image Gallery" => "Galería de imaxes principal",
"Home File Gal" => "Gal de ficheiros ppal",
"Home File Gallery" => "Galería de ficheiros principal",
"User preferences" => "Preferencias do usuario",
"User prefs" => "Prefs do usuario",
"List galleries" => "Listar galerías",
"List image galleries" => "Listar galerías de imaxes",
"Upload image" => "Cargar imaxe",
"Gallery Rankings" => "Clasificacións de galerías",
"Browse a gallery" => "Navegar por unha galería",
"Articles home" => "Inicio de artigos",
"All articles" => "Todos os artigos",
"Submit" => "Enviar",
"List Blogs" => "Listar Blogs",
"Create blog" => "Crear blog",
"View a forum" => "Ver un foro",
"View a thread" => "Ver un fío",
"View a FAQ" => "Ver un PMF",
"Take a quiz" => "Cubrir o cuestionario",
"Quiz stats" => "Estatísticas de cuestionario",
"Stats for a Quiz" => "Estatísticas do cuestionario",
"Preview menu" => "Previsualizar o menú",
"Menu options" => "Opcións de menú",
"Options" => "Opcións",
"Active Permissions" => "Activar permisos",
"Edit this Menu:" => "Editar este menú:",
"Create new Menu" => "Crear novo menú",
"dynamic collapsed" => "dinámico colapsado",
"dynamic extended" => "dinámico expandido",
"fixed" => "estático",
"Clear Cache" => "Limpar caché",
"Assigned Modules" => "Módulos asignados",
"Left Modules" => "Módulos esquerda",
"Move to Right Column" => "Mover á columna dereita",
"Right Modules" => "Módulos da dereita",
"Move to Left Column" => "Mover á columna esquerda",
"Assign new module" => "Asignar novo módulo",
"Edit this assigned module:" => "Editar o módulo asignado:",
"Cache Time" => "Tempo en caché",
"Visibility" => "Visibilidade",
"Displayed now for all eligible users even with personal assigned modules" => "Mostrando agora para todos os usuarios elixibles mesmo con módulos persoais asignados",
"Displayed for the eligible users with no personal assigned modules" => "Mostrado para os usuarios elixibles sen módulos persoais asignados",
"Displayed now, can't be unassigned" => "Mostrado agora, non pode estar desasignado",
"Not displayed until a user chooses it" => "Non mostrado ata que o usuario o elixe",
"User Modules" => "Módulos de usuario",
"Create new user module" => "Crear novo módulo de usuario",
"Edit this user module:" => "Editar este módulo de usuario:",
"Must be wiki parsed" => "Debe ser procesado por wiki",
"Objects that can be included" => "Obxectos que poden incluírse",
"Random active poll" => "Votación activa ao chou",
"Random current poll" => "Votación actual ao chou",
"Use Poll" => "Usar votación",
"Use Gallery" => "Usar galería",
"Use RSS Module" => "Usar módulo RSS",
"Use Menu" => "Usar menú",
"Use phplayermenu" => "Usar menú phplayer",
"Use Banner Zone" => "Usar zona de pancartas",
"Structures:" => "Estruturas:",
"Admin newsletter subscriptions" => "Administrar suscricións ao boletín",
"List Newsletters" => "Listar boletíns",
"Admin Newsletters" => "Administrar boletíns",
"Send Newsletters" => "Enviar boletíns",
"Add a subscription newsletters" => "Engadir unha subscrición a boletíns",
"Email:" => "Correo:",
"Add email:" => "Engadir correo:",
"Add user:" => "Engadir usuario:",
"Group subscription also subscribes included groups" => "Subscrición de grupo tamén subscribe grupos incluídos",
"Don't send confirmation mail" => "Non enviar correo de confirmación",
"The user email will be refreshed at each newsletter sending" => "O correo de usuario será actualizado en cada envío de boletín",
"Subscribe group" => "Subscribir grupo",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Usuarios e correos-e de grupos e grupos incluídos serán actualizados en cada envío de boletín",
"Subscriptions" => "Suscricións",
"Valid" => "Válido",
"Subscribed" => "subscrito",
"Admin newsletters" => "Administrar boletíns",
"Editions" => "Edicións",
"Last Sent" => "última enviada",
"Create/Edit Newsletters" => "Crear/editar boletíns",
"There are individual permissions set for this newsletter" => "Existen permisos individuais para este boletín",
"Users can subscribe/unsubscribe to this list" => "Os usuarios poden subscribirse/cancelas a subscrición nesta lista",
"Users can subscribe any email address" => "Os usuarios poden subscribir calquera enderezo de correo-e",
"Add unsubscribe instructions to each newsletter" => "Engadir instrucións de cancelar a subscrición a cada boletín",
"Validate email addresses" => "Validar enderezo de correo-e",
"Add notification" => "Engadir notificación",
"Event" => "Evento",
"edit" => "editar",
"remove" => "eliminar",
"Update" => "Actualizar",
"List polls" => "Listar votacións",
"Edit this poll" => "Editar esta votación",
"Preview poll" => "Previsualizar votación",
"Poll options" => "Opcións de votación",
"Votes" => "Votos",
"Admin Polls" => "Administrar votacións",
"Set last poll as current" => "Poñer a última votación como actual",
"Close all polls but last" => "Pechar todas as votacións agás a última",
"Activate all polls" => "Activar todas as votacións",
"active" => "activo",
"current" => "actual",
"object" => "obxecto",
"PublishDate" => "Data de publicación",
"Results" => "Resultados",
"Wiki pages" => "páxinas wiki",
"Content for the feed" => "Contido da fonte",
"Security Admin" => "Administrar seguridade",
"PHP settings" => "Configuración de PHP",
"Risk Factor" => "Factor de risco",
"Explanation" => "Explicación",
"Check all tiki files" => "Comprobar todos os ficheiros tiki",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Teña en conta que isto pode demorar moito tempo. Debería comprobar a súa configuración de max_execution_time en php.ini.",
"File checks" => "Comprobación de ficheiros",
"user" => "usuario",
"group" => "grupo",
"sticky" => "persistente",
"Admin Shoutbox Words" => "Administrar palabras do taboleiro de anuncios",
"Add Banned Word" => "Agregar palabra prohibida",
"Are you sure you want to delete this word?" => "Está seguro de que quere borrar esta palabra?",
"Destroy the structure leaving the wiki pages" => "Destruír a estrutura deixando as páxinas wiki",
"Destroy the structure and remove the pages" => "Destruír a estrutura e borrar as páxinas",
"Export Pages" => "Exportar páxinas",
"Dump Tree" => "Envorcar árbore",
"Create WebHelp" => "Crear AxudaWeb",
"View WebHelp" => "Ver axuda web",
"Create new structure" => "Crear nova estrutura",
"Alias" => "Alcume",
"Tree" => "árbore",
"Use single spaces to indent structure levels" => "Usar espazos simples para sangrar niveis de estrutura",
"Create New Structure" => "Crear nova estrutura",
"List surveys" => "Listar enquisas",
"Survey Stats" => "Estatísticas da enquisa",
"Edit this Survey" => "Editar enquisa",
"Admin Surveys" => "Administrar enquisas",
"Question" => "Pregunta",
"One choice" => "Unha opción",
"Multiple choices" => "Múltiples opcións",
"Short text" => "Texto breve",
"Rate (1..5)" => "Cualificar (1..5)",
"Rate (1..10)" => "Cualificar (1..10)",
"Rate" => "Cualificación",
"Options (if apply)" => "Opcións (se for o caso)",
"Questions" => "Preguntas",
"Admin surveys" => "Administrar enquisas",
"List Surveys" => "Listar enquisas",
"Edit this Survey:" => "Editar esta enquisa:",
"Create New Survey" => "Crear nova enquisa",
"There are individual permissions set for this survey" => "Existen permisos individuais establecidos para esta enquisa",
"Open" => "Aberto",
"Empty" => "Baleiro",
"Fix UTF-8 Errors in Tables" => "Arranxar erros UTF-8 en táboas",
"Warning: Make a backup of your Database before using this function!" => "Atención: faga unha copia de seguridade da súa base de datos antes de usar esta función!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Atención: se tenta converter grandes táboas, aumente o tempo máximo de execución no php.ini!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Esta función converte textos codificados en ISO-8859-1 nas súas táboas a UTF-8",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Isto pode ser necesario se creou contido con tiki &lt; 1.8.4 e opción Default Charset de apache en ISO-8859-1",
"UTF-8 Errors fixed" => "Erros UTF-8 arranxados",
"Investigate" => "Investigar",
"Fix it" => "Arranxar",
"Create a new topic" => "Crear novo tema",
"Topic Name" => "Nome do tema",
"Upload Image" => "Cargar imaxe",
"List of topics" => "Lista de temas",
"Articles (subs)" => "Artigos (colaboracións)",
"topic image" => "imaxe do tópico",
"Deactivate" => "Desactivar",
"Remove with articles" => "Borrar con artigos",
"List Trackers" => "Listar trackers",
"Admin Trackers" => "Administrar os trackers",
"Edit This Tracker" => "Editar tracker ",
"View This Tracker's Items" => "Ver elementos do tracker",
"Tracker fields" => "Campos de tracker",
"Mandatory" => "Obrigatorio",
"Is column visible when listing tracker items?" => "Está visible a columna cando se listan ítems do tracker?",
"Tbl vis" => "visible en listaxes",
"Column links to edit/view item?" => "Ligazóns na columna para editar/ver o ítem?",
"isMain" => "é principal",
"Searchable" => "incluír o campo nas buscas",
"Hidden" => "Oculto",
"Edit tracker field" => "Editar campos do tracker",
"Field is mandatory?" => "O campo é obrigatorio?",
"Column is searchable?" => "A columna é localizable?",
"Import/Export Trackers Fields" => "Importar/exportar campos de trackers ",
"Found" => "Encontrado",
"Edit Tracker" => "Editar tracker",
"There are individual permissions set for this tracker" => "Hai permisos individuais configurados para este tracker",
"No individual permissions. Global permissions apply." => "Non hai permisos individuais, aplican os permisos globais",
"Show status" => "Mostrar estado",
"Default status displayed in list mode" => "Estado por defecto mostrado en modalidade de lista",
"Show status to tracker admin only" => "Mostrar estado só ao administrador do tracker",
"Send copies of all activity in this tracker to this e-mail address" => "Enviar copias de toda actividade neste tracker a este enderezo de correo",
"Use simplified e-mail format" => "Usar formato simplificado de correo",
"New items are created with status" => "Os novos ítems son creados con estado",
"Authoritative status for modified items" => "Estado autorizativo para os ítems modificados",
"No change" => "Sen cambios",
"Item creator can modify his items?" => "O creador do ítem pode modificar os seus ítems?",
"The tracker needs a user field with the option 1" => "O tracker precisa un campo para o usuario coa opción 1",
"The tracker needs a group field with the option 1" => "O tracker precisa un campo para o grupo coa opción 1",
"Show creation date when listing tracker items?" => "Mostrar a data de creación cando se listan ítems do tracker?",
"Show lastModif date when listing tracker items?" => "Mostrar a data da última modificación cando se listan ítems do tracker?",
"What field is used for default sort?" => "Que campo se usa para a ordenación por defecto?",
"What is default sort order in list?" => "Cal é a orde por defecto para a listaxe?",
"ascending" => "ascendente",
"descending" => "descendente",
"Tracker items allow ratings?" => "Os ítems do tracker permiten cualificacións?",
"with values" => "con valores",
"and display rating results in listing?" => "e mostrar o resultado das cualificacións na listaxe?",
"Tracker items allow comments?" => "Os ítems do tracker permiten comentarios?",
"and display comments in listing?" => "e mostrar os comentarios na listaxe?",
"Tracker items allow attachments?" => "Os ítems do tracker permiten anexos?",
"and display attachments in listing?" => "e mostrar os anexos na listaxe?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Opcións para mostrar os anexos (Use números para ordenar os ítems, 0 non se mostrará, e os números negativos mostraranse en emerxentes)",
"Filesize" => "Tamaño do ficheiro",
"Filetype" => "Tipo de ficheiro",
"LongDesc" => "Descrición longa",
"Import/Export" => "Importar/exportar",
"Import/export trackers" => "Importar/exportar trackers",
"Admin groups" => "Administrar grupos",
"Admin users" => "Administrar usuarios",
"Add new group" => "Engadir novo grupo",
"List of existing groups" => "Lista de grupos existentes",
"Edit group" => "Editar grupo",
"Add a New Group" => "Engadir novo grupo",
"Use wiki page name or full URL" => "Utilice o nome da páxina wiki ou o URL completo",
"Group Information Tracker" => "Tracker de información do grupo",
"choose a group tracker ..." => "elixa un tracker de grupo ...",
"choose a field ..." => "elixa un campo ...",
"Users Information Tracker" => "Tracker de información dos usuarios",
"choose a users tracker ..." => "elixa un tracker de usuarios ...",
"Group tracker item : {\$groupitemid}" => "Ítem de tracker de grupo : {\$groupitemid}",
"Edit Item" => "Editar ítem",
"Group tracker item not found" => "Ítem de tracker de grupo non atopado",
"Members" => "Membros",
"users in group" => "usuarios no grupo",
"CSV File" => "Ficheiro CSV",
"Add a New User" => "Engadir un novo usuario",
"Reason" => "Razón",
"Registered" => "Rexistrado",
"to groups" => "aos grupos",
"Manage Group Assignments" => "Xestionar as asignacións de grupo",
"Set Default Groups" => "Poñer grupos por defecto",
"Assign selected to" => "Asignar elixidos a",
"Remove selected from" => "Borrar seleccionado de",
"the following groups:" => "os seguintes grupos:",
"Edit user" => "Editar usuario",
"Generate a password" => "Xerar un contrasinal",
"User tracker item : {\$usersitemid}" => "Ítem do tracker do usuario: {\$usersitemid}",
"Overwrite" => "Sobrescribir",
"Source" => "Fonte",
"Admin Article Types" => "Administrar tipos de artigo",
"List of types" => "Lista de tipos",
"Shows up in the drop down list of article types" => "Móstrase no despregable da lista de tipos de artigo",
"Allow ratings by the author" => "Permite cualificacións polo autor",
"Show before publish date" => "Mostrar antes da data de publicación",
"non-admins can view before the publish date" => "non-administradores poden visualizar antes da data de publicación",
"Show after expire date" => "Mostrar despois da data de expiración",
"non-admins can view after the expire date" => "non-administradores poden visualizar despois da data de expiración",
"Heading only" => "Só encabezado",
"No article body, heading only" => "Sen corpo de artigo, só encabezado",
"Allow comments for this type" => "Permite comentarios para este tipo",
"Comment Can Rate Article" => "Un comentario pode cualificar un artigo",
"Allow comments to include a rating value" => "Permitir que ps  comentarios inclúan un valor de cualificación",
"Show image" => "Mostrar imaxe",
"Show topic or own image" => "Mostrar imaxe do tema ou propia",
"Show avatar" => "Mostrar avatar",
"Show author's avatar" => "Mostrar avatar do autor",
"Show author" => "Mostrar autor",
"Show author name" => "Mostra o nome do autor",
"Show publish date" => "Mostrar data de publicación",
"Show expire date" => "Mostrar data de expiración",
"Show reads" => "Mostrar lecturas",
"Show the number of times the article was read" => "Mostra o número de veces que o artigo foi lido",
"Show size" => "Mostrar tamaño",
"Show the size of the article" => "Mostra o tamaño do artigo",
"Show topline" => "Mostra a liña superior",
"Show a small title over the title" => "Mostra un pequeno título sobre o título",
"Show subtitle" => "Mostra subtítulo",
"Show the subtitle" => "Mostra o subtítulo",
"Show source" => "Mostra fonte",
"Show link to source after article body" => "Mostra a ligazón á fonte despois do corpo do artigo",
"Show Image Caption" => "Mostra o título da imaxe",
"Show a legend under the image" => "Mostra unha lenda debaixo da imaxe",
"Show Language" => "Mostra idioma",
"Show the language" => "Mostra o idioma",
"Creator can edit" => "O creador pode editar",
"The person who submits an article of this type can edit it" => "A persoa que envía un artigo deste tipo pode editalo",
"Show lang" => "Mostrar idioma",
"Review" => "Revisión",
"Classified" => "Clasificado",
"Create a new type" => "Crear un novo tipo",
"Group Information" => "Información do grupo",
"level" => "nivel",
"Create level" => "Crear nivel",
"all permissions in level" => "todos os permisos en nivel",
"backlinks to" => "retroligazóns a",
"No backlinks to this page" => "Non hai retroligazóns a esta páxina",
"Directory batch upload" => "Carga en lote de directorio",
"Browse Gallery" => "Explorar galería",
"Upload From Disk" => "Cargar desde disco",
"available images" => "imaxes dispoñibles",
"Remove File Extension from Image Name" => "Borre a extensión do ficheiro do nome da imaxe",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "exemplo de \"digicam0001.jpg\" o nome digicam0001 usarase para o campo nome",
"Select a Gallery" => "Seleccione unha galería",
"Process" => "Proceso",
"Edit Post" => "Editar artigo",
"View Blog" => "Visualizar blog",
"Use ...page... to separate pages in a multi-page post" => "Use ...páxina... para separar páxinas nunha publicación multi-páxina",
"Body" => "Corpo",
"Upload image for this post" => "Cargar imaxe para este artigo",
"Trash" => "Lixo",
"Mark entry as private:" => "Marcar entrada como privada:",
"Spellcheck" => "Comprobación ortográfica",
"Save and Exit" => "Gardar e saír",
"Powered by" => "Baseado en",
"Made with" => "Feito con",
"powered by" => "baseado en",
"Wiki RSS" => "RSS de Wiki ",
"Blogs RSS" => "RSS de blogs ",
"Articles RSS" => "Artigos RSS",
"Image Galleries RSS" => "Galerías de Imaxes RSS",
"File Galleries RSS" => "Galerías de Ficheiros RSS",
"Forums RSS" => "Foros RSS",
"Maps RSS" => "Mapas RSS",
"Execution time" => "Tempo de execución",
"Memory usage" => "Uso de memoria ",
"Server load" => "Carga do servidor",
"Admin Category" => "Administrar categoría",
"Admin the Category System" => "Administrar o sistema de categorías",
"Browse in" => "Navegar en",
"Sheets" => "Follas de cálculo",
"Hide subcategories objects" => "Ocultar obxectos de subcategorías",
"Show subcategories objects" => "Mostrar obxectos de subcategorías",
"Upper level" => "Nivel superior",
"List Galleries" => "Listar galerías",
"Edit Gallery" => "Editar galería",
"Rebuild Thumbnails" => "Reconstruír miniaturas",
"Directory Batch" => "Carga de directorio",
"List Gallery" => "Listar galería",
"Monitor this Gallery" => "Monitorizar esta galería",
"Stop Monitoring this Gallery" => "Deixar de monitorizar esta galería",
"Sort Images by" => "Ordenar imaxes por",
"subgallery" => "subgalería",
"Subgallery" => "Subgalería",
"Hit" => "Acceso",
"Original Size" => "Tamaño orixinal",
"rotate right" => "rotar á dereita",
"rotate" => "rotar",
"Details" => "Detalles",
"popup" => "emerxente",
"You can include the image in a tiki page using one of these lines" => "Pode incluír a imaxe nunha páxina tiki usando unha destas liñas",
"Return to Gallery" => "Volver á galería",
"Edit Image" => "Editar imaxe",
"First Image" => "Primeira imaxe",
"Prev Image" => "Imaxe previa",
"Smaller" => "Menor",
"Bigger" => "Maior",
"Popup window" => "Fiestra emerxente",
"Next Image" => "Seguinte imaxe ",
"Slideshow Forward" => "Pase diapositivas adiante",
"Last Image" => "última imaxe",
"Click to zoom" => "Premer para agrandar",
"Image Name" => "Nome da imaxe",
"Image Scale" => "Escala da imaxe",
"Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/graos decimais)",
"Longitude (WGS84/decimal degrees)" => "Lonxitude (WGS84/graos decimais)",
"Move image" => "Mover imaxe",
"Stop Monitoring this Page" => "Deixar de monitorizar esta páxina",
"Monitor this Page" => "Monitorizar esta páxina",
"Group Calendars" => "Calendarios de grupo",
"Tentative" => "Tentativa",
"Confirmed" => "Confirmado",
"Cancelled" => "Cancelado",
"Change Focus" => "Cambiar foco",
"Edit Calendar Item" => "Editar ítem de calendario",
"New Calendar Item" => "Novo ítem de calendario",
"Tuesday" => "Martes",
"Wednesday" => "Mércores",
"Thursday" => "Xoves",
"Friday" => "Venres",
"January" => "Xaneiro",
"February" => "Febreiro",
"March" => "Marzo",
"April" => "Abril",
"May" => "Maio",
"June" => "Xuño",
"July" => "Xullo",
"August" => "Agosto",
"September" => "Setembro",
"October" => "Outubro",
"November" => "Novembro",
"December" => "Decembro",
"times" => "veces",
"End" => "Fin",
"Duration" => "Duración",
"Organized by" => "Organizado por",
"Calendar import" => "Importar calendario",
"Calendar has been updated" => "O calendario foi actualizado",
"import" => "importar",
"Change password enforced" => "Cambio de contrasinal forzoso",
"Send a message to us" => "Enviarnos mensaxe",
"Contact us by email" => "Contactarnos por correo",
"Click here to send us an email" => "Prema aquí para enviarnos un correo",
"Contacts" => "Contactos",
"Create/edit contacts" => "Crear/editar contactos",
"First Name" => "Nome",
"Last Name" => "Apelido",
"Nickname" => "Alcume",
"You can browse the generated WebHelp here" => "Pode navegar el AxudaWeb xerado aquí",
"Structure" => "Estutura",
"Top page" => "Páxina principal",
"Add a new site" => "Engadir novo sitio",
"You cannot add sites until Directory Categories are setup." => "Non pode engadir sitios ata que as Categorías de Directorio estean configuradas.",
"Please contact the Site Administrator" => "Por favor contacte co administrador do sitio",
"Site added" => "Sitio engadido",
"Directory Administration" => "Administración de Directorio",
"There are" => "Hai",
"invalid sites" => "sitios incorrectos",
"valid sites" => "sitios válidos",
"Users have visited" => "Os usuarios visitaron",
"sites from the directory" => "sitios desde o directorio",
"Users have searched" => "Os usuarios buscaron",
"times from the directory" => "veces desde o directorio",
"Related" => "Relacionado",
"Sites" => "Sitios",
"Validate" => "Validar",
"Admin directory categories" => "Administrar categorías de directorio",
"Add a directory category" => "Engadir unha categoría de directorio",
"Edit this directory category" => "Editar esta categoría de directorio",
"Children type" => "Tipo de fillos",
"Maximum number of children to show" => "Número máximo de fillos que se van mostrar",
"Editor group" => "Grupo editor",
"cType" => "cTipo",
"allow" => "permitir",
"count" => "conta",
"relate" => "relacionar",
"Mutual" => "Mutuo",
"Admin sites" => "Administrar sitios",
"Is valid" => "é válida",
"New Sites" => "Novos sitios",
"Cool Sites" => "Sitios con máis accesos",
"Add a Site" => "Engadir un sitio",
"any" => "calquera",
"in entire directory" => "en todo o directorio",
"Sort by" => "Ordenar por",
"name (desc)" => "nome (desc)",
"name (asc)" => "nome (asc)",
"hits (desc)" => "accesos(desc)",
"hits (asc)" => "accesos (asc)",
"creation date (desc)" => "data de creación (desc)",
"creation date (asc)" => "data de creación (asc)",
"last updated (desc)" => "última actualización (desc)",
"last updated (asc)" => "última actualización (asc)",
"Added" => "Engadida",
"Last updated" => "Última modificación",
"Total links" => "Total de ligazóns",
"Links to validate" => "Ligazóns para validar",
"Searches performed" => "Buscas feitas",
"Total links visited" => "Total de ligazóns visitadas",
"Directory ranking" => "Clasificación de directorios",
"Search results" => "Resultados da busca",
"Validate sites" => "Validar sitios",
"Edit article" => "Editar artigo",
"List Articles" => "Listar artigos",
"View Articles" => "Visualizar artigos",
"Topline" => "LiñaTope",
"Author Name" => "Nome do autor",
"Own Image" => "Imaxe propia",
"Article image" => "Imaxe do artigo",
"Use own image" => "Usar imaxe propia",
"Float text around image" => "Texto flotante arredor da imaxe",
"Own image size x" => "Imaxe propia tamaño x",
"Own image size y" => "Imaxe propia tamaño y",
"Image caption" => "Lenda da imaxe",
"Publish Date" => "Data de publicación",
"Expiration Date" => "Data de expiración",
"Edit or create banners" => "Editar ou crear pancartas",
"List banners" => "Listar pancartas",
"URL to link the banner" => "URL para ligar a pancarta",
"Client" => "Cliente",
"Max impressions" => "Impresións máximas",
"Show the banner only between these dates" => "Mostrar a pancarta só entre estas datas",
"From date" => "Desde a data",
"To date" => "Ata a data",
"Use dates" => "Usar datas",
"Show the banner only in this hours" => "Mostrar a pancarta só neste horario",
"Show the banner only on" => "Mostrar a pancarta só en",
"Mon" => "L",
"Tue" => "M",
"Wed" => "Mc",
"Thu" => "X",
"Fri" => "V",
"Sat" => "S",
"Sun" => "D",
"Select ONE method for the banner" => "Seleccione UN método para a pancarta",
"Use HTML" => "Usar HTML",
"Use image" => "Usar imaxe",
"Image:" => "Imaxe:",
"Current Image" => "Imaxe actual",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Usar a imaxe xerada polo URL (a imaxe será solicitada ao URL indicado para cada impresión)",
"Use text" => "Usar texto",
"Save the Banner" => "Gardar a pancarta",
"Remove Zones (you lose entered info for the banner)" => "Borrar Zonas (perderá a información introducida para a pancarta)",
"Create Blog" => "Crear Blog",
"Current heading" => "Encabezado actual",
"There are individual permissions set for this blog" => "Hai permisos individuais configurados para este blog",
"Number of posts to show" => "Número de artigos para mostrar",
"Allow other user to post in this blog" => "Permitir a outros usuarios publicar neste blog",
"Allow search" => "Permitir busca",
"Allow comments" => "Permitir comentarios",
"Show user avatar" => "Mostrar avatar de usuario",
"Blog heading" => "Encabezado do blog",
"Edit Style Sheet" => "Editar folla de estilo",
"Style Sheet" => "Folla de estilo",
"choose a stylesheet" => "escolla unha folla de estilo",
"Try" => "Probar",
"Colored text" => "Texto en cores",
"Headings" => "Encabezados",
"Show/Hide" => "Mostrar/Ocultar",
"show/hide heading section. + (shown) or - (hidden) by default" => "mostrar/ocultar sección de encabezados. + (mostrar) ou - (ocultar) por defecto",
"Box content" => "Contido da caixa",
"Dynamic variables" => "Variables dinámicas",
"Inserts an editable variable" => "Insire unha variable editable",
"External links" => "Ligazóns externas",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Para un Wiki externo, use NomeExternoWiki:NomePáxina ou ((Nome Externo Wiki: Nome Páxina))",
"Square Brackets" => "Corchetes",
"Use [[foo] to show [foo]." => "Usar [[foo] para mostrar [foo].",
"Wiki References" => "Referencias Wiki",
"JoinCapitalizedWords or use" => "XuntarPalabrasEnMaiúsculas ou usar",
"page|description" => "páxina|desc",
"for wiki references" => "para referencias no wiki",
"SomeName" => "AlgúnNome",
"prevents referencing" => "impide facer referencia",
"Lists" => "Listas",
"for bullet lists" => "para listas de viñetas",
"for numbered lists" => "para listas numeradas",
"for definiton lists" => "para listas de definicións",
"Tables" => "Táboas",
"Title bar" => "Barra de título",
"Multi-page pages" => "Páxinas multi-páxina",
"Non parsed sections" => "Seccións non procesadas",
"Prevents wiki parsing of the enclosed data." => "Prevén o procesamento wiki dos datos encerrados.",
"Preformated sections" => "Sección preformatadas",
"Block Preformatting" => "Preformato de bloque",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Sangra texto cun número de espazos para convertelo nun bloque monoespazado que segue outras instrucións de formato de Wiki. Será sangrado co mesmo número de espazos que utilizou. Teña en conta que este modo non preserva o espazado exacto e os saltos de liña, use ~pp~...~/pp~ para iso.",
"No description available" => "Sen descrición dispoñible",
"Browse Images" => "Ver imaxe",
"Edit successful!" => "Editado con éxito!",
"The following image was successfully edited" => "A seguinte imaxe foi editada con éxito",
"Image Description" => "Descrición",
"You can view this image in your browser using" => "Pode visualizar esta imaxe no seu navegador usando",
"You can include the image in an HTML page using one of these lines" => "Pode incluír a imaxe nunha páxina HTML usando unha destas liñas",
"Edit or ex/import Languages" => "Editar ou exportar/importar linguas",
"Edit and create Languages" => "Editar e crear linguas",
"Edit and create languages" => "Editar e crear linguas",
"Create Language" => "Crear lingua",
"Shortname" => "Nome curto",
"like" => "como",
"Longname" => "Nome longo",
"Select the language to edit" => "Elixa lingua para editar",
"Add a translation" => "Engadir unha tradución",
"Edit translations" => "Editar traducións",
"Translate recorded" => "Tradución gravada",
"Translation" => "Tradución",
"reset table" => "reiniciar táboa",
"Create New Block" => "Crear novo bloque",
"Return to block listing" => "Volver á lista de bloques",
"Block description: " => "Descrición do bloque: ",
"You are editing block:" => "Está editando o bloque:",
"Publishing date" => "Data de publicación",
"Publishing Date" => "Data de Publicación",
"Edit question options" => "Editar opcións de pregunta",
"List Quizzes" => "Listar cuestionarios",
"Quiz Stats" => "Estatísticas de cuestionarios",
"This Quiz Stats" => "Estatísticas deste cuestionario",
"Edit this Quiz" => "Editar este cuestionario",
"Admin Quizzes" => "Administrar cuestionarios",
"Create/edit options for question" => "Crear/editar opcións para unha pregunta",
"Option" => "Opción",
"points" => "puntos",
"Quiz" => "Cuestionario",
"canRepeat" => "podeRepetir",
"timeLimit" => "tempoLímite",
"Create/edit quizzes" => "Crear/editar cuestionarios",
"There are individual permissions set for this quiz" => "Existen permisos individuais para este cuestionario",
"Quiz can be repeated" => "O cuestionario pode repetirse",
"Store quiz results" => "Almacena resultados deste cuestionario",
"Immediate feedback" => "Retroalimentación inmediata",
"Show correct answers" => "Mostrar respostas correctas",
"Shuffle questions" => "Remexer preguntas",
"Shuffle answers" => "Remexer respostas",
"Quiz is time limited" => "O cuestionario ten un tempo límite",
"Maximum time" => "Tempo máximo",
"Passing Percentage" => "Porcentaxe de realización",
"Edit quiz questions" => "Editar preguntas do cuestionario",
"Create/edit questions for quiz" => "Crear/editar preguntas para un cuestionario",
"Question Type" => "Tipo de pregunta",
"Import questions from text" => "Importar preguntas desde o texto",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instrucións: Escriba ou pegue as súas preguntas de múltiple opción debaixo. Unha liña para a pregunta, logo comezan as opcións de resposta nas liñas subsecuentes. Separe as preguntas adicionais con liñas en branco. Indique as respostas correctas iniciándoas cun carácter \"*\" (sen as comiñas).",
"Input" => "Entrada",
"maxScore" => "Puntuación máxima",
"From Points" => "Desde puntos",
"To Points" => "Ata puntos",
"Answer" => "Resposta",
"Modify Structure" => "Modificar estrutura",
"You will remove" => "Vostede vai borrar",
"and its subpages from the structure, now you have two options:" => "e as súas subpáxinas da estrutura, agora ten dúas opcións:",
"Remove only from structure" => "Borrar só da estrutura",
"Remove from structure and remove page too" => "Borrar da estrutura e borrar tamén a páxina",
"Structure Layout" => "Deseño da estrutura",
"Promote" => "Promover",
"Demote" => "Degradar",
"Previous" => "Previo",
"Current Node" => "Nodo actual",
"Page alias" => "Alcume de páxina",
"Add pages to current node" => "Engadir páxinas a nodo actual",
"After page" => "Despois da páxina",
"Create Page" => "Crear páxina",
"Use pre-existing page" => "Use a páxina preexistente",
"Submit article" => "Enviar artigo",
"List Submissions" => "Listar colaboracións",
"<b>*</b>=optional" => "<b>*</b>=opcional",
"<b>Topline</b>=small line above Title" => "<b>Liña superior</b>=pequena liña sobre o título",
"<b>Subtitle</b>=small line below Title" => "<b>Subtítulo</b>=pequena liña debaixo do título",
"<b>Source</b>=URL to article source" => "<b>Orixe</b>=URL do artigo fonte",
"Edit templates" => "Editar modelos",
"Template listing" => "Lista de modelos",
"Available templates" => "Modelos dispoñibles",
"Edit a topic" => "Editar tema",
"You must specify the object language" => "Debe especificar a lingua do obxecto",
"The object doesn't exist" => "O obxecto non existe",
"The object doesn't have a language" => "O obxecto non ten unha lingua",
"The object has already a translation for this language" => "O obxecto xa ten unha tradución para esta lingua",
"The object is already in the set of translations" => "O obxecto xa está no conxunto de traducións",
"detach" => "separar",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "A Caixa de Area é unha páxina onde pode practicar as súas habilidades de edición; use a vista previa para ver a aparencia da páxina; non se gardarán versións desta páxina.",
"Upload picture" => "Cargar imaxe",
"Admin Content Templates" => "Administrar modelos de contido",
"Try to convert HTML to wiki" => "Intentar converter HTML a wiki",
"Import page" => "Importar páxina",
"export all versions" => "exportar todas as versións",
"Year:" => "Ano:",
"Authors:" => "Autores:",
"Manage structures" => "Manexar estruturas",
"License" => "Licenza",
"Important" => "Importante",
"Use rating" => "Usar cualificacións ",
"There is no available poll template." => "Non hai un modelo dispoñible de votación.",
"You should ask an admin to create them." => "Debe pedirlle ao administrador que as cree.",
"an existing poll" => "votación existente",
"votes" => "votos",
"status" => "estado",
"lastModif" => "última modificación",
"Admin FAQ" => "Administrar PMF",
"List FAQs" => "Listar PMF",
"View FAQ" => "Ver PMF",
"Edit this FAQ" => "Editar esta PMF",
"New Question" => "Nova pregunta",
"Use a question from another FAQ" => "Usar unha pregunta doutro PMF",
"FAQ questions" => "Preguntas frecuentes",
"Suggested questions" => "Preguntas suxeridas",
"No suggested questions" => "Non hai preguntas suxeridas",
"Upload File" => "Cargar ficheiro",
"View tpl" => "Ver modelo",
"File Galleries tpl" => "Modelo de galerías de ficheiros",
"You can access the file gallery using the following URL" => "Pode acceder á galería usando este URL",
"Admin forums" => "Administrar foros",
"Edit queued message" => "Editar mensaxes en cola",
"make this a thread of" => "transformar isto nun fío de discusión de",
"None, this is a thread message" => "Ningún, esta é unha mensaxe dun fío de discusión",
"summary" => "sumario",
"announce" => "anuncio",
"hot" => "quente",
"no feeling" => "sen emoción",
"frown" => "cello",
"exclaim" => "exclamar",
"question" => "pregunta",
"happy" => "contento",
"wink" => "chisco de ollo",
"Save and Approve" => "Garde e aprobe",
"convert to topic" => "converter a tema",
"List of messages" => "Lista de mensaxes",
"New Topic" => "Novo tema",
"no summary" => "sen sumario",
"No messages queued yet" => "Sen mensaxes aínda na cola",
"Last Post" => "último artigo",
"Configure Forum" => "Configurar foro",
"Reported by" => "Notificado por",
"Pending requests" => "Solicitudes pendentes",
"Request Time" => "Hora da solicitude",
"Accept" => "Aceptado",
"Refuse" => "Rexeitar",
"Waiting requests" => "Solicitudes en espera",
"Your friends" => "Os seus amigos",
"break friendship" => "romper amizade",
"Galleries" => "Galerías",
"Create New Gallery" => "Crear nova galería",
"Create a gallery" => "Crear unha galería",
"Edit this gallery:" => "Editar esta galería:",
"There are individual permissions set for this gallery" => "Hai permisos individuais configurados para esta galería",
"Gallery is visible to non-admin users?" => "Galería visible para usuarios non-administradores?",
"Geographic" => "xeográfico",
"Fields to show during browsing the gallery" => "Campos para mostrar mentres se percorre a galería",
"Creation Date" => "Data de creación",
"XY-Size" => "Tamaño-XY ",
"Gallery Image" => "Imaxe de galería",
"Available scales" => "Escalas dispoñibles",
"Bounding box" => "Caixa delimitadora",
"default scale" => "escala por defecto",
"No scales available" => "Non hai escalas dispoñibles",
"Original image is default scale" => "A imaxe orixinal é a escala por defecto",
"Add scaled images with bounding box of square size" => "Agregar as imaxes escaladas con caixas delimitadoras de tamaño cadrado",
"Other users can upload images to this gallery" => "Outros usuarios poden cargar imaxes nesta galería",
"You can access the gallery using the following URL" => "Pode acceder á galería usando o seguinte URL",
"Available Galleries" => "Galerías dispoñibles",
"Choose a filter" => "Escolla un filtro",
"Imgs" => "Imxs.",
"Make Map" => "Facer mapa",
"To" => "Para",
"Im- Export languages" => "Importar ou Exportar linguas",
"Select the language to Import" => "Elixa a lingua para importar",
"Select the language to Export" => "Elixa a lingua para exportar",
"Import From File" => "Importar desde ficheiro",
"Grab Wiki Tables" => "Obter táboas Wiki",
"Import pages from a Structured Text Dump" => "Importar páxinas desde Envorcado de Texto Estruturado",
"Name of the dump file (it has to be in dump/)" => "Nome do ficheiro de envorcado(ten que estar en dump/)",
"Overwrite existing pages if the name is the same" => "Sobrescribir páxinas se o nome coincide",
"Previously remove existing page versions" => "Borrar versións existentes previamente de páxinas ",
"excerpt" => "extracto",
"Result" => "Resultado",
"body" => "corpo",
"Locked" => "Bloqueado",
"Install" => "Instalar",
"Configure General Settings" => "Configuracións xerais",
"Documentation" => "Documentación",
"Clear cached version and refresh cache" => "Limpar versión en caché e actualizar",
"configure rules" => "configurar regras",
"Edit Repository" => "Editar almacén",
"Last Changes" => "Últimas modificacións",
"Search by Date" => "Buscar por data",
"LastChanges" => "ÚltimosCambios",
"Rollback" => "Reverter",
"Pages like" => "Páxinas similares",
"No pages found" => "Non se encontraron páxinas",
"Edit New Article" => "Editar novo artigo",
"View Submissions" => "Ver colaboracións",
"ExpireDate" => "Data de Expiración",
"AuthorName" => "Autor",
"Img" => "Imx",
"Create banner" => "Crear pancarta",
"Method" => "Método",
"Use Dates?" => "Usar datas?",
"Max Impressions" => "Máximo de impresións",
"Impressions" => "Impresións",
"Clicks" => "Clics",
"Create New Blog" => "Crear novo blog",
"Dynamic content system" => "Sistema de contido dinámico",
"Available content blocks" => "Bloques dispoñibles",
"Current ver" => "Versión actual",
"Next ver" => "Próxima versión",
"Future vers" => "Versión futura",
"Program" => "Programar",
"Available FAQs" => "PMFs dispoñibles",
"Edit/Create" => "Editar/Crear",
"Edit this FAQ:" => "Editar este PMF:",
"Create new FAQ" => "Crear novo PMF",
"Create New FAQ:" => "Crear Novo PMF:",
"Users can suggest questions" => "Os usuarios poden suxerir preguntas",
"Create a File Gallery" => "Crear galería de ficheiros",
"Gallery Images" => "Imaxes de Galería",
"Edit Blog" => "Editar Blog",
"Blog Title" => "Título do blog",
"Edit New Submission" => "Editar nova colaboración",
"Survey stats" => "Estatísticas de enquisa",
"Take Survey" => "Tomar enquisa",
"Distance (km)" => "Distancia (km)",
"List Movies" => "Lista de filmes",
"Choose a movie" => "Elixa un filme",
"Last mod" => "Última modificación",
"Last author" => "Último autor",
"Last version" => "Última versión",
"unlocked" => "desbloqueada",
"Open client window" => "Abrir a fiestra de cliente",
"Generate HTML" => "Xerar HTML",
"Transcripts" => "Transcricións",
"Online operators" => "Operadores en liña",
"Operator" => "Operador",
"transcripts" => "transcricións",
"Offline operators" => "Operadores desconectados",
"Add an operator to the system" => "Engadir un operador ao sistema",
"Operators must be tiki users" => "Os operadores deben ser usuarios do tiki",
"Set as Operator" => "Poñer como operador",
"Chat started" => "Charla iniciada",
"Operator:" => "Operador:",
"Live support:User window" => "Asistencia en liña: fiestra do usuario",
"Request live support" => "Solicitar asistencia en liña",
"Request support" => "Solicitar asistencia",
"Open a support ticket instead" => "Abrir un tícket de soporte no seu lugar",
"Your request is being processed" => "O súa solicitude está a ser procesada",
"cancel request and exit" => "cancelar solicitude e saír",
"cancel request and leave a message" => "cancelar solicitude e deixar unha mensaxe",
"Live support:Console" => "Asistencia en liña:Consola",
"be online" => "quedar en liña",
"be offline" => "quedar fóra de liña",
"Support requests" => "Solicitudes de asistencia",
"Requested" => "Solicitude",
"Join" => "Unir",
"Support chat transcripts" => "transcrición de charlas de asistencia",
"operator" => "operador",
"started" => "iniciada",
"reason" => "razón",
"msgs" => "msxs",
"Transcript" => "Transcrición",
"Mail-in feature" => "Característica entrada de correo",
"Prefs" => "Prefs.",
"Daily" => "Diario",
"Weekly" => "Semanal",
"Remove old events" => "Borrar eventos antigos",
"duration" => "duración",
"Mini Calendar: Preferences" => "Mini Calendario: Preferencias",
"Calendar Interval in daily view" => "Intervalo do calendario na vista diaria",
"Start hour for days" => "Hora de inicio para os días",
"End hour for days" => "Hora final para os días",
"Reminders" => "Recordatorios",
"no reminders" => "sen recordatorios",
"Or enter path or URL" => "Introducir camiño ou URL",
"Add Topic" => "Engadir tema",
"Update remote index" => "Actualizar índice remoto",
"Rebuild local list" => "Reconstruír lista local",
"Republish all" => "Republicar todo",
"Publish all" => "Publicar todo",
"Unpublish all" => "Despublicar todo",
"Attention" => "Atención",
"all types" => "todos os tipos",
"Display only this type" => "Mostrar só este tipo",
"Unpublish" => "Despublicar",
"Republish" => "Republicar",
"Tikiwiki Mods Configuration" => "Configuración Tikiwiki Mods",
"Enable Mods providing" => "Activar prover Mods",
"Mods local directory" => "Directorio local de Mods",
"Mods remote server" => "Servidor remoto de Mods",
"Package Config" => "Configuración de paquete",
"User Galleries" => "Galerías de usuario",
"Unread Messages" => "Mensaxes non lidas",
"Tasks" => "Tarefas",
"MyTiki" => "O meu Tiki",
"Notepad" => "Caderno de notas",
"MyFiles" => "OsMeusFicheiros",
"My Watches" => "Os meus monitores",
"Sent editions" => "Edicións enviadas",
"The newsletter was sent to {\$sent} email addresses" => "O boletín foi enviado a {\$sent} enderezos de correo",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Grazas por subscribirse. Axiña recibirá un correo para confirmar a súa subscrición. Non se enviarán boletíns ata que a subscrición sexa confirmada.",
"Your email address was removed from the list of subscriptors." => "O seu enderezo de correo foi eliminado da lista de subscritores.",
"Subscription confirmed!" => "Subscrición confirmada!",
"Subscribe to Newsletter" => "Subscribirse ao boletín",
"Subscribe to this Newsletter" => "Subscribirse",
"Available Newsletters" => "Boletíns dispoñibles",
"Notes" => "Notas",
"Write a note" => "Escribir unha nota",
"quota" => "cota",
"No notes yet" => "Sen notas aínda",
"Merge selected notes into" => "combinar notas seleccionadas en",
"Reading note:" => "Lendo nota:",
"List notes" => "Listar notas",
"Write note" => "Escribir nota",
"Wiki Create" => "Crear wiki",
"Wiki Overwrite" => "Sobrescribir wiki",
"Assign permissions to " => "Asignar permisos a ",
"Assign permissions to this object" => "Asignar permisos a este obxecto",
"Published" => "Publicada",
"Passcode to register (not your user password)" => "Código para rexistrarse (non o seu contrasinal de usuario)",
"Orphan Pages" => "Páxinas orfas",
"Browser not supported" => "Navegador non considerado",
"Rename" => "Renomear",
"Slides" => "Diapositivas",
"Discuss" => "Discutir",
"Attach File" => "Anexar ficheiro",
"1 File Attached" => "1 ficheiro anexado",
"(current)" => "(actual)",
"Rollback to this version" => "Reverter a esta versión",
"s=source" => "s=fonte",
"b=rollback" => "b=reverter",
"Pick your avatar" => "Elixir o seu avatar",
"User Preferences" => "Preferencias do usuario",
"Your current avatar" => "O seu avatar actual",
"no avatar" => "sen avatar",
"reset" => "reiniciar",
"Pick avatar from the library" => "Elixa avatar da biblioteca",
"Pick user Avatar" => "Elixir o avatar do usuario",
"Hide all" => "Ocultar todo",
"icons" => "iconas",
"Show all" => "Mostrar todo",
"Avatar Image" => "Imaxe de avatar",
"random" => "azar",
"Upload your own avatar" => "Cargar avatar ou foto",
"View Details" => "Ver detalles",
"Insert" => "Inserir",
"atts" => "atributos",
"List Attachments" => "Listar anexos",
"Average" => "Media",
"View Results" => "Ver Resultados",
"Vote poll" => "Votar encuesta",
"Other Polls" => "Otras encuestas",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Nota: Lembre que isto é só unha previsualización, aínda non foi gardada!",
"on:" => "en:",
"Topic image" => "Imaxe do tema",
"Viewing blog post" => "Leyendo post de blog",
"Return to blog" => "Volver al blog",
"The original document is available at" => "O documento orixinal está dispoñible en",
"Print multiple pages" => "Imprimir múltiples páginas",
"Add Page" => "Engadir páxina",
"Edit quiz" => "Editar cuestionario",
"Current Version" => "Versión actual",
"General Options" => "Opcións xerais",
"Publication Date" => "Data de publicación",
"at " => "en ",
"Use " => "Usar",
"randomly selected questions." => "preguntas seleccionadas ao chou.",
"Test-time Options" => "Opcións durante o test",
"Limit questions displayed per page to " => "Limitar preguntas mostradas por páxina a ",
"&nbsp question(s)." => "&nbsp pregunta(s).",
"Impose a time limit of " => "Impoña un límite de tempo de",
"Allow students to store partial results and return to quiz." => "Permitir aos estudantes gardar resultados parciais e volver ao cuestionario.",
"Allow students to retake this quiz " => "Permitir aos estudantes retomar este cuestionario",
"Grading and Feedback" => "Cualificación e Resposta",
"Grading method " => "Método de cualificación ",
"Show students their score " => "Mostrar puntuación aos estudantes ",
"Show students the correct answers " => "Mostrar as respostas correctas aos estudantes ",
"Publish statistics " => "Publicar estatísticas ",
"Extra Options" => "Opcións extra",
"Solicit additional questions from students" => "Solicitar preguntas adicionais dos estudantes",
"Link quiz to forum named: " => "Ligar cuestionario a foro chamado: ",
"Prologue:" => "Prólogo:",
"Epilogue:" => "Epílogo:",
"Quiz result stats" => "Estatísticas de resultados de cuestionarios",
"Time" => "Tempo",
"User answers" => "Respostas do usuario",
"Stats for quizzes" => "Estatísticas dos cuestionarios",
"taken" => "tomado",
"Av score" => "Puntuación media",
"Av time" => "Tempo medio",
"Clear Stats" => "Borrar estatísticas",
"time taken" => "tempo empregado",
"Stats for this quiz Questions " => "Estatísticas para as preguntas deste cuestionario ",
"Top 10" => "10 primeiros",
"Top 20" => "20 primeiros",
"Top 50" => "50 primeiros",
"Top 100" => "100 primeiros",
"Received articles" => "Artigos recibidos",
"Edit received article" => "Editar artigo recibido",
"Use Image" => "Usar imaxe",
"Image x size" => "Tamaño x da imaxe",
"Image y size" => "Tamaño y da imaxe",
"Image name" => "Nome da imaxe",
"Accept Article" => "Aceptar artigo",
"Site" => "Sitio",
"Referer stats" => "Estatísticas de referencia",
"Last" => "Último",
"Your email could not be validated; make sure you email is correct and click register below." => "O seu correo non pode ser validado; asegúrese de que o seu correo é correcto e prema en rexistrarse abaixo.",
"Register as a new user" => "Rexistarse como un novo usuario",
"Repeat password" => "Repetir contrasinal",
"A valid email is mandatory to register" => " É obrigatorio un correo válido para rexistrarse",
"Tiki site registered" => "Sitio Tiki rexistrado",
"The following site was added and validation by admin may be needed before appearing on the lists" => "O seguinte sitio foi engadido aínda que o administrador pode requirir unha validación antes de aparecer nas listas",
"You don't have permission to use this feature." => "Non ten permiso para usar esta función.",
"Please register." => "Por favor, rexístrese.",
"Register this site at tikiwiki.org" => "Rexistrar este sitio en tikiwiki.org",
"Read this first!" => "Lea isto primeiro!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Nesta páxina pode facer que o seu sitio sexa coñecido para tikiwiki.org. Mostrarase nunha lista de sitios tiki coñecidos.",
"Registering is voluntary." => "Rexistrarse é voluntario.",
"Registering does not give you any benefits except one more link to your site." => "Rexistrarse non lle reportará ningún beneficio agás unha ligazón máis ao seu sitio.",
"You don't get any emails, we don't sell the data about your site." => "Non recibirá correos, non venderemos os datos acerca do seu sitio.",
"Registering is just for us to get an overview of Tiki's usage." => "Rexistrarse é só para que nós teñamos unha idea do uso de Tiki.",
"If your site is private or inside your intranet, you should not register!" => "Se o seu sitio é privado ou está dentro dunha intranet, non debería rexistrarse!",
"Information about your site" => "Información acerca do seu sitio",
"Send me my Password" => "Enviar o meu contrasinal",
"Remove page" => "Eliminar páxina",
"Last Version" => "última versión",
"You are about to remove the page" => "Está a piques de eliminar a páxina",
"permanently" => "permanentemente",
"Remove all versions of this page" => "Eliminar todas as versións desta páxina",
"Rollback page" => "Reverter a páxina",
"Searched" => "Buscado",
"Search in" => "Buscar en",
"Simple search" => "Busca simple",
"No pages matched the search criteria" => "Non se encontraron páxinas que encaixen no criterio de busca",
"This newsletter will be sent to {\$subscribers} email addresses." => "Este boletín será enviado a {\$subscribers} enderezos de correo.",
"Prepare a newsletter to be sent" => "Preparar un boletín para envialo",
"Apply content template" => "Aplicar modelo de contido",
"Send objects" => "Enviar obxectos",
"Transmission results" => "Resultados da transmisión",
"Send Wiki Pages" => "Enviar páxinas Wiki",
"Send Articles" => "Enviar artigos",
"Add Article" => "Engadir artigo",
"Send objects to this site" => "Enviar obxectos a este sitio",
"Create a sheet" => "Crear unha folla de cálculo",
"Edit this sheet:" => "Editar esta folla de cálculo:",
"Create New Sheet" => "Crear nova folla de cálculo",
"There are individual permissions set for this sheet" => "Hai permisos individuais configurados para esta folla de cálculo",
"Class Name" => "Nome de Clase",
"Header Rows" => "Filas de cabeceira",
"Footer Rows" => "Filas de pé",
"Create new Sheet" => "Crear nova folla de cálculo",
"You can access the sheet using the following URL" => "Pode acceder á folla de cálculo usando o seguinte URL",
"Available Sheets" => "Follas de cálculo dispoñibles",
"Change shoutbox general settings" => "Cambiar as opcións xerais da do taboleiro de anuncios",
"auto-link urls" => "autoligar urls",
"Post or edit a message" => "Enviar ou editar mensaxe",
"Location : " => "Localización: ",
"Parent page" => "Páxina superior",
"Child" => "Fillo",
"Last edited by" => "Última edición por",
"based on work by" => "baseado no traballo de",
"Contributors to this page" => "Contribuidores a esta páxina",
"Site Stats" => "Estatísticas do sitio",
"Started" => "Iniciada",
"Days online" => "Días en liña",
"Total pageviews" => "Total de acccesos",
"Average pageviews per day" => "Media de accesos por día",
"Best day" => "O mellor día",
"Worst day" => "O peor día",
"Wiki Stats" => "Estatísticas do Wiki",
"Size of Wiki Pages" => "Tamaño das páxinas",
"Average page length" => "Tamaño medio das páxinas",
"Average versions per page" => "Media de versións por páxina",
"Visits to wiki pages" => "Visitas a páxinas do wiki",
"Average links per page" => "Cantidade media de ligazóns por páxina",
"Image galleries Stats" => "Estatísticas de galerías de imaxes",
"Average images per gallery" => "Media de imaxes por galería",
"Total size of images" => "Tamaño total das imaxes",
"Average image size" => "Tamaño medio da imaxe",
"Visits to image galleries" => "Visitas a galerías de imaxes",
"File galleries Stats" => "Estatísticas de galerías de ficheiros",
"Average files per gallery" => "Media de ficheiros por galería",
"Total size of files" => "Tamaño total de ficheiros",
"Average file size" => "Tamaño medio de ficheiro",
"Visits to file galleries" => "Cantidade de visitas a galerías de ficheiros",
"CMS Stats" => "Estatísticas do CMS",
"Total reads" => "Total de lecturas",
"Average reads per article" => "Media de lecturas por artigo",
"Total articles size" => "Tamaño total dos artigos",
"Average article size" => "Tamaño medio dun artigo",
"Forum Stats" => "Estatísticas de foros",
"Total topics" => "Total de temas",
"Average topics per forums" => "Media de temas por foro",
"Visits to forums" => "Visitas aos foros",
"Blog Stats" => "Estatísticas de blog",
"Weblogs" => "Cantidade de blogs",
"Total posts" => "Total de artigos",
"Average posts per weblog" => "Media de artigos por blog",
"Total size of blog posts" => "Tamaño total dos artigos",
"Average posts size" => "Tamaño medio dun artigo",
"Visits to weblogs" => "Visitas aos blogs",
"Poll Stats" => "Estatísticas de votación",
"Total votes" => "Total de votos",
"Average votes per poll" => "Media de votos por votación",
"Total questions" => "Total de preguntas",
"Average questions per FAQ" => "Media de preguntas por PMF",
"User Stats" => "Estatísticas de usuario",
"Average bookmarks per user" => "Media de marcadores por usuario",
"Average questions per quiz" => "Media de preguntas por cuestionario",
"Quizzes taken" => "Cuestionarios tomados",
"Average quiz score" => "Puntuación media de cuestionario",
"Average time per quiz" => "Media de tempo por cuestionario",
"Stats for surveys" => "Estatísticas de enquisas",
"Last taken" => "Última resposta",
"Time Left" => "Tempo restante",
"Send Answers" => "Enviar respostas",
"Thank you for your submission" => "Grazas polo seu envío",
"Your email was sent" => "O seu correo foi enviado",
"Theme is selected as follows" => "O decorado foi seleccionado como segue",
"If a theme is assigned to the individual object that theme is used." => "Se un decorado está asignado a un obxecto individual, úsase ese decorado.",
"If not then if a theme is assigned to the object's category that theme is used" => "Se non, entón se un decorado é asignado á categoría do obxecto, úsase ese decorado",
"If not then a theme for the section is used" => "Se non, entón úsase un decorado para a sección",
"If none of the above was selected the user theme is used" => "Se nada do anterior foi seleccionado, usarase o decorado do usuario",
"Finally if the user didn't select a theme the default theme is used" => "Finalmente, se o usuario non elixiu decorado ningún, usarase o decorado por defecto",
"Control by Objects" => "Control por Obxectos",
"Control by Sections" => "Control por Seccións",
"Assign themes to categories" => "Asignar decorado a categorías",
"Assigned categories" => "Categorías asignadas",
"Theme Control Center: Objects" => "Centro de Control de Decorados: Obxectos",
"Control by Categories" => "Control por categorías",
"Assign themes to objects" => "Asignar decorados a obxectos",
"Assigned objects" => "Obxectos asignados",
"Assign themes to sections" => "Asignar decorados a seccións",
"Assigned sections" => "Seccións asignadas",
"Edit File:" => "Editar ficheiro:",
"The following file was successfully uploaded" => "O seguinte ficheiro foi cargado con éxito",
"You can download this file using" => "Pode descargar este ficheiro usando",
"Batch Upload Results" => "Resultados da carga en lote",
"Upload successful!" => "Imaxe recibida correctamente!",
"The following image was successfully uploaded" => "A seguinte imaxe recibiuse correctamente",
"Image ID thumb" => "Miniatura da imaxe",
"You can include the image in an Wiki page using" => "Pode incluír a imaxe nunha páxina wiki usando",
"or use filename" => "ou use o nome do ficheiro",
"Now enter the image URL" => "Agora introduza o URL da imaxe",
"or upload a local image from your disk" => "ou cargue unha imaxe desde o seu disco local",
"Batch Upload" => "Carga por lote",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Miniatura (opcional, prevalece sobre a xeración automática de miniaturas)",
"You have to create a gallery first!" => "Primeiro debe crear unha galería!",
"User assigned modules" => "Módulos asignados polo usuario",
"Restore defaults" => "Recuperar valores por defecto",
"Assign module" => "Asignar módulo",
"Column" => "Columna",
"Folders" => "Carpetas",
"Folder in" => "Abrir carpeta",
"Remove Folder" => "Borrar carpeta",
"Refresh Cache" => "Refrescar caché",
"Admin folders and bookmarks" => "Administrar carpetas e marcadores",
"Send me a message" => "Enviarme unha mensaxe",
"Assign Group" => "Asignar grupo",
"Change user preferences" => "Cambiar preferencias do usuario",
"Homepage" => "Inicio",
"Users HomePage" => "Páxina inicial dos usuarios",
"Personal Wiki Page" => "Páxina Wiki Persoal",
"Create page" => "Crear páxina",
"Request friendship from this user" => "Solicitar a amizade deste usuario",
"Toggle options" => "Cambiar opcións",
"Personal Information" => "Información persoal",
"View extra information" => "Visualizar información extra",
"Is email public? (uses scrambling to prevent spam)" => "É público o correo? (usa cifrado para previr correo lixo)",
"Unavailable - please set your e-mail below" => "Non dispoñible - por favor, configure o seu correo debaixo",
"Does your mail reader need a special charset" => "O seu lector de correo require un xogo de caracteres especial",
"Notify sender when reading his mail" => "Avisa o autor cando lea o seu correo",
"Account Information" => "Información da conta",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Deixe os campos \"Novo contrasinal\" e \"Confirmar contrasinal\" en branco para conservar o contrasinal actual",
"Change administrative info" => "Cambiar a información administrativa",
"New task" => "Nova tarefa",
"Task list" => "Lista de tarefas",
"Admin mode off" => "Modo admininistrador desactivado",
"Admin mode on" => "Modo admininistrador activado",
"Task help" => "Axuda de tarefas",
"Empty Trash" => "Baleirar papeleira",
"Received task" => "Tarefa recibida",
"You received this task, please read and execute it" => "Recibiu esta tarefa, por favor léaa e execútea",
"Send task" => "Enviar tarefa",
"You send this task to a other user" => "Pode enviar esta tarefa a outro usuario",
"Shared task" => "Tarefa compartida",
"This task is public to a special group" => "Esta tarefa é pública para un grupo especial",
"Accepted by Task User and Creator" => "Aceptada polo usuario de tarefa e o creador",
"Accepted User and Creator" => "Aceptado (usuario e creador)",
"Task is accepted by user and creator" => "Tarefa aceptada por usuario e creador",
"Not Accepted by One User" => "Non aceptada por un usuario",
"Not Accepted User" => " non aceptado (usuario)",
"Task is rejected by one user" => "A tarefa é rexeitada por un usuario",
"Waiting for Me" => "Esperando por min",
"Task is not accepted by you, read the task and accept or reject it" => "Non aceptou a tarefa, lea a tarefa e acéptea ou rexéitea",
"Waiting for Other User" => "Esperando por outro usuario",
"Task is not accepted/rejected by other user" => "A tarefa non é aceptada/rexeitada por outro usuario",
"Admin Mode" => "Modo administrador",
"Edit task" => "Editar tarefa",
"NOT accept" => "NON acepta",
"Remove from Trash" => "Sacar da papeleira",
"Move into Trash" => "Botar na papeleira",
"Task saved" => "Tarefa gardada",
"Edit Task" => "Editar tarefa",
"View Task" => "Ver tarefa",
"Open a new task" => "Abrir nova tarefa",
"taskId" => "ID da tarefa",
"Task user" => "Usuario da tarefa",
"Only the creator can delete this task" => "Só o creador pode borrar esta tarefa",
"Use start date and time" => "Usar data e hora de inicio",
"Use end date and time" => "Usar data e hora de fin",
"Open / In Process" => "Aberta / en proceso",
"Waiting / Not Started" => "Esperando / non empezada",
"Percentage completed" => "Porcentaxe completada",
"Shared for Group" => "Compartida para grupo",
"Accepted by User" => "Aceptada por usuario",
"No / Rejected" => "Non / rexeitada",
"Accepted by Creator" => "Aceptada polo creador",
"This message will be send to users if you are makeing changes of assigned tasks" => "Esta mensaxe será enviada aos usuarios se está facendo cambios a tarefas asignadas",
"Send message with changes" => "Enviar mensaxe con cambios",
"Modified by" => "Modificado por",
"Marked as deleted" => "Marcado como borrado",
"Inform task user by email" => "Informa o usuario da tarefa por correo-e",
"You can only view this task" => "Só pode ver esta tarefa",
"Completed" => "Completada",
"%m/%d/%Y [%H:%M]" => "%d/%m/%Y [%H:%M]",
"No tasks entered" => "Non se introduciron tarefas",
"Select One" => "Seleccione unha",
"Undo Trash" => "Desfacer papeleira",
"Show:" => "Mostrar:",
"Received" => "Recibido/a",
"Submitted" => "Enviado/a",
"Shared" => "Compartido/a",
"All Shared Tasks" => "Todas as tarefas compartidas",
"completed (100%)" => "completada (100%)",
"Monthly" => "Mensual",
"Add Watch" => "Engadir monitor",
"A user submits an article" => "Un usuario envía un artigo",
"A user submits a blog post" => "Un usuario presenta unha mensaxe de blog",
"A user posts a forum thread" => "Un usuario presenta un argumento no foro",
"A user posts a forum topic" => "Un usuario anuncia un tema do foro",
"A user edited a wiki page" => "Un usuario editou unha páxina wiki",
"May need to refresh twice to see changes" => "Pode ter que refrescar dúas veces para ver os cambios",
"Add top level bookmarks to menu" => "Engadir marcadores do nivel principal ao menú",
"Add or edit an item" => "Engadir ou editar un ítem",
"New Window" => "Nova fiestra",
"replace window" => "substituír fiestra",
"User_versions_for" => "Versións do usuario para",
"This page is being edited by" => "Esta páxina está sendo editada por",
"Proceed at your own peril" => "Proceda pola súa conta e risco",
"Insert Row" => "Inserir fila",
"Insert Column" => "Inserir columna",
"Remove Row" => "Borrar fila",
"Remove Column" => "Borrar columna",
"Merge Cells" => "Unir celas",
"Restore Cells" => "Restaurar celas",
"Copy Calculation" => "Copiar cálculo",
"Format Cell" => "Formatar cela",
"expires:" => "expira:",
"Banner stats" => "Estatísticas de pancarta",
"Create new banner" => "Crear nova pancarta",
"Banner Information" => "Información de pancarta",
"Click ratio" => "Taxa de clics",
"Hours" => "Horas",
"Weekdays" => "Días da semana",
"mon" => "l",
"tue" => "m",
"wed" => "mc",
"thu" => "x",
"fri" => "ve",
"sat" => "s",
"sun" => "dom",
"Banner raw data" => "Datos en bruto da pancarta",
"Cached" => "Almacenado na caché",
"This is a cached version of the page." => "Esta é a versión cacheada da páxina.",
"Click here to view the Google cache of the page instead." => "Prema aquí para ver a caché de Google da páxina.",
"Answers" => "Respostas",
"Add Suggestion" => "Agregar suxestión",
"Forum List" => "Lista de foros",
"Edit Forum" => "Editar foro",
"Summary" => "Resumo",
"for links" => "para ligazóns",
"HTML tags are not allowed inside posts" => "As etiquetas HTML non están permitidas dentro dos envíos",
"Moderator Actions" => "Accións de moderador",
"Move Selected Topics" => "Mover temas seleccionados",
"Unlock Selected Topics" => "Desbloquear temas seleccionados",
"Lock Selected Topics" => "Bloquear temas seleccionados",
"Delete Selected Topics" => "Borrar temas seleccionados",
"Merge" => "Combinar",
"Merge Selected Topics" => "Combinar temas seleccionados",
"Reported Messages:" => "Mensaxes divulgadas:",
"Queued Messages:" => "Mensaxes na cola:",
"Merge into topic" => "Combinar no tema",
"Emot" => "Emot.",
"pts" => "pts.",
"Announce" => "Anuncio",
"Hot" => "Quente",
"No topics yet" => "Sen tema aínda",
"Jump to forum" => "Ir ao foro",
"All posts" => "Todos os artigos",
"Last hour" => "Última hora",
"Last 24 hours" => "Últimas 24 horas",
"Last 48 hours" => "Últimas 48 horas",
"prev topic" => "tema ant",
"next topic" => "tema seg",
"Show posts" => "Mostrar mensaxes",
"Monitor" => "Monitorizar",
"Insert New Item" => "Inserir ítem",
"Edit Fields" => "Editar campos",
"View inserted item" => "Ver ítem inserido",
"Insert new item" => "Inserir ítem",
"Tracker Item:" => "Ítem de tracker:",
"View Item" => "Visualizar ítem",
"Filter Tracker Items" => "Filtrar ítems de tracker",
"Add a Comment" => "Engadir un comentario",
"Items list" => "Lista de ítems",
"Special Operations" => "Operacións especiais",
"close" => "pechar",
"Show All" => "Mostrar todo",
"Clip" => "clip",
"Back To Mailbox" => "volver á caixa do correo",
"Full Headers" => "ver cabeceiras",
"Normal Headers" => "cabeceiras normais",
"Reply To All" => "responder a todos",
"Forward" => "reenviar",
"Select from address book" => "elixir desde a axenda de enderezos",
"Use HTML mail" => "Usar correo HTML",
"The following addresses are not in your address book" => "Os seguintes enderezos non están na súa axenda de enderezos",
"Add Contacts" => "Engadir contactos",
"Attachment 1" => "Anexo 1",
"Attachment 2" => "Anexo 2",
"Attachment 3" => "Anexo 3",
"Address book" => "Axenda de enderezos",
"page id" => "id de páxina",
"3d browser" => "navegador 3d",
"Show/Hide Left Column" => "Mostrar/Ocultar menús da esquerda",
"Show/Hide Right Column" => "Mostrar/Ocultar menús da dereita",
"as Creator &amp; Last Editor" => "como creador e último editor",
"no (disabled)" => "non (desactivado)",
"Save Minor Edit" => "Menor",
"Enable/disable Tiki features here, but configure them elsewhere" => "Active/Desactive características de Tiki aquí, pero configúreas noutro lugar",
"General preferences and settings" => "Configuracións e preferencias xerais",
"User registration, login and authentication" => "Rexistro de usuario, inicio de sesión e autenticación",
"Wiki settings" => "Configuracións para o Wiki",
"Wiki Attachments" => "Anexos ao Wiki",
"Article/CMS settings" => "Configuración para o Artigo/CMS",
"Poll comments settings" => "Configuración dos comentarios para votacións",
"Configuration options for all blogs on your site" => "Opcións de configuración para todos os blogs do seu sitio",
"Forums settings" => "Configuración de foros",
"FAQ comments settings" => "Configuración de comentarios do PMF",
"Trackers settings" => "Configuración de trackers",
"Directory settings" => "Configuración de directorio",
"Maps configuration" => "Configuración de mapas",
"Meta Tags settings" => "Configuración de meta etiquetas ",
"Search settings" => "Configuración de busca",
"Score settings" => "Configuración do sistema de puntuación",
"Community settings" => "Configuración de comunidade",
"Calendar settings" => "Configuración do calendario",
"Help on \$admintitle Config" => "Axuda sobre a configuración de \$admintitle ",
"Category can`t be parent of itself" => "A categoría non pode ser superior a si mesma",
"Upload failed" => "Carga errónea",
"All posted" => "Todos os enviados",
"Queue anonymous posts" => "Pór en cola os artigos anónimos",
"Queue all posts" => "Pór en cola todos os artigos",
"No attachments" => "Sen anexos",
"Everybody can attach" => "Todos poden anexar",
"Only users with attach permission" => "Só usuarios con permiso para anexar",
"Moderators and admin can attach" => "Os moderadores e administradores poden anexar",
"Date (desc)" => "Data(desc)",
"Date (asc)" => "Data (asc)",
"Score (desc)" => "Puntuación (desc)",
"Replies (desc)" => "Respostas (desc)",
"Reads (desc)" => "Lecturas (desc)",
"You have to provide a hotword and a URL" => "Ten que fornecer unha palabra clave e un URL",
"Owner" => "Propietario",
"Detected, Version:" => "Detectado, Versión:",
"Not detected." => "Non detectada.",
"Your admin password has been changed" => "O seu contrasinal de admin foi cambiado",
"All Fields except gdaltindex must be filled" => "Todos os campos agás gdaltindex deben cubrirse",
"No valid gdaltindex executable" => "Executable gdaltindex non válido",
"Tag already exists" => "A etiqueta xa existe",
"Tag not found" => "Etiqueta non atopada",
"Repository name can't be an empty" => "O nome do almacén non pode estar baleiro",
"Requested action is not supported on repository" => "Acción solicitada non está permitida polo almacén",
"No repository" => "Sen almacén",
"Search is mandatory field" => "Buscar é un campo requirido",
"File not found " => "Ficheiro non atopado",
"Requested action in not supported on repository" => "A acción solicitada non está permitida no almacén",
"Non-existent link" => "Ligazón inexistente",
"Mail-in account %s incorrect" => "Conta de correo de entrada %s incorrecta",
"Mail-in account %s saved" => "Conta de correo de entrada %s gardada",
"Frequency should be a positive integer!" => "A frecuencia debe de ser un enteiro positivo!",
"Mail-in accounts set to be checked every %s minutes" => "As contas de correo de entrada están configuradas para verificar cada %s minutos",
"Automatic Mail-in accounts checking disabled" => "Verificación automática de contas de correo de entrada desactivada",
"No menu indicated" => "Non se indica menú",
"No newsletter indicated" => "Non se indica boletín",
"A user registers" => "Un usuario rexistrouse",
"Any wiki page is changed" => "Calquera páxina do wiki é cambiada",
"Any wiki page is changed, even minor changes" => "Calquera páxina wiki é cambiada, mesmo cambios menores",
"PHP error" => "erro de PHP",
"No poll indicated" => "Non se indica votación",
"unsafe" => "inseguro",
"register_globals should be off by default. See the php manual for details." => "register_globals debería estar desactivado por defecto. Vexa o manual de php para os detalles.",
"safe" => "seguro",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid debería estar desactivado por defecto. Vexa o manual de php para os detalles.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "Probablemente upload_tmp_dir está dentro do seu directorio Tikiwiki. Existe o risco de que alguén poida cargar algúns ficheiros a este directorio e acceder a eles pola vía do navegador",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "Non se puido verificar se upload_tmp_dir é accesible pola vía do navegador. Para estar seguro, debe comprobar a configuración do seu servidor web.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "Activar a opción xbithack é inseguro. Dependendo do manexo de ficheiros do seu servidor e a súa configuración de tiki, pode ser posible que un atacante suba scripts á súa galería de ficheiros e os execute",
"The Path to store files in the filegallery should be outside the tiki root directory" => "O camiño para gardar ficheiros na galería de ficheiros debería estar fóra da raíz do directorio de tiki",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "O camiño para gardar ficheiros na galería de imaxes debe estar fóra do directorio raíz de tiki",
"File is not readable. Unable to check." => "O ficheiro non é lexible. Non é posible verificalo.",
"You have to provide a word" => "Debe fornecer unha palabra",
"Permission denied. You cannot view this page." => "Non ten permiso para visualizar a páxina",
"Permission denied you cannot edit this page" => "Non pode editar esta páxina",
"You must specify a page name, it will be created if it doesn't exist." => "Debe especificar un nome de páxina; será creada se non existe.",
"page not added (Exists)" => "páxina non engadida (existe)",
"No survey indicated" => "Non se indica enquisa",
"You don't have permission to use this feature" => "Non ten permiso para usar esta característica",
"No Errors detected" => "Non se detectaron erros",
"No tracker indicated" => "Non se indica tracker",
"Group already exists" => "O grupo xa existe",
"User doesn't exist" => "O usuario non existe",
"No records were found. Check the file please!" => "Non se atoparon rexistros. Comprobe o ficheiro, por favor!",
"User login is required" => "Inicio de sesión de usuario obrigatorio",
"Password is required" => "O contrasinal é obrigatorio",
"Email is required" => "O correo-e é obrigatorio",
"User is duplicated" => "O usuario está duplicado",
"Created account %s <%s>" => "Creada conta %s <%s>",
"Assigned %s in group %s" => "Asignado %s a grupo %s",
"User %s already exists" => "Usuario %s xa existe",
"New %s created with %s %s." => "Novo %s creado con %s %s.",
"Impossible to create new %s with %s %s." => "Imposible crear un novo %s con %s %s.",
"%s %s successfully deleted." => "%s %s correctamente borrado.",
"%s %s removed from %s %s." => "%s %s eliminado desde %s %s.",
"%s changed from %s to %s" => "%s cambiado de %s a %s",
"Impossible to change %s from %s to %s" => "Imposible cambiar %s de %s a %s",
"%s modified successfully." => "%s modificado con éxito.",
"password" => "contrasinal",
"%s modification failed." => "fallou a modificación de %s.",
"rss feed disabled" => "fonte rss desactivada",
"Tiki RSS feed for articles" => "fonte RSS Tiki para os artigos",
"Last articles." => "Últimos artigos.",
"Unknown group" => "Grupo descoñecido",
"Group doesn't exist" => "O grupo non existe",
"You have to indicate a group" => "Debe indicar un grupo",
"This group is invalid" => "Este grupo é incorrecto",
"Permission denied you cannot view backlinks for this page" => "Permiso denegado, non pode ver retroligazóns cara a esta páxina",
"The page cannot be found" => "Non se atopou a páxina ",
"Image Galleries Admin Panel" => "Panel de administración das galerías de imaxes",
"Could not read image %s." => "Non é posible ler a imaxe %s.",
"Image %s upload failed." => "Fallo ao cargar a imaxe %s.",
"Image %s uploaded successfully." => "Imaxe %s cargada con éxito.",
"Image %s removed from Batch directory." => "Imaxe %s borrada do directorio por lotes.",
"Impossible to remove image %s from Batch directory." => "Imposible borrar imaxe%s do directorio por lotes.",
"Permission denied you cannot use the batch directory loading" => "Permiso denegado, non pode usar a carga de directorio en lotes",
"Incorrect directory chosen for batch upload of images." => "Directorio elixido incorrecto para a carga en lote de imaxes.",
"Please setup that dir on " => "Por favor, configure ese directorio en",
"Please contact the website administrator." => "Por favor, póñase en contacto co administrador do sitio web.",
"Invalid directory name" => "Nome de directorio inválido",
"It isn't possible to post in any blog. You may need to create a blog first." => "Non pode publicar en ningún blog, debería crear primeiro un blog",
"Permission denied you cannot post" => "Non ten permiso para publicar",
"Permission denied you cannot edit this post" => "Non pode editar este artigo",
"Top visited blogs" => "Blogs máis visitados",
"Last posts" => "Últimos artigos",
"Top active blogs" => "Blogs máis activos",
"Tiki RSS feed for blog: " => "fonte RSS Tiki para o blog: ",
"No blogId specified" => "Non se especificou ID de blog",
"Tiki RSS feed for weblogs" => "Fonte RSS Tiki para os blogs",
"Last posts to weblogs." => "Últimos artigos en blogs.",
"Permission denied you cannot access this gallery" => "Non ten permisos para acceder a esta galería",
"No gallery indicated" => "Non se indica a galería",
"Permission denied you can not view this section" => "Permiso denegado, non pode visualizar esta sección",
"Permission denied you cannot remove images from this gallery" => "Non ten permiso para quitar imaxes desta galería",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Permiso denegado, non pode reconstruír miniaturas nesta galería",
"Permission denied you cannot rotate images in this gallery" => "Permiso denegado, non pode rotar imaxes nesta galería",
"No image indicated" => "Non se indica imaxe",
"Permission denied you cannot move images from this gallery" => "Non ten permiso para mover imaxes desta galería",
"Permission denied you cannot view the calendar" => "Permiso denegado, non pode visualizar o calendario",
"event without name" => "evento sen nome",
"Access Denied" => "Acceso denegado",
"You can not use the same password again" => "Non pode usar o mesmo contrasinal outra vez",
"Top authors" => "Principais autores",
"Message sent to" => "Mensaxe enviada a",
"You need to change chmod 'whelp' manually to 777" => "Debe cambiar chmod 'whelp' manualmente a 777",
"This feature has been disabled" => "Esta sección foi desactivada",
"Tiki RSS feed for directory sites" => "Fonte RSS Tiki para sitios de directorio",
"Last sites." => "Últimos sitios.",
"Must enter a name to add a site. " => "Debe introducir un nome para engadir un sitio. ",
"Must enter a url to add a site. " => "Debe introducir un URL para engadir un sitio.",
"URL already added to the directory. Duplicate site? " => "O URL xa fora engadida ao directorio. Quere duplicar o sitio? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Non se pode ser acceder ao URL. URL incorrecto ou sitio fóra de liña, e non se pode engadir ao directorio.",
"Must select a category. " => "Debe escoller unha categoría.",
"Must enter a name to add a site" => "Debe introducir un nome para engadir un sitio",
"Must enter a url to add a site" => "Debe introducir un URL para engadir un sitio",
"URL already added to the directory. Duplicate site?" => "URL xa engadido ao directorio. Quere duplicar o sitio?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Non se pode acceder ao URL: URL incorrecto ou sitio fóra de liña e non se pode engadir ao directorio",
"Must select a category" => "Debe escoller unha categoría",
"No site indicated" => "Non se indicou sitio",
"No parent specified" => "Non se especificou superior",
"Article not found" => "Artigo non atopado",
"Permission denied you cannot edit this article" => "Non ten permiso para editar este artigo",
"The language can't be changed as its set of translations has already this language" => "Non se pode cambiar a lingua xa que o seu conxunto de traducións xa ten esa lingua",
"You do not have permissions to edit banners" => "Non ten permiso para editar pancartas",
"Banner not found" => "Pancarta non atopada",
"You do not have permission to edit this banner" => "Non ten permiso para editar esta pancarta",
"Permission denied you cannot create or edit blogs" => "Non ten permiso para crear ou editar blogs",
"Permission denied you cannot edit this blog" => "Non ten permiso para editar este blog",
"You do not have permission to write the style sheet" => "Non ten permiso para escribir a folla de estilo",
"Invalid request to edit an image" => "Solicitude incorrecta para editar unha imaxe",
"Permission denied you cannot edit images" => "Non pode editar imaxes",
"Permission denied you can edit images but not in this gallery" => "Permiso denegado: pode editar imaxes, pero non nesta galería",
"Failed to edit the image" => "Erro ao editar a imaxe",
"Permission denied to use this feature" => "Non ten permiso para acceder a esta característica",
"Shortname must be 2 Characters" => "O nome curto debe ser de dous caracteres",
"You must provide a longname" => "Debe fornecer un nome longo",
"Language created" => "Lingua creada",
"No content id indicated" => "Non se indicou un ID de contido",
"No question indicated" => "Non se indica pregunta",
"No quiz indicated" => "Non se indica cuestionario",
"No structure indicated" => "Non se indicou estrutura",
"Invalid structure_id or page_ref_id" => "structure_id ou page_ref_id incorrectas",
"Permission denied you cannot send submissions" => "Non ten permiso para enviar colaboracións",
"Permission denied you cannot edit submissions" => "Non ten permiso para editar colaboracións",
"You have to create a topic first" => "Primeiro ten que crear un tema",
"You do not have permission to do that" => "Non ten permiso para facer iso",
"You do not have permission to read the template" => "Non ten permiso para ler o modelo",
"No topic id specified" => "Non se especificou o id do tema",
"Invalid topic id specified" => "O Id de tema especificado é incorrecto",
"No object indicated" => "Non se indicou obxecto",
"No type indicated" => "Non se indicou tipo",
"page imported" => "páxina importada",
"created from import" => "creada desde importación",
"Can't import remote HTML page" => "Non podo importar páxina HTML remota",
"The SandBox is disabled" => "A caixa de area está desactivada",
"Cannot edit page because it is locked" => "Non se pode editar a páxina porque está bloqueada",
"No questions group indicated" => "Non se indicou grupo de preguntas",
"Permission denied you cannot edit this file" => "Permiso denegado: non pode editar este ficheiro",
"Permission denied you cannot remove files from this gallery" => "Permiso denegado: non pode eliminar ficheiros desta galería",
"Top visited file galleries" => "Galerías máis visitadas",
"Most downloaded files" => "Ficheiros máis descargados",
"Last files" => "Últimos ficheiros",
"Tiki RSS feed for file galleries" => "Fonte RSS Tiki para galerías de ficheiros",
"Last files uploaded to the file galleries." => "Últimos ficheiros cargados nas galerías de ficheiros.",
"No galleryId specified" => "Non se especificou ID de galería",
"Tiki RSS feed for the file gallery: " => "fonte RSS Tiki para a galería de ficheiros: ",
"No forum indicated" => "Non se indicou foro",
"Last forum topics" => "Últimos temas en foros",
"Top topics" => "Temas principais",
"Forum posts" => "Artigos de foros",
"No forumId specified" => "Non se especificou Id de foro",
"Tiki RSS feed for forum: " => "Fonte RSS Tiki para foro:",
"Tiki RSS feed for forums" => "Fonte RSS Tiki para foros",
"Last topics in forums." => "Últimos temas nos foros.",
"Accepted friendship request from %s" => "Aceptada a solicitude de amizade de %s",
"Refused friendship request from %s" => "Rexeitada a solicitude de amizade de %s",
"Broke friendship with %s" => "Romper amizade con %s",
"I have broken our friendship!" => "Rompín a nosa amizade!",
"You must be logged in to use this feature" => "Debe iniciar sesión para usar esta función",
"Friendship request sent to %s" => "Solicitude de amizade enviada a %s",
"You're already friend of %s" => "Xa era amigo de %s",
"I have accepted your friendship request!" => "Aceptei a súa solicitude de amizade!",
"first uploaded image" => "primeira imaxe cargada",
"last uploaded image" => "última imaxe cargada",
"first image" => "primeira imaxe",
"last image" => "última imaxe",
"random image" => "imaxe aleatoria",
"Permission denied you cannot create galleries and so you cant edit them" => "Permiso denegado, non pode crear galerías nin editalas",
"Permission denied you cannot edit this gallery" => "Non ten permiso para editar esta galería",
"Permission denied you cannot remove this gallery" => "Non pode quitar esta galería",
"Permission denied you cannot make the map of this gallery" => "Permiso denegado, non pode facer o mapa para esta galería",
"Top images" => "Principais imaxes",
"Last images" => "Últimas imaxes",
"Tiki RSS feed for image galleries" => "fonte RSS Tiki para galerías de imaxes",
"Last images uploaded to the image galleries." => "Últimas imaxes cargadas ás galerías de imaxes.",
"Tiki RSS feed for the image gallery: " => "Fonte RSS Tiki para a galería de imaxes:",
"overwriting old page" => "sobrescribindo páxina antiga",
"updated from structured text import" => "actualizado desde importación de texto estruturado",
"page created" => "páxina creada",
"created from structured text import" => "creado desde importación de texto estruturado",
"No name indicated for wiki page" => "Non se indicou nome para a páxina wiki",
"No repository given" => "Non se deu almacén",
"Permission denied. You cannot view pages like this page" => "Non ten permiso para visualizar páxinas semellantes a esta",
"Permission denied you cannot remove articles" => "Non ten permiso para eliminar artigos",
"Permission denied you cannot remove banners" => "Permiso denegado: non pode eliminar pancartas",
"Permission denied you cannot remove this blog" => "Permiso denegado: non pode quitar este blog",
"Non-existent gallery" => "Galería inexistente",
"Permission denied you can upload files but not to this file gallery" => "Permiso denegado: pode cargar ficheiros, pero non nesta galería",
"Could not upload the file" => "Non podo cargar o ficheiro",
"Could not find the file requested" => "Non podo atopar o ficheiro solicitado",
"File update was successful" => "O ficheiro actualizouse con éxito",
"Permission denied you can't upload files so you can't edit them" => "Permiso denegado: non pode cargar ficheiros, así que non os pode editar",
"You cannot admin blogs" => "Non ten permiso para administrar blogs",
"Permission denied you cannot remove submissions" => "Non ten permiso para eliminar colaboracións",
"Permission denied you cannot approve submissions" => "Non ten permiso para aprobar colaboracións",
"You have to enable cookies to be able to login to this site" => "Ten que activar cuquis para poder iniciar a sesión neste sitio",
"Tiki mail-in auto-reply" => "Resposta automática da entrada de correo Tiki",
"Sorry, you can't use this feature." => "Síntoo, non pode usar esta característica.",
"You do not have permissions to view the maps" => "Non ten permiso para visualizar os mapas",
"Maps feature is not correctly setup : Maps path is missing." => "A función de Mapas non está correctamente configurada: falta a ruta para os mapas.",
"mapfile name incorrect" => "Nome de ficheiro de mapa incorrecto",
"This mapfile already exists" => "Este mapa xa existe",
"You do not have permission to write to the mapfile" => "Non ten permiso para escribir no ficheiro de mapa",
"You do not have permission to delete the mapfile" => "Non ten permiso para borrar o ficheiro de mapa",
"I could not make a copy" => "Non podo facer unha copia",
"You do not have permission to read the mapfile" => "Non ten permiso para ler o ficheiro de mapa",
"You dont have permission to do that" => "Non ten permiso para facer iso",
"Tiki RSS feed for maps" => "fonte RSS Tiki para mapas",
"List of maps available." => "Lista de mapas dispoñibles.",
"You do not have permissions to view the layers" => "Non tien permisos para visualizar as capas",
"You do not have permissions to delete a file" => "Non ten permisos para borrar un ficheiro",
"File not found" => "Ficheiro non atopado",
"You do not have permissions to create a directory" => "Non ten permiso para crear un directorio",
"The Directory is not empty" => "O directorio non está baleiro",
"You do not have permissions to delete a directory" => "Non ten permisos para borrar un directorio",
"You do not have permissions to create an index file" => "Non ten permisos para crear ficheiros de índice",
"Invalid file name" => "Nome de ficheiro incorrecto",
"Invalid files to index" => "Ficheiros incorrectos para indexar",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Non sei onde está gdaltindex. Configure correctamente a función de Mapas",
"I could not create the index file" => "Non podo crear o ficheiro de índice",
"Must be logged to use this feature" => "Debe iniciar a sesión para usar esa característica",
"Welcome at Hawiki" => "Benvido a Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Este sitio Tikiwiki está preparado para o acceso desde unha gran variedade de dispositivos móbiles, por ex. teléfonos WAP, PDAs, dispositivos i-mode, etc.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Pode navegar neste sitio co seu dispositivo móbil dirixindo o seu navegador cara ao seguinte URL neste sitio:",
"About" => "Acerca de",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "Debe executar setup.sh :<br />./setup.sh \$APACHEUSER all<br />Usuarios comúns de Apache son www-data, apache ou nobody",
"Your PHP installation does not have zlib enabled." => "A súa instalación de PHP non ten zlib habilitado.",
"You must log in to use this feature" => "Debe iniciar a sesión para usar esta característica",
"You do not have permission to view other users data" => "Non ten permiso para visualizar os datos doutros usuarios",
"You must be logged in to subscribe to newsletters" => "Debe iniciar a sesión para poder subscribirse a boletíns",
"No note indicated" => "Non se indicou nota",
"merged note:" => "nota combinada:",
"File is too big" => "Ficheiro demasiado grande",
"No item indicated" => "Non se indicou ítem",
"created from notepad" => "creado desde o caderno de notas",
"Page already exists" => "A páxina xa existe",
"Not enough information to display this page" => "Non hai información abonda para mostrar esta páxina",
"Permission denied you cannot browse this page history" => "Non ten permiso para navegar polo historial da páxina",
"No article indicated" => "Non se indica un artigo",
"Article is not published yet" => "O artigo aínda non foi publicado",
"No post indicated" => "Non indica o artigo",
"Blog not found" => "No se atopa o blog",
"No pages indicated" => "Non se indican as páxinas",
"Pageviews" => "Accesos",
"You don't have permission to edit quizzes." => "Non ten permiso para editar cuestionarios.",
"No result indicated" => "Non se indica resultado",
"The passwords don't match" => "Os contrasinais non coinciden",
"Invalid or unknown username" => "Nome de usuario inválido ou descoñecido",
"Unable to send mail. User has not configured email" => "Non se pode enviar correo. O usuario non configurou o seu correo electrónico",
"to the registered email address for" => "ao enderezo rexistrada de correo para",
"last version" => "última versión",
"Permission denied you cannot remove versions from this page" => "Non pode eliminar versións desta páxina",
"Permission denied you cannot rename this page" => "Permiso denegado: non pode renomear esta páxina",
"Cannot rename page because the new name begins with reserved prefix" => "Non pode renomear a páxina porque o novo nome comeza cun prefixo reservado",
"Cannot rename page maybe new page already exists" => "Non podo renomear a páxina, talvez a nova páxina xa existe",
"Non-existent version" => "Versión inexistente",
"Permission denied you cannot rollback this page" => "Non ten permiso para restablecer unha versión anterior da páxina",
"Error Message" => "Mensaxe de erro",
"Tiki RSS Feed Error Message: \$errmsg" => "Fonte RSS Tiki: Mensaxe de Erro: \$errmsg",
"No newsletters available." => "Non hai boletíns dispoñibles.",
"successfully sent" => "enviada con éxito",
"not sent" => "non enviada",
"Error: " => "Erro: ",
"Page must be defined inside a structure to use this feature" => "A páxina debe estar definida dentro dunha estrutura para usar esa función",
"You cannot take this quiz twice" => "Non pode facer o cuestionario dúas veces",
"Quiz time limit exceeded quiz cannot be computed" => "Superouse o tempo límite",
"You cannot take this survey twice" => "Non responder a enquisa dúas veces",
"Please create a category first" => "Por favor, primeiro cree unha categoría",
"Tracker item:" => "Ítem de tracker:",
"empty" => "baleiro",
"No trackerId specified" => "Non se especificou o ID de tracker",
"No permission to upload zipped file packages" => "Non ten permiso para cargar paquetes de ficheiros comprimidos zip",
"Error processing zipped image package" => "Erro ao procesar paquete de imaxes comprimido zip",
"No permission to upload zipped image packages" => "Sen permiso para cargar paquete de imaxes comprimido zip",
"The uploaded file ist not recognized as a image" => "O ficheiro cargado non é recoñecido como unha imaxe",
"Permission denied you cannot upload images" => "Non ten permiso para cargar imaxes",
"Permission denied you can upload images but not to this gallery" => "Ten permisos para cargar imaxes, pero non a esta galería",
"Cannot get image from URL" => "Non se puido ler imaxe a partir do URL",
"That is not an image (or you have php < 4.0.5)" => "Esta non é unha imaxe (ou ten php < 4.0.5)",
"Usage" => "Uso",
"No url indicated" => "Non se indica url",
"Unknown user" => "Usuario descoñecido",
"You are not logged in and no user indicated" => "Non iniciou a sesión e non hai usuario indicado",
"The user has chosen to make his information private" => "O usuario elixiu facer a súa información privada",
"Email is set to %s" => "Correo está configurado a %s",
"The passwords did not match" => "Os contrasinais non coinciden",
"no" => "non",
"was moved into trash" => "foi movido á papeleira",
"trashed by" => "borrado por",
"open / in process" => "aberta / en proceso",
"Public for group" => "Publica para grupo",
"Rights by creator" => "Dereitos do autor",
"END" => "FIN",
"Percentage" => "Porcentaxe",
"Task accepted by creator" => "Tarefa aceptada polo creador ",
"Task accepted by task user" => "Tarefa aceptada polo usuario de tarefa",
"Task NOT accepted by creator" => "Tarefa NON aceptada polo creador",
"Task NOT accepted by task user" => "Tarefa NON aceptada polo usuario da tarefa",
"Sorry this task does not exist or you have no rights to view this task" => "Síntoo, esta tarefa non existe ou vostede non ten dereito a vela",
"Task entries:" => "Entradas da tarefa:",
"Changes:" => "Cambios:",
"Info message" => "Mensaxe de información",
"NEW Task" => "NOVA tarefa",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Síntoo, vostede non ten permitido enviar tarefas a outros usuarios, ou o usuario non ten permitido recibilas!",
"Changes on Task" => "Cambios na tarefa",
"You received a new task" => "Vostede recibiu unha nova tarefa",
"The priority is" => "A prioridade é",
"very low" => "moi baixa",
"low" => "baixa",
"high" => "alta",
"very high" => "moi alta",
"You've to start your work at least on" => "Vostede debe empezar o seu traballo ao menos en",
"You've to finish your work on" => "Debe terminar o seu traballo en",
"Login and click the link below" => "Inicie sesión e prema a ligazón seguinte",
"Please read the task and work on it!" => "Por favor, lea a tarefa e traballe nela!",
"Sorry, there was an error while trying to write data into the database" => "Síntoo, houbo un erro intentando escribir datos na base de datos",
"Cannot upload this file not enough quota" => "Non pode cargar este ficheiro, cota insuficiente",
"No user indicated" => "Non se indica usuario",
"Non-existent user" => "Usuario inexistente",
"No banner indicated" => "Non se indica unha pancarta",
"No blog indicated" => "Non se indica un blog",
"Permission denied you cannot remove the post" => "Non ten permiso para eliminar este artigo",
"No cache information available" => "Non hai información dispoñible na caché ",
"No faq indicated" => "Non se indica pmf",
"You are not permitted to remove someone else\\'s post!" => "Non ten permitido borrar o artigo de outro!",
"No thread indicated" => "Non se indica un fío",
"A SheetId is required." => "Requírese un Id de folla de cálculo.",
"That tracker don't use extras." => "Este tracker non usa extras.",
"Aborted" => "Abortada",
"Top pages" => "Páxinas principais",
"Last pages" => "Últimas páxinas",
"Tiki RSS feed for the wiki pages" => "Fonte RSS Tiki para as páxinas wiki",
"Last modifications to the Wiki." => "Últimas modificacións para o Wiki.",
"###end###"=>"###end###");
