'''OpenGL extension IBM.multimode_draw_arrays

Overview (from the spec)
	
	These functions behave identically to the standard OpenGL 1.1 functions
	glDrawArrays() and glDrawElements() except they handle multiple lists of
	vertices and multiple primitive modes in one call. Their main purpose is
	to allow one function call to render more than one primitive regardless
	of the primitive mode. 
	
	This extension is similar to the EXT_multi_draw_arrays extension 
	except that it accomodates the specification of a  unique mode for
	each primitive.
	

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/IBM/multimode_draw_arrays.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_IBM_multimode_draw_arrays'

glMultiModeDrawArraysIBM = platform.createExtensionFunction( 
	'glMultiModeDrawArraysIBM', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLuintArray, arrays.GLintArray, arrays.GLsizeiArray, constants.GLsizei, constants.GLint,),
	doc = 'glMultiModeDrawArraysIBM( GLuintArray(mode), GLintArray(first), GLsizeiArray(count), GLsizei(primcount), GLint(modestride) ) -> None',
	argNames = ('mode', 'first', 'count', 'primcount', 'modestride',),
)

glMultiModeDrawElementsIBM = platform.createExtensionFunction( 
	'glMultiModeDrawElementsIBM', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(arrays.GLuintArray, arrays.GLsizeiArray, constants.GLenum, ctypes.POINTER(ctypes.c_void_p), constants.GLsizei, constants.GLint,),
	doc = 'glMultiModeDrawElementsIBM( GLuintArray(mode), GLsizeiArray(count), GLenum(type), POINTER(ctypes.c_void_p)(indices), GLsizei(primcount), GLint(modestride) ) -> None',
	argNames = ('mode', 'count', 'type', 'indices', 'primcount', 'modestride',),
)


def glInitMultimodeDrawArraysIBM():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
