-- File: GrayIncReg.vhd
-- Generated by MyHDL 0.7
-- Date: Sun Dec 19 16:52:33 2010


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_07.all;

entity GrayIncReg is
    port (
        graycnt: out unsigned(7 downto 0);
        enable: in std_logic;
        clock: in std_logic;
        reset: in std_logic
    );
end entity GrayIncReg;


architecture MyHDL of GrayIncReg is

signal graycnt_comb: unsigned(7 downto 0);
signal gray_inc_1_bincnt: unsigned(7 downto 0);

begin




GRAYINCREG_GRAY_INC_1_INC_1_INCLOGIC: process (clock, reset) is
begin
    if (reset = '0') then
        gray_inc_1_bincnt <= "00000000";
    elsif rising_edge(clock) then
        if to_boolean(enable) then
            gray_inc_1_bincnt <= ((gray_inc_1_bincnt + 1) mod 256);
        end if;
    end if;
end process GRAYINCREG_GRAY_INC_1_INC_1_INCLOGIC;


GRAYINCREG_GRAY_INC_1_BIN2GRAY_1_LOGIC: process (gray_inc_1_bincnt) is
    variable Bext: unsigned(8 downto 0);
begin
    Bext := to_unsigned(0, 9);
    Bext := resize(gray_inc_1_bincnt, 9);
    for i in 0 to 8-1 loop
        graycnt_comb(i) <= (Bext((i + 1)) xor Bext(i));
    end loop;
end process GRAYINCREG_GRAY_INC_1_BIN2GRAY_1_LOGIC;


GRAYINCREG_REG_1: process (clock) is
begin
    if rising_edge(clock) then
        graycnt <= graycnt_comb;
    end if;
end process GRAYINCREG_REG_1;

end architecture MyHDL;
