<?php
/**
 * Internationalisation file for the reCAPTCHA module of the ConfirmEdit
 * extension.
 *
 * @addtogroup Extensions
*/

$messages = array();

/* English */
$messages['en'] = array(
	'recaptcha-desc' => 'reCAPTCHA module for Confirm Edit',
        'recaptcha-edit' => 'To help protect against automated edit spam, please type the two words you see in the box below:', 
        'recaptcha-addurl' => 'Your edit includes new external links. To help protect against automated spam, please type the two words you see in the box below:',
	'recaptcha-badpass' => 'To help protect against automated password cracking, please type the two words you see in the box below:',
	'recaptcha-createaccount' => 'To help protect against automated account creation, please type the two words you see in the box below:',
	'recaptcha-createaccount-fail' => "Incorrect or missing reCAPTCHA answer.",
	'recaptcha-create' => 'To help protect against automated page creation, please type the two words you see in the box below:', 
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'recaptcha-desc' => 'موديل reCAPTCHA لConfirm Edit',
);

/** Asturian (Asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'recaptcha-edit' => "P'ayudar a protexenos escontra'l spam d'edición, escribi les dos pallabres que se ven na caxella d'abaxo:",
	'recaptcha-addurl' => "La to edición incluye enllaces esternos nuevos. P'ayudar a protexenos escontra'l spam automáticu, escribi les dos pallabres que se ven na caxella d'abaxo:",
	'recaptcha-badpass' => "P'ayudar a protexenos escontra'l frañimientu de claves automáticu, escribi les dos pallabres que se ven na caxella d'abaxo:",
	'recaptcha-createaccount' => "P'ayudar a protexenos escontra la creación de cuentes automática, escribi les dos pallabres que se ven na caxella d'abaxo:",
	'recaptcha-createaccount-fail' => 'Falta la rempuesta a la entruga de reCAPTCHA o ye incorreuta',
	'recaptcha-create' => "P'ayudar a protexenos escontra la creación de páxines automática, escribi les dos pallabres que se ven na caxella d'abaxo:",
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'recaptcha-edit' => 'Для абароны супраць спаму, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:',
	'recaptcha-addurl' => 'Вашае рэдагаваньне ўтрымлівае новыя вонкавыя спасылкі. Для абароны супраць спаму, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:',
	'recaptcha-badpass' => 'Для абароны супраць узлому паролю, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:',
	'recaptcha-createaccount' => 'Для абароны супраць аўтаматычнага стварэньня рахункаў, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:',
	'recaptcha-createaccount-fail' => 'Адказ reCAPTCHA няслушны ці адсутнічае.',
	'recaptcha-create' => 'Для абароны супраць аўтаматычнага стварэньня старонак, калі ласка, увядзіце два словы, якія Вы бачыце ў полі ніжэй:',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'recaptcha-edit' => "Da sikour en em wareziñ diouzh ar stroboù emgefre, merkit an daou c'her a welit er voest dindan :",
	'recaptcha-addurl' => "Liamm diavaez nevez zo bet degaset ganeoc'h. Da sikour en em wareziñ diouzh ar stroboù, merkit an daou c'her a welit er voest dindan :",
	'recaptcha-badpass' => "Da sikour en em wareziñ diouzh an diskuliañ gerioù-tremen emgefre dre daolioù-esae, merkit an daou c'her a welit er voest dindan :",
	'recaptcha-createaccount' => "Da sikour en em wareziñ diouzh ar c'hrouiñ kontoù emgefre, merkit an daou c'her a welit er voest dindan :",
	'recaptcha-createaccount-fail' => 'Respont reCAPTHCA faziek pe ezvezant.',
	'recaptcha-create' => "Da sikour en em wareziñ diouzh ar c'hrouiñ pajennoù emgefre, merkit an daou c'her a welit er voest dindan :",
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'recaptcha-edit' => 'Da bismo pomogli protiv automatiziranog spam uređivanja, molimo upišite dvije riječi koje vidite u kutiju ispod:',
	'recaptcha-addurl' => 'Vaše izmjene uključuju nove vanjske linkove. Da bismo pomogli protiv automatiziranog spama, molimo upišite dvije riječi koje vidite u kutiju ispod.',
	'recaptcha-badpass' => 'Da bismo pomogli protiv automatiziranog probijanja šifre, molimo upišite dvije riječi koje vidite u kutiju ispod:',
	'recaptcha-createaccount' => 'Da bismo pomogli protiv automatiziranog pravljenja računa, molimo upišite dvije riječi koje vidite u kutiju ispod:',
	'recaptcha-createaccount-fail' => 'Neispravan ili nedostajući reCAPTCHA odgovor.',
	'recaptcha-create' => 'Da bismo pomogli protiv automatiziranog pravljenja stranica, molimo upišite dvije riječi koje vidite u kutiju ispod:',
);

/** Czech (Česky)
 * @author Jkjk
 * @author Mormegil
 */
$messages['cs'] = array(
	'recaptcha-desc' => 'Podpora reCAPTCHA pro rozšíření Confirm Edit',
	'recaptcha-edit' => 'V zájmu ochrany před automatickým spamováním opište dvě slova, která vidíte na obrázku:',
	'recaptcha-addurl' => 'Vaše editace obsahuje nové externí odkazy. V zájmu ochrany před automatickým spamováním opište dvě slova, která vidíte na obrázku:',
	'recaptcha-badpass' => 'V zájmu ochrany proti automatickým pokusům uhodnout heslo opište dvě slova, která vidíte na obrázku:',
	'recaptcha-createaccount' => 'V rámci ochrany před automatickým vytvářením účtů opište dvě slova, která vidíte na obrázku:',
	'recaptcha-createaccount-fail' => 'Nesprávná nebo chybějící odpověď na reCAPTCHA.',
	'recaptcha-create' => 'V zájmu ochrany před automatickým zakládáním stránek opište dvě slova, která vidíte na obrázku:',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'recaptcha-edit' => "Er mwyn ei gwneud yn annodd i olygyddion awtomatig osod sbam, teipiwch y ddau air sydd i'w gweld yn y blwch isod:",
	'recaptcha-addurl' => "Mae'ch golygiad yn cynnwys cysylltiadau allanol newydd. Er mwyn helpu i ddiogelu rhag sbam awtomatig, teipiwch y ddau air sydd i'w gweld yn y blwch isod:",
	'recaptcha-badpass' => "Er mwyn helpu i arbed rhag i'ch cyfrinair gael ei ddatrys gan beiriant, teipiwch y ddau air sydd i'w gweld yn y blwch isod:",
	'recaptcha-createaccount' => "Er mwyn ei gwneud yn annodd i beiriannau i agor cyfrifon yn awtomatig, teipiwch y ddau air sydd i'w gweld yn y blwch isod:",
	'recaptcha-createaccount-fail' => "Mae'r ateb i'r pos CAPTCHA yn anghywir neu yn eisiau.",
	'recaptcha-create' => "Er mwyn ei gwneud yn annodd i beiriannau i ddechrau tudalennau yn awtomatig, teipiwch y ddau air sydd i'w gweld yn y blwch isod:",
);

/** German (Deutsch) */
$messages['de'] = array(
	'recaptcha-edit' => 'Zum Schutz vor automatisiertem Spam, gib bitte die beiden folgenden Wörter in das untenstehende Feld ein:',
	'recaptcha-addurl' => 'Deine Bearbeitung enthält neue externe Links. Zum Schutz vor automatisiertem Spam gib bitte die beiden folgenden Wörter in das folgende Feld ein:',
	'recaptcha-badpass' => 'Zum Schutz gegen automatisiertes Knacken von Passwörtern, gib bitte die beiden folgenden Wörter in das folgende Feld ein:',
	'recaptcha-createaccount' => 'Zum Schutz gegen automatisierte Erstellung von Benutzerkonten gib bitte die beiden folgenden Wörter in das folgende Feld ein:',
	'recaptcha-createaccount-fail' => 'Fehlerhafte oder fehlende reCAPTCHA Antwort.',
	'recaptcha-create' => 'Zum Schutz gegen automatisierte Erstellung von Seiten gib bitte die beiden folgenden Wörter in das folgende Feld ein:',
);

/** Spanish (Español)
 * @author Fitoschido
 */
$messages['es'] = array(
	'recaptcha-edit' => 'Para protegernos de la publicidad automatizada, escribe las dos palabras visibles en el cuadro de abajo:',
	'recaptcha-addurl' => 'Tu edición incluye nuevos enlaces externos. Para ayudar a protegernos contra el spam automatizado, por favor, escribe las dos palabras que ves en el cuadro a continuación:',
	'recaptcha-badpass' => 'Para protegernos del robo automatizado de contraseñas, escribe las dos palabras visibles en el cuadro de abajo:',
	'recaptcha-createaccount' => 'Para protegernos de la creación automática de cuentas, escribe las dos palabras que ves en el cuadro de abajo:',
	'recaptcha-createaccount-fail' => 'ReCAPTCHA incorrecto o sin responder.',
	'recaptcha-create' => 'Para protegernos de la creación automática de páginas, escribe las dos palabras que ves en el cuadro de abajo:',
);

/** French (Français) */
$messages['fr'] = array(
	'recaptcha-edit' => "Pour nous protéger des robots, merci d'écrire les deux mots visibles dans le cadre qui suit:",
	'recaptcha-addurl' => "Votre contribution contient des liens vers un site externe. Pour nous protéger des robots, merci d'écrire les deux mots visibles dans le cadre qui suit:",
	'recaptcha-badpass' => "Pour nous protéger des essais automatiques de cassage de mot de passe, merci d'écrire les deux mots visibles dans le cadre qui suit:",
	'recaptcha-createaccount' => "Pour nous protéger des créations automatiques de compte, merci d'écrire les deux mots visibles dans le cadre qui suit:",
	'recaptcha-createaccount-fail' => 'Réponse de reCAPTCHA fausse ou manquante.',
	'recaptcha-create' => "Pour nous protéger des créations automatiques de pages, merci d'écrire les deux mots visibles dans le cadre qui suit:",
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'recaptcha-desc' => 'Módulo de reCAPTCHA para Confirm Edit',
	'recaptcha-edit' => 'Para axudarnos á protección contra o spam, escriba as dúas palabras que vexa nesta caixa:',
	'recaptcha-addurl' => 'A súa edición inclúe novas ligazóns externas. Para axudar na protección contra o spam automático, ten que escribir as dúas palabras que aparecen na caixa inferior:',
	'recaptcha-badpass' => 'Para axudarnos á protección contra o roubo de contrasinais, escriba as dúas palabras que vexa nesta caixa:',
	'recaptcha-createaccount' => 'Para axudarnos á protección contra a creación automática de contas, escriba as dúas palabras que vexa nesta caixa:',
	'recaptcha-createaccount-fail' => 'Falta a resposta ao reCAPTCHA ou esta é incorrecta.',
	'recaptcha-create' => 'Para axudarnos á protección contra a creación automática de páxinas, escriba as dúas palabras que vexa nesta caixa:',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'recaptcha-edit' => 'Zum Schutz vor automatisiertem Spam, gib bitte di beide Werter in s Fäld unten yy:',
	'recaptcha-addurl' => 'In Dyre Bearbeitg het s neji extärni Links. Zum Schutz vor automatisiertem Spam, gib bitte di beide Werter in s Fäld unten yy:',
	'recaptcha-badpass' => 'Zum Schutz gege automatisiert Knacken vu Passwerter, gib bitte di beide Werter in s Fäld unten yy:',
	'recaptcha-createaccount' => 'Zum Schutz gege s automatisiert Aalege vu Benutzerkonte, gib bitte di beide Werter in s Fäld unten yy:',
	'recaptcha-createaccount-fail' => 'D reCAPTCHA-Antwort isch fählerhaft oder si fählt.',
	'recaptcha-create' => 'Zum Schutz gege s automatisiert Aalege vu Syte, gib bitte di beide Werter in s Fäld unten yy:',
);

/** Hebrew (עברית) */
$messages['he'] = array(
	'recaptcha-edit' => 'אינכם משתמש רשום.כהגנה מפני ספאם אוטומטי, אנא הקלידו את שתי המילים שלהלן. תודה.',
	'recaptcha-addurl' => 'אינכם משתמש רשום.כהגנה מפני ספאם אוטומטי, אנא הקלידו את שתי המילים שלהלן. תודה.',
	'recaptcha-badpass' => 'כהגנה מפני מפצחי סיסמאות אוטומטיים אנא הקלידו את שתי המילים שלהלן:',
	'recaptcha-createaccount' => 'כהגנה מפני יצירת חשבונות פיקטיביים ע"י אוטומטים אנא הקלידו את שתי המילים שלהלן:',
	'recaptcha-createaccount-fail' => 'לא הוקלדו מילות האישור, או שהוקלדו מילים לא נכונות. נסו שנית.',
	'recaptcha-create' => 'אינכם משתמש רשום.כהגנה מפני ספאם אוטומטי, אנא הקלידו את שתי המילים שלהלן. תודה.',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'recaptcha-edit' => 'Za škit přećiwo awtomatizowanemu spamej, prošu zapisaj dwě słowje, kotrejž w slědowacym polu widźiš:',
	'recaptcha-addurl' => 'Twoja změna wobsahuje nowe eksterne wotkazy. Za škit přećiwo awtomatizowanemu spamej, prošu zapisaj dwě słowje, kotrerjž w slědowacym polu widźiš:',
	'recaptcha-badpass' => 'Za škit přećiwo awtomatizowanemu złamanju hesłow, zapisaj prošu wobě słowje, kotrejž widźiš, do slědowaceho pola:',
	'recaptcha-createaccount' => 'Za škit přećiwo awtomatiskemu wutworjenju konta, prošu zapisaj tej wobě słowje, kotrejž w slědowacym polu widźiš:',
	'recaptcha-createaccount-fail' => 'Wopačna abo falowaca wotmołwa reCAPTCHA.',
	'recaptcha-create' => 'Za škit přećiwo awtomatiskemu wutworjenju strony, prošu zapisaj tej wobě słowje, kotrejž w slědowacym polu widźiš:',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'recaptcha-edit' => 'Pro adjutar a proteger nos contra le spam automatisate, per favor entra le duo parolas que tu vide in le quadro sequente:',
	'recaptcha-addurl' => 'Iste modification include nove ligamines externe. Pro adjutar a proteger nos contra le spam automatisate, per favor entra le duo parolas que tu vide in le quadro sequente:',
	'recaptcha-badpass' => 'Pro adjutar a proteger nos contra le furto automatisate de contrasignos, per favor entra le duo parolas que tu vide in le quadro sequente:',
	'recaptcha-createaccount' => 'Pro adjutar a proteger nos contra le creation automatisate de contos, per favor entra le duo parolas que tu vide in le quadro sequente:',
	'recaptcha-createaccount-fail' => 'Responsa reCAPTCHA incorrecte o mancante.',
	'recaptcha-create' => 'Pro adjutar a proteger nos contra le creation automatisate de paginas, per favor entra le duo parolas que tu vide in le quadro sequente:',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 */
$messages['id'] = array(
	'recaptcha-edit' => 'Untuk membantu pelindungan terhadap spam penyuntingan otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:',
	'recaptcha-addurl' => 'Suntingan Anda menyertakan pranala eksternal baru. Untuk membantu pelindungan terhadap spam otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:',
	'recaptcha-badpass' => 'Untuk membantu pelindungan terhadap perengkahan sandi otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:',
	'recaptcha-createaccount' => 'Untuk membantu pelindungan terhadap pembuatan akun otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:',
	'recaptcha-createaccount-fail' => 'Jawaban reCAPTCHA tidak benar atau tidak dimasukkan.',
	'recaptcha-create' => 'Untuk membantu pelindungan terhadap pembuatan halaman otomatis, silakan ketik dua kata yang Anda lihat dalam kotak di bawah ini:',
);

/** Japanese (日本語) */
$messages['ja'] = array(
	'recaptcha-edit' => '自動編集スパムからの保護のため、下の画像に表示されている２つの言葉を入力 してください。',
	'recaptcha-addurl' => 'あなたの編集は新しい外部リンクを含んでいます。自動スパムからの保護のた め、下の画像に表示されている２つの言葉を入力してください。',
	'recaptcha-badpass' => '自動パスワードクラッキングからの保護のために、下の画像に表示されている２ つの言葉を入力してください。',
	'recaptcha-createaccount' => '自動アカウント登録からの保護のために、下の画像に表示されている２つの言葉 を入力してください。',
	'recaptcha-createaccount-fail' => '入力された文字列が正しくありません。',
	'recaptcha-create' => '自動ページ作成からの保護のために、下の画像に表示されている２つの言葉を入 力してください。',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'recaptcha-edit' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje et automattesche Ändere un SPAM em Wiki schöze.',
	'recaptcha-addurl' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje automattesch en et Wiki jebraate SPAM schöze, nohdämm en Dingem Beidraach {{PLURAL:$1|ene neue Lengk dren es|neue Lengks dren sin|kein neue Lengks dren sin}}.',
	'recaptcha-badpass' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje et automattesche Paßwoot Knacke em Wiki schöze.',
	'recaptcha-createaccount' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje SPAM un automattesch aanjelaate Zohjäng nohm Wiki schöze.',
	'recaptcha-createaccount-fail' => 'Dat wohr en verkehte udder jaa kei Antwoot op dat Kaptscha.',
	'recaptcha-create' => 'Schrief di zwei Wööt en dä Kaste onge erin.
Dat sull jääje SPAM un automattesch aanjelaate Sigge em Wiki schöze.',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'recaptcha-edit' => "Fir ze hëllefe eis géint automatiséierte Spam ze schützen, tippt w.e.g. déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner an:",
	'recaptcha-addurl' => "An Ärer Ännerung sinn nei extern Linken! Fir ze hëllefe géint automatiséierte Spam virzegoen, tippt w.e.g. déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner:",
	'recaptcha-badpass' => "Fir ze hëllefe eis géint d'automatiséiert hacke vu Passwierder ze schützen, tippt w.e.g. déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner an:",
	'recaptcha-createaccount' => "Fir ze hëllefe eis géint d'automatiséiert Uleeë vu Benotzerkonten ze schützen, tippt w.e.g. déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner an:",
	'recaptcha-createaccount-fail' => 'reCAPTCHA Äntwert feelt oder ass net korrekt.',
	'recaptcha-create' => "Fir ze hëllefe eis géint d'automatiséiert Uleeë vu Säiten ze schützen, tippt w.e.g. déi zwee Wierder déi Dir gesitt an d'Këscht ënnendrënner an:",
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'recaptcha-desc' => 'Модул reCAPTCHA за потврда на уредувања',
	'recaptcha-edit' => 'Како заштитна мерка против автоматизиран спам, внесете ги двата збора прикажани во полето:',
	'recaptcha-addurl' => 'Во вашите измени има нови надворешни врски. Како заштитна мерка против автоматизиран спам, внесете ги двата збора прикажани во полето:',
	'recaptcha-badpass' => 'Како заштитна мерка против автоматизирано провалување на лозинки, внесете ги двата збора прикажани во полето:',
	'recaptcha-createaccount' => 'Како заштитна мерка против автоматизирано создавање на сметки, внесете ги двата збора прикажани во полето:',
	'recaptcha-createaccount-fail' => 'reCAPTCHA доби погрешен одговор или одговорот недостасува.',
	'recaptcha-create' => 'Како заштитна мерка против автоматизирано создавање на страници, внесете ги двата збора прикажани во полето:',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'recaptcha-edit' => 'Untuk membanteras kegiatan spam automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:',
	'recaptcha-addurl' => 'Suntingan anda termasuk pautan luar baru. Untuk membanteras kegiatan spam automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:',
	'recaptcha-badpass' => 'Untuk membanteras kegiatan meneka kata laluan secara automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:',
	'recaptcha-createaccount' => 'Untuk membanteras kegiatan membuka akaun secara automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:',
	'recaptcha-createaccount-fail' => 'Jawapan reCAPTCHA tidak betul atau tidak ada.',
	'recaptcha-create' => 'Untuk membanteras kegiatan mencipta laman secara automatik, sila taipkan dua perkataan yang anda lihat dalam petak di bawah:',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'recaptcha-edit' => 'Voer ter bescherming tegen geautomatiseerde spam de twee woorden die u ziet in het invoervenster in:',
	'recaptcha-addurl' => 'Uw bewerking bevat nieuwe externe verwijzingen. Voer ter bescherming tegen geautomatiseerde spam de twee woorden die u ziet in het invoervenster in:',
	'recaptcha-badpass' => 'Voer ter bescherming tegen het automatisch kraken van wachtwoorden de twee woorden die u ziet in het invoervenster in:',
	'recaptcha-createaccount' => 'Om het automatisch aanmaken van gebruikers tegen te gaan moet u de twee woorden die u ziet invoeren:',
	'recaptcha-createaccount-fail' => 'Het reCAPTCHA-antwoord is onjuist of niet ingevoerd.',
	'recaptcha-create' => "Om het automatisch aanmaken van pagina's tegen te gaan moet u de twee woorden die u ziet invoeren:",
);

/** Polish (Polski) */
$messages['pl'] = array(
	'recaptcha-edit' => 'Aby uchronić nas przed robotami, proszę wpisać dwa widoczne słowa w poniższym polu:',
	'recaptcha-addurl' => 'Twoja edycja zawiera linki zewnętrzne. Aby uchronić nas przed robotami, proszę wpisać dwa widoczne słowa w poniższym polu:',
	'recaptcha-badpass' => 'Aby uchronić nas przed złamaniem automatycznym haseł, proszę wpisać dwa widoczne słowa w poniższym polu:',
	'recaptcha-createaccount' => 'Aby uchronić nas przed automatycznym stworzeniem użytkowników, proszę wpisać dwa widoczne słowa w poniższym polu:',
	'recaptcha-createaccount-fail' => 'Odpowiedź na reCAPTCHA jest fałszywa lub brakująca.',
	'recaptcha-create' => 'Aby uchronić nas przed tworzeniem stron przez robotów, proszę wpisać dwa widoczne słowa w poniższym polu:',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'recaptcha-edit' => "Për giuté a protege contra la rumenta dle modìfiche automàtiche, për piasì ch'a scriva le doe paròle ch'a s-ciàira ant ël quàder sì-sota:",
	'recaptcha-addurl' => "Soa modìfica a conten d'anliure esterne neuv. Për giuté a protege contra la rumenta dle modìfiche automàtiche, për piasì ch'a scriva le doe paròle ch'a s-ciàira ant ël quàder sì-sota:",
	'recaptcha-badpass' => "Për giuté a protege contra la forsadura automatisà ëd le ciav, për piasì ch'a scriva le doe paròle ch'a s-ciàira ant ël formolari sì-sota:",
	'recaptcha-createaccount' => "Për giuté a protege contra la creassion automatisà ëd cont, për piasì ch'a scriva le doe paròle ch'a s-ciàira ant ël formolari sì-sota:",
	'recaptcha-createaccount-fail' => 'Rispòsta ëd reCAPTCHA fàussa o mancanta.',
	'recaptcha-create' => "Për giuté a protege contra la creassion automatisà ëd pàgine, për piasì ch'a scriv le doe paròle ch'a s-ciàira ant la casela sì-sota:",
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'recaptcha-edit' => 'Para proteger-nos de spam, por favor escreva  as duas palavras visíveis abaixo:',
	'recaptcha-addurl' => "A sua edição contém links externos novos. Como prevenção contra sistemas automatizados de inserção de ''spam'', escreva as duas palavras visíveis na caixa abaixo:",
	'recaptcha-badpass' => 'Para proteger-nos de robots que tentam adivinhar senhas, por favor escreva  as duas palavras visíveis abaixo:',
	'recaptcha-createaccount' => 'Para proteger-nos de criação automática de contas, por favor escreva  as duas palavras visíveis abaixo:',
	'recaptcha-createaccount-fail' => 'A resposta ao reCAPTCHA é errada.',
	'recaptcha-create' => 'Para proteger-nos da criação automática de páginas, por favor escreva  as duas palavras visíveis abaixo:',
);

/** Brazilian Portuguese (Português do Brasil) */
$messages['pt-br'] = array(
	'recaptcha-edit' => 'Para ajudar a prevenir contra vandalismos, por favor digite as duas palavras que você vê na caixa abaixo:',
	'recaptcha-addurl' => 'A sua edição inclui ligações externas. Para ajudar a prevenir contra vandalismos, por favor digite as duas palavras que você vê na caixa abaixo:',
	'recaptcha-badpass' => 'Para ajudar a prevenir contra tentativas de desbloquear senhas, por favor digite as duas palavras que você vê na caixa abaixo:',
	'recaptcha-createaccount' => 'Para ajudar a prevenir contra criação automatizada de usuários, por favor digite as duas palavras que você vê na caixa abaixo:',
	'recaptcha-createaccount-fail' => 'Resposta incorreta ao reCAPTCHA.',
	'recaptcha-create' => 'Para ajudar a prevenir contra criação automatizada de páginas, por favor digite as duas palavras que você vê na caixa abaixo:',
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'recaptcha-edit' => 'В целях защиты от автоматического спама в правках, пожалуйста, введите два слова, которые вы видите ниже:',
	'recaptcha-addurl' => 'Ваша правка содержит новые внешние ссылки. В целях защиты от автоматического спама, пожалуйста, введите два слова, которые вы видите ниже:',
	'recaptcha-badpass' => 'В целях защиты от автоматического подбора пароля, пожалуйста, введите два слова, которые вы видите ниже:',
	'recaptcha-createaccount' => 'В целях защиты от автоматического создания учётных записей, пожалуйста, введите два слова, которые вы видите ниже:',
	'recaptcha-createaccount-fail' => 'Ответ reCAPTCHA неправильный или отсутствует.',
	'recaptcha-create' => 'В целях защиты от автоматического создания страниц, пожалуйста, введите два слова, которые вы видите ниже:',
);

/** Swedish (Svenska) */
$messages['sv'] = array(
	'recaptcha-edit' => 'Den här sidan skyddas mot spam-robotar, bevisa att du är en människa genom att skriva de två orden du ser i boxen nedan:',
	'recaptcha-addurl' => 'Din förändring av sidan innehåller nya externa länkar, vilket är typiskt för spam. Bevisa att du är en människa genom att skriva de två orden du ser i boxen nedan:',
	'recaptcha-badpass' => 'För att skydda wikin mot robotar som gissar användares lösenord behöver användare bevisa att de är människor. Skriv ner de två orden som du ser i boxen nedan:',
	'recaptcha-createaccount' => 'För att skydda wikin mot robotar som skapar konton behöver användare bevisa att de är människor. Var vänlig och skriv ner de två orden du ser i boxen nedan:',
	'recaptcha-createaccount-fail' => 'Du har angivit ett felaktig svar för reCAPTCHA.',
	'recaptcha-create' => 'För att skydda wikin mot robotar som skapar nya artiklar. Var vänlig och skriv ner de två orden som finns i boxen nedan:',
);

/** Swahili (Kiswahili)
 * @author Lloffiwr
 */
$messages['sw'] = array(
	'recaptcha-edit' => 'Ili kusaidia kuzuia mashine zisihariri, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:',
	'recaptcha-addurl' => 'Haririo lako lina viungo vipya vya nje. Ili kusaidia katika kuzuisha viungo visivyotakiwa visiwekwe na mashine, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:',
	'recaptcha-badpass' => 'Ili kusaidia katika kuzuia neno lako la siri lisigunduliwe na mashine, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:',
	'recaptcha-createaccount' => 'Ili kusaidia kuzuia akaunti zisifunguliwe nyingi na mashine, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:',
	'recaptcha-createaccount-fail' => 'Jibu la swali la CAPTCHA si sahihi au halipo.',
	'recaptcha-create' => 'Ili kusaidia kuzuia kurasa zisianzishwe nyingi na mashine, tafadhali andika maneno mawili yanayoonekana katika kisanduku pakipo chini:',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'recaptcha-edit' => 'Upang makatulong sa pagprutekta laban sa kusang basurang pamamatnugot, paki imakinilya ang dalawang mga salitang nakikita mo sa loob ng kahong nasa ibaba:',
	'recaptcha-addurl' => 'Ang pagbabago mo ay nagsasama ng bagong panlabas na mga kawing.  Upang makatulong sa pagprutekta laban sa kusang paglusob ng basurang-liham, paki imakinilya ang dalawang mga salitang nakikita sa loob ng kahong nasa ibaba:',
	'recaptcha-badpass' => 'Upang makatulong sa pagsasanggalang laban sa kusang panghuhula ng hudyat, paki imakinilya ang dalawang mga salitang nakikita mo sa loob ng kahong nasa ibaba:',
	'recaptcha-createaccount' => 'Upang makatulong sa pagprutekta laban sa kusang paglikha ng akawnt, paki imakinilya ang dalawang mga salitang nakikita mo sa loob ng kahong nasa ibaba:',
	'recaptcha-createaccount-fail' => 'Hindi tama o nawawalang sagot sa reCAPTCHA.',
	'recaptcha-create' => 'Upang makatulong sa pagprutekta laban sa kusang paglikha ng pahina, paki imakinilya ang dalawang mga salitang nakikita mo sa loob ng kahong nasa ibaba:',
);

/** Ukrainian (Українська)
 * @author Тест
 */
$messages['uk'] = array(
	'recaptcha-createaccount-fail' => 'Відповідь reCAPTCHA неправильна або відсутня.',
);

/** Vietnamese (Tiếng Việt) */
$messages['vi'] = array(
	'recaptcha-edit' => 'Để giúp tránh các sửa đổi rác tự động, xin hãy gõ hai từ mà bạn nhìn thấy vào ô dưới đây:',
	'recaptcha-addurl' => 'Sửa đổi của bạn có chứa liên kết ngoài mới. Để giúp tránh các sửa đổi rác tự động, xin hãy gõ hai từ mà bạn nhìn vào ô dưới đây:',
	'recaptcha-badpass' => 'Để giúp tránh bẻ khóa mật khẩu tự động, xin hãy gõ hai từ mà bạn nhìn vào ô dưới đây:',
	'recaptcha-createaccount' => 'Để giúp tránh việc mở tài khoản tự động, xin hãy gõ hai từ mà bạn nhìn vào ô dưới đây:',
	'recaptcha-createaccount-fail' => 'Thiếu câu trả lời reCAPTCHA hoặc câu trả lời không đúng.',
	'recaptcha-create' => 'Để giúp tránh việc tạo trang tự động, xin hãy gõ hai từ mà bạn nhìn vào ô dưới đây:',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Hydra
 */
$messages['zh-hans'] = array(
	'recaptcha-edit' => '要帮助保护免受垃圾邮件自动的编辑，请键入您在下面的框中看到这两个词：',
	'recaptcha-addurl' => '您的编辑包含新的外部链接。为了帮助防止自动垃圾邮件，请键入您在下面的框中看到这两个词：',
	'recaptcha-badpass' => '为帮助防止自动密码破解，请键入您看到下面的框中的两个字：',
	'recaptcha-createaccount' => '为了帮助防止创建自动化的帐户，请键入您在下面的框中看到的这两个字：',
	'recaptcha-createaccount-fail' => '不正确或缺失的 reCAPTCHA 答案。',
	'recaptcha-create' => '为了帮助防止自动的页创建，请键入您在下面的框中看到这两个词：',
);

