match.fun                package:base                R Documentation

_F_u_n_c_t_i_o_n _V_e_r_i_f_i_c_a_t_i_o_n _f_o_r "_F_u_n_c_t_i_o_n _V_a_r_i_a_b_l_e_s"

_D_e_s_c_r_i_p_t_i_o_n:

     When called inside functions that take a function as argument,
     extract the desired function object while avoiding undesired
     matching to objects of other types.

_U_s_a_g_e:

     match.fun(FUN, descend = TRUE)

_A_r_g_u_m_e_n_t_s:

     FUN: item to match as function: a function, symbol or character
          string.  See 'Details'.

 descend: logical; control whether to search past non-function objects.

_D_e_t_a_i_l_s:

     'match.fun' is not intended to be used at the top level since it
     will perform matching in the _parent_ of the caller.

     If 'FUN' is a function, it is returned.  If it is a symbol (for
     example, enclosed in backquotes) or a character vector of length
     one, it will be looked up using 'get' in the environment of the
     parent of the caller.  If it is of any other mode, it is attempted
     first to get the argument to the caller as a symbol (using
     'substitute' twice), and if that fails, an error is declared.

     If 'descend = TRUE', 'match.fun' will look past non-function
     objects with the given name; otherwise if 'FUN' points to a
     non-function object then an error is generated.

     This is used in base functions such as 'apply', 'lapply', 'outer',
     and 'sweep'.

_V_a_l_u_e:

     A function matching 'FUN' or an error is generated.

_B_u_g_s:

     The 'descend' argument is a bit of misnomer and probably not
     actually needed by anything.  It may go away in the future.

     It is impossible to fully foolproof this.  If one 'attach'es a
     list or data frame containing a length-one character vector with
     the same name as a function, it may be used (although name spaces
     will help).

_A_u_t_h_o_r(_s):

     Peter Dalgaard and Robert Gentleman, based on an earlier version
     by Jonathan Rougier.

_S_e_e _A_l_s_o:

     'match.arg', 'get'

_E_x_a_m_p_l_e_s:

     # Same as get("*"):
     match.fun("*")
     # Overwrite outer with a vector
     outer <- 1:5
     ## Not run: 
     match.fun(outer, descend = FALSE) #-> Error:  not a function
     ## End(Not run)
     match.fun(outer) # finds it anyway
     is.function(match.fun("outer")) # as well

