/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import scala.Option;
import scala.ScalaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniquenessCache<K, V>
implements ScalaObject {
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rlock = this.rwl().readLock();
    private final ReentrantReadWriteLock.WriteLock wlock = this.rwl().writeLock();
    private final WeakHashMap<K, WeakReference<V>> map = new WeakHashMap();

    private ReferenceQueue<V> queue() {
        return this.queue;
    }

    private ReentrantReadWriteLock rwl() {
        return this.rwl;
    }

    private ReentrantReadWriteLock.ReadLock rlock() {
        return this.rlock;
    }

    private ReentrantReadWriteLock.WriteLock wlock() {
        return this.wlock;
    }

    private WeakHashMap<K, WeakReference<V>> map() {
        return this.map;
    }

    public abstract V valueFromKey(K var1);

    public abstract Option<K> keyFromValue(V var1);

    public V apply(K name$1) {
        Object res = this.cached$1(name$1);
        return (V)(res == null ? this.updateCache$1(name$1) : res);
    }

    public Option<K> unapply(V other) {
        return this.keyFromValue(other);
    }

    private final Object cached$1(Object object) {
        this.rlock().lock();
        Object exceptionResult1 = null;
        try {
            WeakReference<V> reference = this.map().get(object);
            exceptionResult1 = (reference == null ? null : reference.get());
            return exceptionResult1;
        }
        finally {
            this.rlock().unlock();
        }
    }

    private final Object updateCache$1(Object object) {
        this.wlock().lock();
        Object exceptionResult2 = null;
        try {
            Object object2;
            Object res = this.cached$1(object);
            if (res == null) {
                V sym = this.valueFromKey(object);
                this.map().put(object, new WeakReference<V>(sym, this.queue()));
                object2 = sym;
            } else {
                object2 = res;
            }
            exceptionResult2 = object2;
            return exceptionResult2;
        }
        finally {
            this.wlock().unlock();
        }
    }
}

