/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ******************************************************************************
 *
 * Copyright (C) 1996-2005 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer
 *    unmodified other than the allowable addition of one or more
 *    copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 *
 * Version: Onyx 5.1.2
 *
 ******************************************************************************/

/* Pseudo-opaque type. */
typedef struct cw_mq_s cw_mq_t;

struct cw_mq_s
{
    cw_mema_t *mema;
#ifdef CW_DBG
    uint32_t magic;
#endif
    uint32_t msg_count;
    uint32_t msg_size;
    uint32_t msgs_vec_count;
    uint32_t msgs_beg;
    uint32_t msgs_end;
    union
    {
	uint8_t *one;
	uint16_t *two;
	uint32_t *four;
	uint64_t *eight;
	void *x; /* Don't care. */
    } msgs;

    cw_mtx_t lock;
    cw_cnd_t cond;

    bool get_stop;
    bool put_stop;
};

void
mq_new(cw_mq_t *a_mq, cw_mema_t *a_mema, uint32_t a_msg_size);

void
mq_delete(cw_mq_t *a_mq);

bool
mq_tryget(cw_mq_t *a_mq, ...);

bool
mq_timedget(cw_mq_t *a_mq, const struct timespec *a_timeout, ...);

bool
mq_get(cw_mq_t *a_mq, ...);

bool
mq_put(cw_mq_t *a_mq, ...);

bool
mq_get_start(cw_mq_t *a_mq);

bool
mq_get_stop(cw_mq_t *a_mq);

bool
mq_put_start(cw_mq_t *a_mq);

bool
mq_put_stop(cw_mq_t *a_mq);
