/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBModel;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.util.NbBundle;

class SQLStatementGenerator {
    private DataViewDBTable tblMeta;
    private DataView dataView;

    public SQLStatementGenerator(DataView dataView) {
        this.dataView = dataView;
        this.tblMeta = dataView.getDataViewDBTable();
    }

    String generateInsertStatement(Object[] insertedRow) throws DBException {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO ");
        String colNames = " (";
        String values = "";
        String commaStr = ", ";
        boolean comma = false;
        for (int i = 0; i < insertedRow.length; ++i) {
            DBColumn dbcol = this.tblMeta.getColumn(i);
            Object val = insertedRow[i];
            if (dbcol.isGenerated()) continue;
            if ((val == null || val.equals("<NULL>")) && !dbcol.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (comma) {
                values = values + commaStr;
                colNames = colNames + commaStr;
            } else {
                comma = true;
            }
            if (val != null && DataViewUtils.isSQLConstantString(val)) {
                String constStr = ((String)val).substring(1, ((String)val).length() - 1);
                values = values + constStr;
            } else {
                values = values + (insertedRow[i] == null ? " NULL " : "?");
            }
            colNames = colNames + dbcol.getQualifiedName(true);
        }
        colNames = colNames + ")";
        insertSql.append(this.tblMeta.getFullyQualifiedName(0, true) + colNames + " Values(" + values + ")");
        return insertSql.toString();
    }

    String generateRawInsertStatement(Object[] insertedRow) throws DBException {
        StringBuilder rawInsertSql = new StringBuilder();
        rawInsertSql.append("INSERT INTO ");
        String rawcolNames = " (";
        String rawvalues = "";
        String commaStr = ", ";
        boolean comma = false;
        for (int i = 0; i < insertedRow.length; ++i) {
            DBColumn dbcol = this.tblMeta.getColumn(i);
            Object val = insertedRow[i];
            if (dbcol.isGenerated()) continue;
            if ((val == null || val.equals("<NULL>")) && !dbcol.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (comma) {
                rawvalues = rawvalues + commaStr;
                rawcolNames = rawcolNames + commaStr;
            } else {
                comma = true;
            }
            if (val != null && DataViewUtils.isSQLConstantString(val)) {
                String constStr = ((String)val).substring(1, ((String)val).length() - 1);
                rawvalues = rawvalues + constStr;
            } else {
                rawvalues = rawvalues + this.getQualifiedValue(dbcol.getJdbcType(), insertedRow[i]);
            }
            rawcolNames = rawcolNames + dbcol.getQualifiedName(false);
        }
        rawcolNames = rawcolNames + ")";
        rawInsertSql.append(this.tblMeta.getFullyQualifiedName(0, false) + rawcolNames + " \n\tVALUES (" + rawvalues + ")");
        return rawInsertSql.toString();
    }

    String generateUpdateStatement(int row, Map<Integer, Object> changedRow, List<Object> values, List<Integer> types, TableModel tblModel) throws DBException {
        StringBuilder updateStmt = new StringBuilder();
        updateStmt.append("UPDATE ").append(this.tblMeta.getFullyQualifiedName(0, true)).append(" SET ");
        String commaStr = ", ";
        boolean comma = false;
        for (Integer col : changedRow.keySet()) {
            DBColumn dbcol = this.tblMeta.getColumn(col);
            Object value = changedRow.get(col);
            int type = dbcol.getJdbcType();
            if ((value == null || value.equals("<NULL>")) && !dbcol.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (comma) {
                updateStmt.append(commaStr);
            } else {
                comma = true;
            }
            updateStmt.append(this.tblMeta.getQualifiedName(col, true));
            if (value != null && DataViewUtils.isSQLConstantString(value)) {
                String constStr = ((String)value).substring(1, ((String)value).length() - 1);
                updateStmt.append(" = ").append(constStr);
                continue;
            }
            updateStmt.append(" = ?");
            values.add(value);
            types.add(type);
        }
        updateStmt.append(" WHERE ");
        this.generateWhereCondition(updateStmt, types, values, row, tblModel);
        return updateStmt.toString();
    }

    String generateUpdateStatement(int row, Map<Integer, Object> changedRow, TableModel tblModel) throws DBException {
        StringBuilder rawUpdateStmt = new StringBuilder();
        rawUpdateStmt.append("UPDATE ").append(this.tblMeta.getFullyQualifiedName(0, false)).append(" SET ");
        String commaStr = ", ";
        boolean comma = false;
        for (Integer col : changedRow.keySet()) {
            DBColumn dbcol = this.tblMeta.getColumn(col);
            Object value = changedRow.get(col);
            int type = dbcol.getJdbcType();
            if ((value == null || value.equals("<NULL>")) && !dbcol.isNullable()) {
                throw new DBException(NbBundle.getMessage(SQLStatementGenerator.class, (String)"MSG_nullable_check"));
            }
            if (comma) {
                rawUpdateStmt.append(commaStr);
            } else {
                comma = true;
            }
            rawUpdateStmt.append(this.tblMeta.getQualifiedName(col, true));
            if (value != null && DataViewUtils.isSQLConstantString(value)) {
                String constStr = ((String)value).substring(1, ((String)value).length() - 1);
                rawUpdateStmt.append(" = ").append(constStr);
                continue;
            }
            rawUpdateStmt.append(" = ").append(this.getQualifiedValue(type, value).toString());
        }
        rawUpdateStmt.append(" WHERE ");
        this.generateWhereCondition(rawUpdateStmt, row, tblModel);
        return rawUpdateStmt.toString();
    }

    String generateDeleteStatement(List<Integer> types, List<Object> values, int rowNum, TableModel tblModel) {
        StringBuilder deleteStmt = new StringBuilder();
        deleteStmt.append("DELETE FROM ").append(this.tblMeta.getFullyQualifiedName(0, true)).append(" WHERE ");
        this.generateWhereCondition(deleteStmt, types, values, rowNum, tblModel);
        return deleteStmt.toString();
    }

    String generateDeleteStatement(int rowNum, TableModel tblModel) {
        StringBuilder rawDeleteStmt = new StringBuilder();
        rawDeleteStmt.append("DELETE FROM ").append(this.tblMeta.getFullyQualifiedName(0, false)).append(" WHERE ");
        this.generateWhereCondition(rawDeleteStmt, rowNum, tblModel);
        return rawDeleteStmt.toString();
    }

    String generateCreateStatement(DBTable table) throws DBException, Exception {
        Connection conn = DBConnectionFactory.getInstance().getConnection(this.dataView.getDatabaseConnection());
        String msg = "";
        if (conn == null) {
            Throwable ex = DBConnectionFactory.getInstance().getLastException();
            msg = ex != null ? ex.getMessage() : NbBundle.getMessage(SQLExecutionHelper.class, (String)"MSG_connection_failure", (Object)this.dataView.getDatabaseConnection());
            this.dataView.setErrorStatusText(new DBException(msg));
            throw new DBException(msg);
        }
        boolean isdb2 = ((DBModel)table.getParentObject()).getDBType() == 0;
        StringBuffer sql = new StringBuffer();
        List<DBColumn> columns = table.getColumnList();
        sql.append("CREATE TABLE ").append(table.getQualifiedName(false)).append(" (");
        int count = 0;
        for (DBColumn col : columns) {
            if (count++ > 0) {
                sql.append(", ");
            }
            String typeName = col.getTypeName();
            sql.append(col.getQualifiedName(false)).append(" ");
            int scale = col.getScale();
            int precision = col.getPrecision();
            if (precision > 0 && DataViewUtils.isPrecisionRequired(col.getJdbcType(), isdb2)) {
                if (typeName.contains("(")) {
                    sql.append(typeName.replace("(", "(" + precision));
                } else {
                    sql.append(typeName).append("(").append(precision);
                    if (scale > 0 && DataViewUtils.isScaleRequired(col.getJdbcType())) {
                        sql.append(", ").append(scale).append(")");
                    } else {
                        sql.append(")");
                    }
                }
            } else {
                sql.append(typeName);
            }
            if (DataViewUtils.isBinary(col.getJdbcType()) && isdb2) {
                sql.append("  FOR BIT DATA ");
            }
            if (col.hasDefault()) {
                sql.append(" DEFAULT ").append(col.getDefaultValue()).append(" ");
            }
            if (!col.isNullable()) {
                sql.append(" NOT NULL");
            }
            if (!col.isGenerated()) continue;
            sql.append(" ").append(this.getAutoIncrementText(((DBModel)table.getParentObject()).getDBType()));
        }
        DBPrimaryKey pk = table.getPrimaryKey();
        if (pk != null) {
            count = 0;
            sql.append(", PRIMARY KEY (");
            for (String col : pk.getColumnNames()) {
                if (count++ > 0) {
                    sql.append(", ");
                }
                sql.append(table.getQuoter().quoteIfNeeded(col));
            }
            sql.append(")");
        }
        sql.append(")");
        return sql.toString();
    }

    static String getCountSQLQuery(String queryString) {
        String[] splitByFrom = queryString.toUpperCase().split("FROM");
        queryString = queryString.substring(splitByFrom[0].length());
        String[] splitByOrderBy = queryString.toUpperCase().split("ORDER BY");
        queryString = queryString.substring(0, splitByOrderBy[0].length());
        return "SELECT COUNT(*) " + queryString;
    }

    static String getCountAsSubQuery(String queryString) {
        String[] splitByOrderBy = queryString.toUpperCase().split("ORDER BY");
        queryString = queryString.substring(0, splitByOrderBy[0].length());
        return "SELECT COUNT(*) FROM (" + queryString + ") C2668";
    }

    private boolean addSeparator(boolean and, StringBuilder sql, String sep) {
        if (and) {
            sql.append(sep);
            return true;
        }
        return true;
    }

    private void generateNameValue(int i, StringBuilder sql, Object value, List<Object> values, List<Integer> types) {
        sql.append(this.tblMeta.getQualifiedName(i, true));
        if (value != null) {
            values.add(value);
            types.add(this.tblMeta.getColumnType(i));
            sql.append(" = ? ");
        } else {
            sql.append(" IS NULL ");
        }
    }

    private void generateNameValue(int i, StringBuilder sql, Object value) {
        String columnName = this.tblMeta.getQualifiedName(i, false);
        int type = this.tblMeta.getColumnType(i);
        sql.append(columnName);
        if (value != null) {
            sql.append(" = ").append(this.getQualifiedValue(type, value));
        } else {
            sql.append(" IS NULL");
        }
    }

    private void generateWhereCondition(StringBuilder result, List<Integer> types, List<Object> values, int rowNum, TableModel model) {
        DBPrimaryKey key = this.tblMeta.geTable(0).getPrimaryKey();
        boolean keySelected = false;
        boolean and = false;
        if (key != null) {
            block0: for (String keyName : key.getColumnNames()) {
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    Object val;
                    String columnName = this.tblMeta.getColumnName(i);
                    if (!columnName.equals(keyName) || (val = this.dataView.getDataViewPageContext().getColumnData(rowNum, i)) == null) continue;
                    keySelected = true;
                    and = this.addSeparator(and, result, " AND ");
                    this.generateNameValue(i, result, val, values, types);
                    continue block0;
                }
            }
        }
        if (key == null || !keySelected) {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                Object val = this.dataView.getDataViewPageContext().getColumnData(rowNum, i);
                and = this.addSeparator(and, result, " AND ");
                this.generateNameValue(i, result, val, values, types);
            }
        }
    }

    private void generateWhereCondition(StringBuilder sql, int rowNum, TableModel model) {
        DBPrimaryKey key = this.tblMeta.geTable(0).getPrimaryKey();
        boolean keySelected = false;
        boolean and = false;
        if (key != null) {
            block0: for (String keyName : key.getColumnNames()) {
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    Object val;
                    String columnName = this.tblMeta.getColumnName(i);
                    if (!columnName.equals(keyName) || (val = this.dataView.getDataViewPageContext().getColumnData(rowNum, i)) == null) continue;
                    keySelected = true;
                    and = this.addSeparator(and, sql, " AND ");
                    this.generateNameValue(i, sql, val);
                    continue block0;
                }
            }
        }
        if (key == null || !keySelected) {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                Object val = this.dataView.getDataViewPageContext().getColumnData(rowNum, i);
                and = this.addSeparator(and, sql, " AND ");
                this.generateNameValue(i, sql, val);
            }
        }
    }

    private Object getQualifiedValue(int type, Object val) {
        if (val == null) {
            return "NULL";
        }
        if (type == -7 && !(val instanceof Boolean)) {
            return "b'" + val + "'";
        }
        if (DataViewUtils.isNumeric(type)) {
            return val;
        }
        return "'" + val + "'";
    }

    private String getAutoIncrementText(int dbType) throws Exception {
        switch (dbType) {
            case 5: {
                return "AUTO_INCREMENT";
            }
            case 4: {
                return "SERIAL";
            }
            case 2: {
                return "IDENTITY";
            }
        }
        return "GENERATED ALWAYS AS IDENTITY";
    }
}

