/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

class PathLookup
extends Lookup {
    private Lookup delegate;
    private String path;

    PathLookup(String path) {
        this.delegate = Lookups.forPath((String)path);
        this.path = path;
    }

    public <T> T lookup(Class<T> clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return (T)(item == null ? null : item.getInstance());
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return this.resultJustForPath(this.delegate.lookup(template));
    }

    public <T> Lookup.Result<T> lookupResult(Class<T> clazz) {
        return this.resultJustForPath(this.delegate.lookupResult(clazz));
    }

    private <T> Lookup.Result<T> resultJustForPath(Lookup.Result<T> result) {
        int l = this.path.length() + 1;
        int count = 0;
        Collection allItems = result.allItems();
        for (Lookup.Item it : allItems) {
            String filePath = it.getId();
            assert (filePath.startsWith(this.path)) : "File path '" + filePath + "' does not start with searched path '" + this.path + "'";
            if (filePath.indexOf(47, l) > 0) break;
            ++count;
        }
        if (count < allItems.size()) {
            return new PathLookupResult<T>(result, count);
        }
        return result;
    }

    static class PathLookupResult<T>
    extends Lookup.Result<T> {
        private Lookup.Result<T> orig;
        private int n;

        PathLookupResult(Lookup.Result<T> orig, int n) {
            this.orig = orig;
            this.n = n;
        }

        public void addLookupListener(LookupListener l) {
            this.orig.addLookupListener(l);
        }

        public void removeLookupListener(LookupListener l) {
            this.orig.removeLookupListener(l);
        }

        public Collection<? extends T> allInstances() {
            return new PathLookupCollection(this.orig.allInstances(), this.n);
        }

        public Set<Class<? extends T>> allClasses() {
            return new PathLookupSet<Class<? extends T>>(this.orig.allClasses(), this.n);
        }

        public Collection<? extends Lookup.Item<T>> allItems() {
            return new PathLookupCollection(this.orig.allItems(), this.n);
        }

        private static class PathLookupIterator<IIT>
        implements Iterator<IIT> {
            private int i;
            private Iterator<IIT> delegate;
            private int n;

            PathLookupIterator(Iterator<IIT> delegate, int n) {
                this.delegate = delegate;
                this.n = n;
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }

            @Override
            public IIT next() {
                if (this.i < this.n) {
                    ++this.i;
                    return this.delegate.next();
                }
                throw new NoSuchElementException("Index = " + this.i + ", size = " + this.n);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        }

        private static class PathLookupSet<IT>
        extends PathLookupCollection<IT>
        implements Set<IT> {
            PathLookupSet(Set<IT> delegate, int n) {
                super(delegate, n);
            }
        }

        private static class PathLookupCollection<IT>
        implements Collection<IT> {
            private Collection<IT> delegate;
            private int n;

            PathLookupCollection(Collection<IT> delegate, int n) {
                this.delegate = delegate;
                this.n = n;
            }

            @Override
            public int size() {
                return this.n;
            }

            @Override
            public boolean isEmpty() {
                return this.n == 0;
            }

            @Override
            public boolean contains(Object o) {
                Iterator<IT> it = this.iterator();
                for (int i = 0; i < this.n; ++i) {
                    IT e = it.next();
                    if (o != e && (o == null || !o.equals(e))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<IT> iterator() {
                return new PathLookupIterator<IT>(this.delegate.iterator(), this.n);
            }

            @Override
            public Object[] toArray() {
                Object[] arr = new Object[this.n];
                Iterator<IT> it = this.iterator();
                for (int i = 0; i < this.n; ++i) {
                    arr[i] = it.next();
                }
                return arr;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                if (a.length < this.n) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.n);
                }
                System.arraycopy(this.toArray(), 0, a, 0, this.n);
                if (a.length > this.n) {
                    a[this.n] = null;
                }
                return a;
            }

            @Override
            public boolean add(IT o) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                Iterator<?> it = c.iterator();
                while (it.hasNext()) {
                    if (this.contains(it.next())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends IT> c) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public void clear() {
                this.delegate.clear();
            }
        }
    }
}

