/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.asm.model.lang.instruction.InstructionArgs;
import org.netbeans.modules.cnd.asm.model.lang.operand.Operand;
import org.netbeans.modules.cnd.asm.model.xml.Util;
import org.netbeans.modules.cnd.asm.model.xml.XMLBaseInstruction;

public class DefaultXMLBaseInstruction
extends XMLBaseInstruction {
    public static final Collection<Integer> DEFAULT_READ = Arrays.asList(2);
    public static final Collection<Integer> DEFAULT_WRITE = Arrays.asList(1);
    private Collection<Integer> readArgsIdx = DEFAULT_READ;
    private Collection<Integer> writeArgsIdx = DEFAULT_WRITE;
    private static final String ARG_PREFIX = "%arg";

    public DefaultXMLBaseInstruction(String name, String groupName, String desc, Collection<InstructionArgs> args) {
        super(name, desc, groupName, args);
    }

    public boolean isSupportive(Operand[] ops) {
        return false;
    }

    public void setWrite(String write) {
        this.writeArgsIdx = DefaultXMLBaseInstruction.parseArgs(Util.descriptionTokenizer(write));
        if (this.readArgsIdx == DEFAULT_READ) {
            this.readArgsIdx = Collections.emptyList();
        }
    }

    public void setRead(String read) {
        this.readArgsIdx = DefaultXMLBaseInstruction.parseArgs(Util.descriptionTokenizer(read));
        if (this.writeArgsIdx == DEFAULT_WRITE) {
            this.writeArgsIdx = Collections.emptyList();
        }
    }

    private static Collection<Integer> parseArgs(List<String> args) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (String arg : args) {
            if (!arg.startsWith(ARG_PREFIX)) continue;
            String argNo = arg.substring(ARG_PREFIX.length(), arg.length() - 1);
            try {
                res.add(Integer.valueOf(argNo));
            }
            catch (NumberFormatException nfe) {}
        }
        return res;
    }

    @Override
    public Collection<Integer> getReadArgIdxs() {
        return this.readArgsIdx;
    }

    @Override
    public Collection<Integer> getWriteArgIdxs() {
        return this.writeArgsIdx;
    }
}

