/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.navigation.overrides.AnnotationsHolder;
import org.netbeans.modules.cnd.navigation.overrides.BaseAnnotation;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class OverrideAnnotationAction
extends AbstractAction {
    private static final Set<String> COMBINED_TYPES = new HashSet<String>(Arrays.asList("org-netbeans-modules-editor-annotations-override-is-overridden-combined"));

    public OverrideAnnotationAction() {
        this.putValue("Name", NbBundle.getMessage(OverrideAnnotationAction.class, (String)"CTL_IsOverriddenAnnotationAction"));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.invokeDefaultAction((JTextComponent)e.getSource())) {
            Action a;
            int nextAction;
            Action[] actions = ImplementationProvider.getDefault().getGlyphGutterActions((JTextComponent)e.getSource());
            if (actions == null) {
                return;
            }
            for (nextAction = 0; nextAction < actions.length && actions[nextAction] != this; ++nextAction) {
            }
            if (actions.length > ++nextAction && (a = actions[nextAction]) != null && a.isEnabled()) {
                a.actionPerformed(e);
            }
        }
    }

    boolean invokeDefaultAction(final JTextComponent comp) {
        final Document doc = comp.getDocument();
        if (doc instanceof BaseDocument) {
            final int currentPosition = comp.getCaretPosition();
            final Annotations annotations = ((BaseDocument)doc).getAnnotations();
            final AtomicReference point = new AtomicReference();
            final AtomicReference anno = new AtomicReference();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        int line = Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)currentPosition);
                        int startOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)doc), (int)line);
                        int endOffset = Utilities.getRowEnd((BaseDocument)((BaseDocument)doc), (int)startOffset);
                        AnnotationDesc desc = annotations.getActiveAnnotation(line);
                        if (desc == null) {
                            return;
                        }
                        List<BaseAnnotation> annos = COMBINED_TYPES.contains(desc.getAnnotationType()) ? OverrideAnnotationAction.this.findAnnotations(comp, startOffset, endOffset) : Collections.singletonList(OverrideAnnotationAction.this.findAnnotation(comp, desc, startOffset, endOffset));
                        for (BaseAnnotation a : annos) {
                            if (a == null) continue;
                            anno.set(a);
                            point.set(comp.modelToView(startOffset).getLocation());
                            break;
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            if (anno.get() != null) {
                ((BaseAnnotation)((Object)anno.get())).mouseClicked(comp, (Point)point.get());
                return true;
            }
        }
        return false;
    }

    private List<BaseAnnotation> findAnnotations(JTextComponent component, int startOffset, int endOffset) {
        DataObject dao = this.getDataObject(component);
        if (dao == null) {
            if (ErrorManager.getDefault().isLoggable(16)) {
                ErrorManager.getDefault().log(16, "component=" + component + " does not have a file specified in the document.");
            }
            return null;
        }
        AnnotationsHolder ah = AnnotationsHolder.get(dao);
        if (ah == null) {
            BaseAnnotation.LOGGER.log(Level.INFO, "component={0} does not have attached AnnotationsHolder", component);
            return null;
        }
        LinkedList<BaseAnnotation> annotations = new LinkedList<BaseAnnotation>();
        for (BaseAnnotation a : ah.getAttachedAnnotations()) {
            int offset = a.getPosition().getOffset();
            if (startOffset > offset || offset > endOffset) continue;
            annotations.add(a);
        }
        return annotations;
    }

    private BaseAnnotation findAnnotation(JTextComponent component, AnnotationDesc desc, int startOffset, int endOffset) {
        DataObject dao = this.getDataObject(component);
        if (dao == null) {
            if (ErrorManager.getDefault().isLoggable(16)) {
                ErrorManager.getDefault().log(16, "component=" + component + " does not have a file specified in the document.");
            }
            return null;
        }
        AnnotationsHolder ah = AnnotationsHolder.get(dao);
        if (ah == null) {
            BaseAnnotation.LOGGER.log(Level.INFO, "component={0} does not have attached a IsOverriddenAnnotationHandler", component);
            return null;
        }
        for (BaseAnnotation a : ah.getAttachedAnnotations()) {
            int offset = a.getPosition().getOffset();
            if (startOffset > offset || offset > endOffset || !desc.getShortDescription().equals(a.getShortDescription())) continue;
            return a;
        }
        return null;
    }

    private DataObject getDataObject(JTextComponent component) {
        Document doc = component.getDocument();
        return (DataObject)doc.getProperty("stream");
    }
}

