/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SessionEJBWizardPanel
extends JPanel {
    private final ChangeListener listener;
    private final Project project;
    private ComboBoxModel projectsList;
    private JComboBox inProjectCombo;
    private JLabel interfaceLabel;
    private JCheckBox localCheckBox;
    private JCheckBox remoteCheckBox;
    private ButtonGroup sessionStateButtons;
    private JLabel sessionTypeLabel;
    private JRadioButton singletonButton;
    private JRadioButton statefulButton;
    private JRadioButton statelessButton;

    public SessionEJBWizardPanel(Project project, ChangeListener changeListener) {
        this.listener = changeListener;
        this.project = project;
        this.initComponents();
        J2eeProjectCapabilities j2eeProjectCapabilities = J2eeProjectCapabilities.forProject((Project)project);
        if (j2eeProjectCapabilities.isEjb31LiteSupported()) {
            boolean bl = Util.getSupportedProfiles((Project)project).contains(Profile.JAVA_EE_6_FULL);
            if (!j2eeProjectCapabilities.isEjb31Supported() && !bl) {
                this.remoteCheckBox.setVisible(false);
                this.remoteCheckBox.setEnabled(false);
            }
        } else {
            this.singletonButton.setVisible(false);
            this.singletonButton.setEnabled(false);
            this.localCheckBox.setSelected(true);
        }
        this.localCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
            }
        });
        this.inProjectCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
            }
        });
        this.remoteCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
                SessionEJBWizardPanel.this.updateInProjectCombo(SessionEJBWizardPanel.this.remoteCheckBox.isSelected());
            }
        });
        this.updateInProjectCombo(false);
    }

    private void updateInProjectCombo(boolean bl) {
        if (bl) {
            this.remoteCheckBox.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_In_Project"));
        } else {
            this.remoteCheckBox.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Remote"));
        }
        this.inProjectCombo.setVisible(bl);
        if (bl && this.projectsList == null) {
            List<Project> list = this.getProjectsList();
            this.projectsList = new DefaultComboBoxModel<Project>(list.toArray(new Project[list.size()]));
            final ListCellRenderer listCellRenderer = this.inProjectCombo.getRenderer();
            this.inProjectCombo.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = ProjectUtils.getInformation((Project)((Project)object)).getDisplayName();
                    return listCellRenderer.getListCellRendererComponent(jList, string, n, bl, bl2);
                }
            });
            this.inProjectCombo.setModel(this.projectsList);
            this.inProjectCombo.setSelectedIndex(0);
            this.listener.stateChanged(null);
        }
    }

    private List<Project> getProjectsList() {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        arrayList.add(this.project);
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            if (project.equals(this.project) || project.getLookup().lookup(AntArtifactProvider.class) != null && AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar").length == 0 || ProjectUtils.getSources((Project)project).getSourceGroups("java").length == 0) continue;
            arrayList.add(project);
        }
        return arrayList;
    }

    private void initComponents() {
        this.sessionStateButtons = new ButtonGroup();
        this.sessionTypeLabel = new JLabel();
        this.statelessButton = new JRadioButton();
        this.statefulButton = new JRadioButton();
        this.interfaceLabel = new JLabel();
        this.remoteCheckBox = new JCheckBox();
        this.localCheckBox = new JCheckBox();
        this.singletonButton = new JRadioButton();
        this.inProjectCombo = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.sessionTypeLabel, (String)NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_SessionType"));
        this.sessionStateButtons.add(this.statelessButton);
        this.statelessButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Stateless").charAt(0));
        this.statelessButton.setSelected(true);
        this.statelessButton.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Stateless"));
        this.sessionStateButtons.add(this.statefulButton);
        this.statefulButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Stateful").charAt(0));
        this.statefulButton.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Stateful"));
        Mnemonics.setLocalizedText((JLabel)this.interfaceLabel, (String)NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Interface"));
        this.remoteCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Remote").charAt(0));
        this.remoteCheckBox.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Remote"));
        this.localCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Local").charAt(0));
        this.localCheckBox.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Local"));
        this.sessionStateButtons.add(this.singletonButton);
        this.singletonButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Singleton").charAt(0));
        this.singletonButton.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Singleton"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.sessionTypeLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.statelessButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.statefulButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.singletonButton)).add((Component)this.interfaceLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.remoteCheckBox).add(6, 6, 6).add((Component)this.inProjectCombo, 0, 129, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.localCheckBox).addPreferredGap(0, 152, Short.MAX_VALUE))))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sessionTypeLabel).add(0, 0, 0).add((Component)this.statelessButton).add(0, 0, 0).add((Component)this.statefulButton).add(0, 0, 0).add((Component)this.singletonButton).addPreferredGap(1).add((Component)this.interfaceLabel).add(0, 0, 0).add((Component)this.localCheckBox).add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.remoteCheckBox).add((Component)this.inProjectCombo, -2, -1, -2))));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle");
        this.statelessButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_Stateless"));
        this.statelessButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_Stateless"));
        this.statefulButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_Stateful"));
        this.statefulButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_Stateful"));
        this.remoteCheckBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_Remote"));
        this.remoteCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_Remote"));
        this.localCheckBox.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_Local"));
        this.localCheckBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_Local"));
    }

    public String getSessionType() {
        if (this.statelessButton.isSelected()) {
            return "Stateless";
        }
        if (this.statefulButton.isSelected()) {
            return "Stateful";
        }
        if (this.singletonButton.isSelected()) {
            return "Singleton";
        }
        return "";
    }

    public boolean isRemote() {
        return this.remoteCheckBox.isSelected();
    }

    public boolean isLocal() {
        return this.localCheckBox.isSelected();
    }

    public Project getRemoteInterfaceProject() {
        if (this.projectsList == null) {
            return null;
        }
        return (Project)this.projectsList.getSelectedItem();
    }
}

