/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.identitymaps;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.identitymaps.FullIdentityMap;
import oracle.toplink.essentials.internal.identitymaps.WeakCacheKey;

public class WeakIdentityMap
extends FullIdentityMap {
    protected int cleanupCount = 0;
    protected int cleanupSize;

    public WeakIdentityMap(int size) {
        super(size);
        this.cleanupSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDeadCacheKeys() {
        Enumeration keysEnum = this.getCacheKeys().elements();
        while (keysEnum.hasMoreElements()) {
            CacheKey key = (CacheKey)keysEnum.nextElement();
            if (key.getObject() != null || !key.acquireNoWait()) continue;
            try {
                if (key.getObject() != null) continue;
                this.getCacheKeys().remove(key);
            }
            finally {
                key.release();
            }
        }
    }

    public CacheKey createCacheKey(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        return new WeakCacheKey(primaryKey, object, writeLockValue, readTime);
    }

    protected int getCleanupCount() {
        return this.cleanupCount;
    }

    protected void setCleanupCount(int cleanupCount) {
        this.cleanupCount = cleanupCount;
    }

    protected int getCleanupSize() {
        return this.cleanupSize;
    }

    protected void setCleanupSize(int cleanupSize) {
        this.cleanupSize = cleanupSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(CacheKey cacheKey) {
        WeakIdentityMap weakIdentityMap = this;
        synchronized (weakIdentityMap) {
            if (this.getCleanupCount() > this.getCleanupSize()) {
                this.cleanupDeadCacheKeys();
                this.setCleanupCount(0);
                if (this.getSize() > this.getCleanupSize()) {
                    this.setCleanupSize(this.getSize());
                }
            }
            this.setCleanupCount(this.getCleanupCount() + 1);
        }
        super.put(cacheKey);
    }
}

