/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.helper;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import oracle.toplink.essentials.internal.helper.JDKPlatform;

public class JDK15Platform
implements JDKPlatform {
    protected static Hashtable patternCache = new Hashtable();

    public Map getQueryCacheMap() {
        return new ConcurrentHashMap();
    }

    public int conformLike(Object left, Object right) {
        if (left == null && right == null) {
            return 1;
        }
        if (left == null || right == null) {
            return 0;
        }
        if (left instanceof String && right instanceof String) {
            boolean match;
            Pattern pattern = (Pattern)patternCache.get(right);
            if (pattern == null) {
                String convertedRight = ((String)right).replaceAll("\\?", "\\\\?");
                convertedRight = convertedRight.replaceAll("\\*", "\\\\*");
                convertedRight = convertedRight.replaceAll("\\.", "\\\\.");
                convertedRight = convertedRight.replaceAll("\\[", "\\\\[");
                convertedRight = convertedRight.replaceAll("\\)", "\\\\)");
                convertedRight = convertedRight.replaceAll("\\(", "\\\\(");
                convertedRight = convertedRight.replaceAll("\\{", "\\\\{");
                convertedRight = convertedRight.replaceAll("\\+", "\\\\+");
                convertedRight = convertedRight.replaceAll("\\^", "\\\\^");
                convertedRight = convertedRight.replaceAll("\\|", "\\\\|");
                convertedRight = convertedRight.replaceAll("([^\\\\])%", "$1.*");
                convertedRight = convertedRight.replaceAll("([^\\\\])_", "$1.");
                convertedRight = convertedRight.replaceAll("^%", ".*");
                convertedRight = convertedRight.replaceAll("^_", ".");
                convertedRight = convertedRight.replaceAll("\\\\%", "%");
                convertedRight = convertedRight.replaceAll("\\\\_", "_");
                pattern = Pattern.compile(convertedRight);
                if (patternCache.size() > 100) {
                    patternCache.remove(patternCache.keySet().iterator().next());
                }
                patternCache.put(right, pattern);
            }
            if (match = pattern.matcher((String)left).matches()) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public long getTimeInMillis(Calendar calendar) {
        return calendar.getTimeInMillis();
    }

    public void setTimeInMillis(Calendar calendar, long millis) {
        calendar.setTimeInMillis(millis);
    }

    public void setExceptionCause(Throwable exception, Throwable cause) {
        if (exception.getCause() == null) {
            exception.initCause(cause);
        }
    }

    public boolean shouldPrintInternalException() {
        return false;
    }
}

