/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.expressions.ExpressionOperator;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.expressions.ExpressionIterator;
import oracle.toplink.essentials.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.essentials.internal.expressions.ExpressionNormalizer;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;

public abstract class CompoundExpression
extends Expression {
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Expression firstChild;
    protected Expression secondChild;

    public DatabaseTable aliasForTable(DatabaseTable table) {
        DatabaseTable alias = null;
        if (this.getFirstChild() != null) {
            alias = this.getFirstChild().aliasForTable(table);
        }
        if (alias == null && this.getSecondChild() != null) {
            alias = this.getSecondChild().aliasForTable(table);
        }
        return alias;
    }

    public Expression create(Expression base, Object singleArgument, ExpressionOperator operator) {
        this.setFirstChild(base);
        Expression argument = Expression.from(singleArgument, base);
        this.setSecondChild(argument);
        this.setOperator(operator);
        return this;
    }

    public Expression create(Expression base, Vector arguments, ExpressionOperator operator) {
        this.setFirstChild(base);
        if (!arguments.isEmpty()) {
            this.setSecondChild((Expression)arguments.firstElement());
        }
        this.setOperator(operator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Compound Expression";
    }

    public ExpressionBuilder getBuilder() {
        ExpressionBuilder builder = this.getFirstChild().getBuilder();
        if (builder == null) {
            return this.getSecondChild().getBuilder();
        }
        return builder;
    }

    public Expression getFirstChild() {
        return this.firstChild;
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform platform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(platform);
        }
        return this.platformOperator;
    }

    public Expression getSecondChild() {
        return this.secondChild;
    }

    public void initializePlatformOperator(DatabasePlatform platform) {
        if (this.getOperator().isComplete()) {
            this.platformOperator = this.getOperator();
            return;
        }
        this.platformOperator = platform.getOperator(this.getOperator().getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.getOperator().toString());
        }
    }

    public boolean isCompoundExpression() {
        return true;
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.getFirstChild() != null) {
            this.getFirstChild().iterateOn(iterator);
        }
        if (this.getSecondChild() != null) {
            this.getSecondChild().iterateOn(iterator);
        }
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        ExpressionBuilder builder;
        this.validateNode();
        if (this.getFirstChild() != null) {
            builder = this.getFirstChild().getBuilder();
            if (builder != null) {
                builder.setSession(normalizer.getSession().getRootSession(null));
            }
            this.setFirstChild(this.getFirstChild().normalize(normalizer));
        }
        if (this.getSecondChild() != null) {
            builder = this.getSecondChild().getBuilder();
            if (builder != null) {
                builder.setSession(normalizer.getSession().getRootSession(null));
            }
            this.setSecondChild(this.getSecondChild().normalize(normalizer));
        }
        if (this.getFirstChild() == null) {
            return this.getSecondChild();
        }
        if (this.getSecondChild() == null) {
            return this.getFirstChild();
        }
        return this;
    }

    public void validateNode() {
        if (this.getFirstChild() != null && (this.getFirstChild().isDataExpression() || this.getFirstChild().isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
        if (this.getSecondChild() != null && (this.getSecondChild().isDataExpression() || this.getSecondChild().isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
    }

    protected void postCopyIn(Dictionary alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.getFirstChild() != null) {
            this.setFirstChild(this.getFirstChild().copiedVersionFrom(alreadyDone));
        }
        if (this.getSecondChild() != null) {
            this.setSecondChild(this.getSecondChild().copiedVersionFrom(alreadyDone));
        }
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        printer.printString("(");
        realOperator.printDuo(this.getFirstChild(), this.getSecondChild(), printer);
        printer.printString(")");
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printJavaDuo(this.getFirstChild(), this.getSecondChild(), printer);
    }

    public Expression rebuildOn(Expression newBase) {
        NonSynchronizedVector arguments;
        Expression first = this.getFirstChild().rebuildOn(newBase);
        if (this.getSecondChild() == null) {
            arguments = NonSynchronizedVector.newInstance(0);
        } else {
            arguments = NonSynchronizedVector.newInstance(1);
            ((Vector)arguments).addElement(this.getSecondChild().rebuildOn(newBase));
        }
        return first.performOperator(this.getOperator(), arguments);
    }

    protected void setFirstChild(Expression firstChild) {
        this.firstChild = firstChild;
    }

    public void setOperator(ExpressionOperator newOperator) {
        this.operator = newOperator;
    }

    protected void setSecondChild(Expression secondChild) {
        this.secondChild = secondChild;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        NonSynchronizedVector arguments;
        if (this.getSecondChild() == null) {
            arguments = NonSynchronizedVector.newInstance(0);
        } else {
            arguments = NonSynchronizedVector.newInstance(1);
            ((Vector)arguments).addElement(this.getSecondChild().twistedForBaseAndContext(newBase, context));
        }
        Expression first = this.getFirstChild().twistedForBaseAndContext(newBase, context);
        return first.performOperator(this.getOperator(), arguments);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.operator.toString());
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.getFirstChild() != null) {
            this.getFirstChild().toString(writer, indent);
        }
        if (this.getSecondChild() != null) {
            this.getSecondChild().toString(writer, indent);
        }
    }
}

