/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;

public final class GeomUtil {
    public static final Logger LOG = Logger.getLogger("org.netbeans.api.visual");
    public static final double M_PI_2 = 1.5707963267948966;

    private GeomUtil() {
    }

    public static Rectangle roundRectangle(Rectangle2D rectangle) {
        int x1 = (int)Math.floor(rectangle.getX());
        int y1 = (int)Math.floor(rectangle.getY());
        int x2 = (int)Math.ceil(rectangle.getMaxX());
        int y2 = (int)Math.ceil(rectangle.getMaxY());
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public static Point center(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public static int centerX(Rectangle rectangle) {
        return rectangle.x + rectangle.width / 2;
    }

    public static int centerY(Rectangle rectangle) {
        return rectangle.y + rectangle.height / 2;
    }

    public static double distanceSq(Point p1, Point p2) {
        int w = p2.x - p1.x;
        int h = p2.y - p1.y;
        return Math.sqrt(w * w + h * h);
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

