/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.Utilities;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class BackgroundImageUrlDialog {
    private static final Logger LOGGER = Logger.getLogger(BackgroundImageUrlDialog.class.getName());
    private File base;
    private String imageUrl = null;

    public BackgroundImageUrlDialog(File base) {
        this.base = base;
    }

    public boolean show(Component parent) {
        JFileChooser fileChooser = Utilities.getJFileChooser();
        try {
            FileObject edited = FileUtil.toFileObject((File)this.base);
            if (edited == null) {
                return false;
            }
            fileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)edited));
            fileChooser.addChoosableFileFilter(new ImageFilter());
            if (fileChooser.showOpenDialog(parent) == 0) {
                String relativePath;
                File imageFile = fileChooser.getSelectedFile();
                if (!imageFile.exists()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"MSG_non_existing_file_selected", (Object)imageFile.getAbsolutePath()), 0));
                    return false;
                }
                FileObject imageFO = FileUtil.toFileObject((File)imageFile);
                if (imageFO == null) {
                    return false;
                }
                FileObject webRoot = ProjectWebRootQuery.getWebRoot((FileObject)edited);
                if (webRoot == null) {
                    Project project = FileOwnerQuery.getOwner((FileObject)edited);
                    webRoot = project.getProjectDirectory();
                }
                boolean copied = false;
                if (!FileUtil.isParentOf((FileObject)webRoot, (FileObject)imageFO)) {
                    FileObject folder = edited.getParent();
                    String freeName = FileUtil.findFreeFileName((FileObject)folder, (String)imageFO.getName(), (String)imageFO.getExt());
                    imageFO = FileUtil.copyFile((FileObject)imageFO, (FileObject)folder, (String)freeName, (String)imageFO.getExt());
                    copied = true;
                }
                if ((relativePath = WebUtils.getRelativePath((FileObject)edited, (FileObject)imageFO)) == null) {
                    if (copied) {
                        imageFO.delete();
                    }
                    return false;
                }
                this.imageUrl = this.encodeURL(relativePath);
            }
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, null, exc);
            return false;
        }
        return true;
    }

    private String encodeURL(String imageUrl) {
        StringBuffer sb = new StringBuffer();
        int len = imageUrl.length();
        for (int i = 0; i < len; ++i) {
            char chr = imageUrl.charAt(i);
            if (chr == ' ') {
                sb.append("%20");
                continue;
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public static class ImageFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                extension = s.substring(i + 1).toLowerCase();
            }
            if (extension != null) {
                return extension.toLowerCase().equals("gif") || extension.toLowerCase().equals("jpg") || extension.toLowerCase().equals("png");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(BackgroundImageUrlDialog.class, (String)"IMAGE_FILTER");
        }
    }
}

