/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.options;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.groovy.editor.options.FmtOptions;

public final class CodeStyle {
    private final Preferences preferences;

    private CodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static CodeStyle get(Preferences prefs) {
        return new CodeStyle(prefs);
    }

    public static CodeStyle get(Document doc) {
        return new CodeStyle(CodeStylePreferences.get((Document)doc).getPreferences());
    }

    public int getIndentSize() {
        int indentLevel = this.preferences.getInt("indent-shift-width", FmtOptions.getDefaultAsInt("indent-shift-width"));
        if (indentLevel <= 0) {
            boolean expandTabs = this.preferences.getBoolean("expand-tabs", FmtOptions.getDefaultAsBoolean("expand-tabs"));
            indentLevel = expandTabs ? this.preferences.getInt("spaces-per-tab", FmtOptions.getDefaultAsInt("spaces-per-tab")) : this.preferences.getInt("tab-size", FmtOptions.getDefaultAsInt("tab-size"));
        }
        return indentLevel;
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt("continuationIndentSize", FmtOptions.getDefaultAsInt("continuationIndentSize"));
    }

    public boolean reformatComments() {
        return this.preferences.getBoolean("reformatComments", FmtOptions.getDefaultAsBoolean("reformatComments"));
    }

    public boolean indentHtml() {
        return this.preferences.getBoolean("indentHtml", FmtOptions.getDefaultAsBoolean("indentHtml"));
    }

    public int getRightMargin() {
        return this.preferences.getInt("text-limit-width", FmtOptions.getDefaultAsInt("text-limit-width"));
    }
}

