/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.http.validation;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPOperation;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPUrlEncoded;
import org.netbeans.modules.xml.wsdl.model.extensions.http.HTTPUrlReplacement;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

public class HTTPComponentValidator
implements Validator,
HTTPComponent.Visitor {
    private static final String HTTP_HOST_TOKEN = "${HttpHostName}";
    private static final String HTTP_DEFAULT_PORT_TOKEN = "${HttpDefaultPort}";
    private static final String HTTPS_DEFAULT_PORT_TOKEN = "${HttpsDefaultPort}";
    private Validation mValidation;
    private Validation.ValidationType mValidationType;
    private ValidationResult mValidationResult;
    private HTTPBinding.Verb mVerb;

    public String getName() {
        return this.getClass().getName();
    }

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        if (!(model instanceof WSDLModel)) {
            return null;
        }
        this.mVerb = HTTPBinding.Verb.GET;
        this.mValidation = validation;
        this.mValidationType = validationType;
        HashSet<Validator.ResultItem> results = new HashSet<Validator.ResultItem>();
        HashSet<Model> models = new HashSet<Model>();
        models.add(model);
        this.mValidationResult = new ValidationResult(results, models);
        if (model instanceof WSDLModel) {
            WSDLModel wsdlModel = (WSDLModel)model;
            if (model.getState() == Model.State.NOT_WELL_FORMED) {
                return null;
            }
            Definitions defs = wsdlModel.getDefinitions();
            for (Binding binding : defs.getBindings()) {
                int numSoapBindings = binding.getExtensibilityElements(HTTPBinding.class).size();
                if (numSoapBindings > 1) {
                    results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPBindingValidator.One_binding_allowed")));
                }
                for (HTTPBinding httpBinding : binding.getExtensibilityElements(HTTPBinding.class)) {
                    httpBinding.accept(this);
                }
                for (BindingOperation bindingOp : binding.getBindingOperations()) {
                    int countUrlReplacement;
                    BindingInput bindingInput;
                    for (HTTPOperation httpOp : bindingOp.getExtensibilityElements(HTTPOperation.class)) {
                        httpOp.accept(this);
                    }
                    List httpOpsList = bindingOp.getExtensibilityElements(HTTPOperation.class);
                    if (httpOpsList.size() <= 0 || (bindingInput = bindingOp.getBindingInput()) == null) continue;
                    int countUrlEncoded = bindingInput.getExtensibilityElements(HTTPUrlEncoded.class).size();
                    int sum = countUrlEncoded + (countUrlReplacement = bindingInput.getExtensibilityElements(HTTPUrlReplacement.class).size());
                    if (sum == 0 && this.mVerb == HTTPBinding.Verb.GET) {
                        results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)bindingInput, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPUrlEncodingValidator.Encoding_required")));
                    } else if (sum > 1) {
                        results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPUrlEncodingValidator.One_encoding_allowed")));
                    }
                    for (HTTPComponent encodingElem : bindingInput.getExtensibilityElements(HTTPUrlEncoded.class)) {
                        encodingElem.accept(this);
                    }
                    for (HTTPComponent encodingElem : bindingInput.getExtensibilityElements(HTTPUrlReplacement.class)) {
                        encodingElem.accept(this);
                    }
                }
            }
            for (Service service : defs.getServices()) {
                for (Port port : service.getPorts()) {
                    Binding binding;
                    if (port.getBinding() == null || (binding = (Binding)port.getBinding().get()) == null) continue;
                    int numHttpAddresses = port.getExtensibilityElements(HTTPAddress.class).size();
                    int numHttpBindings = binding.getExtensibilityElements(HTTPBinding.class).size();
                    if (numHttpBindings > 0) {
                        if (numHttpAddresses == 0) {
                            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Missing_address")));
                        } else if (numHttpAddresses > 1) {
                            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.One_address_allowed")));
                        }
                    }
                    for (HTTPAddress httpAddress : port.getExtensibilityElements(HTTPAddress.class)) {
                        httpAddress.accept(this);
                    }
                }
            }
        }
        this.mValidation = null;
        this.mValidationType = null;
        ValidationResult rv = this.mValidationResult;
        this.mValidationResult = null;
        return rv;
    }

    @Override
    public void visit(HTTPAddress address) {
        Collection results = this.mValidationResult.getValidationResult();
        String location = address.getLocation();
        if (location == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Missing_location")));
            return;
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(location)) {
            return;
        }
        if (location.indexOf(HTTP_DEFAULT_PORT_TOKEN, 6) > 0 && location.startsWith("http")) {
            int contextStartIndex;
            int portColonIndex = location.indexOf(":", 6);
            if (HTTP_DEFAULT_PORT_TOKEN.equals(location.substring(portColonIndex + 1, contextStartIndex = location.indexOf("/", 7)))) {
                return;
            }
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Unsupported_location_attribute")));
            return;
        }
        if (location.indexOf(HTTPS_DEFAULT_PORT_TOKEN, 7) > 0 && location.startsWith("https")) {
            int contextStartIndex;
            int portColonIndex = location.indexOf(":", 7);
            if (HTTPS_DEFAULT_PORT_TOKEN.equals(location.substring(portColonIndex + 1, contextStartIndex = location.indexOf("/", 8)))) {
                return;
            }
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Unsupported_location_attribute")));
            return;
        }
        if (this.containsToken(location)) {
            if (!this.isValidAddressToken(location)) {
                results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Unsupported_token_format")));
                return;
            }
        } else {
            try {
                URI uri = new URI(location);
                String scheme = uri.getScheme();
                if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                    return;
                }
                uri.toURL();
            }
            catch (Exception ex) {
                results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)address, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPAddressValidator.Unsupported_location_attribute")));
            }
        }
    }

    @Override
    public void visit(HTTPBinding binding) {
        Collection results = this.mValidationResult.getValidationResult();
        HTTPBinding.Verb verb = binding.getVerb();
        if (verb == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPBindingValidator.Verb_required")));
        } else {
            this.mVerb = verb;
        }
    }

    @Override
    public void visit(HTTPOperation operation) {
        Collection results = this.mValidationResult.getValidationResult();
        if (operation.getLocation() == null) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)operation, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPOperationValidator.Location_attribute_required")));
        }
    }

    @Override
    public void visit(HTTPUrlEncoded enc) {
        Collection results = this.mValidationResult.getValidationResult();
        if (this.mVerb == HTTPBinding.Verb.POST) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)enc, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPUrlEncodingValidator.POST_ignores_urlEncoding")));
        }
    }

    @Override
    public void visit(HTTPUrlReplacement enc) {
        Collection results = this.mValidationResult.getValidationResult();
        if (this.mVerb == HTTPBinding.Verb.POST) {
            results.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)enc, NbBundle.getMessage(HTTPComponentValidator.class, (String)"HTTPUrlEncodingValidator.POST_ignores_urlEncoding")));
        }
    }

    private boolean containsToken(String val) {
        boolean hasToken = false;
        if (val != null && val.length() >= 4) {
            int idx1 = val.indexOf("${");
            int idx2 = idx1 == -1 ? -1 : val.indexOf("}", idx1 + 1);
            hasToken = idx2 - idx1 >= 3;
        }
        return hasToken;
    }

    private boolean isToken(String val) {
        boolean isToken = false;
        if (val != null && val.length() >= 4) {
            isToken = val.charAt(0) == '$' && val.charAt(1) == '{' && val.indexOf("${", 1) == -1 && val.indexOf("}") == val.length() - 1;
        }
        return isToken;
    }

    private boolean isValidAddressToken(String tokenString) {
        boolean containsProtocolInfo = false;
        boolean isValidToken = true;
        if (tokenString.startsWith("http://")) {
            tokenString = tokenString.substring(7, tokenString.length());
            containsProtocolInfo = true;
        }
        if (tokenString.startsWith("https://")) {
            tokenString = tokenString.substring(8, tokenString.length());
            containsProtocolInfo = true;
        }
        if (!containsProtocolInfo) {
            int indexOfTokenStart = tokenString.indexOf("${");
            int indexOfTokenEnd = tokenString.indexOf("}");
            if (indexOfTokenEnd == tokenString.length() - 1 && indexOfTokenStart == 0) {
                isValidToken = true;
            } else {
                return false;
            }
        }
        if (tokenString.contains("${")) {
            int indexOfPortSeparator = tokenString.indexOf(":");
            int indexOfContextSeparator = tokenString.lastIndexOf("/");
            if (indexOfContextSeparator != -1) {
                String host;
                int indexOfTokenEnd;
                int indexOfTokenEnd2;
                String context = tokenString.substring(indexOfContextSeparator + 1, tokenString.length());
                int indexOfContextTokenStart = context.indexOf("${");
                if (indexOfContextTokenStart == 0 ? (indexOfTokenEnd2 = context.indexOf("}")) < indexOfContextTokenStart : context.indexOf("}") > 0) {
                    return false;
                }
                int indexOfTokenStart = tokenString.indexOf("${");
                if (indexOfTokenStart == 0 ? (indexOfTokenEnd = (host = tokenString.substring(1, indexOfPortSeparator)).indexOf("}")) < 1 : tokenString.substring(1, indexOfPortSeparator).indexOf("}") > 0) {
                    return false;
                }
                String port = tokenString.substring(indexOfPortSeparator + 1, indexOfContextSeparator);
                if (port.indexOf("${") != -1 && port.indexOf("}") > 0) {
                    isValidToken = true;
                } else {
                    return false;
                }
            }
        }
        return isValidToken;
    }
}

