/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class GlobalAbilitiesCache
implements Runnable {
    private static GlobalAbilitiesCache instance = null;
    protected final Set<String> globalAbilities = Collections.synchronizedSortedSet(new TreeSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalAbilitiesCache getDefault() {
        Class<GlobalAbilitiesCache> clazz = GlobalAbilitiesCache.class;
        synchronized (GlobalAbilitiesCache.class) {
            if (instance == null) {
                instance = new GlobalAbilitiesCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private GlobalAbilitiesCache() {
        L l = new L();
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)l);
        l.propertyChange(null);
        RequestProcessor.getDefault().post((Runnable)this);
    }

    public Set<String> getAllAbilities() {
        return Collections.unmodifiableSet(this.globalAbilities);
    }

    public void addAbility(String ability) {
        this.globalAbilities.add(ability);
    }

    @Override
    public void run() {
        for (ProjectConfigurationFactory fac : Lookup.getDefault().lookupAll(ProjectConfigurationFactory.class)) {
            LinkedList<ProjectConfigurationFactory.CategoryDescriptor> list = new LinkedList<ProjectConfigurationFactory.CategoryDescriptor>();
            list.add(fac.getRootCategory());
            while (!list.isEmpty()) {
                Map map;
                ProjectConfigurationFactory.Descriptor des = (ProjectConfigurationFactory.Descriptor)list.removeFirst();
                if (des instanceof ProjectConfigurationFactory.CategoryDescriptor) {
                    list.addAll(((ProjectConfigurationFactory.CategoryDescriptor)des).getChildren());
                }
                if (!(des instanceof ProjectConfigurationFactory.ConfigurationTemplateDescriptor) || (map = ((ProjectConfigurationFactory.ConfigurationTemplateDescriptor)des).getProjectConfigurationProperties()) == null || (map = CommentingPreProcessor.decodeAbilitiesMap((String)((String)map.get("abilities")))) == null) continue;
                this.globalAbilities.addAll(map.keySet());
            }
        }
    }

    private class L
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private L() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Project[] p = OpenProjects.getDefault().getOpenProjects();
            if (p == null) {
                return;
            }
            for (int i = 0; i < p.length; ++i) {
                ProjectConfigurationsHelper h = (ProjectConfigurationsHelper)p[i].getLookup().lookup(ProjectConfigurationsHelper.class);
                if (h == null) continue;
                GlobalAbilitiesCache.this.globalAbilities.addAll(h.getAllIdentifiers(false));
            }
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject fo = fe.getFile();
            this.loadAbilities(fo);
        }

        public void loadAbilities(FileObject fo) {
            if (fo == null || !fo.isData() || !fo.getExt().equals("cfg")) {
                return;
            }
            try {
                Properties p = new Properties();
                p.load(fo.getInputStream());
                Map abs = CommentingPreProcessor.decodeAbilitiesMap((String)p.getProperty("configs." + fo.getName() + '.' + "abilities"));
                if (abs != null) {
                    GlobalAbilitiesCache.this.globalAbilities.addAll(abs.keySet());
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }
}

