/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.maven.graph.DependencyGraphScene;
import org.netbeans.modules.maven.graph.GraphConstructor;
import org.netbeans.modules.maven.graph.HighlightVisitor;
import org.netbeans.modules.maven.graph.ScopesVisitor;
import org.netbeans.modules.maven.graph.SearchVisitor;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.openide.awt.Mnemonics;
import org.openide.awt.Toolbar;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class DependencyGraphTopComponent
extends TopComponent
implements LookupListener,
MultiViewElement {
    private Lookup.Result<DependencyNode> result;
    private Lookup.Result<MavenProject> result2;
    private Lookup.Result<POMModel> result3;
    private DependencyGraphScene scene;
    private MultiViewElementCallback callback;
    final JScrollPane pane = new JScrollPane();
    private HighlightVisitor highlightV;
    private Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DependencyGraphTopComponent.this.checkFindValue();
        }
    });
    private JToolBar toolbar;
    private JButton btnBigger;
    private JButton btnSmaller;
    private JComboBox comScopes;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private JLabel lblFind;
    private JLabel lblPath;
    private JLabel lblScopes;
    private JSpinner maxPathSpinner;
    private JTextField txtFind;

    public DependencyGraphTopComponent(Lookup lookup) {
        this.associateLookup(lookup);
        this.initComponents();
        this.timer.setDelay(500);
        this.timer.setRepeats(false);
        this.txtFind.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DependencyGraphTopComponent.this.timer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DependencyGraphTopComponent.this.timer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DependencyGraphTopComponent.this.timer.restart();
            }
        });
        this.comScopes.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                int n2 = ((List)object).size();
                String string = n2 == 0 ? "LBL_Scope_All" : (n2 == 2 ? "LBL_Scope_Compile" : (n2 == 3 ? "LBL_Scope_Runtime" : "LBL_Scope_Test"));
                return super.getListCellRendererComponent((JList<?>)jList, NbBundle.getMessage(DependencyGraphTopComponent.class, (String)string), n, bl, bl2);
            }
        });
        DefaultComboBoxModel<List<String>> defaultComboBoxModel = new DefaultComboBoxModel<List<String>>();
        defaultComboBoxModel.addElement(Arrays.asList(new String[0]));
        defaultComboBoxModel.addElement(Arrays.asList(Artifact.SCOPE_PROVIDED, Artifact.SCOPE_COMPILE));
        defaultComboBoxModel.addElement(Arrays.asList(Artifact.SCOPE_PROVIDED, Artifact.SCOPE_COMPILE, Artifact.SCOPE_RUNTIME));
        defaultComboBoxModel.addElement(Arrays.asList(Artifact.SCOPE_PROVIDED, Artifact.SCOPE_COMPILE, Artifact.SCOPE_RUNTIME, Artifact.SCOPE_TEST));
        this.comScopes.setModel(defaultComboBoxModel);
        this.comScopes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DependencyGraphTopComponent.this.scene != null) {
                    List list = (List)DependencyGraphTopComponent.this.comScopes.getSelectedItem();
                    ScopesVisitor scopesVisitor = new ScopesVisitor(DependencyGraphTopComponent.this.scene, list);
                    DependencyGraphTopComponent.this.scene.getRootGraphNode().getArtifact().accept((DependencyNodeVisitor)scopesVisitor);
                    DependencyGraphTopComponent.this.scene.validate();
                    DependencyGraphTopComponent.this.scene.repaint();
                    DependencyGraphTopComponent.this.revalidate();
                    DependencyGraphTopComponent.this.repaint();
                }
            }
        });
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    private void checkFindValue() {
        String string = this.txtFind.getText().trim();
        if ("".equals(string)) {
            string = null;
        }
        SearchVisitor searchVisitor = new SearchVisitor(this.scene);
        searchVisitor.setSearchString(string);
        DependencyNode dependencyNode = this.scene.getRootGraphNode().getArtifact();
        dependencyNode.accept((DependencyNodeVisitor)searchVisitor);
        this.scene.validate();
        this.scene.repaint();
        this.revalidate();
        this.repaint();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        super.componentOpened();
        this.pane.setWheelScrollingEnabled(true);
        this.maxPathSpinner.setEnabled(false);
        this.maxPathSpinner.setVisible(false);
        this.lblPath.setVisible(false);
        this.txtFind.setEnabled(false);
        this.btnBigger.setEnabled(false);
        this.btnSmaller.setEnabled(false);
        this.comScopes.setEnabled(false);
        this.add(this.pane, "Center");
        this.setPaneText(NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"LBL_Loading"), true);
        this.result = this.getLookup().lookup(new Lookup.Template(DependencyNode.class));
        this.result.addLookupListener((LookupListener)this);
        this.result2 = this.getLookup().lookup(new Lookup.Template(MavenProject.class));
        this.result2.addLookupListener((LookupListener)this);
        this.result3 = this.getLookup().lookup(new Lookup.Template(POMModel.class));
        this.result3.addLookupListener((LookupListener)this);
        this.createScene();
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentShowing() {
        super.componentShowing();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.btnBigger = new JButton();
        this.btnSmaller = new JButton();
        this.lblFind = new JLabel();
        this.txtFind = new JTextField();
        this.lblPath = new JLabel();
        this.maxPathSpinner = new JSpinner();
        this.lblScopes = new JLabel();
        this.comScopes = new JComboBox();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.btnBigger.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/graph/zoomin.gif", (boolean)true)));
        this.btnBigger.setFocusable(false);
        this.btnBigger.setHorizontalTextPosition(0);
        this.btnBigger.setVerticalTextPosition(3);
        this.btnBigger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DependencyGraphTopComponent.this.btnBiggerActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.btnBigger);
        this.btnSmaller.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/graph/zoomout.gif", (boolean)true)));
        this.btnSmaller.setFocusable(false);
        this.btnSmaller.setHorizontalTextPosition(0);
        this.btnSmaller.setVerticalTextPosition(3);
        this.btnSmaller.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DependencyGraphTopComponent.this.btnSmallerActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.btnSmaller);
        Mnemonics.setLocalizedText((JLabel)this.lblFind, (String)NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.lblFind.text"));
        this.jToolBar1.add(this.lblFind);
        this.txtFind.setMaximumSize(new Dimension(200, 19));
        this.txtFind.setMinimumSize(new Dimension(50, 19));
        this.txtFind.setPreferredSize(new Dimension(150, 19));
        this.jToolBar1.add(this.txtFind);
        this.jPanel1.add(this.jToolBar1);
        this.lblPath.setLabelFor(this.maxPathSpinner);
        Mnemonics.setLocalizedText((JLabel)this.lblPath, (String)NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.lblPath.text"));
        this.lblPath.setToolTipText(NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.maxPathSpinner.toolTipText"));
        this.jPanel1.add(this.lblPath);
        this.maxPathSpinner.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.maxPathSpinner.setToolTipText(NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.maxPathSpinner.toolTipText"));
        this.maxPathSpinner.setRequestFocusEnabled(false);
        this.maxPathSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DependencyGraphTopComponent.this.maxPathSpinnerStateChanged(changeEvent);
            }
        });
        this.jPanel1.add(this.maxPathSpinner);
        Mnemonics.setLocalizedText((JLabel)this.lblScopes, (String)NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"DependencyGraphTopComponent.lblScopes.text"));
        this.jPanel1.add(this.lblScopes);
        this.jPanel1.add(this.comScopes);
        this.add(this.jPanel1, "North");
    }

    private void btnSmallerActionPerformed(ActionEvent actionEvent) {
        this.scene.setZoomFactor(this.scene.getZoomFactor() * 0.8);
        this.scene.validate();
        this.scene.repaint();
        if (!this.pane.getHorizontalScrollBar().isVisible() && !this.pane.getVerticalScrollBar().isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void btnBiggerActionPerformed(ActionEvent actionEvent) {
        this.scene.setZoomFactor(this.scene.getZoomFactor() * 1.2);
        this.scene.validate();
        this.scene.repaint();
        if (this.pane.getHorizontalScrollBar().isVisible() || this.pane.getVerticalScrollBar().isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void maxPathSpinnerStateChanged(ChangeEvent changeEvent) {
        this.depthHighlight();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.createScene();
    }

    public void depthHighlight() {
        if (this.highlightV == null) {
            this.highlightV = new HighlightVisitor(this.scene);
        }
        int n = ((SpinnerNumberModel)this.maxPathSpinner.getModel()).getNumber().intValue();
        this.highlightV.setMaxDepth(n);
        DependencyNode dependencyNode = this.scene.getRootGraphNode().getArtifact();
        dependencyNode.accept((DependencyNodeVisitor)this.highlightV);
        this.scene.validate();
        this.scene.repaint();
    }

    JScrollPane getScrollPane() {
        return this.pane;
    }

    private void createScene() {
        MavenProject mavenProject;
        Iterator iterator = this.result.allInstances().iterator();
        Iterator iterator2 = this.result2.allInstances().iterator();
        Iterator iterator3 = this.result3.allInstances().iterator();
        MavenProject mavenProject2 = mavenProject = iterator2.hasNext() ? (MavenProject)iterator2.next() : null;
        if (mavenProject != null && "error".equals(mavenProject.getGroupId()) && "error".equals(mavenProject.getArtifactId())) {
            this.setPaneText(NbBundle.getMessage(DependencyGraphTopComponent.class, (String)"Err_CannotLoad"), false);
        }
        final Project project = (Project)this.getLookup().lookup(Project.class);
        if (mavenProject != null && iterator.hasNext()) {
            final DependencyNode dependencyNode = (DependencyNode)iterator.next();
            final POMModel pOMModel = iterator3.hasNext() ? (POMModel)iterator3.next() : null;
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    DependencyGraphTopComponent.this.scene = new DependencyGraphScene(mavenProject, project, DependencyGraphTopComponent.this, pOMModel);
                    GraphConstructor graphConstructor = new GraphConstructor(DependencyGraphTopComponent.this.scene);
                    dependencyNode.accept((DependencyNodeVisitor)graphConstructor);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JComponent jComponent = DependencyGraphTopComponent.this.scene.getView();
                            if (jComponent == null) {
                                jComponent = DependencyGraphTopComponent.this.scene.createView();
                                jComponent.putClientProperty("print.printable", Boolean.TRUE);
                            }
                            DependencyGraphTopComponent.this.pane.setViewportView(jComponent);
                            DependencyGraphTopComponent.this.scene.cleanLayout(DependencyGraphTopComponent.this.pane);
                            DependencyGraphTopComponent.this.scene.setSelectedObjects(Collections.singleton(DependencyGraphTopComponent.this.scene.getRootGraphNode()));
                            DependencyGraphTopComponent.this.txtFind.setEnabled(true);
                            DependencyGraphTopComponent.this.btnBigger.setEnabled(true);
                            DependencyGraphTopComponent.this.btnSmaller.setEnabled(true);
                            DependencyGraphTopComponent.this.comScopes.setEnabled(true);
                            if (DependencyGraphTopComponent.this.scene.getMaxNodeDepth() > 1) {
                                DependencyGraphTopComponent.this.lblPath.setVisible(true);
                                ((SpinnerNumberModel)DependencyGraphTopComponent.this.maxPathSpinner.getModel()).setMaximum(Integer.valueOf(DependencyGraphTopComponent.this.scene.getMaxNodeDepth()));
                                DependencyGraphTopComponent.this.maxPathSpinner.setEnabled(true);
                                DependencyGraphTopComponent.this.maxPathSpinner.setVisible(true);
                            }
                            DependencyGraphTopComponent.this.depthHighlight();
                        }
                    });
                }
            });
        }
    }

    public JComponent getVisualRepresentation() {
        this.jPanel1.removeAll();
        this.jToolBar1.removeAll();
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new EditorToolbar();
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            Dimension dimension = new Dimension(3, 0);
            this.toolbar.addSeparator(dimension);
            this.toolbar.add(this.btnBigger);
            this.toolbar.addSeparator(dimension);
            this.toolbar.add(this.btnSmaller);
            this.toolbar.addSeparator(dimension);
            this.toolbar.add(this.lblFind);
            this.toolbar.add(this.txtFind);
            this.toolbar.addSeparator(dimension);
            this.toolbar.add(this.lblPath);
            this.toolbar.add(this.maxPathSpinner);
            this.toolbar.addSeparator(dimension);
            this.toolbar.add(this.lblScopes);
            this.toolbar.add(this.comScopes);
        }
        return this.toolbar;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.callback = multiViewElementCallback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void setPaneText(String string, boolean bl) {
        JComponent jComponent = null;
        if (bl) {
            JPanel jPanel = new JPanel();
            JProgressBar jProgressBar = new JProgressBar();
            JLabel jLabel = new JLabel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setOpaque(false);
            jProgressBar.setIndeterminate(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)jProgressBar, gridBagConstraints);
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel.add((Component)jLabel, gridBagConstraints);
            jComponent = jPanel;
        } else {
            JLabel jLabel = new JLabel(string);
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            jComponent = jLabel;
        }
        this.pane.setViewportView(jComponent);
    }

    public static class EditorToolbar
    extends Toolbar {
        public EditorToolbar() {
            Border border = UIManager.getBorder("Nb.Editor.Toolbar.border");
            this.setBorder(border);
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
        }

        public String getUIClassID() {
            if (UIManager.get("Nb.Toolbar.ui") != null) {
                return "Nb.Toolbar.ui";
            }
            return super.getUIClassID();
        }

        public String getName() {
            return "editorToolbar";
        }
    }
}

