/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.IOManager;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class DebuggerOutput
extends LazyActionsManagerListener
implements PropertyChangeListener {
    private static final Set<IOManager> managers = new HashSet<IOManager>();
    private GdbDebugger debugger;
    private IOManager ioManager;

    public DebuggerOutput(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        if (DebuggerManager.getDebuggerManager().getSessions().length == 1) {
            for (IOManager curManager : managers) {
                curManager.close();
            }
            managers.clear();
        }
        String title = NbBundle.getBundle(IOManager.class).getString("CTL_DebuggerConsole_Title");
        this.ioManager = new IOManager(title);
        managers.add(this.ioManager);
        this.debugger.addPropertyChangeListener("state", this);
    }

    protected synchronized void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        this.debugger = null;
        this.ioManager = null;
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        GdbDebugger.State debuggerState;
        DebuggerOutput debuggerOutput = this;
        synchronized (debuggerOutput) {
            if (this.debugger == null) {
                return;
            }
            debuggerState = this.debugger.getState();
        }
        switch (debuggerState) {
            case STARTING: {
                this.print("CTL_Launching", null, null);
                break;
            }
            case RUNNING: {
                this.print("CTL_Debugger_running", null, null);
                break;
            }
            case EXITED: {
                this.print("CTL_Debugger_finished", null, null);
                if (this.ioManager == null) break;
                this.ioManager.closeStream();
                break;
            }
            case NONE: {
                this.print("CTL_Debugger_finished", null, null);
                break;
            }
            case STOPPED: {
                String sig = this.debugger.getSignal();
                if (sig != null) {
                    this.print("CTL_Debugger_stopped_by_signal", new String[]{sig}, null);
                    break;
                }
                this.print("CTL_Debugger_stopped", null, null);
            }
        }
    }

    public void actionPerformed(Object action, boolean success) {
        if (success) {
            if (action == ActionsManager.ACTION_CONTINUE) {
                this.print("CTL_Continue", null, null);
            } else if (action == ActionsManager.ACTION_STEP_INTO) {
                this.print("CTL_Step_Into", null, null);
            } else if (action == ActionsManager.ACTION_STEP_OUT) {
                this.print("CTL_Step_Out", null, null);
            } else if (action == ActionsManager.ACTION_STEP_OVER) {
                this.print("CTL_Step_Over", null, null);
            }
        }
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String message, String[] args, IOManager.Line line) {
        IOManager iom;
        String text = args == null ? NbBundle.getMessage(DebuggerOutput.class, (String)message) : new MessageFormat(NbBundle.getMessage(DebuggerOutput.class, (String)message)).format(args);
        DebuggerOutput debuggerOutput = this;
        synchronized (debuggerOutput) {
            iom = this.ioManager;
            if (iom == null) {
                return;
            }
        }
        iom.println(text, line);
    }
}

