/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.api;

import java.io.File;
import java.net.URI;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;

public abstract class AntClasspathClosureProvider {
    public abstract String getClasspathClosureAsString();

    public abstract File getTargetArtifact();

    public static String getClasspathClosure(Project p) {
        AntClasspathClosureProvider c = (AntClasspathClosureProvider)p.getLookup().lookup(AntClasspathClosureProvider.class);
        if (c != null) {
            return c.getClasspathClosureAsString();
        }
        return AntClasspathClosureProvider.findClasspathClosure(p);
    }

    public static File getTargetArtifact(Project p) {
        AntClasspathClosureProvider c = (AntClasspathClosureProvider)p.getLookup().lookup(AntClasspathClosureProvider.class);
        if (c != null) {
            return c.getTargetArtifact();
        }
        return AntClasspathClosureProvider.findTargetArtifact(p);
    }

    private static File findTargetArtifact(Project p) {
        AntArtifactProvider prov = (AntArtifactProvider)p.getLookup().lookup(AntArtifactProvider.class);
        for (AntArtifact a : prov.getBuildArtifacts()) {
            URI[] arr$;
            int len$;
            int i$;
            if (!"jar".equals(a.getType()) || (i$ = 0) >= (len$ = (arr$ = a.getArtifactLocations()).length)) continue;
            URI uri = arr$[i$];
            try {
                return new File(uri);
            }
            catch (Exception e) {
                FileObject pdir = p.getProjectDirectory();
                try {
                    String url = pdir.getURL().toURI().toString();
                    if (!url.endsWith("/") && !uri.toString().startsWith("/")) {
                        url = url + "/";
                    }
                    URI fullUri = new URI(url + uri);
                    return new File(fullUri);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not find target artifact from project in " + p.getProjectDirectory().getPath() + ":" + uri, ex);
                }
            }
        }
        return null;
    }

    private static String findClasspathClosure(Project p) {
        ClassPathProvider prov = (ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class);
        File jar = AntClasspathClosureProvider.findTargetArtifact(p);
        String target = jar.getAbsolutePath();
        return target;
    }
}

