/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public final class JAXWSUtils {
    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getFileOrURLName(String fileOrURL) {
        try {
            try {
                return JAXWSUtils.escapeSpace(new URL(fileOrURL).toExternalForm());
            }
            catch (MalformedURLException e) {
                return new File(fileOrURL).getCanonicalFile().toURL().toExternalForm();
            }
        }
        catch (Exception e) {
            return fileOrURL;
        }
    }

    public static URL getFileOrURL(String fileOrURL) throws IOException {
        try {
            return new URL(fileOrURL);
        }
        catch (MalformedURLException e) {
            return new File(fileOrURL).toURL();
        }
    }

    private static String escapeSpace(String url) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) == ' ') {
                buf.append("%20");
                continue;
            }
            buf.append(url.charAt(i));
        }
        return buf.toString();
    }

    public static String absolutize(String name) {
        try {
            URL baseURL = new File(".").getCanonicalFile().toURL();
            return new URL(baseURL, name).toExternalForm();
        }
        catch (IOException iOException) {
            return name;
        }
    }

    public static void checkAbsoluteness(String systemId) {
        try {
            new URL(systemId);
        }
        catch (MalformedURLException _) {
            try {
                new URI(systemId);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("system ID '" + systemId + "' isn't absolute", e);
            }
        }
    }

    public static boolean matchQNames(QName target, QName pattern) {
        if (target == null || pattern == null) {
            return false;
        }
        if (pattern.getNamespaceURI().equals(target.getNamespaceURI())) {
            String regex = pattern.getLocalPart().replaceAll("\\*", ".*");
            return Pattern.matches(regex, target.getLocalPart());
        }
        return false;
    }
}

